/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.process;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.process.AbstractQueryResultsTest;
import org.modeshape.graph.query.process.ProcessingComponent;
import org.modeshape.graph.query.process.SortLocationsComponent;
import org.modeshape.graph.query.validate.Schemata;

public class SortLocationsComponentTest
extends AbstractQueryResultsTest {
    private SortLocationsComponent component;
    private QueryContext context;
    private QueryResults.Columns columns;
    private List<Object[]> inputTuples;

    @Before
    public void beforeEach() {
        this.context = new QueryContext((Schemata)Mockito.mock(Schemata.class), this.typeSystem);
        this.inputTuples = new ArrayList<Object[]>();
        this.columns = this.resultColumns("Selector1", "ColA", "ColB", "ColC");
        ProcessingComponent delegate = new ProcessingComponent(this.context, this.columns){

            public List<Object[]> execute() {
                return new ArrayList<Object[]>(SortLocationsComponentTest.this.inputTuples);
            }
        };
        this.component = new SortLocationsComponent(delegate);
    }

    @Test
    public void shouldReturnAllResultsInPathOrderForTuplesContainingOneLocation() {
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c1", "v1", "v2", "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c4", "v1", "v2", "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c2", "v1", "v2", "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c3", "v1", "v2", "v3"));
        ArrayList<Object[]> expected = new ArrayList<Object[]>();
        expected.add(this.inputTuples.get(0));
        expected.add(this.inputTuples.get(2));
        expected.add(this.inputTuples.get(3));
        expected.add(this.inputTuples.get(1));
        Assert.assertThat((Object)this.component.execute(), Is.is(expected));
    }

    @Test
    public void shouldReturnAllResultsInPathOrderForTuplesContainingOneLocationAndWithDuplicateTuples() {
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c1", "v1", "v2", "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c4", "v1", "v2", "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c2", "v1", "v2", "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c3", "v1", "v2", "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c4", "v1", "v2", "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c3", "v1", "v2", "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c0", "v1", "v2", "v3"));
        ArrayList<Object[]> expected = new ArrayList<Object[]>();
        expected.add(this.inputTuples.get(6));
        expected.add(this.inputTuples.get(0));
        expected.add(this.inputTuples.get(2));
        expected.add(this.inputTuples.get(3));
        expected.add(this.inputTuples.get(5));
        expected.add(this.inputTuples.get(1));
        expected.add(this.inputTuples.get(4));
        Assert.assertThat((Object)this.component.execute(), Is.is(expected));
    }

    @Test
    public void shouldReturnEmptyResultsWhenDelegateReturnsEmptyResults() {
        Assert.assertThat((Object)this.component.execute().isEmpty(), Is.is(true));
    }
}

