/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.UUID;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.Request;

public abstract class AbstractRequestTest {
    protected ExecutionContext context;
    protected String workspace1;
    protected String workspace2;
    protected Location validPathLocation;
    protected Location validUuidLocation;
    protected Location validPropsLocation;
    protected Location validPathLocation1;
    protected Location validUuidLocation1;
    protected Location validPropsLocation1;
    protected Location validPathLocation2;
    protected Location validUuidLocation2;
    protected Location validPropsLocation2;
    protected Property validProperty1;
    protected Property validProperty2;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.workspace1 = "workspace1";
        this.workspace2 = "workspace2";
        Path validPath = this.createPath("/a/b/c");
        UUID validUuid = UUID.randomUUID();
        Name idProperty1Name = this.createName("id1");
        Name idProperty2Name = this.createName("id2");
        Property idProperty1 = this.context.getPropertyFactory().create(idProperty1Name, new Object[]{"1"});
        Property idProperty2 = this.context.getPropertyFactory().create(idProperty2Name, new Object[]{"2"});
        this.validPathLocation = Location.create((Path)validPath);
        this.validUuidLocation = Location.create((UUID)validUuid);
        this.validPropsLocation = Location.create((Property)idProperty1, (Property[])new Property[]{idProperty2});
        this.validPathLocation1 = Location.create((Path)validPath);
        this.validUuidLocation1 = Location.create((UUID)validUuid);
        this.validPropsLocation1 = Location.create((Property)idProperty1, (Property[])new Property[]{idProperty2});
        validPath = this.createPath("/a/c/d");
        validUuid = UUID.randomUUID();
        idProperty1 = this.context.getPropertyFactory().create(idProperty1Name, new Object[]{"3"});
        idProperty2 = this.context.getPropertyFactory().create(idProperty2Name, new Object[]{"4"});
        this.validPathLocation2 = Location.create((Path)validPath);
        this.validUuidLocation2 = Location.create((UUID)validUuid);
        this.validPropsLocation2 = Location.create((Property)idProperty1, (Property[])new Property[]{idProperty2});
        this.validProperty1 = this.context.getPropertyFactory().create(this.createName("fooProperty"), new Object[]{"foo"});
        this.validProperty2 = this.context.getPropertyFactory().create(this.createName("barProperty"), new Object[]{"bar"});
    }

    protected Path createPath(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected Name createName(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    protected Location location(String path) {
        return Location.create((Path)this.createPath(path));
    }

    protected abstract Request createRequest();

    @Test
    public void shouldNotBeCancelledByDefault() {
        Request request = this.createRequest();
        Assert.assertThat((Object)request.isCancelled(), Is.is(false));
    }

    @Test
    public void shouldBeCancelledAfterCallingCancel() {
        Request request = this.createRequest();
        Assert.assertThat((Object)request.isCancelled(), Is.is(false));
        request.cancel();
        Assert.assertThat((Object)request.isCancelled(), Is.is(true));
    }
}

