/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.request.AbstractRequestTest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.Request;

public class CreateWorkspaceRequestTest
extends AbstractRequestTest {
    private CreateWorkspaceRequest request;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
    }

    @Override
    protected Request createRequest() {
        return new CreateWorkspaceRequest(this.workspace1, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullWorkspaceName() {
        new CreateWorkspaceRequest(null, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE);
    }

    @Test
    public void shouldAllowCreatingRequestWithNullCreateConflictBehavior() {
        this.request = new CreateWorkspaceRequest(this.workspace1, null);
        Assert.assertThat((Object)this.request.conflictBehavior(), Is.is(CreateWorkspaceRequest.DEFAULT_CREATE_CONFLICT_BEHAVIOR));
    }

    @Test
    public void shouldCreateValidRequestWithValidLocation() {
        this.request = new CreateWorkspaceRequest(this.workspace1, CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME);
        Assert.assertThat((Object)this.request.desiredNameOfNewWorkspace(), Is.is(this.workspace1));
        Assert.assertThat((Object)this.request.conflictBehavior(), Is.is(CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME));
        Assert.assertThat((Object)this.request.hasError(), Is.is(false));
        Assert.assertThat((Object)this.request.getError(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithSameLocations() {
        this.request = new CreateWorkspaceRequest(this.workspace1, CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME);
        CreateWorkspaceRequest request2 = new CreateWorkspaceRequest(this.workspace1, CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME);
        Assert.assertThat((Object)this.request, Is.is(request2));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithDifferentCreateConflictBehaviors() {
        this.request = new CreateWorkspaceRequest(this.workspace1, CreateWorkspaceRequest.CreateConflictBehavior.DO_NOT_CREATE);
        CreateWorkspaceRequest request2 = new CreateWorkspaceRequest(this.workspace1, CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME);
        Assert.assertThat((Object)this.request, Is.is(request2));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentDesiredWorkspaceNames() {
        this.request = new CreateWorkspaceRequest(this.workspace1, CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME);
        CreateWorkspaceRequest request2 = new CreateWorkspaceRequest(this.workspace2, CreateWorkspaceRequest.CreateConflictBehavior.CREATE_WITH_ADJUSTED_NAME);
        Assert.assertThat((Object)this.request.equals((Object)request2), Is.is(false));
    }
}

