/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.AbstractRequestTest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.Request;

public class ReadNodeRequestTest
extends AbstractRequestTest {
    private ReadNodeRequest request;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
    }

    @Override
    protected Request createRequest() {
        return new ReadNodeRequest(this.validPathLocation1, this.workspace1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullLocation() {
        new ReadNodeRequest(null, this.workspace1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullWorkspaceName() {
        new ReadNodeRequest(this.validPathLocation, null);
    }

    @Test
    public void shouldCreateValidRequestWithValidLocation() {
        this.request = new ReadNodeRequest(this.validPathLocation1, this.workspace1);
        Assert.assertThat((Object)this.request.at(), Is.is(IsSame.sameInstance(this.validPathLocation1)));
        Assert.assertThat((Object)this.request.inWorkspace(), Is.is(IsSame.sameInstance(this.workspace1)));
        Assert.assertThat((Object)this.request.hasError(), Is.is(false));
        Assert.assertThat((Object)this.request.getError(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithSameLocations() {
        this.request = new ReadNodeRequest(this.validPathLocation1, this.workspace1);
        ReadNodeRequest request2 = new ReadNodeRequest(this.validPathLocation1, new String(this.workspace1));
        Assert.assertThat((Object)this.request, Is.is(request2));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentLocations() {
        this.request = new ReadNodeRequest(this.validPathLocation1, this.workspace1);
        ReadNodeRequest request2 = new ReadNodeRequest(this.validPathLocation2, this.workspace1);
        Assert.assertThat((Object)this.request.equals((Object)request2), Is.is(false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentWorkspaceNames() {
        this.request = new ReadNodeRequest(this.validPathLocation1, this.workspace1);
        ReadNodeRequest request2 = new ReadNodeRequest(this.validPathLocation1, this.workspace2);
        Assert.assertThat((Object)this.request.equals((Object)request2), Is.is(false));
    }

    @Test
    public void shouldAllowAddingChildren() {
        this.request = new ReadNodeRequest(this.validPathLocation, this.workspace1);
        this.request.addChild(this.validPathLocation1);
        this.request.addChild(this.validPathLocation2);
        Assert.assertThat((Object)this.request.getChildren().size(), Is.is(2));
        Assert.assertThat((Object)this.request.getChildren(), (Matcher)JUnitMatchers.hasItems((Object[])new Location[]{this.validPathLocation1, this.validPathLocation2}));
    }

    @Test
    public void shouldAllowAddingProperties() {
        this.request = new ReadNodeRequest(this.validPathLocation, this.workspace1);
        this.request.addProperty(this.validProperty1);
        this.request.addProperty(this.validProperty2);
        Assert.assertThat((Object)this.request.getProperties().size(), Is.is(2));
        Assert.assertThat((Object)this.request.getProperties(), (Matcher)JUnitMatchers.hasItems((Object[])new Property[]{this.validProperty1, this.validProperty2}));
        Assert.assertThat(this.request.getPropertiesByName().get(this.validProperty1.getName()), Is.is(this.validProperty1));
        Assert.assertThat(this.request.getPropertiesByName().get(this.validProperty2.getName()), Is.is(this.validProperty2));
    }
}

