/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.LocationWithPath;
import org.modeshape.graph.LocationWithPathAndProperties;
import org.modeshape.graph.LocationWithPathAndProperty;
import org.modeshape.graph.LocationWithPathAndUuid;
import org.modeshape.graph.LocationWithProperties;
import org.modeshape.graph.LocationWithProperty;
import org.modeshape.graph.LocationWithUuid;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;

@Immutable
public abstract class Location
implements Iterable<Property>,
Comparable<Location>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Comparator<Location> COMPARATOR = new Comparator<Location>(){

        @Override
        public int compare(Location o1, Location o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    };
    protected static final Iterator<Property> NO_ID_PROPERTIES_ITERATOR = new Iterator<Property>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Property next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    public static final Comparator<Location> comparator() {
        return COMPARATOR;
    }

    public static Location create(Path path) {
        CheckArg.isNotNull((Object)path, (String)"path");
        return new LocationWithPath(path);
    }

    public static Location create(UUID uuid) {
        CheckArg.isNotNull((Object)uuid, (String)"uuid");
        return new LocationWithUuid(uuid);
    }

    public static Location create(Path path, UUID uuid) {
        if (path == null) {
            return Location.create(uuid);
        }
        if (uuid == null) {
            return Location.create(path);
        }
        return new LocationWithPathAndUuid(path, uuid);
    }

    public static Location create(Path path, Property idProperty) {
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isNotNull((Object)idProperty, (String)"idProperty");
        if (ModeShapeLexicon.UUID.equals(idProperty.getName()) && idProperty.isSingle()) {
            Object uuid = idProperty.getFirstValue();
            assert (uuid instanceof UUID);
            return new LocationWithPathAndUuid(path, (UUID)uuid);
        }
        return new LocationWithPathAndProperty(path, idProperty);
    }

    public static Location create(Path path, Property firstIdProperty, Property ... remainingIdProperties) {
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isNotNull((Object)firstIdProperty, (String)"firstIdProperty");
        CheckArg.isNotNull((Object)remainingIdProperties, (String)"remainingIdProperties");
        ArrayList<Property> idProperties = new ArrayList<Property>(1 + remainingIdProperties.length);
        HashSet<Name> names = new HashSet<Name>();
        names.add(firstIdProperty.getName());
        idProperties.add(firstIdProperty);
        for (Property property : remainingIdProperties) {
            if (!names.add(property.getName())) continue;
            idProperties.add(property);
        }
        return new LocationWithPathAndProperties(path, idProperties);
    }

    public static Location create(Path path, Iterable<Property> idProperties) {
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isNotNull(idProperties, (String)"idProperties");
        ArrayList<Property> idPropertiesList = new ArrayList<Property>();
        HashSet<Name> names = new HashSet<Name>();
        for (Property property : idProperties) {
            if (!names.add(property.getName())) continue;
            idPropertiesList.add(property);
        }
        if (idPropertiesList.isEmpty()) {
            return new LocationWithPath(path);
        }
        return new LocationWithPathAndProperties(path, idPropertiesList);
    }

    public static Location create(Property idProperty) {
        CheckArg.isNotNull((Object)idProperty, (String)"idProperty");
        if (ModeShapeLexicon.UUID.equals(idProperty.getName()) && idProperty.isSingle()) {
            Object uuid = idProperty.getFirstValue();
            assert (uuid instanceof UUID);
            return new LocationWithUuid((UUID)uuid);
        }
        return new LocationWithProperty(idProperty);
    }

    public static Location create(Property firstIdProperty, Property ... remainingIdProperties) {
        CheckArg.isNotNull((Object)firstIdProperty, (String)"firstIdProperty");
        CheckArg.isNotNull((Object)remainingIdProperties, (String)"remainingIdProperties");
        if (remainingIdProperties.length == 0) {
            return Location.create(firstIdProperty);
        }
        ArrayList<Property> idProperties = new ArrayList<Property>(1 + remainingIdProperties.length);
        HashSet<Name> names = new HashSet<Name>();
        names.add(firstIdProperty.getName());
        idProperties.add(firstIdProperty);
        for (Property property : remainingIdProperties) {
            if (!names.add(property.getName())) continue;
            idProperties.add(property);
        }
        return new LocationWithProperties(idProperties);
    }

    public static Location create(Iterable<Property> idProperties) {
        CheckArg.isNotNull(idProperties, (String)"idProperties");
        ArrayList<Property> idPropertiesList = new ArrayList<Property>();
        HashSet<Name> names = new HashSet<Name>();
        for (Property property : idProperties) {
            if (!names.add(property.getName())) continue;
            idPropertiesList.add(property);
        }
        return Location.create(idPropertiesList);
    }

    public static Location create(List<Property> idProperties) {
        CheckArg.isNotEmpty(idProperties, (String)"idProperties");
        return new LocationWithProperties(idProperties);
    }

    public abstract Path getPath();

    public boolean hasPath() {
        return this.getPath() != null;
    }

    public abstract List<Property> getIdProperties();

    public boolean hasIdProperties() {
        return this.getIdProperties() != null && this.getIdProperties().size() != 0;
    }

    public Property getIdProperty(Name name) {
        CheckArg.isNotNull((Object)name, (String)"name");
        if (this.getIdProperties() != null) {
            for (Property property : this.getIdProperties()) {
                if (!property.getName().equals(name)) continue;
                return property;
            }
        }
        return null;
    }

    public UUID getUuid() {
        Object value;
        Property property = this.getIdProperty(ModeShapeLexicon.UUID);
        if (property != null && !property.isEmpty() && (value = property.getFirstValue()) instanceof UUID) {
            return (UUID)value;
        }
        return null;
    }

    public boolean isSame(Location that) {
        if (that == null) {
            return false;
        }
        if (this.hasPath() ? !this.getPath().equals(that.getPath()) : that.hasPath()) {
            return false;
        }
        if (this.hasIdProperties()) {
            if (that.hasIdProperties()) {
                return ((Object)this.getIdProperties()).equals(that.getIdProperties());
            }
            return false;
        }
        return !that.hasIdProperties();
    }

    @Override
    public Iterator<Property> iterator() {
        return this.getIdProperties() != null ? this.getIdProperties().iterator() : NO_ID_PROPERTIES_ITERATOR;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.getPath(), this.getIdProperties()});
    }

    public boolean equals(Object obj) {
        return this.equals(obj, true);
    }

    public boolean equals(Object obj, boolean requireSameNameSiblingIndexes) {
        if (obj instanceof Location) {
            Location that = (Location)obj;
            if (requireSameNameSiblingIndexes) {
                if (this.hasPath() && that.hasPath()) {
                    return this.getPath().equals(that.getPath());
                }
            } else {
                Path thisPath = this.getPath();
                Path thatPath = that.getPath();
                if (thisPath.isRoot()) {
                    return thatPath.isRoot();
                }
                if (thatPath.isRoot()) {
                    return thisPath.isRoot();
                }
                if (!thisPath.hasSameAncestor(thatPath)) {
                    return false;
                }
                if (!thisPath.getLastSegment().getName().equals(thatPath.getLastSegment().getName())) {
                    return false;
                }
            }
            if (this.hasIdProperties()) {
                return ((Object)this.getIdProperties()).equals(that.getIdProperties());
            }
        }
        return false;
    }

    @Override
    public int compareTo(Location that) {
        if (this == that) {
            return 0;
        }
        if (this.hasPath() && that.hasPath()) {
            return this.getPath().compareTo(that.getPath());
        }
        UUID thisUuid = this.getUuid();
        UUID thatUuid = that.getUuid();
        if (thisUuid != null && thatUuid != null) {
            return thisUuid.compareTo(thatUuid);
        }
        return this.hashCode() - that.hashCode();
    }

    public String getString() {
        return this.getString(null, null, null);
    }

    public String getString(TextEncoder encoder) {
        return this.getString(null, encoder, null);
    }

    public String getString(NamespaceRegistry namespaceRegistry) {
        return this.getString(namespaceRegistry, null, null);
    }

    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder) {
        return this.getString(namespaceRegistry, encoder, null);
    }

    public String getString(NamespaceRegistry namespaceRegistry, TextEncoder encoder, TextEncoder delimiterEncoder) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        boolean hasPath = this.hasPath();
        if (hasPath) {
            sb.append(this.getPath().getString(namespaceRegistry, encoder, delimiterEncoder));
        }
        if (this.hasIdProperties()) {
            if (hasPath) {
                sb.append(" && ");
            }
            sb.append("[");
            boolean first = true;
            for (Property idProperty : this.getIdProperties()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(idProperty.getString(namespaceRegistry, encoder, delimiterEncoder));
            }
            sb.append("]");
        }
        sb.append(" }");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean hasPath = this.hasPath();
        boolean hasProps = this.hasIdProperties();
        if (hasPath) {
            if (hasProps) {
                sb.append("<");
            }
            sb.append(this.getPath());
        }
        if (hasProps) {
            if (hasPath) {
                sb.append(" && ");
            }
            sb.append("[");
            boolean first = true;
            for (Property idProperty : this.getIdProperties()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(idProperty);
            }
            sb.append("]");
            if (hasPath) {
                sb.append(">");
            }
        }
        return sb.toString();
    }

    public abstract Location with(Property var1);

    public abstract Location with(Path var1);

    public abstract Location with(UUID var1);
}

