/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.observe;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.request.ChangeRequest;

@Immutable
public class Changes
implements Comparable<Changes>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final String processId;
    protected final String contextId;
    protected final String userName;
    protected final String sourceName;
    protected final DateTime timestamp;
    protected final List<ChangeRequest> changeRequests;

    public Changes(String processId, String contextId, String userName, String sourceName, DateTime timestamp, List<ChangeRequest> requests) {
        assert (requests != null);
        assert (!requests.isEmpty());
        this.userName = userName;
        this.sourceName = sourceName;
        this.timestamp = timestamp;
        this.changeRequests = Collections.unmodifiableList(requests);
        this.processId = processId != null ? processId : "";
        String string = this.contextId = contextId != null ? contextId : "";
        assert (this.userName != null);
        assert (this.sourceName != null);
        assert (this.timestamp != null);
        assert (this.changeRequests != null);
        assert (this.processId != null);
    }

    protected Changes(Changes changes) {
        this.userName = changes.userName;
        this.sourceName = changes.sourceName;
        this.timestamp = changes.timestamp;
        this.changeRequests = changes.changeRequests;
        this.processId = changes.processId;
        this.contextId = changes.contextId;
        assert (this.userName != null);
        assert (this.sourceName != null);
        assert (this.timestamp != null);
        assert (this.changeRequests != null);
        assert (this.processId != null);
        assert (this.contextId != null);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getContextId() {
        return this.contextId;
    }

    public List<ChangeRequest> getChangeRequests() {
        return this.changeRequests;
    }

    public int hashCode() {
        return this.getTimestamp().hashCode();
    }

    @Override
    public int compareTo(Changes that) {
        if (this == that) {
            return 0;
        }
        return this.getTimestamp().compareTo(that.getTimestamp());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Changes) {
            Changes that = (Changes)obj;
            if (!this.getProcessId().equals(that.getProcessId())) {
                return false;
            }
            if (!this.getContextId().equals(that.getContextId())) {
                return false;
            }
            if (!this.getSourceName().equals(that.getSourceName())) {
                return false;
            }
            if (!this.getTimestamp().equals(that.getTimestamp())) {
                return false;
            }
            return this.getUserName().equals(that.getUserName());
        }
        return false;
    }

    public String toString() {
        if (this.processId.length() != 0) {
            return this.getTimestamp() + " @" + this.getUserName() + " [" + this.getSourceName() + "] - " + this.changeRequests.size() + " events";
        }
        return this.getTimestamp() + " @" + this.getUserName() + " #" + this.getProcessId() + " [" + this.getSourceName() + "] - " + this.changeRequests.size() + " events";
    }
}

