/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

@Immutable
public class PropertyExistence
extends Constraint {
    private static final long serialVersionUID = 1L;
    private final SelectorName selectorName;
    private final String propertyName;
    private final int hc;

    public PropertyExistence(SelectorName selectorName, String propertyName) {
        CheckArg.isNotNull((Object)selectorName, (String)"selectorName");
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        this.selectorName = selectorName;
        this.propertyName = propertyName;
        this.hc = HashCode.compute((Object[])new Object[]{this.selectorName, this.propertyName});
    }

    public final SelectorName getSelectorName() {
        return this.selectorName;
    }

    public final String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PropertyExistence) {
            PropertyExistence that = (PropertyExistence)obj;
            if (this.hc != that.hc) {
                return false;
            }
            return this.selectorName.equals(that.selectorName) && this.propertyName.equals(that.propertyName);
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

