/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.graph.query.model.JoinCondition;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.model.Visitors;

@Immutable
public class SameNodeJoinCondition
extends JoinCondition {
    private static final long serialVersionUID = 1L;
    private final SelectorName selector1Name;
    private final SelectorName selector2Name;
    private final String selector2Path;
    private final int hc;

    public SameNodeJoinCondition(SelectorName selector1Name, SelectorName selector2Name, String selector2Path) {
        CheckArg.isNotNull((Object)selector1Name, (String)"selector1Name");
        CheckArg.isNotNull((Object)selector2Name, (String)"selector2Name");
        CheckArg.isNotNull((Object)selector2Path, (String)"selector2Path");
        this.selector1Name = selector1Name;
        this.selector2Name = selector2Name;
        this.selector2Path = selector2Path;
        this.hc = HashCode.compute((Object[])new Object[]{this.selector1Name, this.selector2Name, this.selector2Path});
    }

    public SameNodeJoinCondition(SelectorName selector1Name, SelectorName selector2Name) {
        CheckArg.isNotNull((Object)selector1Name, (String)"selector1Name");
        CheckArg.isNotNull((Object)selector2Name, (String)"selector2Name");
        this.selector1Name = selector1Name;
        this.selector2Name = selector2Name;
        this.selector2Path = null;
        this.hc = HashCode.compute((Object[])new Object[]{this.selector1Name, this.selector2Name, this.selector2Path});
    }

    public final SelectorName getSelector1Name() {
        return this.selector1Name;
    }

    public final SelectorName getSelector2Name() {
        return this.selector2Name;
    }

    public final String getSelector2Path() {
        return this.selector2Path;
    }

    public String toString() {
        return Visitors.readable(this);
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SameNodeJoinCondition) {
            SameNodeJoinCondition that = (SameNodeJoinCondition)obj;
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.selector1Name.equals(that.selector1Name)) {
                return false;
            }
            if (!this.selector2Name.equals(that.selector2Name)) {
                return false;
            }
            return ObjectUtil.isEqualWithNulls((Object)this.selector2Path, (Object)that.selector2Path);
        }
        return false;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

