/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.modeshape.graph.GraphI18n;

public abstract class Request
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Throwable error;
    private AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AtomicBoolean frozen = new AtomicBoolean(false);
    private transient CountDownLatch freezingLatch = null;

    protected Request() {
    }

    public void setLatchForFreezing(CountDownLatch latch) {
        this.checkNotFrozen();
        this.freezingLatch = latch;
    }

    public void setError(Throwable error) {
        this.checkNotFrozen();
        this.error = error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    void setCancelledFlag(AtomicBoolean cancelled) {
        assert (cancelled != null);
        this.cancelled = cancelled;
    }

    AtomicBoolean getCancelledFlag() {
        return this.cancelled;
    }

    public void cancel() {
        this.checkNotFrozen();
        this.cancelled.set(true);
    }

    public abstract boolean isReadOnly();

    public boolean isFrozen() {
        return this.frozen.get();
    }

    public boolean freeze() {
        if (this.frozen.compareAndSet(false, true)) {
            CountDownLatch latch = this.freezingLatch;
            if (latch != null) {
                latch.countDown();
            }
            return true;
        }
        return false;
    }

    protected void checkNotFrozen() throws IllegalStateException {
        if (this.frozen.get()) {
            throw new IllegalStateException(GraphI18n.requestIsFrozenAndMayNotBeChanged.text(new Object[]{this}));
        }
    }
}

