/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAResource;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.MockRepositoryRequestProcessor;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.request.Request;

public class MockRepositoryConnection
implements RepositoryConnection {
    private final String sourceName;
    private final Queue<Request> processed;

    public MockRepositoryConnection(String sourceName) {
        this(sourceName, new LinkedList<Request>());
    }

    public MockRepositoryConnection(String sourceName, Queue<Request> processed) {
        assert (sourceName != null);
        this.sourceName = sourceName;
        this.processed = processed != null ? processed : new LinkedList();
    }

    public Queue<Request> getProcessedRequests() {
        return this.processed;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
        MockRepositoryRequestProcessor processor = new MockRepositoryRequestProcessor(this.sourceName, context, this.processed);
        try {
            processor.process(request);
        }
        finally {
            processor.close();
        }
    }

    public CachePolicy getDefaultCachePolicy() {
        return null;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public XAResource getXAResource() {
        return null;
    }

    public boolean ping(long time, TimeUnit unit) {
        return true;
    }
}

