/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.inmemory;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.Request;

public class InMemoryRepositorySourceTest {
    private ExecutionContext context;
    private RepositoryContext repositoryContext;
    private InMemoryRepositorySource source;
    private String[] predefinedWorkspaces = new String[]{"foo", "bar", "baz"};

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.repositoryContext = (RepositoryContext)Mockito.mock(RepositoryContext.class);
        Mockito.when((Object)this.repositoryContext.getExecutionContext()).thenReturn((Object)this.context);
        this.source = new InMemoryRepositorySource();
        this.source.setName("In-Memory Repository Source");
        this.source.setPredefinedWorkspaceNames(this.predefinedWorkspaces);
        this.source.setDefaultWorkspaceName(this.predefinedWorkspaces[0]);
        this.source.initialize(this.repositoryContext);
    }

    @Test
    public void shouldCreatePredefinedWorkspaces() {
        RepositoryConnection connection = this.source.getConnection();
        GetWorkspacesRequest request = new GetWorkspacesRequest();
        connection.execute(this.context, (Request)request);
        Set workspaces = request.getAvailableWorkspaceNames();
        HashSet<String> graphWorkspaces = new HashSet<String>(Arrays.asList(this.predefinedWorkspaces));
        Assert.assertThat((Object)workspaces, CoreMatchers.is(graphWorkspaces));
    }
}

