/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property;

import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.property.InvalidPathExpressionException;
import org.modeshape.graph.property.PathExpression;

public class PathExpressionTest {
    private PathExpression expr;

    @Before
    public void beforeEach() throws Exception {
        this.expr = new PathExpression(".*");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCompileNullExpression() {
        PathExpression.compile(null);
    }

    @Test(expected=InvalidPathExpressionException.class)
    public void shouldNotCompileZeroLengthExpression() {
        PathExpression.compile((String)"");
    }

    @Test(expected=InvalidPathExpressionException.class)
    public void shouldNotCompileBlankExpression() {
        PathExpression.compile((String)"    ");
    }

    @Test
    public void shouldCompileExpressionWithAnyNode() {
        this.expr = PathExpression.compile((String)"/*");
        Assert.assertThat((Object)this.expr.getSelectExpression(), Is.is("/*"));
        Assert.assertThat((Object)this.expr.matcher("/a").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a").getInputPath(), Is.is("/a"));
        Assert.assertThat((Object)this.expr.matcher("/a").getSelectedNodePath(), Is.is("/a"));
        Assert.assertThat((Object)this.expr.matcher("/a").groupCount(), Is.is(0));
    }

    @Test
    public void shouldCompileExpressionWithAnySequenceOfNodes() {
        this.expr = PathExpression.compile((String)"//");
        Assert.assertThat((Object)this.expr.getSelectExpression(), Is.is("//"));
        Assert.assertThat((Object)this.expr.matcher("/a").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a").getInputPath(), Is.is("/a"));
        Assert.assertThat((Object)this.expr.matcher("/a").getSelectedNodePath(), Is.is("/a"));
        Assert.assertThat((Object)this.expr.matcher("/a").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b").getInputPath(), Is.is("/a/b"));
        Assert.assertThat((Object)this.expr.matcher("/a/b").getSelectedNodePath(), Is.is("/a/b"));
        Assert.assertThat((Object)this.expr.matcher("/a/b").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").getInputPath(), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").getSelectedNodePath(), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").groupCount(), Is.is(0));
    }

    @Test
    public void shouldCompileExpressionWithExtraWhitespace() {
        this.expr = PathExpression.compile((String)" /a/b/c ");
        Assert.assertThat((Object)this.expr, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.expr.getSelectExpression(), Is.is("/a/b/c"));
        this.expr = PathExpression.compile((String)"  /a/b/c ");
        Assert.assertThat((Object)this.expr, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.expr.getSelectExpression(), Is.is("/a/b/c"));
    }

    @Test
    public void shouldCompileExpressionWithIndexes() {
        Assert.assertThat((Object)PathExpression.compile((String)"/a/b[0]/c[1]/d/e"), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)PathExpression.compile((String)"/a/b[0]/c[1]/d/e[2]"), Is.is(IsNull.notNullValue()));
    }

    @Test
    public void shouldNotRemoveUsedPredicates() {
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b/c"), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[0]/c"), Is.is("/a/b[0]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[1]/c"), Is.is("/a/b[1]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[10]/c"), Is.is("/a/b[10]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[100]/c"), Is.is("/a/b[100]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[1000]/c"), Is.is("/a/b[1000]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[]/c"), Is.is("/a/b[]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[*]/c"), Is.is("/a/b[*]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[1,2]/c"), Is.is("/a/b[1,2]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[1,2,3,4,5]/c"), Is.is("/a/b[1,2,3,4,5]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b/c[@title]"), Is.is("/a/b/c[@title]"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b/c[d/e/@title]"), Is.is("/a/b/c[d/e/@title]"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/(b/c)[(d|e)/(f|g)/@something]"), Is.is("/a/(b/c)[(d|e)/(f|g)/@something]"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/*"), Is.is("/*"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/*[]"), Is.is("/*[]"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/*[3]"), Is.is("/*[3]"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[1][2][3]/c"), Is.is("/a/b[1][2][3]/c"));
    }

    @Test
    public void shouldRemoveUnusedPredicates() {
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[-1]/c"), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[@name='wacky']/c"), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[3][@name='wacky']/c"), Is.is("/a/b[3]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[3][@name]/c"), Is.is("/a/b[3]/c"));
        Assert.assertThat((Object)this.expr.removeUnusedPredicates("/a/b[length(@name)=3]/c"), Is.is("/a/b/c"));
    }

    @Test
    public void shouldRemoveAllPredicates() {
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b/c"), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[0]/c"), Is.is("/a/b[0]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[1]/c"), Is.is("/a/b[1]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[10]/c"), Is.is("/a/b[10]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[100]/c"), Is.is("/a/b[100]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[1000]/c"), Is.is("/a/b[1000]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[]/c"), Is.is("/a/b[]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[*]/c"), Is.is("/a/b[*]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b/c[@title]"), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[1][2][3]/c"), Is.is("/a/b[1][2][3]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[-1]/c"), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[@name='wacky']/c"), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[3][@name='wacky']/c"), Is.is("/a/b[3]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[3][@name]/c"), Is.is("/a/b[3]/c"));
        Assert.assertThat((Object)this.expr.removeAllPredicatesExceptIndexes("/a/b[length(@name)=3]/c"), Is.is("/a/b/c"));
    }

    @Test
    public void shouldReplaceAllXPathPatterns() {
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[3]/c"), Is.is("/a/b\\[3\\]/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[*]/c"), Is.is("/a/b(?:\\[\\d+\\])?/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[]/c"), Is.is("/a/b(?:\\[\\d+\\])?/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[0]/c"), Is.is("/a/b(?:\\[0\\])?/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[0,1,2,4]/c"), Is.is("/a/b(?:\\[(?:1|2|4)\\])?/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[1,2,4,0]/c"), Is.is("/a/b(?:\\[(?:1|2|4)\\])?/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[1,2,0,4]/c"), Is.is("/a/b(?:\\[(?:1|2|4)\\])?/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[0,1,2,0,4,0]/c"), Is.is("/a/b(?:\\[(?:1|2|4)\\])?/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[1,2,4]/c"), Is.is("/a/b\\[(?:1|2|4)\\]/c"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[@param]"), Is.is("/a/b/@param"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[3][@param]"), Is.is("/a/b\\[3\\]/@param"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/b[c/d/@param]"), Is.is("/a/b/c/d/@param"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(b|c|d)/e"), Is.is("/a/(b|c|d)/e"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(b||c|d)/e"), Is.is("/a/(b|c|d)/e"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(b|||c|d)/e"), Is.is("/a/(b|c|d)/e"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(|b|c|d)/e"), Is.is("/a(?:/(b|c|d))?/e"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(b|c|d|)/e"), Is.is("/a(?:/(b|c|d))?/e"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(b|c|d)[]/e"), Is.is("/a/(b|c|d)(?:\\[\\d+\\])?/e"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(b|c[2]|d[])/e"), Is.is("/a/(b|c\\[2\\]|d(?:\\[\\d+\\])?)/e"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(b|c/d|e)/f"), Is.is("/a/(b|c/d|e)/f"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/(b/c)[(d|e)/(f|g)/@something]"), Is.is("/a/(b/c)/(d|e)/(f|g)/@something"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/*/f"), Is.is("/a/[^/]*/f"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a//f"), Is.is("/a(?:/[^/]*)*/f"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a///f"), Is.is("/a(?:/[^/]*)*/f"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/a/////f"), Is.is("/a(?:/[^/]*)*/f"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/*"), Is.is("/[^/]*"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/*[]"), Is.is("/[^/]*(?:\\[\\d+\\])?"));
        Assert.assertThat((Object)this.expr.replaceXPathPatterns("/*[3]"), Is.is("/[^/]*\\[3\\]"));
    }

    @Test
    public void shouldDetermineIfPatternMatchesAnything() {
        Assert.assertThat((Object)PathExpression.compile((String)"/.").matchesAnything(), Is.is(true));
        Assert.assertThat((Object)PathExpression.compile((String)"//").matchesAnything(), Is.is(true));
        Assert.assertThat((Object)PathExpression.compile((String)"///").matchesAnything(), Is.is(true));
        Assert.assertThat((Object)PathExpression.compile((String)"///").matchesAnything(), Is.is(true));
        Assert.assertThat((Object)PathExpression.compile((String)"/*").matchesAnything(), Is.is(true));
        Assert.assertThat((Object)PathExpression.compile((String)"*").matchesAnything(), Is.is(true));
        Assert.assertThat((Object)PathExpression.compile((String)"*[*]").matchesAnything(), Is.is(true));
        Assert.assertThat((Object)PathExpression.compile((String)"*[]").matchesAnything(), Is.is(true));
        Assert.assertThat((Object)PathExpression.compile((String)"/a").matchesAnything(), Is.is(false));
        Assert.assertThat((Object)PathExpression.compile((String)"/*[3]").matchesAnything(), Is.is(false));
        Assert.assertThat((Object)PathExpression.compile((String)"/a/b/c").matchesAnything(), Is.is(false));
    }

    @Test
    public void shouldMatchExpressionsWithoutRegardToCase() {
        this.expr = PathExpression.compile((String)"/a/b/c/d/e[@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getInputPath(), Is.is("/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/E/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/E/@something").getInputPath(), Is.is("/a/b/c/d/E/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/E/@something").getSelectedNodePath(), Is.is("/a/b/c/d/E"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/E/@something").groupCount(), Is.is(0));
    }

    @Test
    public void shouldMatchExpressionsWithExactFullPath() {
        this.expr = PathExpression.compile((String)"/a/b/c/d/e[@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getInputPath(), Is.is("/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/E/@something2").matches(), Is.is(false));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/ex/@something").matches(), Is.is(false));
        Assert.assertThat((Object)this.expr.matcher("/a/b[1]/c/d/e/@something").matches(), Is.is(false));
    }

    @Test
    public void shouldMatchExpressionsWithExactFullPathAndExtraPathInsideMatch() {
        this.expr = PathExpression.compile((String)"/a/b/c[d/e/@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getInputPath(), Is.is("/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/E/@something2").matches(), Is.is(false));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/ex/@something").matches(), Is.is(false));
        Assert.assertThat((Object)this.expr.matcher("/a/b[1]/c/d/e/@something").matches(), Is.is(false));
    }

    @Test
    public void shouldMatchExpressionsWithWildcardSelection() {
        this.expr = PathExpression.compile((String)"/a/*/c[d/e/@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getInputPath(), Is.is("/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getInputPath(), Is.is("/a/b[2]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b[2]/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/rt/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/rt/c/d/e/@something").getInputPath(), Is.is("/a/rt/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/rt/c/d/e/@something").getSelectedNodePath(), Is.is("/a/rt/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/rt/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/ac/d/e/@something").matches(), Is.is(false));
        Assert.assertThat((Object)this.expr.matcher("/a/d/e/@something").matches(), Is.is(false));
        Assert.assertThat((Object)this.expr.matcher("/a/b/b2/b3/d/e/@something").matches(), Is.is(false));
    }

    @Test
    public void shouldMatchExpressionsWithFilenameLikeWildcardSelection() {
        this.expr = PathExpression.compile((String)"/a/*.txt[@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/@something").getInputPath(), Is.is("/a/b.txt/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/@something").getSelectedNodePath(), Is.is("/a/b.txt"));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b.tx/@something").matches(), Is.is(false));
        this.expr = PathExpression.compile((String)"/a/*.txt/c[@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/c/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/c/@something").getInputPath(), Is.is("/a/b.txt/c/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/c/@something").getSelectedNodePath(), Is.is("/a/b.txt/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/c/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b.tx/c/@something").matches(), Is.is(false));
        this.expr = PathExpression.compile((String)"//*.txt[*]/c[@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/c/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/c/@something").getInputPath(), Is.is("/a/b.txt/c/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/c/@something").getSelectedNodePath(), Is.is("/a/b.txt/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b.txt/c/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b.tx/c/@something").matches(), Is.is(false));
        Assert.assertThat((Object)this.expr.matcher("/z/a/b.txt/c/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/z/a/b.txt/c/@something").getInputPath(), Is.is("/z/a/b.txt/c/@something"));
        Assert.assertThat((Object)this.expr.matcher("/z/a/b.txt/c/@something").getSelectedNodePath(), Is.is("/z/a/b.txt/c"));
        Assert.assertThat((Object)this.expr.matcher("/z/a/b.txt/c/@something").groupCount(), Is.is(0));
    }

    @Test
    public void shouldMatchExpressionsWithSegmentWildcardSelection() {
        this.expr = PathExpression.compile((String)"/a//c[d/e/@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/c/d/e/@something").getInputPath(), Is.is("/a/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/c/d/e/@something").getSelectedNodePath(), Is.is("/a/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getInputPath(), Is.is("/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getInputPath(), Is.is("/a/b[2]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b[2]/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/rt/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/rt/c/d/e/@something").getInputPath(), Is.is("/a/rt/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/rt/c/d/e/@something").getSelectedNodePath(), Is.is("/a/rt/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/rt/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/r/s/t/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/r/s/t/c/d/e/@something").getInputPath(), Is.is("/a/r/s/t/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/r/s/t/c/d/e/@something").getSelectedNodePath(), Is.is("/a/r/s/t/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/r/s/t/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/r[1]/s[2]/t[33]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/r[1]/s[2]/t[33]/c/d/e/@something").getInputPath(), Is.is("/a/r[1]/s[2]/t[33]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/r[1]/s[2]/t[33]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/r[1]/s[2]/t[33]/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/r[1]/s[2]/t[33]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a[3]/c/d/e/@something").matches(), Is.is(false));
    }

    @Test
    public void shouldMatchExpressionsWithSegmentWildcardAtEnd() {
        this.expr = PathExpression.compile((String)"/a/b/c//");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").getInputPath(), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").getSelectedNodePath(), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d").getInputPath(), Is.is("/a/b/c/d"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d").getSelectedNodePath(), Is.is("/a/b/c/d"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/a").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/a").getInputPath(), Is.is("/a/b/c/a"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/a").getSelectedNodePath(), Is.is("/a/b/c/a"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/a").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/f/g/h").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/f/g/h").getInputPath(), Is.is("/a/b/c/d/e/f/g/h"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/f/g/h").getSelectedNodePath(), Is.is("/a/b/c/d/e/f/g/h"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/f/g/h").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b").matches(), Is.is(false));
        Assert.assertThat((Object)this.expr.matcher("/a/b/d").matches(), Is.is(false));
    }

    @Test
    public void shouldMatchExpressionsWithExtraLargeSegmentWildcardAtEnd() {
        this.expr = PathExpression.compile((String)"/a/b/c////");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").getInputPath(), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").getSelectedNodePath(), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c").groupCount(), Is.is(0));
    }

    @Test
    public void shouldMatchExpressionsWithIndexesInSelectionPaths() {
        this.expr = PathExpression.compile((String)"/a/b[2,3,4,5]/c/d/e[@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getInputPath(), Is.is("/a/b[2]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b[2]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").getInputPath(), Is.is("/a/b[3]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b[3]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").getInputPath(), Is.is("/a/b[4]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b[4]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").getInputPath(), Is.is("/a/b[5]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b[5]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[1]/c/d/e/@something").matches(), Is.is(false));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), Is.is(false));
        Assert.assertThat((Object)this.expr.matcher("/a[1]/b/c/d/e/@something").matches(), Is.is(false));
        this.expr = PathExpression.compile((String)"/a/b[0,2,3,4,5]/c/d/e[@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getInputPath(), Is.is("/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getInputPath(), Is.is("/a/b[2]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b[2]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").getInputPath(), Is.is("/a/b[3]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b[3]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").getInputPath(), Is.is("/a/b[4]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b[4]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").getInputPath(), Is.is("/a/b[5]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b[5]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[0]/c/d/e/@something").matches(), Is.is(false));
        Assert.assertThat((Object)this.expr.matcher("/a/b[1]/c/d/e/@something").matches(), Is.is(false));
        Assert.assertThat((Object)this.expr.matcher("/a[1]/b/c/d/e/@something").matches(), Is.is(false));
    }

    @Test
    public void shouldMatchExpressionsWithAnyIndexesInSelectionPaths() {
        this.expr = PathExpression.compile((String)"/a/b[*]/c[]/d/e[@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getInputPath(), Is.is("/a/b[2]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b[2]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[2]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").getInputPath(), Is.is("/a/b[3]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b[3]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[3]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").getInputPath(), Is.is("/a/b[4]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b[4]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[4]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").getInputPath(), Is.is("/a/b[5]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b[5]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[5]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[1]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[1]/c/d/e/@something").getInputPath(), Is.is("/a/b[1]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[1]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b[1]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[1]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[6]/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[6]/c/d/e/@something").getInputPath(), Is.is("/a/b[6]/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[6]/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b[6]/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[6]/c/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b[6]/c[1]/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b[6]/c[1]/d/e/@something").getInputPath(), Is.is("/a/b[6]/c[1]/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[6]/c[1]/d/e/@something").getSelectedNodePath(), Is.is("/a/b[6]/c[1]/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b[6]/c[1]/d/e/@something").groupCount(), Is.is(0));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getInputPath(), Is.is("/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b/c/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").groupCount(), Is.is(0));
    }

    @Test
    public void shouldMatchExpressionsWithRepositoryInSelectionPath() {
        this.expr = PathExpression.compile((String)"reposA:/a/b/c[d/e/@something]");
        Assert.assertThat((Object)this.expr.matcher("reposA:/a/b/c/d/e/@something").matches(), Is.is(true));
    }

    @Test
    public void shouldMatchExpressionsWithNamedGroups() {
        this.expr = PathExpression.compile((String)"/a(//c)[d/e/@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getInputPath(), Is.is("/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").getSelectedNodePath(), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").groupCount(), Is.is(1));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").group(0), Is.is("/a/b/c/d/e/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/e/@something").group(1), Is.is("/b/c"));
        this.expr = PathExpression.compile((String)"/a(/(b|c|d|)/e)[f/g/@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/e/f/g/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/e/f/g/@something").getInputPath(), Is.is("/a/b/e/f/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/e/f/g/@something").getSelectedNodePath(), Is.is("/a/b/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/e/f/g/@something").groupCount(), Is.is(2));
        Assert.assertThat((Object)this.expr.matcher("/a/b/e/f/g/@something").group(0), Is.is("/a/b/e/f/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/e/f/g/@something").group(1), Is.is("/b/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/e/f/g/@something").group(2), Is.is("b"));
        Assert.assertThat((Object)this.expr.matcher("/a/c/e/f/g/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/c/e/f/g/@something").getInputPath(), Is.is("/a/c/e/f/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/c/e/f/g/@something").getSelectedNodePath(), Is.is("/a/c/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/c/e/f/g/@something").groupCount(), Is.is(2));
        Assert.assertThat((Object)this.expr.matcher("/a/c/e/f/g/@something").group(0), Is.is("/a/c/e/f/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/c/e/f/g/@something").group(1), Is.is("/c/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/c/e/f/g/@something").group(2), Is.is("c"));
        Assert.assertThat((Object)this.expr.matcher("/a/d/e/f/g/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/d/e/f/g/@something").getInputPath(), Is.is("/a/d/e/f/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/d/e/f/g/@something").getSelectedNodePath(), Is.is("/a/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/d/e/f/g/@something").groupCount(), Is.is(2));
        Assert.assertThat((Object)this.expr.matcher("/a/d/e/f/g/@something").group(0), Is.is("/a/d/e/f/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/d/e/f/g/@something").group(1), Is.is("/d/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/d/e/f/g/@something").group(2), Is.is("d"));
        Assert.assertThat((Object)this.expr.matcher("/a/e/f/g/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/e/f/g/@something").getInputPath(), Is.is("/a/e/f/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/e/f/g/@something").getSelectedNodePath(), Is.is("/a/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/e/f/g/@something").groupCount(), Is.is(2));
        Assert.assertThat((Object)this.expr.matcher("/a/e/f/g/@something").group(0), Is.is("/a/e/f/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/e/f/g/@something").group(1), Is.is("/e"));
        Assert.assertThat((Object)this.expr.matcher("/a/e/f/g/@something").group(2), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.expr.matcher("/a/t/e/f/g/@something").matches(), Is.is(false));
        this.expr = PathExpression.compile((String)"/a/(b/c)[(d|e)/(f|g)/@something]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").getInputPath(), Is.is("/a/b/c/d/f/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").getSelectedNodePath(), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").groupCount(), Is.is(3));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").group(0), Is.is("/a/b/c/d/f/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").group(1), Is.is("b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").group(2), Is.is("d"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").group(3), Is.is("f"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").getInputPath(), Is.is("/a/b/c/e/f/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").getSelectedNodePath(), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").groupCount(), Is.is(3));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").group(0), Is.is("/a/b/c/e/f/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").group(1), Is.is("b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").group(2), Is.is("e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").group(3), Is.is("f"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").getInputPath(), Is.is("/a/b/c/d/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").getSelectedNodePath(), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").groupCount(), Is.is(3));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").group(0), Is.is("/a/b/c/d/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").group(1), Is.is("b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").group(2), Is.is("d"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").group(3), Is.is("g"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").getInputPath(), Is.is("/a/b/c/e/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").getSelectedNodePath(), Is.is("/a/b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").groupCount(), Is.is(3));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").group(0), Is.is("/a/b/c/e/g/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").group(1), Is.is("b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").group(2), Is.is("e"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").group(3), Is.is("g"));
        this.expr = PathExpression.compile((String)"/a/(b/c)/(d|e)/(f|g)/@something");
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").getInputPath(), Is.is("/a/b/c/d/f/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").getSelectedNodePath(), Is.is("/a/b/c/d/f"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").groupCount(), Is.is(3));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").group(0), Is.is("/a/b/c/d/f/@something"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").group(1), Is.is("b/c"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").group(2), Is.is("d"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/f/@something").group(3), Is.is("f"));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/f/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/d/g/@something").matches(), Is.is(true));
        Assert.assertThat((Object)this.expr.matcher("/a/b/c/e/g/@something").matches(), Is.is(true));
    }

    @Test
    public void shouldMatchExpressionWithFilenamePatternAndChildProperty() {
        this.expr = PathExpression.compile((String)"//(*.(jpeg|gif|bmp|pcx|png|iff|ras|pbm|pgm|ppm|psd))[*]/jcr:content[@jcr:data]");
        Assert.assertThat((Object)this.expr.matcher("/a/b/caution.png/jcr:content/@jcr:data").matches(), Is.is(true));
    }
}

