/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.modeshape.common.text.Jsr283Encoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.basic.BasicName;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;

public class BasicNameTest {
    private NamespaceRegistry namespaceRegistry;
    private Name name;
    private String validNamespaceUri;
    private String validLocalName;
    private TextEncoder encoder;
    private TextEncoder delimiterEncoder;
    private String validNamespacePrefix;

    @Before
    public void beforeEach() {
        this.validNamespacePrefix = "mode";
        this.validNamespaceUri = "http://www.modeshape.org/1.0";
        this.validLocalName = "localPart";
        this.name = new BasicName(this.validNamespaceUri, this.validLocalName);
        this.encoder = Path.URL_ENCODER;
        this.namespaceRegistry = new SimpleNamespaceRegistry();
        this.namespaceRegistry.register(this.validNamespacePrefix, this.validNamespaceUri);
        this.delimiterEncoder = new TextEncoder(){

            public String encode(String text) {
                if (":".equals(text)) {
                    return "\\:";
                }
                if ("{".equals(text)) {
                    return "\\{";
                }
                if ("}".equals(text)) {
                    return "\\}";
                }
                return text;
            }
        };
    }

    @Test
    public void shouldAllowNullNamespaceUriInConstructorAndConvertToEmptyString() {
        this.name = new BasicName(null, this.validLocalName);
        Assert.assertThat((Object)this.name.getNamespaceUri(), Is.is(""));
    }

    @Test
    public void shouldAllowEmptyNamespaceUriInConstructor() {
        this.name = new BasicName("", this.validLocalName);
        Assert.assertThat((Object)this.name.getNamespaceUri(), Is.is(""));
    }

    @Test
    public void shouldTrimNamespaceUriInConstructor() {
        this.name = new BasicName("  " + this.validNamespaceUri + "\t \t", this.validLocalName);
        Assert.assertThat((Object)this.name.getNamespaceUri(), Is.is(this.validNamespaceUri.trim()));
        this.name = new BasicName("  \t  \t", this.validLocalName);
        Assert.assertThat((Object)this.name.getNamespaceUri(), Is.is(""));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNullLocalNameInConstructor() {
        new BasicName(this.validNamespaceUri, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldAllowEmptyLocalNameInConstructor() {
        new BasicName(this.validNamespaceUri, "");
    }

    @Test
    public void shouldAcceptLocalNameWithColon() {
        this.validLocalName = "some:name:with:colons";
        this.name = new BasicName(this.validNamespaceUri, this.validLocalName);
        Assert.assertThat((Object)this.name.getLocalName(), Is.is(this.validLocalName));
    }

    @Test
    public void shouldReturnSameHashCodeForNamesWithSameNamespaceUriAndLocalPart() {
        BasicName other = new BasicName(this.name.getNamespaceUri(), this.name.getLocalName());
        Assert.assertThat((Object)this.name.hashCode(), Is.is(other.hashCode()));
    }

    @Test
    public void shouldConsiderNamesEqualIfTheyHaveTheSameNamespaceUriAndLocalPart() {
        BasicName other = new BasicName(this.name.getNamespaceUri(), this.name.getLocalName());
        Assert.assertThat((Object)this.name.equals(other), Is.is(true));
        Assert.assertThat((Object)this.name.compareTo((Object)other), Is.is(0));
    }

    @Test
    public void shouldConsiderSameInstanceEqualToItself() {
        Assert.assertThat((Object)this.name.equals(this.name), Is.is(true));
        Assert.assertThat((Object)this.name.compareTo((Object)this.name), Is.is(0));
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotSupportNullInCompareTo() {
        this.name.compareTo(null);
    }

    @Test
    public void shouldSupportNullInEquals() {
        Assert.assertThat((Object)this.name.equals(null), Is.is(false));
    }

    @Test
    public void shouldUseFullNamespaceUriInResultFromGetStringWithoutNamespaceRegistry() {
        String encodedNamespaceUri = Path.DEFAULT_ENCODER.encode(this.validNamespaceUri);
        String encodedLocalName = Path.DEFAULT_ENCODER.encode(this.validLocalName);
        String result = this.name.getString();
        Assert.assertThat((Object)result, (Matcher)JUnitMatchers.containsString((String)encodedNamespaceUri));
        Assert.assertThat((Object)result, (Matcher)JUnitMatchers.containsString((String)encodedLocalName));
        Assert.assertThat((Object)result, Is.is("{" + encodedNamespaceUri + "}" + encodedLocalName));
    }

    @Test
    public void shouldEncodeColonInLocalNameAndNamespaceUriInResultFromGetStringWithoutNamespaceRegistry() {
        this.validLocalName = "some:name:with:colons";
        this.name = new BasicName(this.validNamespaceUri, this.validLocalName);
        String encodedNamespaceUri = this.encoder.encode(this.validNamespaceUri);
        String encodedLocalName = this.encoder.encode(this.validLocalName);
        String result = this.name.getString(this.encoder);
        Assert.assertThat((Object)result, Is.is("{" + encodedNamespaceUri + "}" + encodedLocalName));
        Assert.assertThat((Object)encodedNamespaceUri, Is.is("http%3a%2f%2fwww.modeshape.org%2f1.0"));
        Assert.assertThat((Object)encodedLocalName, Is.is("some%3aname%3awith%3acolons"));
    }

    @Test
    public void shouldUseNamespacePrefixInResultFromGetStringWithNamespaceRegistry() {
        String result = this.name.getString(this.namespaceRegistry, this.encoder);
        Assert.assertThat((Object)result, Is.is("mode:" + this.validLocalName));
        this.validLocalName = "some:name:with:colons";
        this.name = new BasicName(this.validNamespaceUri, this.validLocalName);
        result = this.name.getString(this.namespaceRegistry, this.encoder);
        Assert.assertThat((Object)result, Is.is("mode:some%3aname%3awith%3acolons"));
    }

    @Test
    public void shouldNotIncludeNamespacePrefixOrColonInResultFromGetStringWithNamespaceRegistry() {
        this.validNamespaceUri = this.namespaceRegistry.getDefaultNamespaceUri();
        this.name = new BasicName(this.validNamespaceUri, this.validLocalName);
        String result = this.name.getString(this.namespaceRegistry, this.encoder);
        Assert.assertThat((Object)result, Is.is(this.validLocalName));
        result = this.name.getString(this.namespaceRegistry);
        Assert.assertThat((Object)result, Is.is(this.validLocalName));
        this.validLocalName = "some:name:with:colons";
        this.name = new BasicName(this.validNamespaceUri, this.validLocalName);
        result = this.name.getString(this.namespaceRegistry, this.encoder);
        Assert.assertThat((Object)result, Is.is(this.encoder.encode(this.validLocalName)));
    }

    @Test
    public void shouldUseDelimiterEncoderToEncodeDelimiterBetweenPrefixAndLocalPart() {
        this.encoder = new Jsr283Encoder();
        this.name = new BasicName("http://www.modeshape.org/1.0", "some:name:with:colons");
        Assert.assertThat((Object)this.name.getString(this.namespaceRegistry, this.encoder, this.delimiterEncoder), Is.is("mode\\:some\uf03aname\uf03awith\uf03acolons"));
        Assert.assertThat((Object)this.name.getString(null, this.encoder, this.delimiterEncoder), Is.is("\\{" + this.encoder.encode("http://www.modeshape.org/1.0") + "\\}some\uf03aname\uf03awith\uf03acolons"));
    }

    @Test
    public void shouldEncodeWhenNoNamespace() {
        String nameForEncoding = "test name";
        String encodedNameForEncoding = this.encoder.encode(nameForEncoding);
        Assert.assertThat((Object)encodedNameForEncoding, IsNot.not(nameForEncoding));
        this.name = new BasicName(null, nameForEncoding);
        String result = this.name.getString(this.namespaceRegistry, this.encoder);
        Assert.assertThat((Object)result, Is.is(encodedNameForEncoding));
        result = this.name.getString(this.encoder);
        Assert.assertThat((Object)result, Is.is(encodedNameForEncoding));
    }
}

