/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.observe;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.Location;
import org.modeshape.graph.observe.ChangeObserver;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.DeleteChildrenRequest;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.RemovePropertyRequest;
import org.modeshape.graph.request.RenameNodeRequest;
import org.modeshape.graph.request.SetPropertyRequest;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.UpdateValuesRequest;

@ThreadSafe
public abstract class NetChangeObserver
extends ChangeObserver {
    protected NetChangeObserver() {
    }

    private void deleteLocationDetails(String workspace, Location location, Map<String, Map<Location, NetChangeDetails>> workspaceLocationMap) {
        Map<Location, NetChangeDetails> detailsByLocation = workspaceLocationMap.get(workspace);
        assert (detailsByLocation != null);
        detailsByLocation.remove(location);
    }

    private NetChangeDetails findDetailsByLocation(String workspace, Location location, Map<String, Map<Location, NetChangeDetails>> workspaceLocationMap) {
        Map<Location, NetChangeDetails> detailsByLocation = workspaceLocationMap.get(workspace);
        NetChangeDetails details = null;
        if (detailsByLocation == null) {
            detailsByLocation = new TreeMap<Location, NetChangeDetails>();
            workspaceLocationMap.put(workspace, detailsByLocation);
            details = new NetChangeDetails();
            detailsByLocation.put(location, details);
        } else {
            details = detailsByLocation.get(location);
            if (details == null) {
                details = new NetChangeDetails();
                detailsByLocation.put(location, details);
            }
        }
        return details;
    }

    @Override
    public void notify(Changes changes) {
        HashMap<String, Map<Location, NetChangeDetails>> detailsByLocationByWorkspace = new HashMap<String, Map<Location, NetChangeDetails>>();
        block18: for (ChangeRequest change : changes.getChangeRequests()) {
            Location location = change.changedLocation();
            assert (location.getPath() != null);
            String workspace = change.changedWorkspace();
            NetChangeDetails details = this.findDetailsByLocation(workspace, location, detailsByLocationByWorkspace);
            switch (change.getType()) {
                case CREATE_NODE: {
                    CreateNodeRequest create = (CreateNodeRequest)change;
                    details.addEventType(ChangeType.NODE_ADDED);
                    for (Property property : create) {
                        details.addProperty(property);
                    }
                    continue block18;
                }
                case UPDATE_PROPERTIES: {
                    UpdatePropertiesRequest update = (UpdatePropertiesRequest)change;
                    for (Map.Entry<Name, Property> entry : update.properties().entrySet()) {
                        Name propName = entry.getKey();
                        Property property = entry.getValue();
                        if (property != null) {
                            if (update.isNewProperty(propName)) {
                                details.addProperty(property);
                                continue;
                            }
                            details.changeProperty(property);
                            continue;
                        }
                        details.removeProperty(propName);
                    }
                    continue block18;
                }
                case SET_PROPERTY: {
                    SetPropertyRequest set = (SetPropertyRequest)change;
                    if (set.isNewProperty()) {
                        details.addProperty(set.property());
                        break;
                    }
                    details.changeProperty(set.property());
                    break;
                }
                case REMOVE_PROPERTY: {
                    RemovePropertyRequest remove = (RemovePropertyRequest)change;
                    details.removeProperty(remove.propertyName());
                    break;
                }
                case DELETE_BRANCH: {
                    if (details.getEventTypes().contains((Object)ChangeType.NODE_ADDED)) {
                        this.deleteLocationDetails(workspace, location, detailsByLocationByWorkspace);
                        break;
                    }
                    details.addEventType(ChangeType.NODE_REMOVED);
                    break;
                }
                case DELETE_CHILDREN: {
                    DeleteChildrenRequest delete = (DeleteChildrenRequest)change;
                    for (Location deletedChild : delete.getActualChildrenDeleted()) {
                        NetChangeDetails childDetails = this.findDetailsByLocation(workspace, deletedChild, detailsByLocationByWorkspace);
                        if (childDetails.getEventTypes().contains((Object)ChangeType.NODE_ADDED)) {
                            this.deleteLocationDetails(workspace, deletedChild, detailsByLocationByWorkspace);
                            continue;
                        }
                        childDetails.addEventType(ChangeType.NODE_REMOVED);
                    }
                    continue block18;
                }
                case LOCK_BRANCH: {
                    details.setLockAction(LockAction.LOCKED);
                    break;
                }
                case UNLOCK_BRANCH: {
                    details.setLockAction(LockAction.UNLOCKED);
                    break;
                }
                case COPY_BRANCH: {
                    details.addEventType(ChangeType.NODE_ADDED);
                    break;
                }
                case MOVE_BRANCH: {
                    Location original = ((MoveBranchRequest)change).getActualLocationBefore();
                    NetChangeDetails originalDetails = this.findDetailsByLocation(workspace, original, detailsByLocationByWorkspace);
                    originalDetails.addEventType(ChangeType.NODE_REMOVED);
                    details.addEventType(ChangeType.NODE_ADDED);
                    break;
                }
                case CLONE_BRANCH: {
                    CloneBranchRequest cloneRequest = (CloneBranchRequest)change;
                    for (Location removed : cloneRequest.getRemovedNodes()) {
                        NetChangeDetails removedDetails = this.findDetailsByLocation(workspace, removed, detailsByLocationByWorkspace);
                        removedDetails.addEventType(ChangeType.NODE_REMOVED);
                    }
                    details.addEventType(ChangeType.NODE_ADDED);
                    break;
                }
                case RENAME_NODE: {
                    Location original = ((RenameNodeRequest)change).getActualLocationBefore();
                    NetChangeDetails originalDetails = this.findDetailsByLocation(workspace, original, detailsByLocationByWorkspace);
                    originalDetails.addEventType(ChangeType.NODE_REMOVED);
                    details.addEventType(ChangeType.NODE_ADDED);
                    break;
                }
                case UPDATE_VALUES: {
                    UpdateValuesRequest updateValuesRequest = (UpdateValuesRequest)change;
                    if (!updateValuesRequest.addedValues().isEmpty() || !updateValuesRequest.removedValues().isEmpty()) {
                        assert (updateValuesRequest.getActualProperty() != null);
                        if (updateValuesRequest.isNewProperty()) {
                            details.addEventType(ChangeType.PROPERTY_ADDED);
                            details.addProperty(updateValuesRequest.getActualProperty());
                            break;
                        }
                        details.addEventType(ChangeType.PROPERTY_CHANGED);
                        details.changeProperty(updateValuesRequest.getActualProperty());
                        break;
                    }
                    if (!details.getEventTypes().isEmpty()) break;
                    this.deleteLocationDetails(workspace, location, detailsByLocationByWorkspace);
                    break;
                }
                case CREATE_WORKSPACE: {
                    details.addEventType(ChangeType.NODE_ADDED);
                    break;
                }
                case DESTROY_WORKSPACE: {
                    details.addEventType(ChangeType.NODE_REMOVED);
                    break;
                }
                case CLONE_WORKSPACE: {
                    details.addEventType(ChangeType.NODE_ADDED);
                    break;
                }
            }
        }
        LinkedList<NetChange> netChanges = new LinkedList<NetChange>();
        for (Map.Entry byWorkspaceEntry : detailsByLocationByWorkspace.entrySet()) {
            String workspaceName = (String)byWorkspaceEntry.getKey();
            for (Map.Entry entry : ((Map)byWorkspaceEntry.getValue()).entrySet()) {
                Location location = (Location)entry.getKey();
                NetChangeDetails details = (NetChangeDetails)entry.getValue();
                netChanges.add(new NetChange(workspaceName, location, details.getEventTypes(), details.getAddedProperties(), details.getModifiedProperties(), details.getRemovedProperties()));
            }
        }
        this.notify(new NetChanges(changes, netChanges));
    }

    protected abstract void notify(NetChanges var1);

    @NotThreadSafe
    private static class NetChangeDetails {
        private final Set<Property> modifiedProperties = new HashSet<Property>();
        private final Set<Property> addedProperties = new HashSet<Property>();
        private final Set<Name> removedProperties = new HashSet<Name>();
        private EnumSet<ChangeType> eventTypes = EnumSet.noneOf(ChangeType.class);

        protected NetChangeDetails() {
        }

        public void setLockAction(LockAction lockAction) {
            switch (lockAction) {
                case LOCKED: {
                    this.eventTypes.add(ChangeType.NODE_LOCKED);
                    this.eventTypes.remove((Object)ChangeType.NODE_UNLOCKED);
                    break;
                }
                case UNLOCKED: {
                    if (this.eventTypes.remove((Object)ChangeType.NODE_LOCKED)) break;
                    this.eventTypes.add(ChangeType.NODE_UNLOCKED);
                }
            }
        }

        public void addEventType(ChangeType eventType) {
            this.eventTypes.add(eventType);
        }

        public void addProperty(Property property) {
            this.addedProperties.add(property);
            this.eventTypes.add(ChangeType.PROPERTY_ADDED);
        }

        public void changeProperty(Property property) {
            if (!this.addedProperties.contains(property)) {
                this.modifiedProperties.add(property);
                this.eventTypes.add(ChangeType.PROPERTY_CHANGED);
            }
        }

        public void removeProperty(Name propertyName) {
            boolean handled = false;
            for (Property property : this.addedProperties) {
                if (!property.getName().equals(propertyName)) continue;
                handled = true;
                this.addedProperties.remove(property);
                if (!this.addedProperties.isEmpty()) break;
                this.eventTypes.remove((Object)ChangeType.PROPERTY_ADDED);
                break;
            }
            if (!handled) {
                for (Property property : this.modifiedProperties) {
                    if (!property.getName().equals(propertyName)) continue;
                    this.modifiedProperties.remove(property);
                    if (!this.modifiedProperties.isEmpty()) break;
                    this.eventTypes.remove((Object)ChangeType.PROPERTY_CHANGED);
                    break;
                }
                this.removedProperties.add(propertyName);
                this.eventTypes.add(ChangeType.PROPERTY_REMOVED);
            }
        }

        public EnumSet<ChangeType> getEventTypes() {
            return this.eventTypes;
        }

        public Set<Property> getAddedProperties() {
            return this.addedProperties;
        }

        public Set<Property> getModifiedProperties() {
            return this.modifiedProperties;
        }

        public Set<Name> getRemovedProperties() {
            return this.removedProperties;
        }
    }

    private static enum LockAction {
        LOCKED,
        UNLOCKED;

    }

    @Immutable
    public static final class NetChange {
        private final String workspaceName;
        private final Location location;
        private final EnumSet<ChangeType> eventTypes;
        private final Set<Property> addedProperties;
        private final Set<Property> modifiedProperties;
        private final Set<Property> addedOrModifiedProperties;
        private final Set<Name> removedProperties;
        private final int hc;

        public NetChange(String workspaceName, Location location, EnumSet<ChangeType> eventTypes, Set<Property> addedProperties, Set<Property> modifiedProperties, Set<Name> removedProperties) {
            assert (workspaceName != null);
            assert (location != null);
            this.workspaceName = workspaceName;
            this.location = location;
            this.hc = HashCode.compute((Object[])new Object[]{this.workspaceName, this.location});
            this.eventTypes = eventTypes;
            Set<Property> addedOrModified = null;
            if (addedProperties == null) {
                addedProperties = Collections.emptySet();
                addedOrModified = modifiedProperties;
            } else {
                addedOrModified = addedProperties;
            }
            if (modifiedProperties == null) {
                if (addedOrModified == null) {
                    addedOrModified = Collections.emptySet();
                }
                modifiedProperties = Collections.emptySet();
            } else if (addedOrModified == null) {
                addedOrModified = modifiedProperties;
            } else {
                addedOrModified = new HashSet<Property>(modifiedProperties);
                addedOrModified.addAll(addedProperties);
            }
            if (removedProperties == null) {
                removedProperties = Collections.emptySet();
            }
            this.addedProperties = Collections.unmodifiableSet(addedProperties);
            this.modifiedProperties = Collections.unmodifiableSet(modifiedProperties);
            this.removedProperties = Collections.unmodifiableSet(removedProperties);
            this.addedOrModifiedProperties = Collections.unmodifiableSet(addedOrModified);
        }

        public Location getLocation() {
            return this.location;
        }

        public Path getPath() {
            return this.location.getPath();
        }

        public String getRepositoryWorkspaceName() {
            return this.workspaceName;
        }

        public Set<Property> getAddedProperties() {
            return this.addedProperties;
        }

        public Set<Property> getModifiedProperties() {
            return this.modifiedProperties;
        }

        public Set<Property> getAddedOrModifiedProperties() {
            return this.addedOrModifiedProperties;
        }

        public Set<Name> getRemovedProperties() {
            return this.removedProperties;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean includesAllOf(ChangeType ... jcrEventTypes) {
            for (ChangeType jcrEventType : jcrEventTypes) {
                if (this.eventTypes.contains((Object)jcrEventType)) continue;
                return false;
            }
            return true;
        }

        public boolean includes(ChangeType ... jcrEventTypes) {
            for (ChangeType jcrEventType : jcrEventTypes) {
                if (!this.eventTypes.contains((Object)jcrEventType)) continue;
                return true;
            }
            return false;
        }

        public boolean isSameNode(NetChange that) {
            if (that == this) {
                return true;
            }
            if (this.hc != that.hc) {
                return false;
            }
            if (!this.workspaceName.equals(that.workspaceName)) {
                return false;
            }
            return this.location.isSame(that.location);
        }

        public boolean isPropertyModified(String property) {
            return this.modifiedProperties.contains(property);
        }

        public boolean isPropertyRemoved(String property) {
            return this.removedProperties.contains(property);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof NetChange) {
                NetChange that = (NetChange)obj;
                if (!this.isSameNode(that)) {
                    return false;
                }
                return this.eventTypes == that.eventTypes;
            }
            return false;
        }

        public String toString() {
            return this.workspaceName + "=>" + this.location;
        }
    }

    @Immutable
    public static final class NetChanges
    extends Changes {
        private static final long serialVersionUID = 1L;
        private final List<NetChange> netChanges;

        public NetChanges(Changes changes, List<NetChange> netChanges) {
            super(changes);
            assert (netChanges != null);
            assert (!netChanges.isEmpty());
            this.netChanges = Collections.unmodifiableList(netChanges);
        }

        public List<NetChange> getNetChanges() {
            return this.netChanges;
        }

        @Override
        public String toString() {
            if (this.processId.length() != 0) {
                return this.getTimestamp() + " @" + this.getUserName() + " [" + this.getSourceName() + "] - " + this.netChanges.size() + " changes";
            }
            return this.getTimestamp() + " @" + this.getUserName() + " #" + this.getProcessId() + " [" + this.getSourceName() + "] - " + this.netChanges.size() + " changes";
        }
    }

    public static enum ChangeType {
        NODE_ADDED,
        NODE_REMOVED,
        PROPERTY_ADDED,
        PROPERTY_REMOVED,
        PROPERTY_CHANGED,
        NODE_LOCKED,
        NODE_UNLOCKED;

    }
}

