/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import net.jcip.annotations.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.IoException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;

@Immutable
public abstract class AbstractValueFactory<T>
implements ValueFactory<T> {
    private final TextDecoder decoder;
    private final PropertyType propertyType;
    private final ValueFactory<String> stringValueFactory;

    protected AbstractValueFactory(PropertyType type, TextDecoder decoder, ValueFactory<String> stringValueFactory) {
        CheckArg.isNotNull((Object)((Object)type), (String)"type");
        this.propertyType = type;
        this.decoder = decoder != null ? decoder : DEFAULT_DECODER;
        this.stringValueFactory = stringValueFactory;
    }

    protected ValueFactory<String> getStringValueFactory() {
        return this.stringValueFactory;
    }

    public TextDecoder getDecoder() {
        return this.decoder;
    }

    protected TextDecoder getDecoder(TextDecoder decoder) {
        return decoder != null ? decoder : this.getDecoder();
    }

    @Override
    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    @Override
    public T create(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.create((String)value);
        }
        if (value instanceof Integer) {
            return this.create((Integer)value);
        }
        if (value instanceof Long) {
            return this.create((Long)value);
        }
        if (value instanceof Double) {
            return this.create((Double)value);
        }
        if (value instanceof Float) {
            return this.create(((Float)value).floatValue());
        }
        if (value instanceof Boolean) {
            return this.create((Boolean)value);
        }
        if (value instanceof BigDecimal) {
            return this.create((BigDecimal)value);
        }
        if (value instanceof DateTime) {
            return this.create((DateTime)value);
        }
        if (value instanceof Calendar) {
            return this.create((Calendar)value);
        }
        if (value instanceof Date) {
            return this.create((Date)value);
        }
        if (value instanceof Name) {
            return this.create((Name)value);
        }
        if (value instanceof Path) {
            return this.create((Path)value);
        }
        if (value instanceof Reference) {
            return this.create((Reference)value);
        }
        if (value instanceof URI) {
            return this.create((URI)value);
        }
        if (value instanceof Binary) {
            return this.create((Binary)value);
        }
        if (value instanceof byte[]) {
            return this.create((byte[])value);
        }
        if (value instanceof InputStream) {
            return this.create((InputStream)value, 0L);
        }
        if (value instanceof Reader) {
            return this.create((Reader)value, 0L);
        }
        return this.create(value.toString());
    }

    protected abstract T[] createEmptyArray(int var1);

    @Override
    public T[] create(BigDecimal[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(boolean[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(byte[][] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(Calendar[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(Date[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(DateTime[] values) throws ValueFormatException {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(double[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(float[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(int[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(long[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(Name[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(Object[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(Path[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(Reference[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(String[] values, TextDecoder decoder) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i], decoder);
        }
        return result;
    }

    @Override
    public T[] create(String[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(URI[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(UUID[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(Binary[] values) throws ValueFormatException, IoException {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public Iterator<T> create(Iterator<?> values) throws ValueFormatException, IoException {
        return new ConvertingIterator(values, this);
    }

    @Override
    public Iterable<T> create(final Iterable<?> valueIterable) throws ValueFormatException, IoException {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return AbstractValueFactory.this.create(valueIterable.iterator());
            }
        };
    }

    protected static class ConvertingIterator<ValueType>
    implements Iterator<ValueType> {
        private final Iterator<?> delegate;
        private final ValueFactory<ValueType> factory;

        protected ConvertingIterator(Iterator<?> delegate, ValueFactory<ValueType> factory) {
            assert (delegate != null);
            assert (factory != null);
            this.delegate = delegate;
            this.factory = factory;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public ValueType next() {
            return this.factory.create(this.delegate.next());
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

