/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.modeshape.common.collection.ImmutableAppendedList;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.basic.AbstractPath;

@Immutable
public class ChildPath
extends AbstractPath {
    private static final long serialVersionUID = 1L;
    private final Path parent;
    private final Path.Segment child;
    private final int size;
    private transient List<Path.Segment> cachedSegmentList;

    public ChildPath(Path parent, Path.Segment child) {
        assert (parent != null);
        assert (child != null);
        this.parent = parent;
        this.child = child;
        this.size = this.parent.size() + 1;
    }

    @Override
    public Path getAncestor(int degree) {
        CheckArg.isNonNegative((int)degree, (String)"degree");
        if (degree == 0) {
            return this;
        }
        if (degree == 1) {
            return this.parent;
        }
        return this.parent.getAncestor(degree - 1);
    }

    @Override
    protected Iterator<Path.Segment> getSegmentsOfParent() {
        return this.parent.iterator();
    }

    @Override
    public Path.Segment getLastSegment() {
        return this.child;
    }

    @Override
    public Path getParent() {
        return this.parent;
    }

    @Override
    public Path.Segment getSegment(int index) {
        if (index == this.size - 1) {
            return this.child;
        }
        return this.parent.getSegment(index);
    }

    @Override
    public List<Path.Segment> getSegmentsList() {
        if (this.cachedSegmentList == null) {
            Object segments = null;
            if (this.parent.isRoot()) {
                segments = Collections.singletonList(this.child);
            } else if (this.size < 4) {
                segments = new ArrayList<Path.Segment>(this.size);
                for (Path.Segment segment : this.parent) {
                    segments.add(segment);
                }
                segments.add(this.child);
                segments = Collections.unmodifiableList(segments);
            } else {
                segments = new ImmutableAppendedList(this.parent.getSegmentsList(), (Object)this.child);
            }
            this.cachedSegmentList = segments;
        }
        return this.cachedSegmentList;
    }

    @Override
    public boolean hasSameAncestor(Path that) {
        CheckArg.isNotNull((Object)that, (String)"that");
        if (this.parent.equals(that.getParent())) {
            return true;
        }
        return super.hasSameAncestor(that);
    }

    @Override
    public boolean isAbsolute() {
        return this.parent.isAbsolute();
    }

    @Override
    public boolean isAtOrBelow(Path other) {
        if (this == other || this.parent == other) {
            return true;
        }
        return super.isAtOrBelow(other);
    }

    @Override
    public boolean isDecendantOf(Path ancestor) {
        if (this.parent == ancestor) {
            return true;
        }
        return this.parent.isAtOrBelow(ancestor);
    }

    @Override
    public boolean isNormalized() {
        if (this.child.isSelfReference()) {
            return false;
        }
        if (!this.parent.isNormalized()) {
            return false;
        }
        if (!this.child.isParentReference()) {
            return true;
        }
        for (Path.Segment segment : this.parent) {
            if (segment.isParentReference()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRoot() {
        if (this.child.isParentReference()) {
            return this.parent.isRoot();
        }
        return false;
    }

    @Override
    public Iterator<Path.Segment> iterator() {
        if (this.parent.isRoot()) {
            return new Iterator<Path.Segment>(){
                boolean finished = false;

                @Override
                public boolean hasNext() {
                    return !this.finished;
                }

                @Override
                public Path.Segment next() {
                    if (this.finished) {
                        throw new NoSuchElementException();
                    }
                    this.finished = true;
                    return ChildPath.this.child;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        final Iterator<Path.Segment> parentIterator = this.parent.iterator();
        return new Iterator<Path.Segment>(){
            boolean finished = false;

            @Override
            public boolean hasNext() {
                return parentIterator.hasNext() || !this.finished;
            }

            @Override
            public Path.Segment next() {
                if (parentIterator.hasNext()) {
                    return (Path.Segment)parentIterator.next();
                }
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                this.finished = true;
                return ChildPath.this.child;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        if (beginIndex == 0 && endIndex == this.size - 1) {
            return this.parent;
        }
        return super.subpath(beginIndex, endIndex);
    }
}

