/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.query.model.AllNodes;
import org.modeshape.graph.query.model.And;
import org.modeshape.graph.query.model.ArithmeticOperand;
import org.modeshape.graph.query.model.Between;
import org.modeshape.graph.query.model.BindVariableName;
import org.modeshape.graph.query.model.ChildNode;
import org.modeshape.graph.query.model.ChildNodeJoinCondition;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Comparison;
import org.modeshape.graph.query.model.DescendantNode;
import org.modeshape.graph.query.model.DescendantNodeJoinCondition;
import org.modeshape.graph.query.model.EquiJoinCondition;
import org.modeshape.graph.query.model.FullTextSearch;
import org.modeshape.graph.query.model.FullTextSearchScore;
import org.modeshape.graph.query.model.Join;
import org.modeshape.graph.query.model.Length;
import org.modeshape.graph.query.model.Limit;
import org.modeshape.graph.query.model.Literal;
import org.modeshape.graph.query.model.LowerCase;
import org.modeshape.graph.query.model.NamedSelector;
import org.modeshape.graph.query.model.NodeDepth;
import org.modeshape.graph.query.model.NodeLocalName;
import org.modeshape.graph.query.model.NodeName;
import org.modeshape.graph.query.model.NodePath;
import org.modeshape.graph.query.model.Not;
import org.modeshape.graph.query.model.Or;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.PropertyExistence;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.Query;
import org.modeshape.graph.query.model.ReferenceValue;
import org.modeshape.graph.query.model.SameNode;
import org.modeshape.graph.query.model.SameNodeJoinCondition;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.SetCriteria;
import org.modeshape.graph.query.model.SetQuery;
import org.modeshape.graph.query.model.StaticOperand;
import org.modeshape.graph.query.model.UpperCase;
import org.modeshape.graph.query.model.Visitable;
import org.modeshape.graph.query.model.Visitor;

public class Visitors {
    public static <StrategyVisitor extends Visitor> StrategyVisitor visitAll(Visitable visitable, StrategyVisitor strategyVisitor) {
        if (visitable != null) {
            visitable.accept(new WalkAllVisitor(strategyVisitor));
        }
        return strategyVisitor;
    }

    public static <GeneralVisitor extends Visitor> GeneralVisitor visit(Visitable visitable, GeneralVisitor visitor) {
        if (visitable != null) {
            visitable.accept(visitor);
        }
        return visitor;
    }

    public static String readable(Visitable visitable) {
        return Visitors.visit(visitable, new ReadableVisitor()).getString();
    }

    public static Set<SelectorName> getSelectorsReferencedBy(Visitable visitable) {
        final HashSet<SelectorName> symbols = new HashSet<SelectorName>();
        Visitors.visitAll(visitable, new AbstractVisitor(){

            @Override
            public void visit(AllNodes allNodes) {
                if (allNodes.hasAlias()) {
                    symbols.add(allNodes.getAlias());
                } else {
                    symbols.add(allNodes.getName());
                }
            }

            @Override
            public void visit(ChildNode childNode) {
                symbols.add(childNode.getSelectorName());
            }

            @Override
            public void visit(ChildNodeJoinCondition joinCondition) {
                symbols.add(joinCondition.getChildSelectorName());
                symbols.add(joinCondition.getParentSelectorName());
            }

            @Override
            public void visit(Column column) {
                symbols.add(column.getSelectorName());
            }

            @Override
            public void visit(DescendantNode descendant) {
                symbols.add(descendant.getSelectorName());
            }

            @Override
            public void visit(DescendantNodeJoinCondition joinCondition) {
                symbols.add(joinCondition.getAncestorSelectorName());
                symbols.add(joinCondition.getDescendantSelectorName());
            }

            @Override
            public void visit(EquiJoinCondition joinCondition) {
                symbols.add(joinCondition.getSelector1Name());
                symbols.add(joinCondition.getSelector2Name());
            }

            @Override
            public void visit(FullTextSearch fullTextSearch) {
                symbols.add(fullTextSearch.getSelectorName());
            }

            @Override
            public void visit(FullTextSearchScore fullTextSearchScore) {
                symbols.add(fullTextSearchScore.getSelectorName());
            }

            @Override
            public void visit(Length length) {
                symbols.add(length.getSelectorName());
            }

            @Override
            public void visit(NodeDepth depth) {
                symbols.add(depth.getSelectorName());
            }

            @Override
            public void visit(NodePath path) {
                symbols.add(path.getSelectorName());
            }

            @Override
            public void visit(NodeLocalName node) {
                symbols.add(node.getSelectorName());
            }

            @Override
            public void visit(NodeName node) {
                symbols.add(node.getSelectorName());
            }

            @Override
            public void visit(NamedSelector node) {
                if (node.hasAlias()) {
                    symbols.add(node.getAlias());
                } else {
                    symbols.add(node.getName());
                }
            }

            @Override
            public void visit(PropertyExistence prop) {
                symbols.add(prop.getSelectorName());
            }

            @Override
            public void visit(PropertyValue prop) {
                symbols.add(prop.getSelectorName());
            }

            @Override
            public void visit(ReferenceValue ref) {
                symbols.add(ref.getSelectorName());
            }

            @Override
            public void visit(SameNode node) {
                symbols.add(node.getSelectorName());
            }

            @Override
            public void visit(SameNodeJoinCondition joinCondition) {
                symbols.add(joinCondition.getSelector1Name());
                symbols.add(joinCondition.getSelector2Name());
            }
        });
        return symbols;
    }

    public static class ReadableVisitor
    implements Visitor {
        private final StringBuilder sb = new StringBuilder();
        private final ExecutionContext context;
        private final NamespaceRegistry registry;

        public ReadableVisitor(ExecutionContext context) {
            CheckArg.isNotNull((Object)context, (String)"context");
            this.context = context;
            this.registry = context == null ? null : context.getNamespaceRegistry();
        }

        public ReadableVisitor() {
            this.context = null;
            this.registry = null;
        }

        protected final ReadableVisitor append(String string) {
            this.sb.append(string);
            return this;
        }

        protected final ReadableVisitor append(char character) {
            this.sb.append(character);
            return this;
        }

        protected final ReadableVisitor append(int value) {
            this.sb.append(value);
            return this;
        }

        protected final ReadableVisitor append(SelectorName name) {
            this.sb.append(name.getString());
            return this;
        }

        protected final ReadableVisitor append(Name name) {
            this.sb.append(name.getString(this.registry, null, null));
            return this;
        }

        protected final ReadableVisitor append(Path path) {
            this.sb.append('\'');
            this.sb.append(path.getString(this.registry));
            this.sb.append('\'');
            return this;
        }

        public final ExecutionContext getContext() {
            return this.context;
        }

        public final String getString() {
            return this.sb.toString();
        }

        public String toString() {
            return this.sb.toString();
        }

        @Override
        public void visit(AllNodes allNodes) {
            this.append(allNodes.getName());
            if (allNodes.hasAlias()) {
                this.append(" AS ").append(allNodes.getAlias());
            }
        }

        @Override
        public void visit(And and) {
            this.append('(');
            and.getLeft().accept(this);
            this.append(" AND ");
            and.getRight().accept(this);
            this.append(')');
        }

        @Override
        public void visit(ArithmeticOperand arithmeticOperand) {
            this.append('(');
            arithmeticOperand.getLeft().accept(this);
            this.append(' ');
            this.append(arithmeticOperand.getOperator().getSymbol());
            this.append(' ');
            arithmeticOperand.getRight().accept(this);
            this.append(')');
        }

        @Override
        public void visit(Between between) {
            between.getOperand().accept(this);
            this.append(" BETWEEN ");
            between.getLowerBound().accept(this);
            if (!between.isLowerBoundIncluded()) {
                this.append(" EXCLUSIVE");
            }
            this.append(" AND ");
            between.getUpperBound().accept(this);
            if (!between.isUpperBoundIncluded()) {
                this.append(" EXCLUSIVE");
            }
        }

        @Override
        public void visit(BindVariableName variable) {
            this.append('$').append(variable.getVariableName());
        }

        @Override
        public void visit(ChildNode child) {
            this.append("ISCHILDNODE(");
            this.append(child.getSelectorName());
            this.append(',');
            this.append(child.getParentPath());
            this.append(')');
        }

        @Override
        public void visit(ChildNodeJoinCondition condition) {
            this.append("ISCHILDNODE(");
            this.append(condition.getChildSelectorName());
            this.append(',');
            this.append(condition.getParentSelectorName());
            this.append(')');
        }

        @Override
        public void visit(Column column) {
            this.append(column.getSelectorName());
            if (column.getPropertyName() == null) {
                this.append(".*");
            } else {
                String propertyName = column.getPropertyName();
                this.append('.').append(propertyName);
                if (!propertyName.equals(column.getColumnName()) && !propertyName.equals(column.getColumnName())) {
                    this.append(" AS ").append(column.getColumnName());
                }
            }
        }

        @Override
        public void visit(Comparison comparison) {
            comparison.getOperand1().accept(this);
            this.append(' ').append(comparison.getOperator().getSymbol()).append(' ');
            comparison.getOperand2().accept(this);
        }

        @Override
        public void visit(DescendantNode descendant) {
            this.append("ISDESCENDANTNODE(");
            this.append(descendant.getSelectorName());
            this.append(',');
            this.append(descendant.getAncestorPath());
            this.append(')');
        }

        @Override
        public void visit(DescendantNodeJoinCondition condition) {
            this.append("ISDESCENDANTNODE(");
            this.append(condition.getDescendantSelectorName());
            this.append(',');
            this.append(condition.getAncestorSelectorName());
            this.append(')');
        }

        @Override
        public void visit(EquiJoinCondition condition) {
            this.append(condition.getSelector1Name()).append('.').append(condition.getProperty1Name());
            this.append(" = ");
            this.append(condition.getSelector2Name()).append('.').append(condition.getProperty2Name());
        }

        @Override
        public void visit(FullTextSearch fullText) {
            this.append("CONTAINS(").append(fullText.getSelectorName());
            if (fullText.getPropertyName() != null) {
                this.append('.').append(fullText.getPropertyName());
            }
            this.sb.append(",'").append(fullText.getFullTextSearchExpression()).append("')");
        }

        @Override
        public void visit(FullTextSearchScore score) {
            this.append("SCORE(").append(score.getSelectorName()).append(')');
        }

        @Override
        public void visit(Join join) {
            join.getLeft().accept(this);
            this.sb.append(' ').append(join.getType().getSymbol());
            this.append(' ');
            join.getRight().accept(this);
            this.append(" ON ");
            join.getJoinCondition().accept(this);
        }

        @Override
        public void visit(Length length) {
            this.append("LENGTH(");
            length.getPropertyValue().accept(this);
            this.append(')');
        }

        @Override
        public void visit(Limit limit) {
            this.append("LIMIT ").append(limit.getRowLimit());
            if (limit.getOffset() != 0) {
                this.append(" OFFSET ").append(limit.getOffset());
            }
        }

        @Override
        public void visit(Literal literal) {
            boolean quote;
            Object value = literal.getValue();
            boolean bl = quote = value instanceof String || value instanceof Path || value instanceof Name;
            if (quote) {
                this.append('\'');
            }
            if (this.context == null) {
                this.append(literal.getValue().toString());
            } else {
                this.append(this.context.getValueFactories().getStringFactory().create(literal.getValue()));
            }
            if (quote) {
                this.append('\'');
            }
        }

        @Override
        public void visit(LowerCase lowerCase) {
            this.append("LOWER(");
            lowerCase.getOperand().accept(this);
            this.append(')');
        }

        @Override
        public void visit(NodeDepth depth) {
            this.append("DEPTH(").append(depth.getSelectorName()).append(')');
        }

        @Override
        public void visit(NodePath path) {
            this.append("PATH(").append(path.getSelectorName()).append(')');
        }

        @Override
        public void visit(NodeLocalName name) {
            this.append("LOCALNAME(").append(name.getSelectorName()).append(')');
        }

        @Override
        public void visit(NodeName name) {
            this.append("NAME(").append(name.getSelectorName()).append(')');
        }

        @Override
        public void visit(NamedSelector selector) {
            this.append(selector.getName());
            if (selector.hasAlias()) {
                this.append(" AS ").append(selector.getAlias());
            }
        }

        @Override
        public void visit(Not not) {
            this.append('(');
            this.append("NOT ");
            not.getConstraint().accept(this);
            this.append(')');
        }

        @Override
        public void visit(Or or) {
            this.append('(');
            or.getLeft().accept(this);
            this.append(" OR ");
            or.getRight().accept(this);
            this.append(')');
        }

        @Override
        public void visit(Ordering ordering) {
            ordering.getOperand().accept(this);
            this.append(' ').append(ordering.getOrder().getSymbol());
        }

        @Override
        public void visit(PropertyExistence existence) {
            this.append(existence.getSelectorName()).append('.').append(existence.getPropertyName()).append(" IS NOT NULL");
        }

        @Override
        public void visit(PropertyValue value) {
            this.append(value.getSelectorName()).append('.').append(value.getPropertyName());
        }

        @Override
        public void visit(ReferenceValue value) {
            this.append(value.getSelectorName());
            if (value.getPropertyName() != null) {
                this.append('.').append(value.getPropertyName());
            }
        }

        @Override
        public void visit(Query query) {
            boolean isFirst;
            this.append("SELECT ");
            if (query.isDistinct()) {
                this.append("DISTINCT ");
            }
            if (query.getColumns().isEmpty()) {
                this.append('*');
            } else {
                isFirst = true;
                for (Column column : query.getColumns()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        this.append(',');
                    }
                    column.accept(this);
                }
            }
            this.append(" FROM ");
            query.getSource().accept(this);
            if (query.getConstraint() != null) {
                this.append(" WHERE ");
                query.getConstraint().accept(this);
            }
            if (!query.getOrderings().isEmpty()) {
                this.append(" ORDER BY ");
                isFirst = true;
                for (Ordering ordering : query.getOrderings()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        this.append(',');
                    }
                    ordering.accept(this);
                }
            }
            if (!query.getLimits().isUnlimited()) {
                this.append(' ');
                query.getLimits().accept(this);
            }
        }

        @Override
        public void visit(SameNode sameNode) {
            this.append("ISSAMENODE(").append(sameNode.getSelectorName()).append(',').append(sameNode.getPath()).append(')');
        }

        @Override
        public void visit(SameNodeJoinCondition condition) {
            this.append("ISSAMENODE(").append(condition.getSelector1Name()).append(',').append(condition.getSelector2Name());
            if (condition.getSelector2Path() != null) {
                this.append(',').append(condition.getSelector2Path());
            }
            this.append(')');
        }

        @Override
        public void visit(SetCriteria criteria) {
            criteria.getLeftOperand().accept(this);
            this.append(" IN (");
            Iterator<StaticOperand> iter = criteria.getRightOperands().iterator();
            if (iter.hasNext()) {
                iter.next().accept(this);
                while (iter.hasNext()) {
                    this.append(',');
                    iter.next().accept(this);
                }
            }
            this.append(')');
        }

        @Override
        public void visit(SetQuery query) {
            query.getLeft().accept(this);
            this.append(' ').append(query.getOperation().getSymbol()).append(' ');
            if (query.isAll()) {
                this.append("ALL ");
            }
            query.getRight().accept(this);
        }

        @Override
        public void visit(UpperCase upperCase) {
            this.append("UPPER(");
            upperCase.getOperand().accept(this);
            this.append(')');
        }
    }

    public static class WalkAllVisitor
    extends NavigationVisitor {
        protected WalkAllVisitor(Visitor strategy) {
            super(strategy);
        }

        @Override
        public void visit(AllNodes allNodes) {
            this.strategy.visit(allNodes);
            this.visitNext();
        }

        @Override
        public void visit(And and) {
            this.strategy.visit(and);
            this.enqueue(and.getLeft());
            this.enqueue(and.getRight());
            this.visitNext();
        }

        @Override
        public void visit(ArithmeticOperand arithmeticOperation) {
            this.strategy.visit(arithmeticOperation);
            this.enqueue(arithmeticOperation.getLeft());
            this.enqueue(arithmeticOperation.getRight());
            this.visitNext();
        }

        @Override
        public void visit(Between between) {
            this.strategy.visit(between);
            this.enqueue(between.getOperand());
            this.enqueue(between.getLowerBound());
            this.enqueue(between.getUpperBound());
            this.visitNext();
        }

        @Override
        public void visit(BindVariableName variableName) {
            this.strategy.visit(variableName);
            this.visitNext();
        }

        @Override
        public void visit(ChildNode child) {
            this.strategy.visit(child);
            this.visitNext();
        }

        @Override
        public void visit(ChildNodeJoinCondition joinCondition) {
            this.strategy.visit(joinCondition);
            this.visitNext();
        }

        @Override
        public void visit(Column column) {
            this.strategy.visit(column);
            this.visitNext();
        }

        @Override
        public void visit(Comparison comparison) {
            this.strategy.visit(comparison);
            this.enqueue(comparison.getOperand1());
            this.enqueue(comparison.getOperand2());
            this.visitNext();
        }

        @Override
        public void visit(DescendantNode descendant) {
            this.strategy.visit(descendant);
            this.visitNext();
        }

        @Override
        public void visit(DescendantNodeJoinCondition condition) {
            this.strategy.visit(condition);
            this.visitNext();
        }

        @Override
        public void visit(EquiJoinCondition condition) {
            this.strategy.visit(condition);
            this.visitNext();
        }

        @Override
        public void visit(FullTextSearch fullTextSearch) {
            this.strategy.visit(fullTextSearch);
            this.visitNext();
        }

        @Override
        public void visit(FullTextSearchScore score) {
            this.strategy.visit(score);
            this.visitNext();
        }

        @Override
        public void visit(Join join) {
            this.strategy.visit(join);
            this.enqueue(join.getLeft());
            this.enqueue(join.getJoinCondition());
            this.enqueue(join.getRight());
            this.visitNext();
        }

        @Override
        public void visit(Length length) {
            this.strategy.visit(length);
            this.visitNext();
        }

        @Override
        public void visit(Limit limit) {
            this.strategy.visit(limit);
            this.visitNext();
        }

        @Override
        public void visit(Literal literal) {
            this.strategy.visit(literal);
            this.visitNext();
        }

        @Override
        public void visit(LowerCase lowerCase) {
            this.strategy.visit(lowerCase);
            this.enqueue(lowerCase.getOperand());
            this.visitNext();
        }

        @Override
        public void visit(NodeDepth depth) {
            this.strategy.visit(depth);
            this.visitNext();
        }

        @Override
        public void visit(NodePath path) {
            this.strategy.visit(path);
            this.visitNext();
        }

        @Override
        public void visit(NodeName nodeName) {
            this.strategy.visit(nodeName);
            this.visitNext();
        }

        @Override
        public void visit(NodeLocalName nodeLocalName) {
            this.strategy.visit(nodeLocalName);
            this.visitNext();
        }

        @Override
        public void visit(NamedSelector selector) {
            this.strategy.visit(selector);
            this.visitNext();
        }

        @Override
        public void visit(Not not) {
            this.strategy.visit(not);
            this.enqueue(not.getConstraint());
            this.visitNext();
        }

        @Override
        public void visit(Or or) {
            this.strategy.visit(or);
            this.enqueue(or.getLeft());
            this.enqueue(or.getRight());
            this.visitNext();
        }

        @Override
        public void visit(Ordering ordering) {
            this.strategy.visit(ordering);
            this.enqueue(ordering.getOperand());
            this.visitNext();
        }

        @Override
        public void visit(PropertyExistence existence) {
            this.strategy.visit(existence);
            this.visitNext();
        }

        @Override
        public void visit(PropertyValue propertyValue) {
            this.strategy.visit(propertyValue);
            this.visitNext();
        }

        @Override
        public void visit(Query query) {
            this.strategy.visit(query);
            this.enqueue(query.getSource());
            this.enqueue(query.getColumns());
            this.enqueue(query.getConstraint());
            this.enqueue(query.getOrderings());
            this.visitNext();
        }

        @Override
        public void visit(ReferenceValue referenceValue) {
            this.strategy.visit(referenceValue);
            this.visitNext();
        }

        @Override
        public void visit(SameNode sameNode) {
            this.strategy.visit(sameNode);
            this.visitNext();
        }

        @Override
        public void visit(SameNodeJoinCondition condition) {
            this.strategy.visit(condition);
            this.visitNext();
        }

        @Override
        public void visit(SetCriteria setCriteria) {
            this.strategy.visit(setCriteria);
            this.enqueue(setCriteria.getLeftOperand());
            for (StaticOperand right : setCriteria.getRightOperands()) {
                this.enqueue(right);
            }
            this.visitNext();
        }

        @Override
        public void visit(SetQuery setQuery) {
            this.strategy.visit(setQuery);
            this.enqueue(setQuery.getLeft());
            this.enqueue(setQuery.getRight());
            this.visitNext();
        }

        @Override
        public void visit(UpperCase upperCase) {
            this.strategy.visit(upperCase);
            this.enqueue(upperCase.getOperand());
            this.visitNext();
        }
    }

    public static abstract class NavigationVisitor
    implements Visitor {
        protected final Visitor strategy;
        private final LinkedList<? super Visitable> itemQueue = new LinkedList();

        protected NavigationVisitor(Visitor strategy) {
            assert (strategy != null);
            this.strategy = strategy;
        }

        protected final void enqueue(Visitable objectToBeVisited) {
            if (objectToBeVisited != null) {
                this.itemQueue.add(objectToBeVisited);
            }
        }

        protected final void enqueue(Iterable<? extends Visitable> objectsToBeVisited) {
            for (Visitable visitable : objectsToBeVisited) {
                if (visitable == null) continue;
                this.itemQueue.add(visitable);
            }
        }

        protected final void visitNext() {
            if (!this.itemQueue.isEmpty()) {
                Visitable first = this.itemQueue.removeFirst();
                assert (first != null);
                first.accept(this);
            }
        }
    }

    public static class AbstractVisitor
    implements Visitor {
        @Override
        public void visit(AllNodes obj) {
        }

        @Override
        public void visit(And obj) {
        }

        @Override
        public void visit(ArithmeticOperand obj) {
        }

        @Override
        public void visit(Between obj) {
        }

        @Override
        public void visit(BindVariableName obj) {
        }

        @Override
        public void visit(ChildNode obj) {
        }

        @Override
        public void visit(ChildNodeJoinCondition obj) {
        }

        @Override
        public void visit(Column obj) {
        }

        @Override
        public void visit(Comparison obj) {
        }

        @Override
        public void visit(DescendantNode obj) {
        }

        @Override
        public void visit(DescendantNodeJoinCondition obj) {
        }

        @Override
        public void visit(EquiJoinCondition obj) {
        }

        @Override
        public void visit(FullTextSearch obj) {
        }

        @Override
        public void visit(FullTextSearchScore obj) {
        }

        @Override
        public void visit(Join obj) {
        }

        @Override
        public void visit(Length obj) {
        }

        @Override
        public void visit(Limit limit) {
        }

        @Override
        public void visit(Literal obj) {
        }

        @Override
        public void visit(LowerCase obj) {
        }

        @Override
        public void visit(NodeDepth obj) {
        }

        @Override
        public void visit(NodePath obj) {
        }

        @Override
        public void visit(NodeName obj) {
        }

        @Override
        public void visit(NodeLocalName obj) {
        }

        @Override
        public void visit(NamedSelector obj) {
        }

        @Override
        public void visit(Not obj) {
        }

        @Override
        public void visit(Or obj) {
        }

        @Override
        public void visit(Ordering obj) {
        }

        @Override
        public void visit(PropertyExistence obj) {
        }

        @Override
        public void visit(PropertyValue obj) {
        }

        @Override
        public void visit(Query obj) {
        }

        @Override
        public void visit(ReferenceValue obj) {
        }

        @Override
        public void visit(SameNode obj) {
        }

        @Override
        public void visit(SameNodeJoinCondition obj) {
        }

        @Override
        public void visit(SetCriteria obj) {
        }

        @Override
        public void visit(SetQuery obj) {
        }

        @Override
        public void visit(UpperCase obj) {
        }
    }
}

