/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.Location;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.request.AccessQueryRequest;
import org.modeshape.graph.request.CacheableRequest;
import org.modeshape.graph.request.ChangeRequest;
import org.modeshape.graph.request.CloneBranchRequest;
import org.modeshape.graph.request.CloneWorkspaceRequest;
import org.modeshape.graph.request.CompositeRequest;
import org.modeshape.graph.request.CopyBranchRequest;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.CreateWorkspaceRequest;
import org.modeshape.graph.request.DeleteBranchRequest;
import org.modeshape.graph.request.DeleteChildrenRequest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.FullTextSearchRequest;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.InvalidRequestException;
import org.modeshape.graph.request.LockBranchRequest;
import org.modeshape.graph.request.MoveBranchRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadAllPropertiesRequest;
import org.modeshape.graph.request.ReadBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadBranchRequest;
import org.modeshape.graph.request.ReadNextBlockOfChildrenRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.ReadPropertyRequest;
import org.modeshape.graph.request.RemovePropertyRequest;
import org.modeshape.graph.request.RenameNodeRequest;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.SetPropertyRequest;
import org.modeshape.graph.request.UnlockBranchRequest;
import org.modeshape.graph.request.UpdatePropertiesRequest;
import org.modeshape.graph.request.UpdateValuesRequest;
import org.modeshape.graph.request.VerifyNodeExistsRequest;
import org.modeshape.graph.request.VerifyWorkspaceRequest;

@NotThreadSafe
public abstract class RequestProcessor {
    private final ExecutionContext context;
    private final String sourceName;
    private final DateTime nowInUtc;
    private final CachePolicy defaultCachePolicy;
    private List<ChangeRequest> changes;
    private final Observer observer;

    protected RequestProcessor(String sourceName, ExecutionContext context, Observer observer) {
        this(sourceName, context, observer, null, null);
    }

    protected RequestProcessor(String sourceName, ExecutionContext context, Observer observer, DateTime now) {
        this(sourceName, context, observer, now, null);
    }

    protected RequestProcessor(String sourceName, ExecutionContext context, Observer observer, DateTime now, CachePolicy defaultCachePolicy) {
        CheckArg.isNotEmpty((String)sourceName, (String)"sourceName");
        CheckArg.isNotNull((Object)context, (String)"context");
        this.context = context;
        this.sourceName = sourceName;
        this.nowInUtc = now != null ? now : context.getValueFactories().getDateFactory().createUtc();
        this.defaultCachePolicy = defaultCachePolicy;
        this.changes = observer != null ? new LinkedList() : null;
        this.observer = observer;
    }

    protected void recordChange(ChangeRequest request) {
        assert (request != null);
        assert (!request.isCancelled());
        assert (!request.hasError());
        if (this.changes != null) {
            this.changes.add(request);
        }
    }

    public final String getSourceName() {
        return this.sourceName;
    }

    public final ExecutionContext getExecutionContext() {
        return this.context;
    }

    public final DateTime getNowInUtc() {
        return this.nowInUtc;
    }

    protected final CachePolicy getDefaultCachePolicy() {
        return this.defaultCachePolicy;
    }

    protected void setCacheableInfo(CacheableRequest request) {
        if (request.getCachePolicy() == null && this.defaultCachePolicy != null) {
            request.setCachePolicy(this.defaultCachePolicy);
        }
        request.setTimeLoaded(this.nowInUtc);
    }

    protected void setCacheableInfo(CacheableRequest request, CachePolicy cachePolicy) {
        if (cachePolicy == null) {
            cachePolicy = this.defaultCachePolicy;
        }
        if (cachePolicy != null) {
            if (request.getCachePolicy() != null) {
                if (request.getCachePolicy().getTimeToLive() > cachePolicy.getTimeToLive()) {
                    request.setCachePolicy(cachePolicy);
                }
            } else {
                request.setCachePolicy(cachePolicy);
            }
        }
        request.setTimeLoaded(this.nowInUtc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(Request request) {
        if (request == null) {
            return;
        }
        try {
            if (request.isCancelled()) {
                return;
            }
            switch (request.getType()) {
                case ACCESS_QUERY: {
                    this.process((AccessQueryRequest)request);
                    return;
                }
                case COMPOSITE: {
                    this.process((CompositeRequest)request);
                    return;
                }
                case CLONE_BRANCH: {
                    this.process((CloneBranchRequest)request);
                    return;
                }
                case CLONE_WORKSPACE: {
                    this.process((CloneWorkspaceRequest)request);
                    return;
                }
                case COPY_BRANCH: {
                    this.process((CopyBranchRequest)request);
                    return;
                }
                case CREATE_NODE: {
                    this.process((CreateNodeRequest)request);
                    return;
                }
                case CREATE_WORKSPACE: {
                    this.process((CreateWorkspaceRequest)request);
                    return;
                }
                case DELETE_BRANCH: {
                    this.process((DeleteBranchRequest)request);
                    return;
                }
                case DELETE_CHILDREN: {
                    this.process((DeleteChildrenRequest)request);
                    return;
                }
                case DESTROY_WORKSPACE: {
                    this.process((DestroyWorkspaceRequest)request);
                    return;
                }
                case FULL_TEXT_SEARCH: {
                    this.process((FullTextSearchRequest)request);
                    return;
                }
                case GET_WORKSPACES: {
                    this.process((GetWorkspacesRequest)request);
                    return;
                }
                case LAST: {
                    return;
                }
                case LOCK_BRANCH: {
                    this.process((LockBranchRequest)request);
                    return;
                }
                case MOVE_BRANCH: {
                    this.process((MoveBranchRequest)request);
                    return;
                }
                case READ_ALL_CHILDREN: {
                    this.process((ReadAllChildrenRequest)request);
                    return;
                }
                case READ_ALL_PROPERTIES: {
                    this.process((ReadAllPropertiesRequest)request);
                    return;
                }
                case READ_BLOCK_OF_CHILDREN: {
                    this.process((ReadBlockOfChildrenRequest)request);
                    return;
                }
                case READ_BRANCH: {
                    this.process((ReadBranchRequest)request);
                    return;
                }
                case READ_NEXT_BLOCK_OF_CHILDREN: {
                    this.process((ReadNextBlockOfChildrenRequest)request);
                    return;
                }
                case READ_NODE: {
                    this.process((ReadNodeRequest)request);
                    return;
                }
                case READ_PROPERTY: {
                    this.process((ReadPropertyRequest)request);
                    return;
                }
                case REMOVE_PROPERTY: {
                    this.process((RemovePropertyRequest)request);
                    return;
                }
                case RENAME_NODE: {
                    this.process((RenameNodeRequest)request);
                    return;
                }
                case SET_PROPERTY: {
                    this.process((SetPropertyRequest)request);
                    return;
                }
                case UNLOCK_BRANCH: {
                    this.process((UnlockBranchRequest)request);
                    return;
                }
                case UPDATE_PROPERTIES: {
                    this.process((UpdatePropertiesRequest)request);
                    return;
                }
                case UPDATE_VALUES: {
                    this.process((UpdateValuesRequest)request);
                    return;
                }
                case VERIFY_NODE_EXISTS: {
                    this.process((VerifyNodeExistsRequest)request);
                    return;
                }
                case VERIFY_WORKSPACE: {
                    this.process((VerifyWorkspaceRequest)request);
                    return;
                }
                default: {
                    this.processUnknownRequest(request);
                    return;
                }
            }
        }
        catch (RuntimeException e) {
            request.setError(e);
            return;
        }
        finally {
            this.completeRequest(request);
        }
    }

    protected void completeRequest(Request request) {
        request.freeze();
    }

    public void process(CompositeRequest request) {
        if (request == null) {
            return;
        }
        boolean hasErrors = false;
        boolean readonly = request.isReadOnly();
        Iterator<Request> iter = request.iterator();
        while (iter.hasNext()) {
            Request embedded = iter.next();
            assert (embedded != null);
            if (embedded.isCancelled()) {
                return;
            }
            try {
                this.process(embedded);
            }
            catch (RuntimeException e) {
                embedded.setError(e);
            }
            if (hasErrors || !embedded.hasError()) continue;
            hasErrors = true;
            if (readonly || embedded.isReadOnly()) continue;
            assert (embedded.getError() != null);
            request.setError(embedded.getError());
            while (iter.hasNext()) {
                embedded = iter.next();
                embedded.cancel();
                embedded.freeze();
            }
            return;
        }
        if (hasErrors) {
            request.checkForErrors();
        }
    }

    protected void processUnknownRequest(Request request) {
        request.setError(new InvalidRequestException(GraphI18n.unsupportedRequestType.text(new Object[]{request.getClass().getName(), request})));
    }

    public abstract void process(VerifyWorkspaceRequest var1);

    public abstract void process(GetWorkspacesRequest var1);

    public abstract void process(CreateWorkspaceRequest var1);

    public abstract void process(CloneBranchRequest var1);

    public abstract void process(CloneWorkspaceRequest var1);

    public abstract void process(DestroyWorkspaceRequest var1);

    public abstract void process(CopyBranchRequest var1);

    public abstract void process(CreateNodeRequest var1);

    public abstract void process(DeleteBranchRequest var1);

    public void process(DeleteChildrenRequest request) {
        if (request == null) {
            return;
        }
        if (request.isCancelled()) {
            return;
        }
        ReadAllChildrenRequest readChildren = new ReadAllChildrenRequest(request.at(), request.inWorkspace());
        this.process(readChildren);
        if (readChildren.hasError()) {
            request.setError(readChildren.getError());
            return;
        }
        if (readChildren.isCancelled()) {
            return;
        }
        for (Location child : readChildren) {
            if (request.isCancelled()) {
                return;
            }
            DeleteBranchRequest deleteChild = new DeleteBranchRequest(child, request.inWorkspace());
            this.process(deleteChild);
            request.addDeletedChild(child);
        }
        request.setActualLocationOfNode(readChildren.getActualLocationOfNode());
    }

    public abstract void process(MoveBranchRequest var1);

    public abstract void process(ReadAllChildrenRequest var1);

    public void process(ReadBlockOfChildrenRequest request) {
        if (request == null) {
            return;
        }
        ReadAllChildrenRequest readAll = new ReadAllChildrenRequest(request.of(), request.inWorkspace());
        this.process(readAll);
        if (readAll.hasError()) {
            request.setError(readAll.getError());
            return;
        }
        List<Location> allChildren = readAll.getChildren();
        if (allChildren.size() < request.startingAtIndex()) {
            return;
        }
        int endIndex = Math.min(request.endingBefore(), allChildren.size());
        for (int i = request.startingAtIndex(); i != endIndex; ++i) {
            request.addChild(allChildren.get(i));
        }
        request.setActualLocationOfNode(readAll.getActualLocationOfNode());
        this.setCacheableInfo(request);
    }

    public void process(ReadNextBlockOfChildrenRequest request) {
        if (request == null) {
            return;
        }
        Location actualSiblingLocation = request.startingAfter();
        Path path = actualSiblingLocation.getPath();
        Path parentPath = null;
        if (path != null) {
            parentPath = path.getParent();
        }
        if (parentPath == null) {
            VerifyNodeExistsRequest verifySibling = new VerifyNodeExistsRequest(request.startingAfter(), request.inWorkspace());
            this.process(verifySibling);
            actualSiblingLocation = verifySibling.getActualLocationOfNode();
            parentPath = actualSiblingLocation.getPath().getParent();
        }
        assert (parentPath != null);
        ReadAllChildrenRequest readAll = new ReadAllChildrenRequest(Location.create(parentPath), request.inWorkspace());
        this.process(readAll);
        if (readAll.hasError()) {
            request.setError(readAll.getError());
            return;
        }
        List<Location> allChildren = readAll.getChildren();
        boolean found = false;
        int count = 0;
        for (Location child : allChildren) {
            if (count > request.count()) break;
            if (!found) {
                found = child.isSame(request.startingAfter());
                continue;
            }
            ++count;
            request.addChild(child);
        }
        request.setActualLocationOfStartingAfterNode(actualSiblingLocation);
        this.setCacheableInfo(request);
    }

    public void process(ReadBranchRequest request) {
        if (request == null) {
            return;
        }
        LinkedList<LocationWithDepth> locationsToRead = new LinkedList<LocationWithDepth>();
        locationsToRead.add(new LocationWithDepth(request.at(), 1));
        boolean first = true;
        while (locationsToRead.peek() != null) {
            if (request.isCancelled()) {
                return;
            }
            LocationWithDepth read = (LocationWithDepth)locationsToRead.poll();
            if (read.depth > request.maximumDepth()) break;
            ReadNodeRequest readNode = new ReadNodeRequest(read.location, request.inWorkspace());
            this.process(readNode);
            if (readNode.hasError()) {
                request.setError(readNode.getError());
                return;
            }
            Location actualLocation = readNode.getActualLocationOfNode();
            if (first) {
                request.setActualLocationOfNode(actualLocation);
                first = false;
            }
            request.setChildren(actualLocation, readNode.getChildren());
            request.setProperties(actualLocation, readNode.getProperties());
            for (Location child : readNode.getChildren()) {
                locationsToRead.add(new LocationWithDepth(child, read.depth + 1));
            }
        }
        this.setCacheableInfo(request);
    }

    public abstract void process(ReadAllPropertiesRequest var1);

    public void process(ReadNodeRequest request) {
        if (request == null) {
            return;
        }
        ReadAllPropertiesRequest readProperties = new ReadAllPropertiesRequest(request.at(), request.inWorkspace());
        this.process(readProperties);
        if (readProperties.hasError()) {
            request.setError(readProperties.getError());
            return;
        }
        request.setActualLocationOfNode(readProperties.getActualLocationOfNode());
        ReadAllChildrenRequest readChildren = new ReadAllChildrenRequest(request.at(), request.inWorkspace());
        this.process(readChildren);
        if (readChildren.hasError()) {
            request.setError(readChildren.getError());
            return;
        }
        if (request.isCancelled()) {
            return;
        }
        for (Property property : readProperties) {
            request.addProperty(property);
        }
        for (Location child : readChildren) {
            request.addChild(child);
        }
        this.setCacheableInfo(request);
    }

    public void process(ReadPropertyRequest request) {
        if (request == null) {
            return;
        }
        ReadAllPropertiesRequest readNode = new ReadAllPropertiesRequest(request.on(), request.inWorkspace());
        this.process(readNode);
        if (readNode.hasError()) {
            request.setError(readNode.getError());
            return;
        }
        Property property = readNode.getPropertiesByName().get(request.named());
        request.setProperty(property);
        request.setActualLocationOfNode(readNode.getActualLocationOfNode());
        this.setCacheableInfo(request);
    }

    public void process(VerifyNodeExistsRequest request) {
        if (request == null) {
            return;
        }
        ReadAllPropertiesRequest readNode = new ReadAllPropertiesRequest(request.at(), request.inWorkspace());
        this.process(readNode);
        if (readNode.hasError()) {
            request.setError(readNode.getError());
            return;
        }
        request.setActualLocationOfNode(readNode.getActualLocationOfNode());
        this.setCacheableInfo(request);
    }

    public void process(RemovePropertyRequest request) {
        if (request == null) {
            return;
        }
        Map<Name, Object> properties = Collections.singletonMap(request.propertyName(), null);
        UpdatePropertiesRequest update = new UpdatePropertiesRequest(request.from(), request.inWorkspace(), properties);
        this.process(update);
        if (update.hasError()) {
            request.setError(update.getError());
        }
        request.setActualLocationOfNode(update.getActualLocationOfNode());
    }

    public void process(SetPropertyRequest request) {
        if (request == null) {
            return;
        }
        Property property = request.property();
        Map<Name, Property> properties = Collections.singletonMap(property.getName(), property);
        UpdatePropertiesRequest update = new UpdatePropertiesRequest(request.on(), request.inWorkspace(), properties);
        this.process(update);
        if (update.hasError()) {
            request.setError(update.getError());
        } else {
            request.setActualLocationOfNode(update.getActualLocationOfNode());
            request.setNewProperty(update.isNewProperty(property.getName()));
        }
    }

    public abstract void process(UpdatePropertiesRequest var1);

    public void process(UpdateValuesRequest request) {
        String workspaceName = request.inWorkspace();
        Location on = request.on();
        Name propertyName = request.property();
        ReadPropertyRequest readProperty = new ReadPropertyRequest(on, workspaceName, propertyName);
        this.process(readProperty);
        if (readProperty.hasError()) {
            request.setError(readProperty.getError());
            return;
        }
        Property property = readProperty.getProperty();
        ArrayList<Object> actualRemovedValues = new ArrayList<Object>(request.removedValues().size());
        LinkedList<Object> newValues = property == null ? new LinkedList<Object>() : new LinkedList<Object>(Arrays.asList(property.getValuesAsArray()));
        block0: for (Object removedValue : request.removedValues()) {
            Iterator iter = newValues.iterator();
            while (iter.hasNext()) {
                if (!iter.next().equals(removedValue)) continue;
                iter.remove();
                actualRemovedValues.add(removedValue);
                continue block0;
            }
        }
        newValues.addAll(request.addedValues());
        Property newProperty = this.getExecutionContext().getPropertyFactory().create(propertyName, newValues);
        SetPropertyRequest setProperty = new SetPropertyRequest(on, workspaceName, newProperty);
        this.process(setProperty);
        if (setProperty.hasError()) {
            request.setError(setProperty.getError());
        } else {
            request.setActualLocation(setProperty.getActualLocationOfNode(), request.addedValues(), actualRemovedValues);
            request.setActualProperty(newProperty, setProperty.isNewProperty());
        }
    }

    public void process(RenameNodeRequest request) {
        if (request == null) {
            return;
        }
        Location from = request.at();
        if (!from.hasPath()) {
            throw new UnsupportedOperationException();
        }
        Path newPath = this.getExecutionContext().getValueFactories().getPathFactory().create(from.getPath(), request.toName());
        Location to = Location.create(newPath);
        MoveBranchRequest move = new MoveBranchRequest(from, to, request.inWorkspace());
        this.process(move);
        request.setActualLocations(move.getActualLocationBefore(), move.getActualLocationAfter());
    }

    public void process(LockBranchRequest request) {
        Location actualLocation = request.at();
        if (!actualLocation.hasPath()) {
            VerifyNodeExistsRequest nodeExists = new VerifyNodeExistsRequest(request.at(), request.inWorkspace());
            this.process(nodeExists);
            if (nodeExists.hasError()) {
                request.setError(nodeExists.getError());
                return;
            }
            actualLocation = nodeExists.getActualLocationOfNode();
        }
        request.setActualLocation(actualLocation);
    }

    public void process(UnlockBranchRequest request) {
        Location actualLocation = request.at();
        if (!actualLocation.hasPath()) {
            VerifyNodeExistsRequest nodeExists = new VerifyNodeExistsRequest(request.at(), request.inWorkspace());
            this.process(nodeExists);
            if (nodeExists.hasError()) {
                request.setError(nodeExists.getError());
                return;
            }
            actualLocation = nodeExists.getActualLocationOfNode();
        }
        request.setActualLocation(actualLocation);
    }

    public void process(AccessQueryRequest request) {
        this.processUnknownRequest(request);
    }

    public void process(FullTextSearchRequest request) {
        this.processUnknownRequest(request);
    }

    public void close() {
    }

    public List<ChangeRequest> getChanges() {
        return this.changes;
    }

    public void notifyObserverOfChanges() {
        String userName;
        if (this.observer == null) {
            if (this.changes != null) {
                this.changes.clear();
            }
            return;
        }
        if (this.changes.isEmpty()) {
            return;
        }
        String string = userName = this.context.getSecurityContext() != null ? this.context.getSecurityContext().getUserName() : null;
        if (userName == null) {
            userName = "";
        }
        String contextId = this.context.getId();
        String processId = null;
        Changes changes = new Changes(processId, contextId, userName, this.getSourceName(), this.getNowInUtc(), this.changes);
        this.observer.notify(changes);
        this.changes = null;
    }

    @Immutable
    protected class LocationWithDepth {
        protected final Location location;
        protected final int depth;

        public LocationWithDepth(Location location, int depth) {
            this.location = location;
            this.depth = depth;
        }

        public Location getLocation() {
            return this.location;
        }

        public int getDepth() {
            return this.depth;
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public String toString() {
            return this.location.toString() + " at depth " + this.depth;
        }
    }
}

