/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.xml;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.XmlNameEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.io.Destination;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.basic.LocalNamespaceRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.ext.DefaultHandler2;

@NotThreadSafe
public class XmlHandler
extends DefaultHandler2 {
    private final ExecutionContext context;
    public static TextDecoder DEFAULT_DECODER = new XmlNameEncoder();
    public static AttributeScoping DEFAULT_ATTRIBUTE_SCOPING = AttributeScoping.USE_DEFAULT_NAMESPACE;
    protected final Destination destination;
    protected final Name nameAttribute;
    protected final Name typeAttribute;
    protected final Name typeAttributeValue;
    protected final PathFactory pathFactory;
    protected final NameFactory nameFactory;
    protected final PropertyFactory propertyFactory;
    protected final NamespaceRegistry namespaceRegistry;
    protected final TextDecoder decoder;
    private final Map<String, LinkedList<String>> prefixStackByUri = new HashMap<String, LinkedList<String>>();
    private final AttributeScoping attributeScoping;
    protected Path currentPath;
    protected boolean skipFirstElement;
    protected final List<Property> properties = new ArrayList<Property>();
    protected final Object[] propertyValues = new Object[1];
    private StringBuilder characterDataBuffer = new StringBuilder();
    private final LinkedList<ElementEntry> elementStack = new LinkedList();

    public XmlHandler(Destination destination, boolean skipRootElement, Path parent, TextDecoder textDecoder, Name nameAttribute, Name typeAttribute, Name typeAttributeValue, AttributeScoping scoping) {
        CheckArg.isNotNull((Object)destination, (String)"destination");
        assert (destination != null);
        this.destination = destination;
        this.nameAttribute = nameAttribute;
        this.typeAttribute = typeAttribute;
        this.typeAttributeValue = typeAttributeValue;
        this.decoder = textDecoder != null ? textDecoder : DEFAULT_DECODER;
        this.skipFirstElement = skipRootElement;
        this.attributeScoping = scoping != null ? scoping : DEFAULT_ATTRIBUTE_SCOPING;
        this.context = destination.getExecutionContext();
        assert (this.context != null);
        LocalNamespaceRegistry namespaceRegistry = new LocalNamespaceRegistry(this.context.getNamespaceRegistry());
        ExecutionContext localContext = this.context.with(namespaceRegistry);
        this.nameFactory = localContext.getValueFactories().getNameFactory();
        this.pathFactory = localContext.getValueFactories().getPathFactory();
        this.propertyFactory = localContext.getPropertyFactory();
        this.namespaceRegistry = localContext.getNamespaceRegistry();
        assert (this.nameFactory != null);
        assert (this.pathFactory != null);
        assert (this.propertyFactory != null);
        assert (this.namespaceRegistry != null);
        Path path = this.currentPath = parent != null ? parent : this.pathFactory.createRootPath();
        assert (this.currentPath != null);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        assert (uri != null);
        LinkedList<String> prefixStack = this.prefixStackByUri.get(uri);
        if (prefixStack == null) {
            prefixStack = new LinkedList();
            this.prefixStackByUri.put(uri, prefixStack);
        }
        prefixStack.addFirst(prefix);
        if (!this.namespaceRegistry.isRegisteredNamespaceUri(uri)) {
            NamespaceRegistry contextRegistry = this.context.getNamespaceRegistry();
            if (contextRegistry.getNamespaceForPrefix(prefix) != null) {
                this.context.getNamespaceRegistry().getPrefixForNamespaceUri(uri, true);
                this.namespaceRegistry.register(prefix, uri);
            } else {
                this.context.getNamespaceRegistry().register(prefix, uri);
            }
        } else {
            this.namespaceRegistry.register(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        assert (prefix != null);
        String uri = this.namespaceRegistry.getNamespaceForPrefix(prefix);
        assert (uri != null);
        LinkedList<String> prefixStack = this.prefixStackByUri.get(uri);
        assert (prefixStack != null);
        assert (!prefixStack.isEmpty());
        String existingPrefix = prefixStack.removeFirst();
        assert (prefix.equals(existingPrefix));
        if (prefixStack.isEmpty()) {
            this.namespaceRegistry.unregister(uri);
            this.prefixStackByUri.remove(uri);
        } else {
            String previous = prefixStack.getFirst();
            this.namespaceRegistry.register(previous, uri);
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) {
        ElementEntry element;
        if (this.skipFirstElement) {
            this.skipFirstElement = false;
            return;
        }
        assert (localName != null);
        Name nodeName = null;
        if (!this.elementStack.isEmpty()) {
            this.elementStack.peek().addAsNode();
            element = new ElementEntry(this.elementStack.peek(), this.currentPath, null);
        } else {
            element = new ElementEntry(null, this.currentPath, null);
        }
        this.elementStack.addFirst(element);
        this.properties.clear();
        Name typePropertyValue = null;
        int len = attributes.getLength();
        for (int i = 0; i != len; ++i) {
            String attributeLocalName = attributes.getLocalName(i);
            String attributeUri = attributes.getURI(i);
            Name attributeName = null;
            if ((attributeUri == null || attributeUri.length() == 0) && attributes.getQName(i).indexOf(58) == -1) {
                switch (this.attributeScoping) {
                    case INHERIT_ELEMENT_NAMESPACE: {
                        attributeName = this.nameFactory.create(uri, attributeLocalName, this.decoder);
                        break;
                    }
                    case USE_DEFAULT_NAMESPACE: {
                        attributeName = (Name)this.nameFactory.create(attributeLocalName, this.decoder);
                    }
                }
            } else {
                attributeName = this.nameFactory.create(attributeUri, attributeLocalName, this.decoder);
            }
            assert (attributeName != null);
            if (nodeName == null && attributeName.equals(this.nameAttribute)) {
                nodeName = (Name)this.nameFactory.create(attributes.getValue(i));
                element.setName(nodeName);
                continue;
            }
            if (typePropertyValue == null && attributeName.equals(this.typeAttribute)) {
                typePropertyValue = this.nameFactory.create(attributes.getValue(i));
                continue;
            }
            element.addProperty(attributeName, attributes.getValue(i));
        }
        if (nodeName == null) {
            nodeName = this.nameFactory.create(uri, localName, this.decoder);
            element.setName(nodeName);
        } else if (typePropertyValue == null) {
            typePropertyValue = this.nameFactory.create(uri, localName, this.decoder);
        }
        if (this.typeAttribute != null) {
            if (typePropertyValue == null) {
                typePropertyValue = this.typeAttributeValue;
            }
            if (typePropertyValue != null) {
                element.addProperty(this.typeAttribute, typePropertyValue);
            }
        }
        this.currentPath = element.path();
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        String s = this.characterDataBuffer.toString().trim();
        if (s.length() > 0) {
            this.elementStack.removeFirst().addAsPropertySetTo(s);
        } else if (!this.elementStack.isEmpty()) {
            this.elementStack.removeFirst().submit();
        }
        this.characterDataBuffer = new StringBuilder();
        this.currentPath = this.currentPath.getParent();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.characterDataBuffer.append(ch, start, length);
    }

    @Override
    public void endDocument() {
        this.destination.submit();
    }

    protected Property createProperty(Name propertyName, Object value) {
        this.propertyValues[0] = value;
        return this.propertyFactory.create(propertyName, this.propertyValues);
    }

    protected Property createProperty(Name propertyName, Collection<Object> values) {
        return this.propertyFactory.create(propertyName, values);
    }

    private class ElementEntry {
        private ElementEntry parent;
        private Path pathToParent;
        private Path pathToThisNode;
        private Name name;
        private Multimap<Name, Object> properties;
        private ElementEntryState state;

        protected ElementEntry(ElementEntry parent, Path pathToParent, Name name) {
            this.parent = parent;
            this.pathToParent = pathToParent;
            this.name = name;
            this.state = ElementEntryState.TBD;
            this.properties = LinkedHashMultimap.create();
        }

        protected void setName(Name name) {
            this.name = name;
            this.pathToThisNode = XmlHandler.this.pathFactory.create(this.pathToParent, name);
        }

        protected void addProperty(Name propertyName, Object propertyValue) {
            assert (this.state != ElementEntryState.PROPERTY);
            this.properties.put((Object)propertyName, propertyValue);
        }

        protected void addAsNode() {
            assert (this.state != ElementEntryState.PROPERTY);
            if (this.state == ElementEntryState.NODE) {
                return;
            }
            this.state = ElementEntryState.NODE;
            XmlHandler.this.destination.create(XmlHandler.this.pathFactory.create(this.pathToParent, this.name), Collections.<Property>emptyList());
        }

        protected void addAsPropertySetTo(Object value) {
            assert (this.state != ElementEntryState.NODE);
            this.state = ElementEntryState.PROPERTY;
            this.parent.addProperty(this.name, value);
        }

        protected final Path path() {
            return this.pathToThisNode;
        }

        protected void submit() {
            if (this.state == ElementEntryState.PROPERTY) {
                return;
            }
            if (this.state == ElementEntryState.NODE && this.properties.size() == 0) {
                return;
            }
            Property[] propertiesToAdd = new Property[this.properties.size()];
            int i = 0;
            for (Name name : this.properties.keySet()) {
                propertiesToAdd[i++] = XmlHandler.this.createProperty(name, this.properties.get((Object)name));
            }
            if (this.state == ElementEntryState.TBD) {
                XmlHandler.this.destination.create(this.pathToThisNode, Arrays.asList(propertiesToAdd));
            } else {
                XmlHandler.this.destination.setProperties(this.pathToThisNode, propertiesToAdd);
            }
        }
    }

    protected static enum ElementEntryState {
        NODE,
        PROPERTY,
        TBD;

    }

    public static enum AttributeScoping {
        USE_DEFAULT_NAMESPACE,
        INHERIT_ELEMENT_NAMESPACE;

    }
}

