/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.util.HashSet;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.common.component.ClassLoaderFactory;
import org.modeshape.graph.ExecutionContext;

public class ExecutionContextTest {
    private ExecutionContext context;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
    }

    @After
    public void afterEach() {
        this.context = null;
    }

    @Test
    public void shouldHaveIdentifierThatIsNotNull() {
        Assert.assertThat((Object)this.context.getId(), Is.is(IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveIdentifierThatIsNotBlank() {
        Assert.assertThat((Object)this.context.getId().length(), Is.is(IsNot.not(0)));
        Assert.assertThat((Object)this.context.getId().trim().length(), Is.is(IsNot.not(0)));
    }

    @Test
    public void shouldHaveIdentifierThatIsUnique() {
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i != 50; ++i) {
            Assert.assertThat((Object)ids.add(new ExecutionContext().getId()), Is.is(true));
        }
    }

    @Test
    public void shouldCreateSubcontextsWithDifferentIdentifiers() {
        ExecutionContext newContext = this.context.with((ClassLoaderFactory)Mockito.mock(ClassLoaderFactory.class));
        Assert.assertThat((Object)newContext.getId(), Is.is(IsNot.not(this.context.getId())));
    }
}

