/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.junit.matchers.IsCollectionContaining;
import org.junit.matchers.TypeSafeMatcher;
import org.modeshape.graph.Node;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Property;

public class IsNodeWithProperty
extends TypeSafeMatcher<Node> {
    private final String propertyNameStr;
    private final Name propertyName;
    private final Matcher<Iterable<Object>> valueMatcher;

    public IsNodeWithProperty(String propertyNameStr, Name propertyName, Matcher<Iterable<Object>> valueMatcher) {
        this.propertyNameStr = propertyNameStr;
        this.propertyName = propertyName;
        this.valueMatcher = valueMatcher;
    }

    public boolean matchesSafely(Node node) {
        Property prop;
        Property property = prop = this.propertyNameStr != null ? node.getProperty(this.propertyNameStr) : node.getProperty(this.propertyName);
        if (prop != null) {
            return this.valueMatcher.matches(prop);
        }
        return false;
    }

    public void describeTo(Description description) {
        String name = this.propertyNameStr != null ? this.propertyNameStr : this.propertyName;
        description.appendText("a property \"" + name + "\"containing ").appendDescriptionOf(this.valueMatcher);
    }

    @Factory
    public static IsNodeWithProperty hasProperty(Name name, Object ... values) {
        return new IsNodeWithProperty(null, name, IsCollectionContaining.hasItems((Object[])values));
    }

    @Factory
    public static IsNodeWithProperty hasProperty(String name, Object ... values) {
        return new IsNodeWithProperty(name, null, IsCollectionContaining.hasItems((Object[])values));
    }
}

