/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.common.text.NoOpEncoder;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.graph.Location;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.BasicSingleValueProperty;
import org.modeshape.graph.property.basic.NameValueFactory;
import org.modeshape.graph.property.basic.PathValueFactory;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;
import org.modeshape.graph.property.basic.StringValueFactory;

public class LocationTest {
    private static final NoOpEncoder NO_OP_ENCODER = new NoOpEncoder();
    private static final NamespaceRegistry NAMESPACE_REGISTRY = new SimpleNamespaceRegistry("http://www.modeshape.org/1.0");
    private static final StringValueFactory STRING_VALUE_FACTORY = new StringValueFactory(NAMESPACE_REGISTRY, (TextDecoder)NO_OP_ENCODER, (TextEncoder)NO_OP_ENCODER);
    private static final NameValueFactory NAME_VALUE_FACTORY = new NameValueFactory(NAMESPACE_REGISTRY, (TextDecoder)NO_OP_ENCODER, (ValueFactory)STRING_VALUE_FACTORY);
    private PathFactory pathFactory = new PathValueFactory((TextDecoder)NO_OP_ENCODER, (ValueFactory)STRING_VALUE_FACTORY, (ValueFactory)NAME_VALUE_FACTORY);
    private static UUID uuid = UUID.randomUUID();
    private Path pathA = (Path)this.pathFactory.create("/A");
    private Path pathABC = (Path)this.pathFactory.create("/A/B/C");
    private static Property propA = new BasicSingleValueProperty(NAME_VALUE_FACTORY.create("A"), (Object)"Value A");
    private static Property propB = new BasicSingleValueProperty(NAME_VALUE_FACTORY.create("B"), (Object)"Value B");
    private static Property propU = new BasicSingleValueProperty(ModeShapeLexicon.UUID, (Object)uuid);
    private static List<Property> propListAB;
    private static List<Property> propListABU;

    @BeforeClass
    public static void beforeAny() {
        propListAB = new ArrayList<Property>();
        propListAB.add(propA);
        propListAB.add(propB);
        propListABU = new ArrayList<Property>();
        propListABU.add(propA);
        propListABU.add(propB);
        propListABU.add(propU);
    }

    @Test
    public void locationsWithSamePathsAreEqual() {
        Location locationA1 = Location.create((Path)this.pathA);
        Location locationA2 = Location.create((Path)this.pathA);
        Assert.assertThat((String)"Locations created with identical paths must be equal", (Object)locationA1, Is.is(locationA2));
        Location locationABC1 = Location.create((Path)this.pathABC);
        Location locationABC2 = Location.create((Path)this.pathABC);
        Assert.assertThat((String)"Locations created with identical non-trivial paths must be equal", (Object)locationABC1, Is.is(locationABC2));
    }

    @Test
    public void locationsWithSamePathsAreSame() {
        Location locationA1 = Location.create((Path)this.pathA);
        Location locationA2 = Location.create((Path)this.pathA);
        Assert.assertThat((String)"isSame must return true for locations created with identical paths", (Object)locationA1.isSame(locationA2), Is.is(true));
        Location locationABC1 = Location.create((Path)this.pathABC);
        Location locationABC2 = Location.create((Path)this.pathABC);
        Assert.assertThat((String)"isSame must return true for locations created with identical, non-trivial paths", (Object)locationABC1.isSame(locationABC2), Is.is(true));
    }

    @Test
    public void locationsWithSamePathsAndSamePropertyAreNotEqual() {
        Location locationA1 = Location.create((Path)this.pathA, (Property)propA);
        Location locationA2 = Location.create((Path)this.pathA, (Property)propA);
        Assert.assertThat((String)"Locations created with identical paths and different property must be equal", (Object)locationA1, Is.is(locationA2));
    }

    @Test
    public void locationsWithSamePathsAndSamePropertyAreNotSame() {
        Location locationA1 = Location.create((Path)this.pathA, (Property)propA);
        Location locationA2 = Location.create((Path)this.pathA, (Property)propA);
        Assert.assertThat((String)"isSame must return true for locations created with identical paths and property", (Object)locationA1.isSame(locationA2), Is.is(true));
    }

    @Test
    public void locationsWithSamePathsAndDifferentPropertyAreEqual() {
        Location locationA1 = Location.create((Path)this.pathA, (Property)propA);
        Location locationA2 = Location.create((Path)this.pathA, (Property)propB);
        Assert.assertThat((String)"Locations created with identical paths and different property must not be equal", (Object)locationA1.equals((Object)locationA2), Is.is(true));
    }

    @Test
    public void locationsWithSamePathsAndDifferentPropertyAreNotSame() {
        Location locationA1 = Location.create((Path)this.pathA, (Property)propA);
        Location locationA2 = Location.create((Path)this.pathA, (Property)propB);
        Assert.assertThat((String)"isSame must not return true for locations created with identical paths and property", (Object)locationA1.isSame(locationA2), Is.is(false));
    }

    @Test
    public void locationsWithDifferentPathsAndSamePropertyAreNotEqual() {
        Location locationA1 = Location.create((Path)this.pathA, (Property)propA);
        Location locationA2 = Location.create((Path)this.pathABC, (Property)propA);
        Assert.assertThat((String)"Locations created with different paths and the same property must not be equal", (Object)locationA1, IsNot.not(locationA2));
    }

    @Test
    public void locationsWithDifferentPathsAndSamePropertyAreNotSame() {
        Location locationA1 = Location.create((Path)this.pathA, (Property)propA);
        Location locationA2 = Location.create((Path)this.pathABC, (Property)propA);
        Assert.assertThat((String)"isSame must not return true for locations created with different paths and the same property", (Object)locationA1.isSame(locationA2), Is.is(false));
    }

    @Test
    public void locationsWithSamePathsAndSamePropertiesAreNotEqual() {
        Location locationA1 = Location.create((Path)this.pathA, propListAB);
        Location locationA2 = Location.create((Path)this.pathA, propListAB);
        Assert.assertThat((String)"Locations created with identical paths and different properties must be equal", (Object)locationA1, Is.is(locationA2));
    }

    @Test
    public void locationsWithSamePathsAndSamePropertiesAreNotSame() {
        Location locationA1 = Location.create((Path)this.pathA, propListAB);
        Location locationA2 = Location.create((Path)this.pathA, propListAB);
        Assert.assertThat((String)"isSame must return true for locations created with identical paths and properties", (Object)locationA1.isSame(locationA2), Is.is(true));
    }

    @Test
    public void locationsWithSamePathsAndDifferentPropertiesAreNotEqual() {
        Location locationA1 = Location.create((Path)this.pathA, propListAB);
        Location locationA2 = Location.create((Path)this.pathA, propListABU);
        Assert.assertThat((String)"Locations created with identical paths and different properties must not be equal", (Object)locationA1.equals((Object)locationA2), Is.is(true));
    }

    @Test
    public void locationsWithSamePathsAndDifferentPropertiesAreNotSame() {
        Location locationA1 = Location.create((Path)this.pathA, propListAB);
        Location locationA2 = Location.create((Path)this.pathA, propListABU);
        Assert.assertThat((String)"isSame must not return true for locations created with identical paths and different properties", (Object)locationA1.isSame(locationA2), Is.is(false));
    }

    @Test
    public void locationsWithDifferentPathsAndSamePropertiesAreNotEqual() {
        Location locationA1 = Location.create((Path)this.pathA, propListAB);
        Location locationA2 = Location.create((Path)this.pathABC, propListAB);
        Assert.assertThat((String)"Locations created with identical paths and different properties must not be equal", (Object)locationA1, IsNot.not(locationA2));
    }

    @Test
    public void locationsWithDifferentPathsAndSamePropertiesAreNotSame() {
        Location locationA1 = Location.create((Path)this.pathA, propListAB);
        Location locationA2 = Location.create((Path)this.pathABC, propListAB);
        Assert.assertThat((String)"isSame must not return true for locations created with different paths and the same properties", (Object)locationA1.isSame(locationA2), Is.is(false));
    }

    @Test
    public void testTransitivityOfWithOperationForPathAndUUID() {
        Location locationA1 = Location.create((Path)this.pathA);
        locationA1 = locationA1.with(uuid);
        Location locationU1 = Location.create((UUID)uuid);
        locationU1 = locationU1.with(this.pathA);
        Assert.assertThat((String)"With() operation must be transitive for equals", (Object)locationA1.equals((Object)locationU1), Is.is(true));
        Assert.assertThat((String)"With() operation must be transitive for isSame", (Object)locationA1.isSame(locationU1), Is.is(true));
        Assert.assertThat((String)"With() operation must be transitive for getString", (Object)locationA1.getString().equals(locationU1.getString()), Is.is(true));
        Assert.assertThat((String)"With() operation must be transitive for hashCode", (Object)(locationA1.hashCode() == locationU1.hashCode() ? 1 : 0), Is.is(true));
    }

    @Test
    public void testTransitivityOfWithOperationForPathAndProperty() {
        Location locationA1 = Location.create((Path)this.pathA);
        locationA1 = locationA1.with(propB);
        Location locationU1 = Location.create((Property)propB);
        locationU1 = locationU1.with(this.pathA);
        Assert.assertThat((String)"With() operation must be transitive for equals", (Object)locationA1.equals((Object)locationU1), Is.is(true));
        Assert.assertThat((String)"With() operation must be transitive for isSame", (Object)locationA1.isSame(locationU1), Is.is(true));
        Assert.assertThat((String)"With() operation must be transitive for getString", (Object)locationA1.getString().equals(locationU1.getString()), Is.is(true));
        Assert.assertThat((String)"With() operation must be transitive for hashCode", (Object)(locationA1.hashCode() == locationU1.hashCode() ? 1 : 0), Is.is(true));
    }
}

