/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector;

import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionPool;
import org.modeshape.graph.connector.RepositoryOperation;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.RepositorySourceLoadHarness;
import org.modeshape.graph.connector.TimeDelayingRepositorySource;

public class RepositoryConnectionPoolTest {
    private RepositoryConnectionPool pool;
    private RepositorySource source;
    private ExecutionContext context;

    @Before
    public void beforeEach() {
        this.source = new TimeDelayingRepositorySource("source 1");
        this.pool = new RepositoryConnectionPool(this.source, 1, 1, 100L, TimeUnit.SECONDS);
        this.context = null;
    }

    @After
    public void afterEach() throws Exception {
        this.pool.shutdown();
        this.pool.awaitTermination(2L, TimeUnit.SECONDS);
    }

    @Test
    public void shouldBeCreatedInRunningState() {
        Assert.assertThat((Object)this.pool.isShutdown(), Is.is(false));
        Assert.assertThat((Object)this.pool.isTerminating(), Is.is(false));
        Assert.assertThat((Object)this.pool.isTerminated(), Is.is(false));
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), Is.is(0L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), Is.is(0L));
    }

    @Test
    public void shouldShutdownWhenNoConnectionsWereCreatedOrUsed() throws InterruptedException {
        Assert.assertThat((Object)this.pool.isShutdown(), Is.is(false));
        Assert.assertThat((Object)this.pool.isTerminating(), Is.is(false));
        Assert.assertThat((Object)this.pool.isTerminated(), Is.is(false));
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), Is.is(0L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), Is.is(0L));
        for (int i = 0; i != 4; ++i) {
            this.pool.shutdown();
            Assert.assertThat((Object)(this.pool.isShutdown() || this.pool.isTerminating() || this.pool.isTerminated() ? 1 : 0), Is.is(true));
            this.pool.awaitTermination(2L, TimeUnit.SECONDS);
            Assert.assertThat((Object)this.pool.isTerminated(), Is.is(true));
            Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), Is.is(0L));
            Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), Is.is(0L));
        }
    }

    @Test
    public void shouldCreateConnectionAndRecoverWhenClosed() throws RepositorySourceException {
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), Is.is(0L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), Is.is(0L));
        RepositoryConnection conn = this.pool.getConnection();
        Assert.assertThat((Object)conn, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), Is.is(1L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), Is.is(1L));
        Assert.assertThat((Object)this.pool.getPoolSize(), Is.is(1));
        conn.close();
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), Is.is(1L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), Is.is(1L));
        Assert.assertThat((Object)this.pool.getPoolSize(), Is.is(1));
    }

    @Test
    public void shouldAllowShutdownToBeCalledMultipleTimesEvenWhenShutdown() throws RepositorySourceException, InterruptedException {
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), Is.is(0L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), Is.is(0L));
        RepositoryConnection conn = this.pool.getConnection();
        Assert.assertThat((Object)conn, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), Is.is(1L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), Is.is(1L));
        Assert.assertThat((Object)this.pool.getPoolSize(), Is.is(1));
        conn.close();
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), Is.is(1L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), Is.is(1L));
        Assert.assertThat((Object)this.pool.getPoolSize(), Is.is(1));
        this.pool.shutdown();
        this.pool.shutdown();
        this.pool.awaitTermination(2L, TimeUnit.SECONDS);
        Assert.assertThat((Object)this.pool.isTerminated(), Is.is(true));
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), Is.is(1L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), Is.is(1L));
        this.pool.shutdown();
        this.pool.awaitTermination(2L, TimeUnit.SECONDS);
        this.pool.shutdown();
        this.pool.awaitTermination(2L, TimeUnit.SECONDS);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotCreateConnectionIfPoolIsNotRunning() throws RepositorySourceException, InterruptedException {
        this.pool.shutdown();
        this.pool.awaitTermination(2L, TimeUnit.SECONDS);
        Assert.assertThat((Object)this.pool.isTerminated(), Is.is(true));
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), Is.is(0L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), Is.is(0L));
        this.pool.getConnection();
    }

    @Test
    public void shouldAllowConnectionsToBeClosedMoreThanOnceWithNoIllEffects() throws RepositorySourceException {
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), Is.is(0L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), Is.is(0L));
        RepositoryConnection conn = this.pool.getConnection();
        Assert.assertThat((Object)conn, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.pool.getTotalConnectionsCreated(), Is.is(1L));
        Assert.assertThat((Object)this.pool.getTotalConnectionsUsed(), Is.is(1L));
        Assert.assertThat((Object)this.pool.getPoolSize(), Is.is(1));
        conn.close();
        conn.close();
    }

    @Test
    public void shouldBlockClientsWhenNotEnoughConnections() throws Exception {
        int numConnectionsInPool = 1;
        int numClients = 2;
        RepositoryConnectionPool pool = new RepositoryConnectionPool(this.source);
        pool.setCorePoolSize(numConnectionsInPool);
        pool.setMaximumPoolSize(numConnectionsInPool);
        RepositoryOperation.Factory<Integer> operationFactory = RepositorySourceLoadHarness.createMultipleLoadOperationFactory(10);
        RepositorySourceLoadHarness.runLoadTest(this.context, pool, numClients, 100L, TimeUnit.MILLISECONDS, operationFactory);
        pool.shutdown();
        pool.awaitTermination(4L, TimeUnit.SECONDS);
    }

    @Test
    public void shouldLimitClientsToRunSequentiallyWithOneConnectionInPool() throws Exception {
        int numConnectionsInPool = 1;
        int numClients = 3;
        RepositoryConnectionPool pool = new RepositoryConnectionPool(this.source);
        pool.setCorePoolSize(numConnectionsInPool);
        pool.setMaximumPoolSize(numConnectionsInPool);
        RepositoryOperation.Factory<Integer> operationFactory = RepositorySourceLoadHarness.createMultipleLoadOperationFactory(10);
        RepositorySourceLoadHarness.runLoadTest(this.context, pool, numClients, 100L, TimeUnit.MILLISECONDS, operationFactory);
        pool.shutdown();
        pool.awaitTermination(4L, TimeUnit.SECONDS);
    }

    @Test
    public void shouldClientsToRunConncurrentlyWithTwoConnectionsInPool() throws Exception {
        int numConnectionsInPool = 2;
        int numClients = 10;
        RepositoryConnectionPool pool = new RepositoryConnectionPool(this.source);
        pool.setCorePoolSize(numConnectionsInPool);
        pool.setMaximumPoolSize(numConnectionsInPool);
        RepositoryOperation.Factory<Integer> operationFactory = RepositorySourceLoadHarness.createMultipleLoadOperationFactory(10);
        RepositorySourceLoadHarness.runLoadTest(this.context, pool, numClients, 100L, TimeUnit.MILLISECONDS, operationFactory);
        pool.shutdown();
        pool.awaitTermination(4L, TimeUnit.SECONDS);
    }

    @Ignore(value="doesn't run on hudson")
    @Test
    public void shouldClientsToRunConncurrentlyWithMultipleConnectionInPool() throws Exception {
        int numConnectionsInPool = 10;
        int numClients = 50;
        RepositoryConnectionPool pool = new RepositoryConnectionPool(this.source);
        pool.setCorePoolSize(numConnectionsInPool);
        pool.setMaximumPoolSize(numConnectionsInPool);
        RepositoryOperation.Factory<Integer> operationFactory = RepositorySourceLoadHarness.createMultipleLoadOperationFactory(20);
        List<Future<Integer>> results = RepositorySourceLoadHarness.runLoadTest(this.context, pool, numClients, 200L, TimeUnit.MILLISECONDS, operationFactory);
        int total = 0;
        for (Future<Integer> result : results) {
            Assert.assertThat((Object)result.isDone(), Is.is(true));
            if (!result.isDone()) continue;
            total += result.get().intValue();
        }
        Assert.assertThat((Object)total, Is.is(20 * numClients));
        pool.shutdown();
        pool.awaitTermination(4L, TimeUnit.SECONDS);
    }
}

