/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.base.MapNode;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;

public class MapNodeTest {
    private MapNode node;
    private ExecutionContext context;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        UUID uuid = UUID.randomUUID();
        Path.Segment name = this.segment("myNode[3]");
        UUID parent = UUID.randomUUID();
        List<Property> props = this.properties(this.property("propA", "valueA"), this.property("propB", "valueB"));
        this.node = new MapNode(uuid, name, parent, props, null);
    }

    public Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    public Path.Segment segment(String segment) {
        return this.context.getValueFactories().getPathFactory().createSegment(segment);
    }

    public Property property(String name, Object ... values) {
        return this.context.getPropertyFactory().create(this.name(name), values);
    }

    public List<Property> properties(Property ... properties) {
        return Arrays.asList(properties);
    }

    @Test
    public void shouldInstantiateNodeWithUuid() {
        UUID uuid = UUID.randomUUID();
        this.node = new MapNode(uuid);
        Assert.assertThat((Object)this.node.getUuid(), Is.is(IsSame.sameInstance(uuid)));
        Assert.assertThat((Object)this.node.getParent(), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.node.getName(), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.node.getChildren().isEmpty(), Is.is(true));
        Assert.assertThat((Object)this.node.getProperties().isEmpty(), Is.is(true));
    }

    @Test
    public void shouldInstantiateNodeWithUuidAndNameAndParent() {
        UUID uuid = UUID.randomUUID();
        Path.Segment name = this.segment("myNode[3]");
        UUID parent = UUID.randomUUID();
        this.node = new MapNode(uuid, name, parent, (Map)null, null);
        Assert.assertThat((Object)this.node.getUuid(), Is.is(IsSame.sameInstance(uuid)));
        Assert.assertThat((Object)this.node.getParent(), Is.is(parent));
        Assert.assertThat((Object)this.node.getName(), Is.is(name));
        Assert.assertThat((Object)this.node.getChildren().isEmpty(), Is.is(true));
        Assert.assertThat((Object)this.node.getProperties().isEmpty(), Is.is(true));
    }

    @Test
    public void shouldInstantiateNodeWithUuidAndNoNameOrParent() {
        UUID uuid = UUID.randomUUID();
        this.node = new MapNode(uuid, null, null, (Map)null, null);
        Assert.assertThat((Object)this.node.getUuid(), Is.is(IsSame.sameInstance(uuid)));
        Assert.assertThat((Object)this.node.getParent(), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.node.getName(), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.node.getChildren().isEmpty(), Is.is(true));
        Assert.assertThat((Object)this.node.getProperties().isEmpty(), Is.is(true));
    }

    @Test
    public void shouldInstantiateNodeWithUuidAndNameAndParentAndProperties() {
        UUID uuid = UUID.randomUUID();
        Path.Segment name = this.segment("myNode[3]");
        UUID parent = UUID.randomUUID();
        List<Property> props = this.properties(this.property("propA", "valueA"), this.property("propB", "valueB"));
        this.node = new MapNode(uuid, name, parent, props, null);
        Assert.assertThat((Object)this.node.getUuid(), Is.is(IsSame.sameInstance(uuid)));
        Assert.assertThat((Object)this.node.getParent(), Is.is(parent));
        Assert.assertThat((Object)this.node.getName(), Is.is(name));
        Assert.assertThat((Object)this.node.getChildren().isEmpty(), Is.is(true));
        Assert.assertThat((Object)this.node.getProperties().size(), Is.is(2));
        Assert.assertThat((Object)this.node.getProperty(this.name("propA")), Is.is(props.get(0)));
        Assert.assertThat((Object)this.node.getProperty(this.name("propB")), Is.is(props.get(1)));
    }

    @Test
    public void shouldCreateCopyWithNewParent() {
        UUID uuid = UUID.randomUUID();
        Assert.assertThat((Object)this.node.getParent(), Is.is(IsNot.not(uuid)));
        this.node = this.node.withParent(uuid);
        Assert.assertThat((Object)this.node.getParent(), Is.is(uuid));
    }

    @Test
    public void shouldCreateCopyWithNewChild() {
        UUID uuid = UUID.randomUUID();
        this.node = this.node.withChild(uuid);
        Assert.assertThat((Object)this.node.getChildren().size(), Is.is(1));
        Assert.assertThat(this.node.getChildren().get(0), Is.is(uuid));
    }

    @Test
    public void shouldCreateCopyWithNewChildAtParticularIndex() {
        UUID uuid = UUID.randomUUID();
        this.node = this.node.withChild(0, uuid);
        Assert.assertThat((Object)this.node.getChildren().size(), Is.is(1));
        Assert.assertThat(this.node.getChildren().get(0), Is.is(uuid));
        UUID uuid2 = UUID.randomUUID();
        this.node = this.node.withChild(1, uuid2);
        Assert.assertThat((Object)this.node.getChildren().size(), Is.is(2));
        Assert.assertThat(this.node.getChildren().get(0), Is.is(uuid));
        Assert.assertThat(this.node.getChildren().get(1), Is.is(uuid2));
        UUID uuid3 = UUID.randomUUID();
        this.node = this.node.withChild(1, uuid3);
        Assert.assertThat((Object)this.node.getChildren().size(), Is.is(3));
        Assert.assertThat(this.node.getChildren().get(0), Is.is(uuid));
        Assert.assertThat(this.node.getChildren().get(1), Is.is(uuid3));
        Assert.assertThat(this.node.getChildren().get(2), Is.is(uuid2));
    }
}

