/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.federation;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.security.auth.callback.CallbackHandler;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.ModeShapeLexicon;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.federation.FederatedRepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.observe.Observer;

public class FederatedRepositorySourceTest {
    private FederatedRepositorySource source;
    private String sourceName;
    private String repositoryName;
    private String configurationSourceName;
    private InMemoryRepositorySource configRepositorySource;
    private RepositoryConnection configRepositoryConnection;
    private ExecutionContext context;
    @Mock
    private RepositoryConnection connection;
    @Mock
    private RepositoryConnectionFactory connectionFactory;
    private RepositoryContext repositoryContext;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new ExecutionContext();
        this.configurationSourceName = "configuration";
        this.repositoryName = "Test Repository";
        this.configRepositorySource = new InMemoryRepositorySource();
        this.configRepositorySource.setName("Configuration Repository");
        this.repositoryContext = new RepositoryContext(){

            public ExecutionContext getExecutionContext() {
                return FederatedRepositorySourceTest.this.context;
            }

            public Observer getObserver() {
                return null;
            }

            public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                return FederatedRepositorySourceTest.this.connectionFactory;
            }

            public Subgraph getConfiguration(int depth) {
                Graph result = Graph.create((RepositorySource)FederatedRepositorySourceTest.this.configRepositorySource, (ExecutionContext)FederatedRepositorySourceTest.this.context);
                result.useWorkspace("configSpace");
                return (Subgraph)result.getSubgraphOfDepth(depth).at("/a/b/Test Repository");
            }
        };
        this.configRepositorySource.initialize(this.repositoryContext);
        this.source = new FederatedRepositorySource();
        this.source.setName(this.repositoryName);
        this.sourceName = "federated source";
        this.source.setName(this.sourceName);
        this.source.initialize(this.repositoryContext);
        Graph configRepository = Graph.create((RepositorySource)this.configRepositorySource, (ExecutionContext)this.context);
        configRepository.createWorkspace().named("configSpace");
        Graph.Batch batch = configRepository.batch();
        batch.create("/a").and();
        batch.create("/a/b").and();
        batch.create("/a/b/Test Repository").with(ModeShapeLexicon.DEFAULT_WORKSPACE_NAME, new Object[]{"fedSpace"}).and();
        batch.create("/a/b/Test Repository/mode:workspaces").and();
        batch.create("/a/b/Test Repository/mode:workspaces/fedSpace").and();
        batch.create("/a/b/Test Repository/mode:workspaces/fedSpace/mode:cache").with(ModeShapeLexicon.PROJECTION_RULES, new Object[]{"/ => /"}).with(ModeShapeLexicon.SOURCE_NAME, new Object[]{"cache source"}).with(ModeShapeLexicon.WORKSPACE_NAME, new Object[]{"cacheSpace"}).with(ModeShapeLexicon.TIME_TO_EXPIRE, new Object[]{100000}).and();
        batch.create("/a/b/Test Repository/mode:workspaces/fedSpace/mode:projections").and();
        batch.create("/a/b/Test Repository/mode:workspaces/fedSpace/mode:projections/projection1").with(ModeShapeLexicon.PROJECTION_RULES, new Object[]{"/ => /s1"}).with(ModeShapeLexicon.SOURCE_NAME, new Object[]{"source 1"}).with(ModeShapeLexicon.WORKSPACE_NAME, new Object[]{"s1 workspace"}).and();
        batch.create("/a/b/Test Repository/mode:workspaces/fedSpace/mode:projections/projection2").with(ModeShapeLexicon.PROJECTION_RULES, new Object[]{"/ => /s2"}).with(ModeShapeLexicon.SOURCE_NAME, new Object[]{"source 2"}).with(ModeShapeLexicon.WORKSPACE_NAME, new Object[]{"s2 worskspace"}).and();
        batch.execute();
        this.configRepositoryConnection = this.configRepositorySource.getConnection();
        Mockito.when((Object)this.connectionFactory.createConnection(this.configurationSourceName)).thenReturn((Object)this.configRepositoryConnection);
    }

    protected static CallbackHandler anyCallbackHandler() {
        return (CallbackHandler)Matchers.argThat((Matcher)new ArgumentMatcher<CallbackHandler>(){

            public boolean matches(Object callback) {
                return callback != null;
            }
        });
    }

    @Test
    public void shouldReturnNonNullCapabilities() {
        Assert.assertThat((Object)this.source.getCapabilities(), Is.is(IsNull.notNullValue()));
    }

    @Test
    public void shouldSupportSameNameSiblings() {
        Assert.assertThat((Object)this.source.getCapabilities().supportsSameNameSiblings(), Is.is(true));
    }

    @Test
    public void shouldSupportUpdates() {
        Assert.assertThat((Object)this.source.getCapabilities().supportsUpdates(), Is.is(true));
    }

    @Test
    public void shouldCreateConnectionsByAuthenticateUsingFederationRepository() throws Exception {
        this.connection = this.source.getConnection();
        Assert.assertThat((Object)this.connection, Is.is(IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveNullSourceNameUponConstruction() {
        this.source = new FederatedRepositorySource();
        Assert.assertThat((Object)this.source.getName(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldAllowSettingName() {
        this.source.setName("Something");
        Assert.assertThat((Object)this.source.getName(), Is.is("Something"));
        this.source.setName("another name");
        Assert.assertThat((Object)this.source.getName(), Is.is("another name"));
    }

    @Test
    public void shouldAllowSettingNameToNull() {
        this.source.setName("some name");
        this.source.setName(null);
        Assert.assertThat((Object)this.source.getName(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldHaveDefaultRetryLimit() {
        Assert.assertThat((Object)this.source.getRetryLimit(), Is.is(0));
    }

    @Test
    public void shouldSetRetryLimitToZeroWhenSetWithNonPositiveValue() {
        this.source.setRetryLimit(0);
        Assert.assertThat((Object)this.source.getRetryLimit(), Is.is(0));
        this.source.setRetryLimit(-1);
        Assert.assertThat((Object)this.source.getRetryLimit(), Is.is(0));
        this.source.setRetryLimit(-100);
        Assert.assertThat((Object)this.source.getRetryLimit(), Is.is(0));
    }

    @Test
    public void shouldAllowRetryLimitToBeSet() {
        for (int i = 0; i != 100; ++i) {
            this.source.setRetryLimit(i);
            Assert.assertThat((Object)this.source.getRetryLimit(), Is.is(i));
        }
    }

    @Test
    public void shouldCreateJndiReferenceAndRecreatedObjectFromReference() throws Exception {
        int retryLimit = 100;
        this.source.setRetryLimit(retryLimit);
        this.source.setName("Some source");
        Reference ref = this.source.getReference();
        Assert.assertThat((Object)ref.getClassName(), Is.is(FederatedRepositorySource.class.getName()));
        Assert.assertThat((Object)ref.getFactoryClassName(), Is.is(FederatedRepositorySource.class.getName()));
        HashMap<String, Object> refAttributes = new HashMap<String, Object>();
        Enumeration<RefAddr> enumeration = ref.getAll();
        while (enumeration.hasMoreElements()) {
            RefAddr addr = enumeration.nextElement();
            refAttributes.put(addr.getType(), addr.getContent());
        }
        Assert.assertThat((Object)((String)refAttributes.remove("sourceName")), Is.is(this.source.getName()));
        Assert.assertThat((Object)((String)refAttributes.remove("retryLimit")), Is.is(Integer.toString(retryLimit)));
        Assert.assertThat((Object)refAttributes.isEmpty(), Is.is(true));
        FederatedRepositorySource factory = new FederatedRepositorySource();
        Name name = (Name)Mockito.mock(Name.class);
        Context context = (Context)Mockito.mock(Context.class);
        Hashtable env = new Hashtable();
        FederatedRepositorySource recoveredSource = (FederatedRepositorySource)factory.getObjectInstance(ref, name, context, env);
        Assert.assertThat((Object)recoveredSource, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)recoveredSource.getName(), Is.is(this.source.getName()));
        Assert.assertThat((Object)recoveredSource.getRetryLimit(), Is.is(this.source.getRetryLimit()));
        Assert.assertThat((Object)recoveredSource.equals((Object)this.source), Is.is(true));
        Assert.assertThat((Object)this.source.equals((Object)recoveredSource), Is.is(true));
    }
}

