/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.test;

import java.io.InputStream;
import java.util.List;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.util.IoUtil;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.test.AbstractConnectorTest;
import org.modeshape.graph.request.InvalidRequestException;

public abstract class NotWritableConnectorTest
extends AbstractConnectorTest {
    protected String[] validLargeValues;

    @Override
    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.validLargeValues = new String[]{IoUtil.read((InputStream)this.getClass().getClassLoader().getResourceAsStream("LoremIpsum1.txt")), IoUtil.read((InputStream)this.getClass().getClassLoader().getResourceAsStream("LoremIpsum2.txt")), IoUtil.read((InputStream)this.getClass().getClassLoader().getResourceAsStream("LoremIpsum3.txt"))};
    }

    @Test
    public void shouldNotHaveUpdateCapabilities() {
        Assert.assertThat((Object)this.source.getCapabilities().supportsUpdates(), Is.is(false));
    }

    @Test(expected=InvalidRequestException.class)
    public void shouldNotAllowSettingPropertyOnRootNode() {
        ((Graph.On)this.graph.set("propA").to("valueA")).on("/");
    }

    @Test(expected=InvalidRequestException.class)
    public void shouldNowAllowAddChildUnderRootNode() {
        ((Graph.Batch)this.graph.batch().create("/a").with("propB", new Object[]{"valueB"}).and("propC", new Object[]{"valueC"}).and()).execute();
    }

    @Test(expected=InvalidRequestException.class)
    public void shouldNotAllowMultipleUpdatesInBatch() {
        Graph.Create create = this.graph.batch().create("/a");
        for (int i = 0; i != 100; ++i) {
            create = create.with("property" + i, new Object[]{"value" + i});
        }
        ((Graph.Batch)create.and()).execute();
    }

    @Test(expected=InvalidRequestException.class)
    public void shouldNotAllowDeletingNodes() {
        for (Location child : (List)this.graph.getChildren().of("/")) {
            this.graph.delete(child);
            Assert.fail((String)"No error when attempting to delete the first child under root");
        }
    }

    @Test(expected=InvalidRequestException.class)
    public void shouldNotAllowCopyingNodes() {
        for (Location child : (List)this.graph.getChildren().of("/")) {
            this.graph.copy(child).into("/");
            Assert.fail((String)"No error when attempting to copy root's first child");
        }
    }
}

