/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.NoOpEncoder;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.IoException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.AbstractValueFactory;
import org.modeshape.graph.property.basic.StringValueFactory;

public class AbstractValueFactoryTest {
    public static final TextDecoder CUSTOM_DECODER = new NoOpEncoder();
    private AbstractValueFactory<String> factory;

    @Before
    public void beforeEach() {
        this.factory = new MockFactory(null, null);
    }

    @Test
    public void shouldHaveDefaultEncoderIfNullPassedIntoConstructor() {
        Assert.assertThat((Object)this.factory.getDecoder(), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.factory.getDecoder(), Is.is(IsSame.sameInstance(ValueFactory.DEFAULT_DECODER)));
    }

    @Test
    public void shouldReturnTextEncoderPassedIntoConstructor() {
        this.factory = new MockFactory(CUSTOM_DECODER, null);
        Assert.assertThat((Object)this.factory.getDecoder(), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.factory.getDecoder(), Is.is(IsSame.sameInstance(CUSTOM_DECODER)));
    }

    @Test
    public void shouldReturnDefaultTextEncoderWhenNullPassedToGetEncoder() {
        Assert.assertThat((Object)this.factory.getDecoder(), Is.is(IsSame.sameInstance(ValueFactory.DEFAULT_DECODER)));
        Assert.assertThat((Object)this.factory.getDecoder(null), Is.is(IsSame.sameInstance(ValueFactory.DEFAULT_DECODER)));
        Assert.assertThat((Object)this.factory.getDecoder(CUSTOM_DECODER), Is.is(IsSame.sameInstance(CUSTOM_DECODER)));
    }

    @Test
    public void shouldReturnSuppliedTextEncoderWhenNonNullPassedToGetEncoder() {
        Assert.assertThat((Object)this.factory.getDecoder(), Is.is(IsSame.sameInstance(ValueFactory.DEFAULT_DECODER)));
        Assert.assertThat((Object)this.factory.getDecoder(null), Is.is(IsSame.sameInstance(ValueFactory.DEFAULT_DECODER)));
        Assert.assertThat((Object)this.factory.getDecoder(CUSTOM_DECODER), Is.is(IsSame.sameInstance(CUSTOM_DECODER)));
    }

    @Test
    public void shouldHaveNullStringValueFactoryIfNullPassedIntoConstructor() {
        Assert.assertThat((Object)this.factory.getStringValueFactory(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldHaveExpectedPropertyType() {
        Assert.assertThat((Object)this.factory.getPropertyType(), Is.is(IsSame.sameInstance(PropertyType.STRING)));
    }

    private static class MockFactory
    extends AbstractValueFactory<String> {
        protected MockFactory(TextDecoder decoder, StringValueFactory stringValueFactory) {
            super(PropertyType.STRING, decoder, (ValueFactory)stringValueFactory);
        }

        public String create(String value) {
            return null;
        }

        public String create(String value, TextDecoder decoder) {
            return null;
        }

        public String create(int value) {
            return null;
        }

        public String create(long value) {
            return null;
        }

        public String create(boolean value) {
            return null;
        }

        public String create(float value) {
            return null;
        }

        public String create(double value) {
            return null;
        }

        public String create(BigDecimal value) {
            return null;
        }

        public String create(Calendar value) {
            return null;
        }

        public String create(Date value) {
            return null;
        }

        public String create(DateTime value) throws ValueFormatException {
            return null;
        }

        public String create(Name value) {
            return null;
        }

        public String create(Path value) {
            return null;
        }

        public String create(Path.Segment value) {
            return null;
        }

        public String create(Reference value) {
            return null;
        }

        public String create(URI value) {
            return null;
        }

        public String create(UUID value) {
            return null;
        }

        public String create(byte[] value) {
            return null;
        }

        public String create(Binary value) throws ValueFormatException, IoException {
            return null;
        }

        public String create(InputStream stream, long approximateLength) {
            return null;
        }

        public String create(Reader reader, long approximateLength) {
            return null;
        }

        protected String[] createEmptyArray(int length) {
            return new String[length];
        }
    }
}

