/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.UUID;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;
import org.modeshape.graph.property.basic.StringValueFactory;
import org.modeshape.graph.property.basic.UuidReference;
import org.modeshape.graph.property.basic.UuidValueFactory;

public class UuidValueFactoryTest {
    private UuidValueFactory factory;
    private StringValueFactory stringFactory;
    private UUID uuid;

    @Before
    public void setUp() throws Exception {
        this.stringFactory = new StringValueFactory((NamespaceRegistry)new SimpleNamespaceRegistry(), Path.URL_DECODER, Path.URL_ENCODER);
        this.factory = new UuidValueFactory(Path.URL_DECODER, (ValueFactory)this.stringFactory);
        this.uuid = UUID.randomUUID();
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateDoubleFromBooleanValue() {
        this.factory.create(true);
    }

    @Test
    public void shouldReturnUuidWhenCreatingFromUuid() {
        Assert.assertThat((Object)this.factory.create(this.uuid), Is.is(IsSame.sameInstance(this.uuid)));
    }

    @Test
    public void shouldCreateUuidWithNoArguments() {
        Assert.assertThat((Object)this.factory.create(), Is.is(IsInstanceOf.instanceOf(UUID.class)));
    }

    @Test
    public void shouldCreateUuidFromString() {
        Assert.assertThat((Object)this.factory.create(this.uuid.toString()), Is.is(this.uuid));
    }

    @Test
    public void shouldCreateUuidFromStringRegardlessOfLeadingAndTrailingWhitespace() {
        Assert.assertThat((Object)this.factory.create("  " + this.uuid.toString() + "  "), Is.is(this.uuid));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateUuidFromIntegerValue() {
        this.factory.create(1);
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateUuidFromLongValue() {
        this.factory.create(1L);
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateUuidFromDoubleValue() {
        this.factory.create(1.0);
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateUuidFromFloatValue() {
        this.factory.create(1.0f);
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateUuidFromBooleanValue() {
        this.factory.create(true);
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateUuidFromCalendarValue() {
        this.factory.create(Calendar.getInstance());
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateUuidFromName() {
        this.factory.create((Name)Mockito.mock(Name.class));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateUuidFromPath() {
        this.factory.create((Path)Mockito.mock(Path.class));
    }

    @Test
    public void shouldCreateUuidFromReference() {
        UuidReference ref = new UuidReference(this.uuid);
        Assert.assertThat((Object)this.factory.create((Reference)ref), Is.is(this.uuid));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateUuidFromUri() throws Exception {
        this.factory.create(new URI("http://www.jboss.org"));
    }

    @Test
    public void shouldCreateUuidFromByteArrayContainingUtf8EncodingOfStringWithUuid() throws Exception {
        Assert.assertThat((Object)this.factory.create(this.uuid.toString().getBytes("UTF-8")), Is.is(this.uuid));
    }

    @Test
    public void shouldCreateUuidFromInputStreamContainingUtf8EncodingOfStringWithUuid() throws Exception {
        Assert.assertThat((Object)this.factory.create((Object)new ByteArrayInputStream(this.uuid.toString().getBytes("UTF-8"))), Is.is(this.uuid));
    }

    @Test
    public void shouldCreateUuidFromReaderContainingStringWithUuid() {
        Assert.assertThat((Object)this.factory.create((Object)new StringReader(this.uuid.toString())), Is.is(this.uuid));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateUuidFromByteArrayContainingUtf8EncodingOfStringWithContentsOtherThanUuid() throws Exception {
        this.factory.create("something".getBytes("UTF-8"));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateUuuidFromInputStreamContainingUtf8EncodingOfStringWithContentsOtherThanUuuid() throws Exception {
        this.factory.create((Object)new ByteArrayInputStream("something".getBytes("UTF-8")));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotCreateUuuidFromReaderContainingStringWithContentsOtherThanUuuid() throws Exception {
        this.factory.create((Object)new ByteArrayInputStream("something".getBytes("UTF-8")));
    }

    @Test
    public void shouldCreateIteratorOverValuesWhenSuppliedIteratorOfUnknownObjects() {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i != 10; ++i) {
            values.add(" " + UUID.randomUUID());
        }
        Iterator iter = this.factory.create(values.iterator());
        Iterator valueIter = values.iterator();
        while (iter.hasNext()) {
            Assert.assertThat(iter.next(), Is.is(this.factory.create((String)valueIter.next())));
        }
    }
}

