/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.optimize;

import java.util.LinkedList;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.query.AbstractQueryTest;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.JoinType;
import org.modeshape.graph.query.optimize.RightOuterToLeftOuterJoins;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.validate.Schemata;

public class RightOuterToLeftOuterJoinsTest
extends AbstractQueryTest {
    private RightOuterToLeftOuterJoins rule;
    private QueryContext context;

    @Before
    public void beforeEach() {
        this.context = new QueryContext((Schemata)Mockito.mock(Schemata.class), new ExecutionContext().getValueFactories().getTypeSystem());
        this.rule = RightOuterToLeftOuterJoins.INSTANCE;
    }

    @Test
    public void shouldDoNothingWithLeftOuterJoin() {
        PlanNode joinNode = new PlanNode(PlanNode.Type.JOIN);
        joinNode.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.LEFT_OUTER);
        PlanNode lhs = new PlanNode(PlanNode.Type.SOURCE, joinNode);
        PlanNode rhs = new PlanNode(PlanNode.Type.SOURCE, joinNode);
        PlanNode result = this.rule.execute(this.context, joinNode, new LinkedList());
        Assert.assertThat((Object)result, Is.is(IsSame.sameInstance(joinNode)));
        Assert.assertThat((Object)joinNode.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class), Is.is(JoinType.LEFT_OUTER));
        Assert.assertThat((Object)joinNode.getFirstChild(), Is.is(IsSame.sameInstance(lhs)));
        Assert.assertThat((Object)joinNode.getLastChild(), Is.is(IsSame.sameInstance(rhs)));
        Assert.assertThat((Object)joinNode.getChildCount(), Is.is(2));
    }

    @Test
    public void shouldDoNothingWithCrossJoin() {
        PlanNode joinNode = new PlanNode(PlanNode.Type.JOIN);
        joinNode.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.CROSS);
        PlanNode lhs = new PlanNode(PlanNode.Type.SOURCE, joinNode);
        PlanNode rhs = new PlanNode(PlanNode.Type.SOURCE, joinNode);
        PlanNode result = this.rule.execute(this.context, joinNode, new LinkedList());
        Assert.assertThat((Object)result, Is.is(IsSame.sameInstance(joinNode)));
        Assert.assertThat((Object)joinNode.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class), Is.is(JoinType.CROSS));
        Assert.assertThat((Object)joinNode.getFirstChild(), Is.is(IsSame.sameInstance(lhs)));
        Assert.assertThat((Object)joinNode.getLastChild(), Is.is(IsSame.sameInstance(rhs)));
        Assert.assertThat((Object)joinNode.getChildCount(), Is.is(2));
    }

    @Test
    public void shouldDoNothingWithFullOuterJoin() {
        PlanNode joinNode = new PlanNode(PlanNode.Type.JOIN);
        joinNode.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.FULL_OUTER);
        PlanNode lhs = new PlanNode(PlanNode.Type.SOURCE, joinNode);
        PlanNode rhs = new PlanNode(PlanNode.Type.SOURCE, joinNode);
        PlanNode result = this.rule.execute(this.context, joinNode, new LinkedList());
        Assert.assertThat((Object)result, Is.is(IsSame.sameInstance(joinNode)));
        Assert.assertThat((Object)joinNode.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class), Is.is(JoinType.FULL_OUTER));
        Assert.assertThat((Object)joinNode.getFirstChild(), Is.is(IsSame.sameInstance(lhs)));
        Assert.assertThat((Object)joinNode.getLastChild(), Is.is(IsSame.sameInstance(rhs)));
        Assert.assertThat((Object)joinNode.getChildCount(), Is.is(2));
    }

    @Test
    public void shouldDoNothingWithInnerJoin() {
        PlanNode joinNode = new PlanNode(PlanNode.Type.JOIN);
        joinNode.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.INNER);
        PlanNode lhs = new PlanNode(PlanNode.Type.SOURCE, joinNode);
        PlanNode rhs = new PlanNode(PlanNode.Type.SOURCE, joinNode);
        PlanNode result = this.rule.execute(this.context, joinNode, new LinkedList());
        Assert.assertThat((Object)result, Is.is(IsSame.sameInstance(joinNode)));
        Assert.assertThat((Object)joinNode.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class), Is.is(JoinType.INNER));
        Assert.assertThat((Object)joinNode.getFirstChild(), Is.is(IsSame.sameInstance(lhs)));
        Assert.assertThat((Object)joinNode.getLastChild(), Is.is(IsSame.sameInstance(rhs)));
        Assert.assertThat((Object)joinNode.getChildCount(), Is.is(2));
    }

    @Test
    public void shouldChangeRightOuterJoinToLeftOuterJoinAndReverseChildNodes() {
        PlanNode joinNode = new PlanNode(PlanNode.Type.JOIN);
        joinNode.setProperty(PlanNode.Property.JOIN_TYPE, (Object)JoinType.RIGHT_OUTER);
        PlanNode lhs = new PlanNode(PlanNode.Type.SOURCE, joinNode);
        PlanNode rhs = new PlanNode(PlanNode.Type.SOURCE, joinNode);
        PlanNode result = this.rule.execute(this.context, joinNode, new LinkedList());
        Assert.assertThat((Object)result, Is.is(IsSame.sameInstance(joinNode)));
        Assert.assertThat((Object)joinNode.getProperty(PlanNode.Property.JOIN_TYPE, JoinType.class), Is.is(JoinType.LEFT_OUTER));
        Assert.assertThat((Object)joinNode.getFirstChild(), Is.is(IsSame.sameInstance(rhs)));
        Assert.assertThat((Object)joinNode.getLastChild(), Is.is(IsSame.sameInstance(lhs)));
        Assert.assertThat((Object)joinNode.getChildCount(), Is.is(2));
    }
}

