/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.plan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.plan.PlanNode;

public class PlanNodeTest {
    private PlanNode node;
    private PlanNode parent;

    @Before
    public void beforeEach() {
        this.node = new PlanNode(PlanNode.Type.GROUP);
    }

    @After
    public void afterEach() {
        this.node = null;
        this.parent = null;
    }

    @Test
    public void shouldFindTypeGivenSymbolWithSameCase() {
        for (PlanNode.Type type : PlanNode.Type.values()) {
            Assert.assertThat((Object)PlanNode.Type.forSymbol((String)type.getSymbol()), Is.is(IsSame.sameInstance(type)));
        }
    }

    @Test
    public void shouldFindTypeGivenSymbolWithLowerCase() {
        for (PlanNode.Type type : PlanNode.Type.values()) {
            Assert.assertThat((Object)PlanNode.Type.forSymbol((String)type.getSymbol().toLowerCase()), Is.is(IsSame.sameInstance(type)));
        }
    }

    @Test
    public void shouldFindTypeGivenSymbolWithUpperCase() {
        for (PlanNode.Type type : PlanNode.Type.values()) {
            Assert.assertThat((Object)PlanNode.Type.forSymbol((String)type.getSymbol().toUpperCase()), Is.is(IsSame.sameInstance(type)));
        }
    }

    @Test
    public void shouldFindTypeGivenSymbolWithLeadingAndTrailingWhitespace() {
        for (PlanNode.Type type : PlanNode.Type.values()) {
            Assert.assertThat((Object)PlanNode.Type.forSymbol((String)(" \t " + type.getSymbol() + " \t \n")), Is.is(IsSame.sameInstance(type)));
        }
    }

    @Test
    public void shouldCreatePlanNodeWithTypeAndNoParent() {
        for (PlanNode.Type type : PlanNode.Type.values()) {
            this.node = new PlanNode(type);
            Assert.assertThat((Object)this.node.getType(), Is.is(type));
            Assert.assertThat((Object)this.node.getParent(), Is.is(IsNull.nullValue()));
        }
    }

    @Test
    public void shouldCreatePlanNodeWithTypeAndParent() {
        for (PlanNode.Type type : PlanNode.Type.values()) {
            this.parent = new PlanNode(PlanNode.Type.JOIN);
            this.node = new PlanNode(type, this.parent);
            Assert.assertThat((Object)this.node.getType(), Is.is(type));
            Assert.assertThat((Object)this.node.getParent(), Is.is(IsSame.sameInstance(this.parent)));
            Assert.assertThat((Object)this.parent.getFirstChild(), Is.is(IsSame.sameInstance(this.node)));
            Assert.assertThat((Object)this.parent.getChildCount(), Is.is(1));
        }
    }

    @Test
    public void shouldAddNodeToParentWhenConstructingChildNodeWithTypeAndParent() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        int counter = 0;
        for (PlanNode.Type type : PlanNode.Type.values()) {
            this.node = new PlanNode(type, this.parent);
            Assert.assertThat((Object)this.node.getType(), Is.is(type));
            Assert.assertThat((Object)this.node.getParent(), Is.is(IsSame.sameInstance(this.parent)));
            Assert.assertThat((Object)this.parent.getLastChild(), Is.is(IsSame.sameInstance(this.node)));
            Assert.assertThat((Object)this.parent.getChildCount(), Is.is(++counter));
        }
    }

    @Test
    public void shouldSetType() {
        this.node = new PlanNode(PlanNode.Type.JOIN);
        for (PlanNode.Type type : PlanNode.Type.values()) {
            this.node.setType(type);
            Assert.assertThat((Object)this.node.getType(), Is.is(type));
        }
    }

    @Test
    public void shouldGetFirstChildAndLastChildWithOneChild() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        this.node = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        Assert.assertThat((Object)this.parent.getFirstChild(), Is.is(IsSame.sameInstance(this.node)));
        Assert.assertThat((Object)this.parent.getLastChild(), Is.is(IsSame.sameInstance(this.node)));
    }

    @Test
    public void shouldGetFirstChildAndLastChildWithTwoChildren() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        PlanNode child2 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        Assert.assertThat((Object)this.parent.getFirstChild(), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getLastChild(), Is.is(IsSame.sameInstance(child2)));
    }

    @Test
    public void shouldGetFirstChildAndLastChildWithMoreThanTwoChildren() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        new PlanNode(PlanNode.Type.ACCESS, this.parent);
        PlanNode child3 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        Assert.assertThat((Object)this.parent.getFirstChild(), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getLastChild(), Is.is(IsSame.sameInstance(child3)));
    }

    @Test
    public void shouldGetFirstChildAndLastChildWithNoChildren() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        Assert.assertThat((Object)this.parent.getFirstChild(), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.parent.getLastChild(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldRemoveNodeFromExistingParentWhenSettingParentToNull() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        this.node = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        Assert.assertThat((Object)this.parent.getFirstChild(), Is.is(IsSame.sameInstance(this.node)));
        Assert.assertThat((Object)this.parent.getChildCount(), Is.is(1));
        this.node.setParent(null);
        Assert.assertThat((Object)this.parent.getChildCount(), Is.is(0));
        Assert.assertThat((Object)this.node.getParent(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldInsertNewParentNodeInBetweenExistingParentAndChild() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        PlanNode child2 = new PlanNode(PlanNode.Type.DUP_REMOVE, this.parent);
        PlanNode child3 = new PlanNode(PlanNode.Type.GROUP, this.parent);
        Assert.assertThat((Object)this.parent.getFirstChild(), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat((Object)this.parent.getLastChild(), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)this.parent.getChildCount(), Is.is(3));
        this.node = new PlanNode(PlanNode.Type.GROUP);
        child2.insertAsParent(this.node);
        Assert.assertThat((Object)this.parent.getChildCount(), Is.is(3));
        Assert.assertThat((Object)this.parent.getFirstChild(), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(this.node)));
        Assert.assertThat((Object)this.parent.getLastChild(), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)this.node.getParent(), Is.is(IsSame.sameInstance(this.parent)));
        Assert.assertThat((Object)child2.getParent(), Is.is(IsSame.sameInstance(this.node)));
    }

    @Test
    public void shouldInsertNewParentNodeInAboveNodeWithoutParent() {
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS);
        this.node = new PlanNode(PlanNode.Type.GROUP);
        PlanNode nodeChild = new PlanNode(PlanNode.Type.JOIN, this.node);
        child1.insertAsParent(this.node);
        Assert.assertThat((Object)this.node.getParent(), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.node.getChildCount(), Is.is(2));
        Assert.assertThat((Object)this.node.getFirstChild(), Is.is(IsSame.sameInstance(nodeChild)));
        Assert.assertThat((Object)this.node.getLastChild(), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)child1.getParent(), Is.is(IsSame.sameInstance(this.node)));
    }

    @Test
    public void shouldRemoveFromParentWhenThereIsAParent() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        PlanNode child2 = new PlanNode(PlanNode.Type.DUP_REMOVE, this.parent);
        PlanNode child3 = new PlanNode(PlanNode.Type.GROUP, this.parent);
        PlanNode grandChild21 = new PlanNode(PlanNode.Type.LIMIT, child2);
        Assert.assertThat((Object)this.parent.getFirstChild(), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat((Object)this.parent.getLastChild(), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)this.parent.getChildCount(), Is.is(3));
        Assert.assertThat((Object)child2.getFirstChild(), Is.is(IsSame.sameInstance(grandChild21)));
        Assert.assertThat((Object)child2.removeFromParent(), Is.is(IsSame.sameInstance(this.parent)));
        Assert.assertThat((Object)this.parent.getFirstChild(), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getLastChild(), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)this.parent.getChildCount(), Is.is(2));
        Assert.assertThat((Object)child2.getFirstChild(), Is.is(IsSame.sameInstance(grandChild21)));
    }

    @Test
    public void shouldRemoveFromParentWhenThereIsNoParent() {
        this.node = new PlanNode(PlanNode.Type.JOIN);
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS, this.node);
        Assert.assertThat((Object)this.node.getFirstChild(), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.node.getChildCount(), Is.is(1));
        Assert.assertThat((Object)this.node.removeFromParent(), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.node.getFirstChild(), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.node.getChildCount(), Is.is(1));
    }

    @Test
    public void shouldReturnListOfChildren() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        PlanNode child2 = new PlanNode(PlanNode.Type.DUP_REMOVE, this.parent);
        PlanNode child3 = new PlanNode(PlanNode.Type.GROUP, this.parent);
        List children = this.parent.getChildren();
        Assert.assertThat(children.get(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat(children.get(1), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat(children.get(2), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)children.size(), Is.is(3));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldReturnImmutableListOfChildren() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        new PlanNode(PlanNode.Type.ACCESS, this.parent);
        new PlanNode(PlanNode.Type.DUP_REMOVE, this.parent);
        new PlanNode(PlanNode.Type.GROUP, this.parent);
        this.parent.getChildren().clear();
    }

    @Test
    public void shouldReturnIteratorOfChildren() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        PlanNode child2 = new PlanNode(PlanNode.Type.DUP_REMOVE, this.parent);
        PlanNode child3 = new PlanNode(PlanNode.Type.GROUP, this.parent);
        Iterator children = this.parent.iterator();
        Assert.assertThat(children.next(), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat(children.next(), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat(children.next(), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)children.hasNext(), Is.is(false));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldReturnImmutableIteratorOfChildren() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        new PlanNode(PlanNode.Type.ACCESS, this.parent);
        new PlanNode(PlanNode.Type.DUP_REMOVE, this.parent);
        new PlanNode(PlanNode.Type.GROUP, this.parent);
        Iterator iter = this.parent.iterator();
        iter.next();
        iter.remove();
    }

    @Test
    public void shouldRemoveAllChildrenOfParentWithNoChildrenByReturningEmptyList() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        List children = this.parent.removeAllChildren();
        Assert.assertThat((Object)children.size(), Is.is(0));
        Assert.assertThat((Object)this.parent.getChildCount(), Is.is(0));
        PlanNode child1a = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        Assert.assertThat((Object)this.parent.getFirstChild(), Is.is(IsSame.sameInstance(child1a)));
        Assert.assertThat((Object)children.size(), Is.is(0));
    }

    @Test
    public void shouldRemoveAllChildrenAndReturnCopyOfListOfChildren() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        PlanNode child2 = new PlanNode(PlanNode.Type.DUP_REMOVE, this.parent);
        PlanNode child3 = new PlanNode(PlanNode.Type.GROUP, this.parent);
        List children = this.parent.removeAllChildren();
        Assert.assertThat(children.get(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat(children.get(1), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat(children.get(2), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)children.size(), Is.is(3));
        Assert.assertThat((Object)this.parent.getChildCount(), Is.is(0));
        PlanNode child1a = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        Assert.assertThat((Object)this.parent.getFirstChild(), Is.is(IsSame.sameInstance(child1a)));
        Assert.assertThat(children.get(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat(children.get(1), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat(children.get(2), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)children.size(), Is.is(3));
    }

    @Test
    public void shouldReturnCorrectChildCount() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        Assert.assertThat((Object)this.parent.getChildCount(), Is.is(0));
        for (int i = 0; i != 10; ++i) {
            new PlanNode(PlanNode.Type.ACCESS, this.parent);
            Assert.assertThat((Object)this.parent.getChildCount(), Is.is(i + 1));
        }
    }

    @Test
    public void shouldAddChildrenAtEnd() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        ArrayList<PlanNode> children = new ArrayList<PlanNode>();
        children.add(new PlanNode(PlanNode.Type.ACCESS, this.parent));
        children.add(new PlanNode(PlanNode.Type.GROUP, this.parent));
        children.add(new PlanNode(PlanNode.Type.NULL, this.parent));
        this.parent.addChildren(children);
        int index = 0;
        for (PlanNode child : children) {
            Assert.assertThat((Object)this.parent.getChild(index++), Is.is(IsSame.sameInstance(child)));
        }
    }

    @Test
    public void shouldRemoveChild() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        PlanNode child2 = new PlanNode(PlanNode.Type.DUP_REMOVE, this.parent);
        PlanNode child3 = new PlanNode(PlanNode.Type.GROUP, this.parent);
        Assert.assertThat((Object)this.parent.getChild(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat((Object)this.parent.getChild(2), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)this.parent.removeChild(child2), Is.is(true));
        Assert.assertThat((Object)this.parent.getChild(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(child3)));
    }

    @Test
    public void shouldNotRemoveChildIfNotReallyAChild() {
        this.node = new PlanNode(PlanNode.Type.PROJECT);
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        PlanNode child2 = new PlanNode(PlanNode.Type.DUP_REMOVE, this.parent);
        PlanNode child3 = new PlanNode(PlanNode.Type.GROUP, this.parent);
        Assert.assertThat((Object)this.parent.getChild(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat((Object)this.parent.getChild(2), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)this.parent.removeChild(this.node), Is.is(false));
        Assert.assertThat((Object)this.parent.getChild(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat((Object)this.parent.getChild(2), Is.is(IsSame.sameInstance(child3)));
    }

    @Test
    public void shouldNotRemoveChildIfReferenceIsNull() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        PlanNode child2 = new PlanNode(PlanNode.Type.DUP_REMOVE, this.parent);
        PlanNode child3 = new PlanNode(PlanNode.Type.GROUP, this.parent);
        Assert.assertThat((Object)this.parent.getChild(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat((Object)this.parent.getChild(2), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)this.parent.removeChild(null), Is.is(false));
        Assert.assertThat((Object)this.parent.getChild(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat((Object)this.parent.getChild(2), Is.is(IsSame.sameInstance(child3)));
    }

    @Test
    public void shouldExtractChildByRemovingIfChildHasNoChildren() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        PlanNode child2 = new PlanNode(PlanNode.Type.DUP_REMOVE, this.parent);
        PlanNode child3 = new PlanNode(PlanNode.Type.GROUP, this.parent);
        Assert.assertThat((Object)this.parent.getChild(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat((Object)this.parent.getChild(2), Is.is(IsSame.sameInstance(child3)));
        this.parent.extractChild(child2);
        Assert.assertThat((Object)this.parent.getChild(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)this.parent.getChildCount(), Is.is(2));
    }

    @Test
    public void shouldExtractChildByReplacingWithFirstGrandchild() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        PlanNode child2 = new PlanNode(PlanNode.Type.DUP_REMOVE, this.parent);
        PlanNode child3 = new PlanNode(PlanNode.Type.GROUP, this.parent);
        PlanNode grandChild1 = new PlanNode(PlanNode.Type.SELECT, child2);
        PlanNode grandChild2 = new PlanNode(PlanNode.Type.SET_OPERATION, child2);
        Assert.assertThat((Object)this.parent.getChild(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat((Object)this.parent.getChild(2), Is.is(IsSame.sameInstance(child3)));
        this.parent.extractChild(child2);
        Assert.assertThat((Object)this.parent.getChild(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(grandChild1)));
        Assert.assertThat((Object)this.parent.getChild(2), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)this.parent.getChildCount(), Is.is(3));
        Assert.assertThat((Object)child2.getFirstChild(), Is.is(IsSame.sameInstance(grandChild2)));
        Assert.assertThat((Object)child2.getParent(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldReplaceChild() {
        PlanNode parentOfReplacement = new PlanNode(PlanNode.Type.SORT);
        PlanNode replacement = new PlanNode(PlanNode.Type.SELECT, parentOfReplacement);
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        PlanNode child2 = new PlanNode(PlanNode.Type.DUP_REMOVE, this.parent);
        PlanNode child3 = new PlanNode(PlanNode.Type.GROUP, this.parent);
        Assert.assertThat((Object)this.parent.getChild(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat((Object)this.parent.getChild(2), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)this.parent.replaceChild(child2, replacement), Is.is(true));
        Assert.assertThat((Object)this.parent.getChild(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(replacement)));
        Assert.assertThat((Object)this.parent.getChild(2), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)replacement.getParent(), Is.is(IsSame.sameInstance(this.parent)));
        Assert.assertThat((Object)child1.getParent(), Is.is(IsSame.sameInstance(this.parent)));
        Assert.assertThat((Object)child2.getParent(), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)child3.getParent(), Is.is(IsSame.sameInstance(this.parent)));
        Assert.assertThat((Object)parentOfReplacement.getChildCount(), Is.is(0));
    }

    @Test
    public void shouldReplaceChildWithAnotherChildToSwapPositions() {
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        PlanNode child2 = new PlanNode(PlanNode.Type.DUP_REMOVE, this.parent);
        PlanNode child3 = new PlanNode(PlanNode.Type.GROUP, this.parent);
        Assert.assertThat((Object)this.parent.getChild(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat((Object)this.parent.getChild(2), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)this.parent.replaceChild(child2, child3), Is.is(true));
        Assert.assertThat((Object)this.parent.getChild(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)this.parent.getChild(2), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat((Object)child1.getParent(), Is.is(IsSame.sameInstance(this.parent)));
        Assert.assertThat((Object)child2.getParent(), Is.is(IsSame.sameInstance(this.parent)));
        Assert.assertThat((Object)child3.getParent(), Is.is(IsSame.sameInstance(this.parent)));
    }

    @Test
    public void shouldNotReplaceChildIfChildNodeIsNotReallyAChild() {
        PlanNode nonChild = new PlanNode(PlanNode.Type.PROJECT);
        PlanNode replacement = new PlanNode(PlanNode.Type.SELECT);
        this.parent = new PlanNode(PlanNode.Type.JOIN);
        PlanNode child1 = new PlanNode(PlanNode.Type.ACCESS, this.parent);
        PlanNode child2 = new PlanNode(PlanNode.Type.DUP_REMOVE, this.parent);
        PlanNode child3 = new PlanNode(PlanNode.Type.GROUP, this.parent);
        Assert.assertThat((Object)this.parent.getChild(0), Is.is(IsSame.sameInstance(child1)));
        Assert.assertThat((Object)this.parent.getChild(1), Is.is(IsSame.sameInstance(child2)));
        Assert.assertThat((Object)this.parent.getChild(2), Is.is(IsSame.sameInstance(child3)));
        Assert.assertThat((Object)this.parent.replaceChild(nonChild, replacement), Is.is(false));
    }

    @Test
    public void shouldGetPathThatIncludesStartAndEndNodes() {
        PlanNode root = new PlanNode(PlanNode.Type.JOIN);
        PlanNode node1 = new PlanNode(PlanNode.Type.ACCESS, root);
        PlanNode node2 = new PlanNode(PlanNode.Type.DUP_REMOVE, node1);
        PlanNode node3 = new PlanNode(PlanNode.Type.GROUP, node2);
        PlanNode node4 = new PlanNode(PlanNode.Type.SELECT, node3);
        PlanNode node5 = new PlanNode(PlanNode.Type.SET_OPERATION, node4);
        Assert.assertThat((Object)root.getPathTo(root), Is.is(this.path(root)));
        Assert.assertThat((Object)root.getPathTo(node1), Is.is(this.path(root, node1)));
        Assert.assertThat((Object)root.getPathTo(node2), Is.is(this.path(root, node1, node2)));
        Assert.assertThat((Object)root.getPathTo(node3), Is.is(this.path(root, node1, node2, node3)));
        Assert.assertThat((Object)root.getPathTo(node4), Is.is(this.path(root, node1, node2, node3, node4)));
        Assert.assertThat((Object)root.getPathTo(node5), Is.is(this.path(root, node1, node2, node3, node4, node5)));
        Assert.assertThat((Object)node1.getPathTo(node1), Is.is(this.path(node1)));
        Assert.assertThat((Object)node1.getPathTo(node2), Is.is(this.path(node1, node2)));
        Assert.assertThat((Object)node1.getPathTo(node3), Is.is(this.path(node1, node2, node3)));
        Assert.assertThat((Object)node1.getPathTo(node4), Is.is(this.path(node1, node2, node3, node4)));
        Assert.assertThat((Object)node1.getPathTo(node5), Is.is(this.path(node1, node2, node3, node4, node5)));
        Assert.assertThat((Object)node2.getPathTo(node2), Is.is(this.path(node2)));
        Assert.assertThat((Object)node2.getPathTo(node3), Is.is(this.path(node2, node3)));
        Assert.assertThat((Object)node2.getPathTo(node4), Is.is(this.path(node2, node3, node4)));
        Assert.assertThat((Object)node2.getPathTo(node5), Is.is(this.path(node2, node3, node4, node5)));
    }

    protected LinkedList<PlanNode> path(PlanNode ... expectedNodes) {
        LinkedList<PlanNode> result = new LinkedList<PlanNode>();
        for (PlanNode node : expectedNodes) {
            result.add(node);
        }
        return result;
    }

    @Test
    public void shouldNotAddNullSelectorNames() {
        List<Object> names = Collections.singletonList(null);
        this.node.addSelectors(names);
        Assert.assertThat((Object)this.node.getSelectors().isEmpty(), Is.is(true));
        this.node.addSelector(null);
        Assert.assertThat((Object)this.node.getSelectors().isEmpty(), Is.is(true));
        SelectorName name = new SelectorName("something");
        this.node.addSelector(name, null);
        Assert.assertThat((Object)this.node.getSelectors().size(), Is.is(1));
        Assert.assertThat((Object)this.node.getSelectors().contains(name), Is.is(true));
    }

    @Test
    public void shouldCorrectlyDetermineIfAncestorHasType() {
        PlanNode root = new PlanNode(PlanNode.Type.JOIN);
        PlanNode node1 = new PlanNode(PlanNode.Type.ACCESS, root);
        PlanNode node2 = new PlanNode(PlanNode.Type.DUP_REMOVE, node1);
        PlanNode node3 = new PlanNode(PlanNode.Type.GROUP, node2);
        PlanNode node4 = new PlanNode(PlanNode.Type.SELECT, node3);
        PlanNode node5 = new PlanNode(PlanNode.Type.SET_OPERATION, node4);
        Assert.assertThat((Object)node5.hasAncestorOfType(PlanNode.Type.SET_OPERATION), Is.is(false));
        Assert.assertThat((Object)node5.hasAncestorOfType(PlanNode.Type.SOURCE), Is.is(false));
        Assert.assertThat((Object)node5.hasAncestorOfType(PlanNode.Type.DUP_REMOVE), Is.is(true));
        Assert.assertThat((Object)node5.hasAncestorOfType(PlanNode.Type.DUP_REMOVE, new PlanNode.Type[]{PlanNode.Type.SELECT}), Is.is(true));
        Assert.assertThat((Object)node5.hasAncestorOfType(PlanNode.Type.DUP_REMOVE, new PlanNode.Type[]{PlanNode.Type.SELECT, PlanNode.Type.SOURCE}), Is.is(true));
    }
}

