/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.process;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.process.AbstractQueryResultsTest;
import org.modeshape.graph.query.process.ProcessingComponent;
import org.modeshape.graph.query.process.SortValuesComponent;
import org.modeshape.graph.query.validate.Schemata;

public class SortValuesComponentTest
extends AbstractQueryResultsTest {
    private SortValuesComponent component;
    private ProcessingComponent delegate;
    private QueryContext context;
    private Schemata schemata;
    private QueryResults.Columns columns;
    private List<Object[]> inputTuples;
    private List<Ordering> orderings;

    @Before
    public void beforeEach() {
        this.columns = this.resultColumns("Selector1", new String[]{"ColA", "ColB", "ColC"}, PropertyType.STRING, PropertyType.LONG, PropertyType.STRING);
        this.schemata = this.schemataFor(this.columns, PropertyType.STRING, PropertyType.LONG, PropertyType.STRING);
        this.context = new QueryContext(this.schemata, this.typeSystem);
        this.inputTuples = new ArrayList<Object[]>();
        this.delegate = new ProcessingComponent(this.context, this.columns){

            public List<Object[]> execute() {
                return new ArrayList<Object[]>(SortValuesComponentTest.this.inputTuples);
            }
        };
        this.orderings = new ArrayList<Ordering>();
        this.component = new SortValuesComponent(this.delegate, this.orderings, null);
    }

    @Test
    public void shouldReturnAllResultsOrderedByNodeName() {
        this.orderings.add(this.orderByNodeName("Selector1"));
        this.component = new SortValuesComponent(this.delegate, this.orderings, null);
        this.inputTuples.add(this.tuple(this.columns, "/a/b1/c1", "v1", 100, "v4"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b2/c4", "v4", 100, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b3/c2", 100, 100, "v2"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b4/c3", "v3", 100, "v1"));
        ArrayList<Object[]> expected = new ArrayList<Object[]>();
        expected.add(this.inputTuples.get(0));
        expected.add(this.inputTuples.get(2));
        expected.add(this.inputTuples.get(3));
        expected.add(this.inputTuples.get(1));
        Assert.assertThat((Object)this.component.execute(), Is.is(expected));
    }

    @Test
    public void shouldReturnAllResultsOrderedByNodeNameWhenThereAreDuplicateTuples() {
        this.orderings.add(this.orderByNodeName("Selector1"));
        this.component = new SortValuesComponent(this.delegate, this.orderings, null);
        this.inputTuples.add(this.tuple(this.columns, "/a/b1/c1", "v1", 100, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b2/c4", "v1", 100, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b3/c2", "v1", 100, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b4/c3", "v1", 100, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b5/c4", "v1", 100, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b6/c3", "v1", 100, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b7/c0", "v1", 100, "v3"));
        ArrayList<Object[]> expected = new ArrayList<Object[]>();
        expected.add(this.inputTuples.get(6));
        expected.add(this.inputTuples.get(0));
        expected.add(this.inputTuples.get(2));
        expected.add(this.inputTuples.get(3));
        expected.add(this.inputTuples.get(5));
        expected.add(this.inputTuples.get(1));
        expected.add(this.inputTuples.get(4));
        Assert.assertThat((Object)this.component.execute(), Is.is(expected));
    }

    @Test
    public void shouldReturnAllResultsOrderedByNodeDepth() {
        this.orderings.add(this.orderByNodeDepth("Selector1"));
        this.component = new SortValuesComponent(this.delegate, this.orderings, null);
        this.inputTuples.add(this.tuple(this.columns, "/a/b1", "v1", 100, "v4"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b2/c4", "v4", 100, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a", 100, 100, "v2"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b4/c3", "v3", 100, "v1"));
        ArrayList<Object[]> expected = new ArrayList<Object[]>();
        expected.add(this.inputTuples.get(2));
        expected.add(this.inputTuples.get(0));
        expected.add(this.inputTuples.get(1));
        expected.add(this.inputTuples.get(3));
        Assert.assertThat((Object)this.component.execute(), Is.is(expected));
    }

    @Test
    public void shouldReturnAllResultsOrderedByNodePath() {
        this.orderings.add(this.orderByNodePath("Selector1"));
        this.component = new SortValuesComponent(this.delegate, this.orderings, null);
        this.inputTuples.add(this.tuple(this.columns, "/a/b1", "v1", 100, "v4"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b1/c4[2]", "v4", 100, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b1/c2", 100, 100, "v2"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b1/c4", "v3", 100, "v1"));
        ArrayList<Object[]> expected = new ArrayList<Object[]>();
        expected.add(this.inputTuples.get(0));
        expected.add(this.inputTuples.get(2));
        expected.add(this.inputTuples.get(3));
        expected.add(this.inputTuples.get(1));
        Assert.assertThat((Object)this.component.execute(), Is.is(expected));
    }

    @Test
    public void shouldReturnAllResultsOrderedByNodeLocalName() {
        this.orderings.add(this.orderByNodeLocalName("Selector1"));
        this.component = new SortValuesComponent(this.delegate, this.orderings, null);
        this.inputTuples.add(this.tuple(this.columns, "/a/b1/c1", "v1", 100, "v4"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b2/c4", "v4", 100, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b3/c2", 100, 100, "v2"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b4/c3", "v3", 100, "v1"));
        ArrayList<Object[]> expected = new ArrayList<Object[]>();
        expected.add(this.inputTuples.get(0));
        expected.add(this.inputTuples.get(2));
        expected.add(this.inputTuples.get(3));
        expected.add(this.inputTuples.get(1));
        Assert.assertThat((Object)this.component.execute(), Is.is(expected));
    }

    @Test
    public void shouldReturnAllResultsOrderedByNodeLocalNameWhenThereAreDuplicateTuples() {
        this.orderings.add(this.orderByNodeName("Selector1"));
        this.component = new SortValuesComponent(this.delegate, this.orderings, null);
        this.inputTuples.add(this.tuple(this.columns, "/a/b1/mode:c1", "v1", 100, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b2/mode:c4", "v1", 100, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b3/mode:c2", "v1", 100, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b4/mode:c3", "v1", 100, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b5/jcr:c4", "v1", 100, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b6/mode:c3", "v1", 100, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b7/mode:c0", "v1", 100, "v3"));
        ArrayList<Object[]> expected = new ArrayList<Object[]>();
        expected.add(this.inputTuples.get(4));
        expected.add(this.inputTuples.get(6));
        expected.add(this.inputTuples.get(0));
        expected.add(this.inputTuples.get(2));
        expected.add(this.inputTuples.get(3));
        expected.add(this.inputTuples.get(5));
        expected.add(this.inputTuples.get(1));
        Assert.assertThat((Object)this.component.execute(), Is.is(expected));
    }

    @Test
    public void shouldReturnAllResultsOrderedByValueLengthOfLong() {
        this.orderings.add(this.orderByPropertyLength((Column)this.columns.getColumns().get(1)));
        this.component = new SortValuesComponent(this.delegate, this.orderings, null);
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c1", "v1", 1L, "v4"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c4", "v1", 1114L, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c2", "v1", 113L, "v2"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c3", "v1", 12L, "v1"));
        ArrayList<Object[]> expected = new ArrayList<Object[]>();
        expected.add(this.inputTuples.get(0));
        expected.add(this.inputTuples.get(3));
        expected.add(this.inputTuples.get(2));
        expected.add(this.inputTuples.get(1));
        Assert.assertThat((Object)this.component.execute(), Is.is(expected));
    }

    @Test
    public void shouldReturnAllResultsOrderedByValueLengthOfString() {
        this.orderings.add(this.orderByPropertyLength((Column)this.columns.getColumns().get(0)));
        this.component = new SortValuesComponent(this.delegate, this.orderings, null);
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c1", "v1", 100L, "v4"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c4", "v1111", 100L, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c2", "v111", 100L, "v2"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c3", "v11", 100L, "v1"));
        ArrayList<Object[]> expected = new ArrayList<Object[]>();
        expected.add(this.inputTuples.get(0));
        expected.add(this.inputTuples.get(3));
        expected.add(this.inputTuples.get(2));
        expected.add(this.inputTuples.get(1));
        Assert.assertThat((Object)this.component.execute(), Is.is(expected));
    }

    @Test
    public void shouldReturnAllResultsInSuppliedOrderWhenThereAreNoOrderings() {
        this.orderings.clear();
        this.component = new SortValuesComponent(this.delegate, this.orderings, null);
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c1", "v1", 100L, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c4", "v1", 100L, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c2", "v1", 100L, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c3", "v1", 100L, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c4", "v1", 100L, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c3", "v1", 100L, "v3"));
        this.inputTuples.add(this.tuple(this.columns, "/a/b/c0", "v1", 100L, "v3"));
        ArrayList<Object[]> expected = new ArrayList<Object[]>(this.inputTuples);
        Assert.assertThat((Object)this.component.execute(), Is.is(expected));
    }

    @Test
    public void shouldReturnEmptyResultsWhenDelegateReturnsEmptyResults() {
        Assert.assertThat((Object)this.component.execute().isEmpty(), Is.is(true));
    }
}

