/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.MockRepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.request.CompositeRequestChannel;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.RequestType;

public class CompositeRequestChannelTest {
    private ExecutionContext context;
    private String sourceName;
    private CompositeRequestChannel channel;
    private List<Request> requests;
    private ExecutorService executor;
    private LinkedList<Request> executedRequests;
    private RepositoryConnection connection;
    @Mock
    private RepositoryConnectionFactory connectionFactory;

    @Before
    public void beforeEach() {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new ExecutionContext();
        this.sourceName = "SourceA";
        this.channel = new CompositeRequestChannel(this.sourceName);
        this.requests = new ArrayList<Request>();
        this.requests.add(new MockRequest());
        this.requests.add(new MockRequest());
        this.requests.add(new MockRequest());
        this.requests.add(new MockRequest());
        this.executedRequests = new LinkedList();
        this.connection = new MockRepositoryConnection(this.sourceName, this.executedRequests);
        Mockito.when((Object)this.connectionFactory.createConnection(this.sourceName)).thenReturn((Object)this.connection);
        this.executor = Executors.newSingleThreadExecutor();
    }

    @Test
    public void shouldCreateEmptyIteratorIfDoneCalledBeforeObtainingIterator() {
        this.channel.close();
        Iterator iter = this.channel.createIterator();
        Assert.assertThat((Object)iter.hasNext(), Is.is(false));
    }

    @Test
    public void shouldCreateEmptyIteratorIfDoneCalledAfterObtainingIterator() {
        Iterator iter = this.channel.createIterator();
        this.channel.close();
        Assert.assertThat((Object)iter.hasNext(), Is.is(false));
    }

    @Test
    public void shouldCreateIteratorOverRequestsAddedToChannelAfterObtainingIterator() {
        Iterator iter = this.channel.createIterator();
        for (Request request : this.requests) {
            this.channel.add(request);
        }
        this.channel.close();
        for (Request expected : this.requests) {
            Assert.assertThat((Object)iter.hasNext(), Is.is(true));
            Assert.assertThat(iter.next(), Is.is(IsSame.sameInstance(expected)));
        }
        Assert.assertThat((Object)iter.hasNext(), Is.is(false));
    }

    @Test
    public void shouldCreateIteratorOverRequestsAddedToChannelAfterBeginningIteration() {
        Iterator iter = this.channel.createIterator();
        new Thread(new AddRequestsRunnable(this.channel, this.requests, 100)).start();
        for (Request expected : this.requests) {
            Assert.assertThat((Object)iter.hasNext(), Is.is(true));
            Assert.assertThat(iter.next(), Is.is(IsSame.sameInstance(expected)));
        }
        Assert.assertThat((Object)iter.hasNext(), Is.is(false));
    }

    @Test
    public void shouldSubmitRequestsToConnection() throws Exception {
        this.channel.start(this.executor, this.context, this.connectionFactory);
        for (Request request : this.requests) {
            this.channel.add(request);
        }
        this.channel.close();
        this.channel.await();
        Iterator iter = this.executedRequests.iterator();
        for (Request expected : this.requests) {
            Assert.assertThat((Object)iter.hasNext(), Is.is(true));
            Assert.assertThat(iter.next(), Is.is(IsSame.sameInstance(expected)));
        }
        Assert.assertThat((Object)iter.hasNext(), Is.is(false));
    }

    @Test
    public void shouldSubmitBlockedRequestsToConnection() throws Exception {
        this.channel.start(this.executor, this.context, this.connectionFactory);
        ArrayList<CountDownLatch> latches = new ArrayList<CountDownLatch>();
        for (Request request : this.requests) {
            CountDownLatch latch = new CountDownLatch(1);
            latches.add(latch);
            this.channel.add(request, latch);
        }
        this.channel.close();
        this.channel.await();
        for (CountDownLatch latch : latches) {
            latch.await();
            Assert.assertThat((Object)latch.getCount(), Is.is(0L));
        }
        Iterator iter = this.executedRequests.iterator();
        for (Request expected : this.requests) {
            Assert.assertThat((Object)iter.hasNext(), Is.is(true));
            Assert.assertThat(iter.next(), Is.is(IsSame.sameInstance(expected)));
        }
        Assert.assertThat((Object)iter.hasNext(), Is.is(false));
    }

    protected static class AddRequestsRunnable
    implements Runnable {
        private final CompositeRequestChannel channel;
        private final Iterator<Request> requests;
        private final int intervalInMillis;

        protected AddRequestsRunnable(CompositeRequestChannel channel, List<Request> requests, int intervalInMillis) {
            this.requests = requests.iterator();
            this.intervalInMillis = intervalInMillis;
            this.channel = channel;
        }

        @Override
        public void run() {
            while (this.requests.hasNext()) {
                try {
                    Thread.sleep(this.intervalInMillis);
                }
                catch (InterruptedException err) {
                    Assert.fail((String)err.getMessage());
                }
                this.channel.add(this.requests.next());
            }
            this.channel.close();
        }
    }

    protected static class MockRequest
    extends Request {
        private static final long serialVersionUID = 1L;

        protected MockRequest() {
        }

        public boolean isReadOnly() {
            return false;
        }

        public RequestType getType() {
            return RequestType.INVALID;
        }
    }
}

