/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.request.AbstractRequestTest;
import org.modeshape.graph.request.DestroyWorkspaceRequest;
import org.modeshape.graph.request.Request;

public class DestroyWorkspaceRequestTest
extends AbstractRequestTest {
    private DestroyWorkspaceRequest request;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
    }

    @Override
    protected Request createRequest() {
        return new DestroyWorkspaceRequest(this.workspace1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullWorkspaceName() {
        new DestroyWorkspaceRequest(null);
    }

    @Test
    public void shouldCreateValidRequestWithValidLocation() {
        this.request = new DestroyWorkspaceRequest(this.workspace1);
        Assert.assertThat((Object)this.request.workspaceName(), Is.is(this.workspace1));
        Assert.assertThat((Object)this.request.hasError(), Is.is(false));
        Assert.assertThat((Object)this.request.getError(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithSameLocations() {
        this.request = new DestroyWorkspaceRequest(this.workspace1);
        DestroyWorkspaceRequest request2 = new DestroyWorkspaceRequest(this.workspace1);
        Assert.assertThat((Object)this.request, Is.is(request2));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentWorkspaceNames() {
        this.request = new DestroyWorkspaceRequest(this.workspace1);
        DestroyWorkspaceRequest request2 = new DestroyWorkspaceRequest(this.workspace2);
        Assert.assertThat((Object)this.request.equals((Object)request2), Is.is(false));
    }
}

