/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.request.AbstractRequestTest;
import org.modeshape.graph.request.RenameNodeRequest;
import org.modeshape.graph.request.Request;

public class RenameNodeRequestTest
extends AbstractRequestTest {
    private RenameNodeRequest request;
    private Name newName;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
        this.newName = this.createName("SomethingElse");
    }

    @Override
    protected Request createRequest() {
        return new RenameNodeRequest(this.validPathLocation1, this.workspace1, this.newName);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullFromLocation() {
        new RenameNodeRequest(null, this.workspace1, this.newName);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullWorkspaceName() {
        new RenameNodeRequest(this.validPathLocation1, null, this.newName);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowCreatingRequestWithNullNewName() {
        new RenameNodeRequest(this.validPathLocation1, this.workspace1, null);
    }

    @Test
    public void shouldCreateValidRequestWithValidFromLocationAndValidToLocation() {
        this.request = new RenameNodeRequest(this.validPathLocation1, this.workspace1, this.newName);
        Assert.assertThat((Object)this.request.at(), Is.is(IsSame.sameInstance(this.validPathLocation1)));
        Assert.assertThat((Object)this.request.inWorkspace(), Is.is(IsSame.sameInstance(this.workspace1)));
        Assert.assertThat((Object)this.request.toName(), Is.is(IsSame.sameInstance(this.newName)));
        Assert.assertThat((Object)this.request.hasError(), Is.is(false));
        Assert.assertThat((Object)this.request.getError(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldConsiderEqualTwoRequestsWithSameLocations() {
        this.request = new RenameNodeRequest(this.validPathLocation1, new String(this.workspace1), this.newName);
        RenameNodeRequest request2 = new RenameNodeRequest(this.validPathLocation1, this.workspace1, this.newName);
        Assert.assertThat((Object)this.request, Is.is(request2));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentLocations() {
        this.request = new RenameNodeRequest(this.validPathLocation1, this.workspace1, this.newName);
        RenameNodeRequest request2 = new RenameNodeRequest(this.validPathLocation2, this.workspace1, this.newName);
        Assert.assertThat((Object)this.request.equals((Object)request2), Is.is(false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithDifferentWorkspaceNames() {
        this.request = new RenameNodeRequest(this.validPathLocation1, this.workspace1, this.newName);
        RenameNodeRequest request2 = new RenameNodeRequest(this.validPathLocation1, this.workspace2, this.newName);
        Assert.assertThat((Object)this.request.equals((Object)request2), Is.is(false));
    }

    @Test
    public void shouldConsiderNotEqualTwoRequestsWithSameLocationsAndDifferentNames() {
        this.request = new RenameNodeRequest(this.validPathLocation1, this.workspace1, this.newName);
        RenameNodeRequest request2 = new RenameNodeRequest(this.validPathLocation1, this.workspace1, this.createName("OtherName"));
        Assert.assertThat((Object)this.request.equals((Object)request2), Is.is(false));
    }
}

