/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.session;

import java.util.Iterator;
import java.util.LinkedList;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.graph.session.InvalidStateException;
import org.modeshape.graph.session.ValidationException;

public class GraphSessionTest {
    private static final Stopwatch LOADING_STOPWATCH = new Stopwatch();
    protected ExecutionContext context;
    protected InMemoryRepositorySource source;
    private Graph store;
    private GraphSession<Object, Object> cache;
    private PathFactory pathFactory;
    protected int numberOfConnections;

    @Before
    public void beforeEach() throws Exception {
        this.context = new ExecutionContext();
        this.pathFactory = this.context.getValueFactories().getPathFactory();
        this.source = new InMemoryRepositorySource();
        this.source.setName("store");
        RepositoryConnectionFactory connectionFactory = new RepositoryConnectionFactory(){

            public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
                if (GraphSessionTest.this.source.getName().equals(sourceName)) {
                    ++GraphSessionTest.this.numberOfConnections;
                    return GraphSessionTest.this.source.getConnection();
                }
                return null;
            }
        };
        RepositoryContext repositoryContext = new RepositoryContext(){

            public ExecutionContext getExecutionContext() {
                return GraphSessionTest.this.context;
            }

            public Observer getObserver() {
                return null;
            }

            public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                return null;
            }

            public Subgraph getConfiguration(int depth) {
                Graph result = Graph.create((RepositorySource)GraphSessionTest.this.source, (ExecutionContext)GraphSessionTest.this.context);
                result.useWorkspace("configSpace");
                return (Subgraph)result.getSubgraphOfDepth(depth).at("/");
            }
        };
        this.source.initialize(repositoryContext);
        this.store = Graph.create((String)this.source.getName(), (RepositoryConnectionFactory)connectionFactory, (ExecutionContext)this.context);
        LOADING_STOPWATCH.start();
        this.store.importXmlFrom(this.getClass().getClassLoader().getResourceAsStream("cars.xml")).into("/");
        LOADING_STOPWATCH.stop();
        this.numberOfConnections = 0;
        GraphSession.Operations nodeOps = null;
        String workspaceName = null;
        this.cache = new GraphSession(this.store, workspaceName, nodeOps);
    }

    @AfterClass
    public static void afterAll() {
        System.out.println(LOADING_STOPWATCH);
    }

    @Test
    public void shouldHaveRootNodeWithCorrectNodeIdAndLocation() {
        GraphSession.Node node = this.cache.getRoot();
        Assert.assertThat((Object)node, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)node.getNodeId(), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)node.getLocation(), Is.is(IsNull.notNullValue()));
        this.assertNoMoreConnectionsUsed();
        this.assertNoChanges();
    }

    @Test
    public void shouldNotHaveAutomaticallyLoadedRootNode() {
        Assert.assertThat((Object)this.cache.getRoot().isLoaded(), Is.is(false));
        this.assertNoMoreConnectionsUsed();
        this.assertNoChanges();
    }

    @Test
    public void shouldHaveRootNodeWithChildren() {
        GraphSession.Node node = this.cache.getRoot();
        this.assertChildren((GraphSession.Node<Object, Object>)node, "Cars");
        this.assertConnectionsUsed(1);
        this.assertNoChanges();
    }

    @Test
    public void shouldHaveNoExpirationIfSourceDoesNotHaveCachePolicy() {
        GraphSession.Node node = this.cache.getRoot();
        node.load();
        Assert.assertThat((Object)node.getExpirationTimeInMillis(), Is.is(Long.MAX_VALUE));
        this.assertConnectionsUsed(1);
        this.assertNoChanges();
    }

    @Test
    public void shouldAutomaticallyLoadNodesWhenNavigatingToChildren() {
        GraphSession.Node root = this.cache.getRoot();
        Assert.assertThat((Object)root.isLoaded(), Is.is(false));
        this.assertChildren((GraphSession.Node<Object, Object>)root, "Cars");
        Assert.assertThat((Object)root.isLoaded(), Is.is(true));
        this.assertConnectionsUsed(1);
        GraphSession.Node cars = (GraphSession.Node)root.getChildren().iterator().next();
        Assert.assertThat((Object)cars.isLoaded(), Is.is(false));
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Sports", "Luxury", "Utility");
        this.assertConnectionsUsed(1);
        Assert.assertThat((Object)cars.isLoaded(), Is.is(true));
        Assert.assertThat((Object)cars.getParent(), Is.is(IsSame.sameInstance(root)));
        GraphSession.Node sports = cars.getChild(this.segment("Sports"));
        Assert.assertThat((Object)sports.isLoaded(), Is.is(false));
        this.assertChildren((GraphSession.Node<Object, Object>)sports, "Aston Martin DB9", "Infiniti G37");
        this.assertConnectionsUsed(1);
        Assert.assertThat((Object)sports.isLoaded(), Is.is(true));
        Assert.assertThat((Object)sports.getParent(), Is.is(IsSame.sameInstance(cars)));
        GraphSession.Node g37 = sports.getChild(this.segment("Infiniti G37"));
        Assert.assertThat((Object)g37.isLoaded(), Is.is(false));
        this.assertChildren((GraphSession.Node<Object, Object>)g37, new String[0]);
        this.assertConnectionsUsed(1);
        Assert.assertThat((Object)g37.isLoaded(), Is.is(true));
        Assert.assertThat((Object)g37.isLeaf(), Is.is(true));
        Assert.assertThat((Object)g37.getParent(), Is.is(IsSame.sameInstance(sports)));
        GraphSession.Node utility = cars.getChild(this.segment("Utility"));
        Assert.assertThat((Object)utility.isLoaded(), Is.is(false));
        this.assertChildren((GraphSession.Node<Object, Object>)utility, "Land Rover LR2", "Land Rover LR3", "Hummer H3", "Ford F-150");
        this.assertConnectionsUsed(1);
        Assert.assertThat((Object)utility.isLoaded(), Is.is(true));
        Assert.assertThat((Object)utility.getParent(), Is.is(IsSame.sameInstance(cars)));
        GraphSession.Node lr3 = utility.getChild(this.segment("Land Rover LR3"));
        Assert.assertThat((Object)lr3.isLoaded(), Is.is(false));
        this.assertChildren((GraphSession.Node<Object, Object>)lr3, new String[0]);
        this.assertConnectionsUsed(1);
        Assert.assertThat((Object)lr3.isLoaded(), Is.is(true));
        Assert.assertThat((Object)lr3.isLeaf(), Is.is(true));
        Assert.assertThat((Object)lr3.getParent(), Is.is(IsSame.sameInstance(utility)));
        this.assertNoMoreConnectionsUsed();
        this.assertNoChanges();
    }

    @Test
    public void shouldFindNodesByPath() {
        GraphSession.Node g37 = this.cache.findNodeWith(this.path("/Cars/Sports/Infiniti G37"));
        this.assertConnectionsUsed(1);
        Assert.assertThat((Object)g37.isLoaded(), Is.is(true));
        this.assertChildren((GraphSession.Node<Object, Object>)g37, new String[0]);
        Assert.assertThat((Object)g37.isLoaded(), Is.is(true));
        Assert.assertThat((Object)g37.isLeaf(), Is.is(true));
        GraphSession.Node sports = g37.getParent();
        Assert.assertThat((Object)sports.isLoaded(), Is.is(true));
        this.assertChildren((GraphSession.Node<Object, Object>)sports, "Aston Martin DB9", "Infiniti G37");
        GraphSession.Node cars = sports.getParent();
        Assert.assertThat((Object)cars.isLoaded(), Is.is(true));
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Sports", "Luxury", "Utility");
        GraphSession.Node root = cars.getParent();
        Assert.assertThat((Object)root, Is.is(IsSame.sameInstance(this.cache.getRoot())));
        Assert.assertThat((Object)root.isLoaded(), Is.is(true));
        this.assertChildren((GraphSession.Node<Object, Object>)root, "Cars");
        this.assertNoMoreConnectionsUsed();
        GraphSession.Node utility = cars.getChild(this.segment("Utility"));
        Assert.assertThat((Object)utility.isLoaded(), Is.is(false));
        this.assertChildren((GraphSession.Node<Object, Object>)utility, "Land Rover LR2", "Land Rover LR3", "Hummer H3", "Ford F-150");
        this.assertConnectionsUsed(1);
        Assert.assertThat((Object)utility.isLoaded(), Is.is(true));
        Assert.assertThat((Object)utility.getParent(), Is.is(IsSame.sameInstance(cars)));
        this.assertNoMoreConnectionsUsed();
        this.assertNoChanges();
    }

    @Test
    public void shouldFindNodesById() {
        this.cache.findNodeWith(this.path("/Cars/Sports/Infiniti G37"));
        this.assertConnectionsUsed(1);
        this.cache.getRoot().onCachedNodes((GraphSession.NodeVisitor)new GraphSession.NodeVisitor<Object, Object>(){

            public boolean visit(GraphSession.Node<Object, Object> node) {
                Assert.assertThat((Object)GraphSessionTest.this.cache.findNodeWith(node.getNodeId(), null), Is.is(IsSame.sameInstance(node)));
                return true;
            }
        });
    }

    @Test
    public void shouldFindNodesByLocation() {
        this.cache.findNodeWith(this.path("/Cars/Sports/Infiniti G37"));
        this.assertConnectionsUsed(1);
        this.cache.getRoot().onCachedNodes((GraphSession.NodeVisitor)new GraphSession.NodeVisitor<Object, Object>(){

            public boolean visit(GraphSession.Node<Object, Object> node) {
                Assert.assertThat((Object)GraphSessionTest.this.cache.findNodeWith(null, node.getLocation().getPath()), Is.is(IsSame.sameInstance(node)));
                return true;
            }
        });
    }

    @Test
    public void shouldFindNodesByIdAfterClearing() {
        GraphSession.Node g37 = this.cache.findNodeWith(this.path("/Cars/Sports/Infiniti G37"));
        this.assertConnectionsUsed(1);
        Assert.assertThat((Object)g37.isLoaded(), Is.is(true));
        this.assertChildren((GraphSession.Node<Object, Object>)g37, new String[0]);
        Assert.assertThat((Object)g37.isLoaded(), Is.is(true));
        Assert.assertThat((Object)g37.isLeaf(), Is.is(true));
        GraphSession.Node sports = g37.getParent();
        GraphSession.Node cars = sports.getParent();
        GraphSession.Node root = cars.getParent();
        this.assertNoMoreConnectionsUsed();
        this.cache.getRoot().unload();
        GraphSession.Node g37_b = this.cache.findNodeWith(g37.getNodeId(), g37.getPath());
        this.assertConnectionsUsed(1);
        GraphSession.Node sports_b = g37_b.getParent();
        GraphSession.Node cars_b = sports_b.getParent();
        GraphSession.Node root_b = cars_b.getParent();
        Assert.assertThat((Object)g37_b, Is.is(IsNot.not(IsSame.sameInstance(g37))));
        Assert.assertThat((Object)sports_b, Is.is(IsNot.not(IsSame.sameInstance(sports))));
        Assert.assertThat((Object)cars_b, Is.is(IsNot.not(IsSame.sameInstance(cars))));
        Assert.assertThat((Object)root_b, Is.is(IsSame.sameInstance(root)));
        Assert.assertThat((Object)g37_b.isLeaf(), Is.is(true));
        this.assertChildren((GraphSession.Node<Object, Object>)sports_b, "Aston Martin DB9", "Infiniti G37");
        this.assertChildren((GraphSession.Node<Object, Object>)cars_b, "Hybrid", "Sports", "Luxury", "Utility");
        this.assertChildren((GraphSession.Node<Object, Object>)root_b, "Cars");
        this.assertNoMoreConnectionsUsed();
        this.assertNoChanges();
    }

    @Test
    public void shouldMoveBranchAndRefresh() {
        GraphSession.Node sports = this.cache.findNodeWith(this.path("/Cars/Sports"));
        GraphSession.Node utility = this.cache.findNodeWith(this.path("/Cars/Utility"));
        this.assertConnectionsUsed(1);
        sports.moveTo(utility);
        this.assertConnectionsUsed(1);
        this.assertNoMoreConnectionsUsed();
        GraphSession.Node cars = this.cache.findNodeWith(this.path("/Cars"));
        for (int i = 0; i != 3; ++i) {
            this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Luxury", "Utility");
            this.assertChildren((GraphSession.Node<Object, Object>)utility, "Land Rover LR2", "Land Rover LR3", "Hummer H3", "Ford F-150", "Sports");
            Assert.assertThat((Object)sports.getParent(), Is.is(utility));
            Assert.assertThat((Object)utility.getParent(), Is.is(cars));
            Assert.assertThat((Object)cars.isChanged(false), Is.is(true));
            Assert.assertThat((Object)utility.isChanged(false), Is.is(true));
            Assert.assertThat((Object)sports.isChanged(false), Is.is(true));
            Assert.assertThat((Object)this.cache.hasPendingChanges(), Is.is(true));
            Assert.assertThat((Object)this.cache.changeDependencies.size(), Is.is(1));
            Assert.assertThat((Object)((GraphSession.Dependencies)this.cache.changeDependencies.get(sports.getNodeId())).getMovedFrom(), Is.is(cars.getNodeId()));
            Assert.assertThat((Object)this.cache.operations.isExecuteRequired(), Is.is(true));
            if (i == 0) {
                try {
                    this.cache.refresh(utility, false);
                    Assert.fail((String)"Expected exception from the call to refresh");
                }
                catch (InvalidStateException e) {}
                continue;
            }
            if (i == 1) {
                this.cache.refresh(cars, true);
                continue;
            }
            if (i != 2) continue;
            this.cache.refresh(cars, false);
        }
        sports = this.cache.findNodeWith(this.path("/Cars/Sports"));
        utility = this.cache.findNodeWith(this.path("/Cars/Utility"));
        cars = this.cache.findNodeWith(this.path("/Cars"));
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Sports", "Luxury", "Utility");
        this.assertChildren((GraphSession.Node<Object, Object>)utility, "Land Rover LR2", "Land Rover LR3", "Hummer H3", "Ford F-150");
        Assert.assertThat((Object)sports.getParent(), Is.is(cars));
        Assert.assertThat((Object)utility.getParent(), Is.is(cars));
        this.assertNoChanges();
        System.out.println(this.cache.root.getSnapshot(false));
    }

    @Test
    public void shouldMoveBranchAndSaveBranch() {
        GraphSession.Node sports = this.cache.findNodeWith(this.path("/Cars/Sports"));
        GraphSession.Node utility = this.cache.findNodeWith(this.path("/Cars/Utility"));
        this.assertConnectionsUsed(1);
        sports.moveTo(utility);
        this.assertConnectionsUsed(1);
        this.assertNoMoreConnectionsUsed();
        GraphSession.Node cars = this.cache.findNodeWith(this.path("/Cars"));
        GraphSession.Node root = this.cache.getRoot();
        for (int i = 0; i != 2; ++i) {
            this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Luxury", "Utility");
            this.assertChildren((GraphSession.Node<Object, Object>)utility, "Land Rover LR2", "Land Rover LR3", "Hummer H3", "Ford F-150", "Sports");
            Assert.assertThat((Object)sports.getParent(), Is.is(utility));
            Assert.assertThat((Object)utility.getParent(), Is.is(cars));
            Assert.assertThat((Object)cars.isChanged(false), Is.is(true));
            Assert.assertThat((Object)utility.isChanged(false), Is.is(true));
            Assert.assertThat((Object)sports.isChanged(false), Is.is(true));
            Assert.assertThat((Object)this.cache.hasPendingChanges(), Is.is(true));
            Assert.assertThat((Object)this.cache.changeDependencies.size(), Is.is(1));
            Assert.assertThat((Object)((GraphSession.Dependencies)this.cache.changeDependencies.get(sports.getNodeId())).getMovedFrom(), Is.is(cars.getNodeId()));
            Assert.assertThat((Object)this.cache.operations.isExecuteRequired(), Is.is(true));
            if (i == 0) {
                try {
                    this.cache.save(utility);
                    Assert.fail((String)"Expected exception from the call to save");
                }
                catch (ValidationException e) {}
                continue;
            }
            if (i != 1) continue;
            this.assertConnectionsUsed(0);
            this.cache.save(cars);
            this.assertConnectionsUsed(2);
        }
        Assert.assertThat((Object)sports.isStale(), Is.is(true));
        Assert.assertThat((Object)utility.isStale(), Is.is(true));
        Assert.assertThat((Object)cars.isStale(), Is.is(false));
        Assert.assertThat((Object)cars.isLoaded(), Is.is(false));
        Assert.assertThat((Object)root.isStale(), Is.is(false));
        sports = this.cache.findNodeWith(this.path("/Cars/Utility/Sports"));
        this.assertConnectionsUsed(1);
        utility = this.cache.findNodeWith(this.path("/Cars/Utility"));
        this.assertNoMoreConnectionsUsed();
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Luxury", "Utility");
        this.assertChildren((GraphSession.Node<Object, Object>)utility, "Land Rover LR2", "Land Rover LR3", "Hummer H3", "Ford F-150", "Sports");
        Assert.assertThat((Object)sports.getParent(), Is.is(utility));
        Assert.assertThat((Object)utility.getParent(), Is.is(cars));
        this.assertNoChanges();
        System.out.println(this.cache.root.getSnapshot(false));
    }

    @Test
    public void shouldMoveBranchAndSaveAll() {
        GraphSession.Node sports = this.cache.findNodeWith(this.path("/Cars/Sports"));
        GraphSession.Node utility = this.cache.findNodeWith(this.path("/Cars/Utility"));
        this.assertConnectionsUsed(1);
        sports.moveTo(utility);
        this.assertConnectionsUsed(1);
        this.assertNoMoreConnectionsUsed();
        GraphSession.Node cars = this.cache.findNodeWith(this.path("/Cars"));
        GraphSession.Node root = this.cache.getRoot();
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Luxury", "Utility");
        this.assertChildren((GraphSession.Node<Object, Object>)utility, "Land Rover LR2", "Land Rover LR3", "Hummer H3", "Ford F-150", "Sports");
        Assert.assertThat((Object)sports.getParent(), Is.is(utility));
        Assert.assertThat((Object)utility.getParent(), Is.is(cars));
        Assert.assertThat((Object)cars.isChanged(false), Is.is(true));
        Assert.assertThat((Object)utility.isChanged(false), Is.is(true));
        Assert.assertThat((Object)sports.isChanged(false), Is.is(true));
        Assert.assertThat((Object)this.cache.hasPendingChanges(), Is.is(true));
        Assert.assertThat((Object)this.cache.changeDependencies.size(), Is.is(1));
        Assert.assertThat((Object)((GraphSession.Dependencies)this.cache.changeDependencies.get(sports.getNodeId())).getMovedFrom(), Is.is(cars.getNodeId()));
        Assert.assertThat((Object)this.cache.operations.isExecuteRequired(), Is.is(true));
        this.assertConnectionsUsed(0);
        this.cache.save();
        this.assertConnectionsUsed(2);
        Assert.assertThat((Object)sports.isStale(), Is.is(true));
        Assert.assertThat((Object)utility.isStale(), Is.is(true));
        Assert.assertThat((Object)cars.isStale(), Is.is(true));
        Assert.assertThat((Object)cars.isLoaded(), Is.is(false));
        Assert.assertThat((Object)root.isStale(), Is.is(false));
        sports = this.cache.findNodeWith(this.path("/Cars/Utility/Sports"));
        this.assertConnectionsUsed(1);
        utility = this.cache.findNodeWith(this.path("/Cars/Utility"));
        cars = this.cache.findNodeWith(this.path("/Cars"));
        this.assertNoMoreConnectionsUsed();
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Luxury", "Utility");
        this.assertChildren((GraphSession.Node<Object, Object>)utility, "Land Rover LR2", "Land Rover LR3", "Hummer H3", "Ford F-150", "Sports");
        Assert.assertThat((Object)sports.getParent(), Is.is(utility));
        Assert.assertThat((Object)utility.getParent(), Is.is(cars));
        this.assertNoChanges();
    }

    @Test
    public void shouldRenameNodeByRemovingAndAddingAtEndOfChildren() {
        GraphSession.Node sports = this.cache.findNodeWith(this.path("/Cars/Sports"));
        this.assertConnectionsUsed(1);
        sports.rename(this.name("non-sports"));
        this.assertNoMoreConnectionsUsed();
        GraphSession.Node cars = this.cache.findNodeWith(this.path("/Cars"));
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Luxury", "Utility", "non-sports");
        Assert.assertThat((Object)sports.getParent(), Is.is(cars));
        Assert.assertThat((Object)cars.isChanged(false), Is.is(true));
        Assert.assertThat((Object)sports.isChanged(false), Is.is(true));
        Assert.assertThat((Object)this.cache.hasPendingChanges(), Is.is(true));
        Assert.assertThat((Object)this.cache.operations.isExecuteRequired(), Is.is(true));
        this.assertConnectionsUsed(0);
        this.cache.save(cars);
        this.assertConnectionsUsed(2);
        GraphSession.Node nonSports = this.cache.findNodeWith(this.path("/Cars/non-sports"));
        this.assertConnectionsUsed(1);
        this.assertNoMoreConnectionsUsed();
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Luxury", "Utility", "non-sports");
        Assert.assertThat((Object)nonSports.getParent(), Is.is(cars));
        this.assertNoChanges();
        System.out.println(this.cache.root.getSnapshot(false));
    }

    @Test
    public void shouldRenameNodeByRemovingAndAddingAtEndOfChildrenEvenWithSameNameSiblings() {
        GraphSession.Node sports = this.cache.findNodeWith(this.path("/Cars/Sports"));
        this.assertConnectionsUsed(1);
        sports.rename(this.name("Utility"));
        this.assertNoMoreConnectionsUsed();
        GraphSession.Node cars = this.cache.findNodeWith(this.path("/Cars"));
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Luxury", "Utility", "Utility[2]");
        Assert.assertThat((Object)sports.getParent(), Is.is(cars));
        Assert.assertThat((Object)cars.isChanged(false), Is.is(true));
        Assert.assertThat((Object)sports.isChanged(false), Is.is(true));
        Assert.assertThat((Object)this.cache.hasPendingChanges(), Is.is(true));
        Assert.assertThat((Object)this.cache.operations.isExecuteRequired(), Is.is(true));
        this.assertConnectionsUsed(0);
        this.cache.save(cars);
        this.assertConnectionsUsed(2);
        GraphSession.Node utility2 = this.cache.findNodeWith(this.path("/Cars/Utility[2]"));
        this.assertConnectionsUsed(1);
        this.assertNoMoreConnectionsUsed();
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Luxury", "Utility", "Utility[2]");
        Assert.assertThat((Object)utility2.getParent(), Is.is(cars));
        this.assertNoChanges();
        System.out.println(this.cache.root.getSnapshot(false));
    }

    @Test
    public void shouldReorderChildWithNoSnsIndexes() {
        GraphSession.Node sports = this.cache.findNodeWith(this.path("/Cars/Sports"));
        GraphSession.Node utility = this.cache.findNodeWith(this.path("/Cars/Utility"));
        GraphSession.Node cars = this.cache.findNodeWith(this.path("/Cars"));
        this.assertConnectionsUsed(1);
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Sports", "Luxury", "Utility");
        cars.orderChildBefore(utility.getSegment(), sports.getSegment());
        this.assertNoMoreConnectionsUsed();
        GraphSession.Node root = this.cache.getRoot();
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Utility", "Sports", "Luxury");
        Assert.assertThat((Object)sports.getParent(), Is.is(cars));
        Assert.assertThat((Object)utility.getParent(), Is.is(cars));
        this.assertConnectionsUsed(0);
        this.cache.save();
        this.assertConnectionsUsed(2);
        Assert.assertThat((Object)sports.isStale(), Is.is(true));
        Assert.assertThat((Object)utility.isStale(), Is.is(true));
        Assert.assertThat((Object)cars.isStale(), Is.is(true));
        Assert.assertThat((Object)cars.isLoaded(), Is.is(false));
        Assert.assertThat((Object)root.isStale(), Is.is(false));
        cars = this.cache.findNodeWith(this.path("/Cars"));
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Utility", "Sports", "Luxury");
        this.assertNoChanges();
    }

    @Test
    public void shouldReorderChildWithSnsIndexes() {
        GraphSession.Node sports = this.cache.findNodeWith(this.path("/Cars/Sports"));
        GraphSession.Node cars = this.cache.findNodeWith(this.path("/Cars"));
        this.assertConnectionsUsed(1);
        GraphSession.Node exp1 = cars.createChild(this.name("Experimental"));
        GraphSession.Node exp2 = cars.createChild(this.name("Experimental"));
        GraphSession.Node exp3 = cars.createChild(this.name("Experimental"));
        Assert.assertThat((Object)this.cache.hasPendingChanges(), Is.is(true));
        Assert.assertThat((Object)exp1.getSegment().getIndex(), Is.is(1));
        Assert.assertThat((Object)exp2.getSegment().getIndex(), Is.is(2));
        Assert.assertThat((Object)exp3.getSegment().getIndex(), Is.is(3));
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Sports", "Luxury", "Utility", "Experimental", "Experimental[2]", "Experimental[3]");
        cars.orderChildBefore(exp3.getSegment(), sports.getSegment());
        this.assertNoMoreConnectionsUsed();
        Assert.assertThat((Object)exp1.getSegment().getIndex(), Is.is(2));
        Assert.assertThat((Object)exp2.getSegment().getIndex(), Is.is(3));
        Assert.assertThat((Object)exp3.getSegment().getIndex(), Is.is(1));
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Experimental", "Sports", "Luxury", "Utility", "Experimental[2]", "Experimental[3]");
        this.assertConnectionsUsed(0);
        this.cache.save();
        this.assertConnectionsUsed(2);
        cars = this.cache.findNodeWith(this.path("/Cars"));
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Experimental", "Sports", "Luxury", "Utility", "Experimental[2]", "Experimental[3]");
        this.assertNoChanges();
    }

    @Test
    public void shouldLoadSubgraphs() {
        this.cache.setDepthForLoadingNodes(4);
        GraphSession.Node cars = this.cache.findNodeWith(this.path("/Cars"));
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Sports", "Luxury", "Utility");
        this.assertConnectionsUsed(1);
        GraphSession.Node sports = this.cache.findNodeWith(this.path("/Cars/Sports"));
        GraphSession.Node g37 = this.cache.findNodeWith(this.path("/Cars/Sports/Infiniti G37"));
        GraphSession.Node db9 = this.cache.findNodeWith(this.path("/Cars/Sports/Aston Martin DB9"));
        this.assertConnectionsUsed(0);
        Assert.assertThat((Object)sports.isLoaded(), Is.is(true));
        Assert.assertThat((Object)g37.isLoaded(), Is.is(true));
        Assert.assertThat((Object)db9.isLoaded(), Is.is(true));
        this.assertChildren((GraphSession.Node<Object, Object>)sports, "Aston Martin DB9", "Infiniti G37");
        this.assertChildren((GraphSession.Node<Object, Object>)g37, new String[0]);
        this.assertChildren((GraphSession.Node<Object, Object>)db9, new String[0]);
        this.assertNoMoreConnectionsUsed();
        this.assertNoChanges();
    }

    @Test
    public void shouldMarkAsChangedWhenSettingProperties() {
        GraphSession.Node g37 = this.cache.findNodeWith(this.path("/Cars/Sports/Infiniti G37"));
        Assert.assertThat((Object)g37.isChanged(false), Is.is(false));
        Property newProperty = this.createProperty("something", "value1");
        g37.setProperty(newProperty, false, null);
        Assert.assertThat((Object)g37.isChanged(false), Is.is(true));
        Assert.assertThat((Object)this.cache.getRoot().isChanged(true), Is.is(true));
        this.cache.save();
    }

    @Test
    public void shouldClearPropertyChangesWhenRefreshing() {
        GraphSession.Node g37 = this.cache.findNodeWith(this.path("/Cars/Sports/Infiniti G37"));
        Assert.assertThat((Object)g37.isChanged(false), Is.is(false));
        Property newProperty = this.createProperty("something", "value1");
        g37.setProperty(newProperty, false, null);
        Assert.assertThat((Object)g37.isChanged(false), Is.is(true));
        Assert.assertThat((Object)this.cache.getRoot().isChanged(true), Is.is(true));
        this.cache.refresh(g37, false);
        Assert.assertThat((Object)g37.isChanged(true), Is.is(false));
        Assert.assertThat((Object)this.cache.getRoot().isChanged(true), Is.is(false));
        this.assertNoChanges();
    }

    @Test
    public void shouldCreateChildren() {
        GraphSession.Node cars = this.cache.findNodeWith(this.path("/Cars"));
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Sports", "Luxury", "Utility");
        this.assertConnectionsUsed(1);
        GraphSession.Node experimental = cars.createChild(this.name("Experimental"));
        Assert.assertThat((Object)experimental.getParent(), Is.is(IsSame.sameInstance(cars)));
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Sports", "Luxury", "Utility", "Experimental");
        Assert.assertThat((Object)cars.isChanged(false), Is.is(true));
        Assert.assertThat((Object)experimental.isNew(), Is.is(true));
        this.assertNoMoreConnectionsUsed();
        GraphSession.Node experimental2 = cars.createChild(this.name("Experimental"));
        Assert.assertThat((Object)experimental2.getParent(), Is.is(IsSame.sameInstance(cars)));
        this.assertChildren((GraphSession.Node<Object, Object>)cars, "Hybrid", "Sports", "Luxury", "Utility", "Experimental[1]", "Experimental[2]");
        Assert.assertThat((Object)cars.isChanged(false), Is.is(true));
        Assert.assertThat((Object)experimental2.isNew(), Is.is(true));
        this.assertNoMoreConnectionsUsed();
    }

    protected void assertChildren(GraphSession.Node<Object, Object> node, String ... childNames) {
        Assert.assertThat((Object)node.getChildrenCount(), Is.is(childNames.length));
        LinkedList<Path.Segment> segments = new LinkedList<Path.Segment>();
        for (String childName : childNames) {
            segments.add(this.pathFactory.createSegment(childName));
        }
        Iterator expectedIter = segments.iterator();
        Iterator actualIter = node.getChildren().iterator();
        while (expectedIter.hasNext() && actualIter.hasNext()) {
            GraphSession.Node actualNode = (GraphSession.Node)actualIter.next();
            Path actualPath = actualNode.getPath();
            Path.Segment actualSegment = actualPath.getLastSegment();
            Path.Segment expectedSegment = (Path.Segment)expectedIter.next();
            Assert.assertThat((Object)actualSegment, Is.is(expectedSegment));
        }
        Assert.assertThat((Object)expectedIter.hasNext(), Is.is(false));
        Assert.assertThat((Object)actualIter.hasNext(), Is.is(false));
    }

    @Test(expected=PathNotFoundException.class)
    public void shouldThrowPathNotFoundExceptionWhenFailingToFindDeepMissingNode() throws Exception {
        this.cache.findNodeRelativeTo(this.cache.getRoot(), this.path("Cars/some/node/that/does/not/exist"), true);
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    protected Path.Segment segment(String segment) {
        return this.context.getValueFactories().getPathFactory().createSegment(segment);
    }

    protected Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected Property createProperty(String name, Object ... values) {
        return this.context.getPropertyFactory().create(this.name(name), values);
    }

    protected void assertChildrenNotLoaded(GraphSession.Node<Object, Object> node) {
        for (GraphSession.Node child : node.getChildren()) {
            Assert.assertThat((Object)child.isLoaded(), Is.is(false));
        }
    }

    protected void assertNoChanges() {
        Assert.assertThat((Object)this.cache.hasPendingChanges(), Is.is(false));
        Assert.assertThat((Object)this.cache.changeDependencies.isEmpty(), Is.is(true));
        Assert.assertThat((Object)this.cache.operations.isExecuteRequired(), Is.is(false));
    }

    protected void assertNoMoreConnectionsUsed() {
        Assert.assertThat((Object)this.numberOfConnections, Is.is(0));
    }

    protected void assertConnectionsUsed(int number) {
        Assert.assertThat((Object)this.numberOfConnections, Is.is(number));
        this.numberOfConnections = 0;
    }
}

