/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.mimetype;

import java.io.IOException;
import java.io.InputStream;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.component.ClassLoaderFactory;
import org.modeshape.common.component.ComponentConfig;
import org.modeshape.common.component.ComponentLibrary;
import org.modeshape.common.component.StandardClassLoaderFactory;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.mimetype.MimeTypeDetector;
import org.modeshape.graph.mimetype.MimeTypeDetectorConfig;

@ThreadSafe
public final class MimeTypeDetectors
implements MimeTypeDetector {
    protected static final ClassLoaderFactory DEFAULT_CLASSLOADER_FACTORY = new StandardClassLoaderFactory(MimeTypeDetectors.class.getClassLoader());
    private final ComponentLibrary<MimeTypeDetector, MimeTypeDetectorConfig> library = new ComponentLibrary(true);
    private Logger logger;

    public MimeTypeDetectors() {
        this.library.setClassLoaderFactory(DEFAULT_CLASSLOADER_FACTORY);
    }

    public boolean addDetector(MimeTypeDetectorConfig config) {
        return this.library.add((ComponentConfig)config);
    }

    public ClassLoaderFactory getClassLoaderFactory() {
        return this.library.getClassLoaderFactory();
    }

    public synchronized Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.getClass());
        }
        return this.logger;
    }

    @Override
    public String mimeTypeOf(String name, InputStream content) throws IOException {
        if (content != null && content.markSupported()) {
            content.mark(Integer.MAX_VALUE);
        }
        for (MimeTypeDetector detector : this.library.getInstances()) {
            String mimeType = detector.mimeTypeOf(name, content);
            if (mimeType == null) continue;
            return mimeType;
        }
        if (content != null && content.markSupported()) {
            try {
                content.reset();
                int chr = content.read();
                while (chr >= 0) {
                    if (chr == 0) {
                        return "application/octet-stream";
                    }
                    chr = content.read();
                }
            }
            catch (IOException meansTooManyBytesRead) {
                return "application/octet-stream";
            }
        }
        return "text/plain";
    }

    public boolean removeDetector(MimeTypeDetectorConfig config) {
        return this.library.remove((ComponentConfig)config);
    }

    public void setClassLoaderFactory(ClassLoaderFactory classLoaderFactory) {
        this.library.setClassLoaderFactory(classLoaderFactory != null ? classLoaderFactory : DEFAULT_CLASSLOADER_FACTORY);
    }

    public synchronized void setLogger(Logger logger) {
        this.logger = logger != null ? logger : this.getLogger();
    }
}

