/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.inmemory;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.request.GetWorkspacesRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.Request;

public class InMemoryRepositorySourceTest {
    private ExecutionContext context;
    private RepositoryContext repositoryContext;
    private InMemoryRepositorySource source;
    private String[] predefinedWorkspaces = new String[]{"foo", "bar", "baz"};

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.repositoryContext = (RepositoryContext)Mockito.mock(RepositoryContext.class);
        Mockito.when((Object)this.repositoryContext.getExecutionContext()).thenReturn((Object)this.context);
        this.source = new InMemoryRepositorySource();
        this.source.setName("In-Memory Repository Source");
        this.source.setPredefinedWorkspaceNames(this.predefinedWorkspaces);
        this.source.setDefaultWorkspaceName(this.predefinedWorkspaces[0]);
        this.source.initialize(this.repositoryContext);
    }

    public Location locationFor(String path) {
        return Location.create((Path)this.pathFor(path));
    }

    public Path pathFor(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    @Test
    public void shouldMakeAvailablePredefinedWorkspaces() {
        RepositoryConnection connection = this.source.getConnection();
        GetWorkspacesRequest request = new GetWorkspacesRequest();
        connection.execute(this.context, (Request)request);
        Set workspaces = request.getAvailableWorkspaceNames();
        HashSet<String> graphWorkspaces = new HashSet<String>(Arrays.asList(this.predefinedWorkspaces));
        Assert.assertThat((Object)workspaces, CoreMatchers.is(graphWorkspaces));
        for (String workspaceName : this.predefinedWorkspaces) {
            ReadNodeRequest readRoot = new ReadNodeRequest(this.locationFor("/"), workspaceName);
            connection.execute(this.context, (Request)readRoot);
            Assert.assertThat((Object)readRoot.getActualLocationOfNode().getPath(), CoreMatchers.is(this.pathFor("/")));
        }
    }
}

