/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.io;

import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.io.GraphSequencerOutput;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;

public class GraphSequencerOutputTest {
    private GraphSequencerOutput output;
    private ExecutionContext context;
    private Graph graph;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        final InMemoryRepositorySource source = new InMemoryRepositorySource();
        source.setName("actual");
        RepositoryContext repositoryContext = new RepositoryContext(){

            public ExecutionContext getExecutionContext() {
                return GraphSequencerOutputTest.this.context;
            }

            public Observer getObserver() {
                return null;
            }

            public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                return null;
            }

            public Subgraph getConfiguration(int depth) {
                Graph result = Graph.create((RepositorySource)source, (ExecutionContext)GraphSequencerOutputTest.this.context);
                result.useWorkspace("configSpace");
                return (Subgraph)result.getSubgraphOfDepth(depth).at("/");
            }
        };
        source.initialize(repositoryContext);
        this.graph = Graph.create((RepositorySource)source, (ExecutionContext)this.context);
        this.output = new GraphSequencerOutput(this.graph);
    }

    protected Path createPath(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected Name createName(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    @Test
    public void shouldSetPropertyWithString() {
        String path1 = "/a";
        String prop1_name = "prop1";
        String value_1 = "blue";
        this.output.setProperty(path1, prop1_name, value_1);
        String path2 = "/a/b";
        String prop2_name = "prop2";
        String value_2 = "red";
        this.output.setProperty(path2, prop2_name, value_2);
        this.output.close();
        Subgraph result = (Subgraph)this.graph.getSubgraphOfDepth(10).at("/");
        String v1 = (String)((SubgraphNode)result.getNode(path1)).getProperty(prop1_name).getFirstValue();
        Assert.assertThat((Object)v1, Is.is(value_1));
        String v2 = (String)((SubgraphNode)result.getNode(path2)).getProperty(prop2_name).getFirstValue();
        Assert.assertThat((Object)v2, Is.is(value_2));
        Assert.assertNull((Object)result.getNode("/c"));
    }

    @Test
    public void shouldSetReferenceWithString() {
        String path1 = "/a";
        String prop1_name = "prop1";
        String value_1 = "blue";
        this.output.setReference(path1, prop1_name, value_1);
        String path2 = "/a/b";
        String prop2_name = "prop2";
        String value_2 = "red";
        this.output.setReference(path2, prop2_name, value_2);
        this.output.close();
        Subgraph result = (Subgraph)this.graph.getSubgraphOfDepth(10).at("/");
        String v1 = (String)((SubgraphNode)result.getNode(path1)).getProperty(prop1_name).getFirstValue();
        Assert.assertThat((Object)v1, Is.is(value_1));
        String v2 = (String)((SubgraphNode)result.getNode(path2)).getProperty(prop2_name).getFirstValue();
        Assert.assertThat((Object)v2, Is.is(value_2));
        Assert.assertNull((Object)result.getNode("/c"));
    }

    @Test
    public void shouldSetPropertyWithPath() {
        Path path1 = this.createPath("/a");
        Name prop1_name = this.createName("prop1");
        String value_1 = "blue";
        this.output.setProperty(path1, prop1_name, value_1);
        Path path2 = this.createPath("/a/b");
        Name prop2_name = this.createName("prop2");
        String value_2 = "red";
        this.output.setProperty(path2, prop2_name, value_2);
        this.output.close();
        Subgraph result = (Subgraph)this.graph.getSubgraphOfDepth(10).at("/");
        String v1 = (String)((SubgraphNode)result.getNode(path1)).getProperty(prop1_name).getFirstValue();
        Assert.assertThat((Object)v1, Is.is(value_1));
        String v2 = (String)((SubgraphNode)result.getNode(path2)).getProperty(prop2_name).getFirstValue();
        Assert.assertThat((Object)v2, Is.is(value_2));
        Assert.assertNull((Object)result.getNode("/c"));
    }
}

