/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.Jsr283Encoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.graph.property.InvalidPathException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.property.basic.BasicName;
import org.modeshape.graph.property.basic.BasicPath;
import org.modeshape.graph.property.basic.BasicPathSegment;
import org.modeshape.graph.property.basic.IsPathContaining;
import org.modeshape.graph.property.basic.NameValueFactory;
import org.modeshape.graph.property.basic.PathValueFactory;
import org.modeshape.graph.property.basic.RootPath;
import org.modeshape.graph.property.basic.SimpleNamespaceRegistry;
import org.modeshape.graph.property.basic.StringValueFactory;

public class BasicPathOldTest {
    public static final TextEncoder NO_OP_ENCODER = Path.NO_OP_ENCODER;
    public static final Path ROOT = RootPath.INSTANCE;
    private NamespaceRegistry namespaceRegistry;
    private String validNamespaceUri;
    private Path path;
    private Path path2;
    private Path.Segment[] validSegments;
    private List<Path.Segment> validSegmentsList;
    private Name[] validSegmentNames;
    private String validNamespacePrefix;
    private PathValueFactory pathFactory;

    @Before
    public void beforeEach() {
        this.validNamespacePrefix = "mode";
        this.validNamespaceUri = "http://www.modeshape.org/1.0";
        this.validSegmentNames = new Name[]{new BasicName(this.validNamespaceUri, "a"), new BasicName(this.validNamespaceUri, "b"), new BasicName(this.validNamespaceUri, "c")};
        this.validSegments = new Path.Segment[]{new BasicPathSegment(this.validSegmentNames[0]), new BasicPathSegment(this.validSegmentNames[1]), new BasicPathSegment(this.validSegmentNames[1])};
        this.validSegmentsList = new ArrayList<Path.Segment>();
        for (Path.Segment segment : this.validSegments) {
            this.validSegmentsList.add(segment);
        }
        this.path = new BasicPath(this.validSegmentsList, true);
        this.namespaceRegistry = new SimpleNamespaceRegistry();
        this.namespaceRegistry.register(this.validNamespacePrefix, this.validNamespaceUri);
        StringValueFactory stringValueFactory = new StringValueFactory(this.namespaceRegistry, Path.DEFAULT_DECODER, Path.DEFAULT_ENCODER);
        NameValueFactory nameValueFactory = new NameValueFactory(this.namespaceRegistry, Path.DEFAULT_DECODER, (ValueFactory)stringValueFactory);
        this.pathFactory = new PathValueFactory(Path.DEFAULT_DECODER, (ValueFactory)stringValueFactory, (ValueFactory)nameValueFactory);
    }

    @Test
    public void shouldCreateAbsolutePathFromListOfValidSegments() {
        this.path = new BasicPath(this.validSegmentsList, true);
        Assert.assertThat((Object)this.path.isAbsolute(), Is.is(true));
        Assert.assertThat((Object)this.path.isNormalized(), Is.is(true));
        Assert.assertThat((Object)this.path.getSegmentsList(), Is.is(this.validSegmentsList));
        Assert.assertThat((Object)this.path.size(), Is.is(this.validSegmentsList.size()));
    }

    @Test
    public void shouldCreateRelativePathFromListOfValidSegments() {
        this.path = new BasicPath(this.validSegmentsList, false);
        Assert.assertThat((Object)this.path.isAbsolute(), Is.is(false));
        Assert.assertThat((Object)this.path.isNormalized(), Is.is(true));
        Assert.assertThat((Object)this.path.getSegmentsList(), Is.is(this.validSegmentsList));
        Assert.assertThat((Object)this.path.size(), Is.is(this.validSegmentsList.size()));
    }

    @Test
    public void shouldCreateAbsolutePathWithParentSegment() {
        this.validSegmentsList.add(Path.PARENT_SEGMENT);
        this.path = new BasicPath(this.validSegmentsList, true);
        Assert.assertThat((Object)this.path.isAbsolute(), Is.is(true));
        Assert.assertThat((Object)this.path.isNormalized(), Is.is(false));
        Assert.assertThat((Object)this.path.getSegmentsList(), Is.is(this.validSegmentsList));
        Assert.assertThat((Object)this.path.size(), Is.is(this.validSegmentsList.size()));
    }

    @Test
    public void shouldCreateRelativePathWithParentSegment() {
        this.validSegmentsList.add(Path.PARENT_SEGMENT);
        this.path = new BasicPath(this.validSegmentsList, false);
        Assert.assertThat((Object)this.path.isAbsolute(), Is.is(false));
        Assert.assertThat((Object)this.path.isNormalized(), Is.is(false));
        Assert.assertThat((Object)this.path.getSegmentsList(), Is.is(this.validSegmentsList));
        Assert.assertThat((Object)this.path.size(), Is.is(this.validSegmentsList.size()));
    }

    @Test
    public void shouldCreateAbsolutePathWithSelfSegment() {
        this.validSegmentsList.add(Path.SELF_SEGMENT);
        this.path = new BasicPath(this.validSegmentsList, true);
        Assert.assertThat((Object)this.path.isAbsolute(), Is.is(true));
        Assert.assertThat((Object)this.path.isNormalized(), Is.is(false));
        Assert.assertThat((Object)this.path.getSegmentsList(), Is.is(this.validSegmentsList));
        Assert.assertThat((Object)this.path.size(), Is.is(this.validSegmentsList.size()));
    }

    @Test
    public void shouldCreateRelativePathWithSelfSegment() {
        this.validSegmentsList.add(Path.SELF_SEGMENT);
        this.path = new BasicPath(this.validSegmentsList, false);
        Assert.assertThat((Object)this.path.isAbsolute(), Is.is(false));
        Assert.assertThat((Object)this.path.isNormalized(), Is.is(false));
        Assert.assertThat((Object)this.path.getSegmentsList(), Is.is(this.validSegmentsList));
        Assert.assertThat((Object)this.path.size(), Is.is(this.validSegmentsList.size()));
    }

    @Test
    public void shouldCreatePathWithNoNamespacePrefixes() {
        this.path = this.pathFactory.create("/a/b/c/");
        Assert.assertThat((Object)this.path.size(), Is.is(3));
        Assert.assertThat((Object)this.path, IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b", "c"));
    }

    @Test
    public void shouldConstructRelativePath() {
        Assert.assertThat((Object)this.pathFactory.create("a/b/c").isAbsolute(), Is.is(false));
        Assert.assertThat((Object)this.pathFactory.create("a/b/c").isNormalized(), Is.is(true));
        Assert.assertThat((Object)this.pathFactory.create("a/b/c").size(), Is.is(3));
        Assert.assertThat((Object)this.pathFactory.create("a/b/c").getString(this.namespaceRegistry), Is.is("a/b/c"));
    }

    @Test
    public void shouldConstructRelativePathToSelf() {
        Assert.assertThat((Object)this.pathFactory.create(".").isAbsolute(), Is.is(false));
        Assert.assertThat((Object)this.pathFactory.create(".").size(), Is.is(1));
        Assert.assertThat((Object)this.pathFactory.create("."), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "."));
        Assert.assertThat((Object)this.pathFactory.create("./").isAbsolute(), Is.is(false));
        Assert.assertThat((Object)this.pathFactory.create("./").size(), Is.is(1));
        Assert.assertThat((Object)this.pathFactory.create("./"), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "."));
    }

    @Test
    public void shouldConstructRelativePathToParent() {
        Assert.assertThat((Object)this.pathFactory.create("..").isAbsolute(), Is.is(false));
        Assert.assertThat((Object)this.pathFactory.create("..").size(), Is.is(1));
        Assert.assertThat((Object)this.pathFactory.create(".."), IsPathContaining.hasSegments((PathFactory)this.pathFactory, ".."));
        Assert.assertThat((Object)this.pathFactory.create("../").isAbsolute(), Is.is(false));
        Assert.assertThat((Object)this.pathFactory.create("../").size(), Is.is(1));
        Assert.assertThat((Object)this.pathFactory.create("../"), IsPathContaining.hasSegments((PathFactory)this.pathFactory, ".."));
    }

    @Test
    public void shouldConstructRootPathFromStringWithSingleDelimiter() {
        Assert.assertThat((Object)this.pathFactory.create("/"), Is.is(ROOT));
        Assert.assertThat((Object)this.pathFactory.create("/").isRoot(), Is.is(true));
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotConstructPathWithSuccessiveDelimiters() {
        this.pathFactory.create("///a/b///c//d//");
    }

    @Test(expected=ValueFormatException.class)
    public void shouldNotConstructPathWithOnlyDelimiters() {
        this.pathFactory.create("///");
    }

    @Test
    public void shouldConstructPathFromStringAndShouldIgnoreLeadingAndTrailingWhitespace() {
        Assert.assertThat((Object)this.pathFactory.create(" \t /  \t").toString(), Is.is("/"));
    }

    @Test
    public void shouldConstructRelativePathIfSuppliedPathHasNoLeadingDelimiter() {
        Assert.assertThat((Object)this.pathFactory.create("a"), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a"));
    }

    @Test
    public void shouldHaveSizeThatReflectsNumberOfSegments() {
        Assert.assertThat((Object)this.path.size(), Is.is(this.validSegmentsList.size()));
    }

    @Test
    public void shouldIterateOverAllSegmentsReturnedByList() {
        Iterator<Object> expectedIter = this.validSegmentsList.iterator();
        for (Path.Segment segment : this.path) {
            Assert.assertThat((Object)segment, Is.is(expectedIter.next()));
        }
        expectedIter = this.path.getSegmentsList().iterator();
        for (Path.Segment segment : this.path) {
            Assert.assertThat((Object)segment, Is.is(expectedIter.next()));
        }
    }

    @Test
    public void shouldReturnNoAncestorForRoot() {
        Assert.assertThat((Object)RootPath.INSTANCE.getParent(), IsNull.nullValue());
    }

    @Test
    public void shouldReturnAncestorForNodeOtherThanRoot() {
        Assert.assertThat((Object)this.path.getParent(), Is.is(this.pathFactory.create("/mode:a/mode:b")));
        Assert.assertThat((Object)this.path.getParent().getParent(), Is.is(this.pathFactory.create("/mode:a")));
        Assert.assertThat((Object)this.path.getParent().getParent().getParent(), Is.is(ROOT));
    }

    @Test
    public void shouldReturnNthDegreeAncestor() {
        Assert.assertThat((Object)this.path.getAncestor(1), Is.is(this.pathFactory.create("/mode:a/mode:b")));
        Assert.assertThat((Object)this.path.getAncestor(2), Is.is(this.pathFactory.create("/mode:a")));
        Assert.assertThat((Object)this.path.getAncestor(3), Is.is(ROOT));
    }

    @Test(expected=InvalidPathException.class)
    public void shouldNotAllowAncestorDegreeLargerThanSize() {
        this.path.getAncestor(this.path.size() + 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowNegativeAncestorDegree() {
        this.path.getAncestor(-1);
    }

    @Test
    public void shouldReturnRootForAnyAncestorExactDegreeFromRoot() {
        Assert.assertThat((Object)this.path.getAncestor(this.path.size()), Is.is(ROOT));
        Assert.assertThat((Object)ROOT.getAncestor(0), Is.is(ROOT));
    }

    @Test
    public void shouldConsiderRootTheLowestCommonAncestorOfAnyNodeAndRoot() {
        Assert.assertThat((Object)this.path.getCommonAncestor(ROOT), Is.is(ROOT));
        Assert.assertThat((Object)ROOT.getCommonAncestor(this.path), Is.is(ROOT));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldReturnNullForLowestCommonAncestorWithNullPath() {
        this.path.getCommonAncestor(null);
    }

    @Test
    public void shouldFindLowestCommonAncestorBetweenTwoNonRootNodesOnCommonBranch() {
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path common = this.pathFactory.create("/a");
        Assert.assertThat((Object)path1.getCommonAncestor(path2), Is.is(common));
        path1 = this.pathFactory.create("/a/b/c");
        path2 = this.pathFactory.create("/a/b/c/d");
        common = path1;
        Assert.assertThat((Object)path1.getCommonAncestor(path2), Is.is(common));
        path1 = this.pathFactory.create("/a/b/c/x/y/");
        path2 = this.pathFactory.create("/a/b/c/d/e/f/");
        common = this.pathFactory.create("/a/b/c");
        Assert.assertThat((Object)path1.getCommonAncestor(path2), Is.is(common));
    }

    @Test
    public void shouldConsiderRootTheLowestCommonAncestorOfAnyNodesOnSeparateBrances() {
        Path path1 = this.pathFactory.create("/x/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path common = ROOT;
        Assert.assertThat((Object)path1.getCommonAncestor(path2), Is.is(common));
    }

    @Test
    public void shouldConsiderNodeToBeAncestorOfEveryDecendantNode() {
        int i;
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path path4 = this.pathFactory.create("/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z");
        Path common = this.pathFactory.create("/a");
        Assert.assertThat((Object)common.isAncestorOf(path1), Is.is(true));
        Assert.assertThat((Object)common.isAncestorOf(path2), Is.is(true));
        Assert.assertThat((Object)common.isAncestorOf(path3), Is.is(false));
        Assert.assertThat((Object)path1.getParent().isAncestorOf(path1), Is.is(true));
        for (i = 1; i < path1.size(); ++i) {
            Assert.assertThat((Object)path1.getAncestor(i).isAncestorOf(path1), Is.is(true));
        }
        for (i = 1; i < path2.size(); ++i) {
            Assert.assertThat((Object)path2.getAncestor(i).isAncestorOf(path2), Is.is(true));
        }
        for (i = 1; i < path3.size(); ++i) {
            Assert.assertThat((Object)path3.getAncestor(i).isAncestorOf(path3), Is.is(true));
        }
        for (i = 1; i < path4.size(); ++i) {
            Assert.assertThat((Object)path4.getAncestor(i).isAncestorOf(path4), Is.is(true));
        }
    }

    @Test
    public void shouldConsiderNodeToBeDecendantOfEveryAncestorNode() {
        int i;
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path path4 = this.pathFactory.create("/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z");
        Path common = this.pathFactory.create("/a");
        Assert.assertThat((Object)path1.isDecendantOf(common), Is.is(true));
        Assert.assertThat((Object)path2.isDecendantOf(common), Is.is(true));
        Assert.assertThat((Object)path3.isDecendantOf(common), Is.is(false));
        Assert.assertThat((Object)path1.getParent().isAncestorOf(path1), Is.is(true));
        for (i = 1; i < path1.size(); ++i) {
            Assert.assertThat((Object)path1.isDecendantOf(path1.getAncestor(i)), Is.is(true));
        }
        for (i = 1; i < path2.size(); ++i) {
            Assert.assertThat((Object)path2.isDecendantOf(path2.getAncestor(i)), Is.is(true));
        }
        for (i = 1; i < path3.size(); ++i) {
            Assert.assertThat((Object)path3.isDecendantOf(path3.getAncestor(i)), Is.is(true));
        }
        for (i = 1; i < path4.size(); ++i) {
            Assert.assertThat((Object)path4.isDecendantOf(path4.getAncestor(i)), Is.is(true));
        }
    }

    @Test
    public void shouldNotConsiderNodeToBeAncestorOfItself() {
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Assert.assertThat((Object)path1.isAncestorOf(path1), Is.is(false));
        Assert.assertThat((Object)path2.isAncestorOf(path2), Is.is(false));
        Assert.assertThat((Object)path3.isAncestorOf(path3), Is.is(false));
        Assert.assertThat((Object)ROOT.isAncestorOf(ROOT), Is.is(false));
    }

    @Test
    public void shouldNotConsiderNodeToBeDecendantOfItself() {
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Assert.assertThat((Object)path1.isDecendantOf(path1), Is.is(false));
        Assert.assertThat((Object)path2.isDecendantOf(path2), Is.is(false));
        Assert.assertThat((Object)path3.isDecendantOf(path3), Is.is(false));
        Assert.assertThat((Object)ROOT.isDecendantOf(ROOT), Is.is(false));
    }

    @Test
    public void shouldNotConsiderRootToBeDecendantOfAnyNode() {
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path common = this.pathFactory.create("/a");
        Assert.assertThat((Object)ROOT.isDecendantOf(path1), Is.is(false));
        Assert.assertThat((Object)ROOT.isDecendantOf(path2), Is.is(false));
        Assert.assertThat((Object)ROOT.isDecendantOf(path3), Is.is(false));
        Assert.assertThat((Object)ROOT.isDecendantOf(common), Is.is(false));
    }

    @Test
    public void shouldConsiderRootToBeAncestorOfAnyNode() {
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path common = this.pathFactory.create("/a");
        Assert.assertThat((Object)ROOT.isAncestorOf(path1), Is.is(true));
        Assert.assertThat((Object)ROOT.isAncestorOf(path2), Is.is(true));
        Assert.assertThat((Object)ROOT.isAncestorOf(path3), Is.is(true));
        Assert.assertThat((Object)ROOT.isAncestorOf(common), Is.is(true));
    }

    @Test
    public void shouldNotConsiderRootToBeAncestorOfItself() {
        Assert.assertThat((Object)ROOT.isAncestorOf(ROOT), Is.is(false));
    }

    @Test
    public void shouldNotConsiderRootToBeDecendantOfItself() {
        Assert.assertThat((Object)ROOT.isDecendantOf(ROOT), Is.is(false));
    }

    @Test
    public void shouldConsiderTwoRootNodesToHaveSameAncestor() {
        Assert.assertThat((Object)ROOT.hasSameAncestor(ROOT), Is.is(true));
    }

    @Test
    public void shouldConsiderTwoNotRootSiblingNodesToHaveSameAncestor() {
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/y/c");
        Assert.assertThat((Object)path1.hasSameAncestor(path2), Is.is(true));
        path1 = this.pathFactory.create("/a/z");
        path2 = this.pathFactory.create("/a/c");
        Assert.assertThat((Object)path1.hasSameAncestor(path2), Is.is(true));
        path1 = this.pathFactory.create("/z");
        path2 = this.pathFactory.create("/c");
        Assert.assertThat((Object)path1.hasSameAncestor(path2), Is.is(true));
    }

    @Test
    public void shouldNotConsiderTwoNonSiblingNodesToHaveSameAncestor() {
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/x/c");
        Assert.assertThat((Object)path1.hasSameAncestor(path2), Is.is(false));
        path1 = this.pathFactory.create("/a/z");
        path2 = this.pathFactory.create("/b/c");
        Assert.assertThat((Object)path1.hasSameAncestor(path2), Is.is(false));
        path1 = this.pathFactory.create("/z");
        path2 = this.pathFactory.create("/a/c");
        Assert.assertThat((Object)path1.hasSameAncestor(path2), Is.is(false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailForSameAncestorOfNullPath() {
        this.path.hasSameAncestor(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailForDecendantOfNullPath() {
        this.path.isDecendantOf(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailForAtOrAboveNullPath() {
        this.path.isAtOrAbove(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailForAtOrBelowNullPath() {
        this.path.isAtOrBelow(null);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailToReturnSegmentAtIndexGreatherThanSize() {
        this.path.getSegment(this.path.size() + 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToReturnSegmentAtNegativeIndex() {
        this.path.getSegment(-1);
    }

    @Test
    public void shouldConsiderNodeToBeAtOrAboveItself() {
        Assert.assertThat((Object)this.path.isAtOrAbove(this.path), Is.is(true));
    }

    @Test
    public void shouldConsiderNodeToBeAtOrBelowItself() {
        Assert.assertThat((Object)this.path.isAtOrBelow(this.path), Is.is(true));
    }

    @Test
    public void shouldConsiderAncestorToBeAtOrAboveTheDecendant() {
        int i;
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path path4 = this.pathFactory.create("/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z");
        for (i = 1; i < path1.size(); ++i) {
            Assert.assertThat((Object)path1.getAncestor(i).isAtOrAbove(path1), Is.is(true));
        }
        for (i = 1; i < path2.size(); ++i) {
            Assert.assertThat((Object)path2.getAncestor(i).isAtOrAbove(path2), Is.is(true));
        }
        for (i = 1; i < path3.size(); ++i) {
            Assert.assertThat((Object)path3.getAncestor(i).isAtOrAbove(path3), Is.is(true));
        }
        for (i = 1; i < path4.size(); ++i) {
            Assert.assertThat((Object)path4.getAncestor(i).isAtOrAbove(path4), Is.is(true));
        }
    }

    @Test
    public void shouldConsiderDecendantToBeAtOrBelowTheAncestor() {
        int i;
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path path4 = this.pathFactory.create("/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z");
        for (i = 1; i < path1.size(); ++i) {
            Assert.assertThat((Object)path1.isAtOrBelow(path1.getAncestor(i)), Is.is(true));
        }
        for (i = 1; i < path2.size(); ++i) {
            Assert.assertThat((Object)path2.isAtOrBelow(path2.getAncestor(i)), Is.is(true));
        }
        for (i = 1; i < path3.size(); ++i) {
            Assert.assertThat((Object)path3.isAtOrBelow(path3.getAncestor(i)), Is.is(true));
        }
        for (i = 1; i < path4.size(); ++i) {
            Assert.assertThat((Object)path4.isAtOrBelow(path4.getAncestor(i)), Is.is(true));
        }
    }

    @Test
    public void shouldNotConsiderAncestorToBeAtOrBelowTheDecendant() {
        int i;
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path path4 = this.pathFactory.create("/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z");
        for (i = 1; i < path1.size(); ++i) {
            Assert.assertThat((Object)path1.getAncestor(i).isAtOrBelow(path1), Is.is(false));
        }
        for (i = 1; i < path2.size(); ++i) {
            Assert.assertThat((Object)path2.getAncestor(i).isAtOrBelow(path2), Is.is(false));
        }
        for (i = 1; i < path3.size(); ++i) {
            Assert.assertThat((Object)path3.getAncestor(i).isAtOrBelow(path3), Is.is(false));
        }
        for (i = 1; i < path4.size(); ++i) {
            Assert.assertThat((Object)path4.getAncestor(i).isAtOrBelow(path4), Is.is(false));
        }
    }

    @Test
    public void shouldNotConsiderDecendantToBeAtOrAboveTheAncestor() {
        int i;
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path path4 = this.pathFactory.create("/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z");
        for (i = 1; i < path1.size(); ++i) {
            Assert.assertThat((Object)path1.isAtOrAbove(path1.getAncestor(i)), Is.is(false));
        }
        for (i = 1; i < path2.size(); ++i) {
            Assert.assertThat((Object)path2.isAtOrAbove(path2.getAncestor(i)), Is.is(false));
        }
        for (i = 1; i < path3.size(); ++i) {
            Assert.assertThat((Object)path3.isAtOrAbove(path3.getAncestor(i)), Is.is(false));
        }
        for (i = 1; i < path4.size(); ++i) {
            Assert.assertThat((Object)path4.isAtOrAbove(path4.getAncestor(i)), Is.is(false));
        }
    }

    @Test
    public void shouldReturnNullForLastSegmentOfRoot() {
        Assert.assertThat((Object)ROOT.getLastSegment(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldReturnLastSegmentOfNonRootPath() {
        Path path1 = this.pathFactory.create("/a/y/z");
        Path path2 = this.pathFactory.create("/a/b/c");
        Path path3 = this.pathFactory.create("/x/b/c");
        Path path4 = this.pathFactory.create("/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x");
        Assert.assertThat((Object)path1.getLastSegment().getName().getLocalName(), Is.is("z"));
        Assert.assertThat((Object)path2.getLastSegment().getName().getLocalName(), Is.is("c"));
        Assert.assertThat((Object)path3.getLastSegment().getName().getLocalName(), Is.is("c"));
        Assert.assertThat((Object)path4.getLastSegment().getName().getLocalName(), Is.is("x"));
    }

    @Test
    public void shouldNormalizePathWithSelfAndParentReferences() {
        this.path = this.pathFactory.create("/a/b/c/../d/./e/../..");
        Assert.assertThat((Object)this.path.isNormalized(), Is.is(false));
        Assert.assertThat((Object)this.path.getNormalizedPath(), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b"));
        Assert.assertThat((Object)this.path.getNormalizedPath().isAbsolute(), Is.is(true));
        Assert.assertThat((Object)this.path.getNormalizedPath().isNormalized(), Is.is(true));
        this.path = this.pathFactory.create("a/b/c/../d/./e/../..");
        Assert.assertThat((Object)this.path.isNormalized(), Is.is(false));
        Assert.assertThat((Object)this.path.getNormalizedPath(), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b"));
        Assert.assertThat((Object)this.path.getNormalizedPath().isAbsolute(), Is.is(false));
        Assert.assertThat((Object)this.path.getNormalizedPath().isNormalized(), Is.is(true));
    }

    @Test
    public void shouldAlreadyBeNormalizedIfPathContainsNoParentOrSelfReferences() {
        Assert.assertThat((Object)this.pathFactory.create("/a/b/c/d/e").isNormalized(), Is.is(true));
        Assert.assertThat((Object)this.pathFactory.create("a/b/c/d/e").isNormalized(), Is.is(true));
        Assert.assertThat((Object)this.pathFactory.create("a").isNormalized(), Is.is(true));
        Assert.assertThat((Object)this.pathFactory.create("/a").isNormalized(), Is.is(true));
        Assert.assertThat((Object)ROOT.isNormalized(), Is.is(true));
    }

    @Test
    public void shouldNotBeNormalizedIfPathContainsParentOrSelfReferences() {
        Assert.assertThat((Object)this.pathFactory.create("/a/b/c/../d/./e/../..").isNormalized(), Is.is(false));
        Assert.assertThat((Object)this.pathFactory.create("a/b/c/../d/./e/../..").isNormalized(), Is.is(false));
        Assert.assertThat((Object)this.pathFactory.create("a/b/c/./d").isNormalized(), Is.is(false));
        Assert.assertThat((Object)this.pathFactory.create("/a/b/c/../d").isNormalized(), Is.is(false));
        Assert.assertThat((Object)this.pathFactory.create(".").isNormalized(), Is.is(false));
        Assert.assertThat((Object)this.pathFactory.create("/.").isNormalized(), Is.is(false));
    }

    @Test(expected=InvalidPathException.class)
    public void shouldFailToReturnNormalizedPathIfPathContainsReferencesToParentsAboveRoot() {
        this.path = this.pathFactory.create("/a/../../../..");
        Assert.assertThat((Object)this.path.isNormalized(), Is.is(false));
        this.path.getNormalizedPath();
    }

    @Test
    public void shouldReturnRootPathAsTheNormalizedPathForAnAbsolutePathWithZeroSegmentsAfterParentAndSelfReferencesRemoved() {
        this.path = this.pathFactory.create("/a/../b/../c/../");
        Assert.assertThat((Object)this.path.isNormalized(), Is.is(false));
        Assert.assertThat((Object)this.path.getNormalizedPath(), Is.is(ROOT));
    }

    @Test
    public void shouldReturnSelfPathAsTheNormalizedPathForARelativePathWithZeroSegmentsAfterParentAndSelfReferencesRemoved() {
        this.path = this.pathFactory.create("a/../b/../c/../");
        Assert.assertThat((Object)this.path.isNormalized(), Is.is(false));
        Assert.assertThat((Object)this.path.getNormalizedPath().size(), Is.is(1));
        Assert.assertThat((Object)this.path.getNormalizedPath(), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "."));
    }

    @Test
    public void shouldNotHaveAnyParentOrSelfReferencesInTheNormalizedPathOfAnAbsolutePath() {
        this.path = this.pathFactory.create("/a/b/c/../d/./e/../..");
        Assert.assertThat((Object)this.path.isNormalized(), Is.is(false));
        Assert.assertThat((Object)this.path.getNormalizedPath(), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b"));
        Assert.assertThat((Object)this.path.getNormalizedPath().isAbsolute(), Is.is(true));
        Assert.assertThat((Object)this.path.getNormalizedPath().isNormalized(), Is.is(true));
    }

    @Test
    public void shouldNotHaveAnyParentReferencesInTheNormalizedPathOfARelativePath() {
        this.path = this.pathFactory.create("a/b/c/../d/./e/../..");
        Assert.assertThat((Object)this.path.isNormalized(), Is.is(false));
        Assert.assertThat((Object)this.path.getNormalizedPath(), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b"));
        Assert.assertThat((Object)this.path.getNormalizedPath().isAbsolute(), Is.is(false));
        Assert.assertThat((Object)this.path.getNormalizedPath().isNormalized(), Is.is(true));
    }

    @Test(expected=InvalidPathException.class)
    public void shouldNotComputeCanonicalPathOfNodeThatIsNotAbsolute() {
        this.pathFactory.create("a/b/c/../d/./e/../..").getCanonicalPath();
    }

    @Test
    public void shouldReturnNormalizedPathForTheCanonicalPathOfAbsolutePath() {
        this.path = this.pathFactory.create("/a/b/c/../d/./e/../..");
        Assert.assertThat((Object)this.path.isNormalized(), Is.is(false));
        Assert.assertThat((Object)this.path.isAbsolute(), Is.is(true));
        Assert.assertThat((Object)this.path.getCanonicalPath(), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b"));
        Assert.assertThat((Object)this.path.getCanonicalPath().isAbsolute(), Is.is(true));
        Assert.assertThat((Object)this.path.getCanonicalPath().isNormalized(), Is.is(true));
    }

    @Test
    public void shouldReturnSameSegmentsInIteratorAndArrayAndList() {
        this.testSegmentsByIteratorAndListAndArray("/a/b/c/../d/./e/../..", "a", "b", "c", "..", "d", ".", "e", "..", "..");
        this.testSegmentsByIteratorAndListAndArray("/a/b/c", "a", "b", "c");
        this.testSegmentsByIteratorAndListAndArray("a/b/c/../d/./e/../..", "a", "b", "c", "..", "d", ".", "e", "..", "..");
        this.testSegmentsByIteratorAndListAndArray("a/b/c", "a", "b", "c");
        this.testSegmentsByIteratorAndListAndArray("", new String[0]);
        this.testSegmentsByIteratorAndListAndArray(ROOT.getString(), new String[0]);
    }

    public void testSegmentsByIteratorAndListAndArray(String pathStr, String ... expectedSegmentStrings) {
        this.path = this.pathFactory.create(pathStr);
        Assert.assertThat((Object)expectedSegmentStrings.length, Is.is(this.path.size()));
        Path.Segment[] segmentArray = this.path.getSegmentsArray();
        List segmentList = this.path.getSegmentsList();
        Assert.assertThat((Object)segmentArray.length, Is.is(this.path.size()));
        Assert.assertThat((Object)segmentList.size(), Is.is(this.path.size()));
        Iterator iter = this.path.iterator();
        Iterator listIter = segmentList.iterator();
        for (int i = 0; i != this.path.size(); ++i) {
            Path.Segment expected = this.pathFactory.createSegment(expectedSegmentStrings[i]);
            Assert.assertThat((Object)this.path.getSegment(i), Is.is(expected));
            Assert.assertThat((Object)segmentArray[i], Is.is(expected));
            Assert.assertThat(segmentList.get(i), Is.is(expected));
            Assert.assertThat(iter.next(), Is.is(expected));
            Assert.assertThat(listIter.next(), Is.is(expected));
        }
        Assert.assertThat((Object)iter.hasNext(), Is.is(false));
        Assert.assertThat((Object)listIter.hasNext(), Is.is(false));
    }

    @Test
    public void shouldGetStringWithNamespaceUrisIfNoNamespaceRegistryIsProvided() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        Assert.assertThat((Object)this.path.getString(NO_OP_ENCODER), Is.is("/{http://www.modeshape.org/1.0}a/{}b/{http://www.modeshape.org/1.0}c/../{}d/./{http://www.modeshape.org/1.0}e/../.."));
    }

    @Test
    public void shouldGetStringWithNamespacePrefixesForAllNamesIfNamespaceRegistryIsProvided() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        Assert.assertThat((Object)this.path.getString(this.namespaceRegistry, NO_OP_ENCODER), Is.is("/mode:a/b/mode:c/../d/./mode:e/../.."));
        this.namespaceRegistry.register("dna2", this.validNamespaceUri);
        Assert.assertThat((Object)this.path.getString(this.namespaceRegistry, NO_OP_ENCODER), Is.is("/dna2:a/b/dna2:c/../d/./dna2:e/../.."));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailToReturnSubpathIfStartingIndexIsNegative() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        this.path.subpath(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailToReturnSubpathWithoutEndingIndexIfStartingIndexIsEqualToOrLargerThanSize() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        this.path.subpath(this.path.size() + 1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailToReturnSubpathWithEndingIndexIfStartingIndexIsEqualToOrLargerThanSize() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        this.path.subpath(this.path.size() + 1, this.path.size() + 2);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailToReturnSubpathIfEndingIndexIsSmallerThanStartingIndex() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        this.path.subpath(2, 1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailToReturnSubpathIfEndingIndexIsEqualToOrLargerThanSize() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        this.path.subpath(2, this.path.size() + 1);
    }

    @Test
    public void shouldReturnRootAsSubpathIfStartingIndexAndEndingIndexAreBothZero() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        Assert.assertThat((Object)this.path.subpath(0, 0), Is.is(ROOT));
    }

    @Test
    public void shouldReturnSubpathIfValidStartingIndexAndNoEndingIndexAreProvided() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        Assert.assertThat((Object)this.path.subpath(0), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:a", "b", "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(0), Is.is(this.path));
        Assert.assertThat((Object)this.path.subpath(0), Is.is(IsSame.sameInstance(this.path)));
        Assert.assertThat((Object)this.path.subpath(1), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "b", "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(2), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(3), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(4), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(5), IsPathContaining.hasSegments((PathFactory)this.pathFactory, ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(6), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(7), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "..", ".."));
        Assert.assertThat((Object)this.path.subpath(8), IsPathContaining.hasSegments((PathFactory)this.pathFactory, ".."));
        this.path = this.pathFactory.create("mode:a/b/mode:c/../d/./mode:e/../..");
        Assert.assertThat((Object)this.path.subpath(0), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:a", "b", "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(0), Is.is(this.path));
        Assert.assertThat((Object)this.path.subpath(0), Is.is(IsSame.sameInstance(this.path)));
        Assert.assertThat((Object)this.path.subpath(1), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "b", "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(2), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(3), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(4), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(5), IsPathContaining.hasSegments((PathFactory)this.pathFactory, ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(6), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(7), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "..", ".."));
        Assert.assertThat((Object)this.path.subpath(8), IsPathContaining.hasSegments((PathFactory)this.pathFactory, ".."));
    }

    @Test
    public void shouldReturnSubpathIfValidStartingIndexAndEndingIndexAreProvided() {
        this.path = this.pathFactory.create("/mode:a/b/mode:c/../d/./mode:e/../..");
        Assert.assertThat((Object)this.path.subpath(0, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:a", "b", "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(0, this.path.size()), Is.is(this.path));
        Assert.assertThat((Object)this.path.subpath(0, this.path.size()), Is.is(IsSame.sameInstance(this.path)));
        Assert.assertThat((Object)this.path.subpath(1, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "b", "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(2, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:c", "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(3, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "..", "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(4, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "d", ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(5, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, ".", "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(6, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:e", "..", ".."));
        Assert.assertThat((Object)this.path.subpath(7, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "..", ".."));
        Assert.assertThat((Object)this.path.subpath(8, this.path.size()), IsPathContaining.hasSegments((PathFactory)this.pathFactory, ".."));
        Assert.assertThat((Object)this.path.subpath(0, 2), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:a", "b"));
        Assert.assertThat((Object)this.path.subpath(1, 2), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "b"));
        Assert.assertThat((Object)this.path.subpath(1, 5), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "b", "mode:c", "..", "d"));
        Assert.assertThat((Object)this.path.subpath(2, 5), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "mode:c", "..", "d"));
        Assert.assertThat((Object)this.path.subpath(3, 5), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "..", "d"));
    }

    @Test
    public void shouldFindRelativePaths() {
        this.path = this.pathFactory.create("/a/b/c/d");
        Assert.assertThat((Object)this.path.relativeTo(this.pathFactory.create("/a/e/f")), Is.is(this.pathFactory.create("../../b/c/d")));
        Assert.assertThat((Object)this.path.relativeTo(this.pathFactory.create("/e/f")), Is.is(this.pathFactory.create("../../a/b/c/d")));
    }

    @Test(expected=InvalidPathException.class)
    public void shouldNotAllowFindingRelativePathsFromRelativePaths() {
        this.path = this.pathFactory.create("a/b/c/d");
        this.path.relativeTo(this.pathFactory.create("/e/f"));
    }

    @Test(expected=InvalidPathException.class)
    public void shouldNotResolveRelativePathToAnotherRelativePath() {
        this.path = this.pathFactory.create("/a/b/c/d");
        this.path.relativeTo(this.pathFactory.create("e/f"));
    }

    @Test(expected=InvalidPathException.class)
    public void shouldNotResolveRelativePathUsingAnAbsolutePath() {
        this.path = this.pathFactory.create("/a/b/c/d");
        this.path.resolve(this.pathFactory.create("/e/f"));
    }

    @Test
    public void shouldResolveRelativePathToAbsolutePath() {
        this.path = this.pathFactory.create("/a/b/c/d");
        this.path2 = this.path.resolve(this.pathFactory.create("../../e/f"));
        Assert.assertThat((Object)this.path2, Is.is(this.pathFactory.create("/a/b/e/f")));
        Assert.assertThat((Object)this.path2.isAbsolute(), Is.is(true));
        Assert.assertThat((Object)this.path2.isNormalized(), Is.is(true));
    }

    @Test
    public void shouldOrderPathsCorrectly() {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(this.pathFactory.create("/a"));
        paths.add(this.pathFactory.create("/a/b"));
        paths.add(this.pathFactory.create("/a/b/alpha"));
        paths.add(this.pathFactory.create("/a/b/beta"));
        paths.add(this.pathFactory.create("/a/b/mode:mixinTypes"));
        paths.add(this.pathFactory.create("/a/b/mode:name"));
        paths.add(this.pathFactory.create("/a/b/mode:primaryType"));
        paths.add(this.pathFactory.create("/a/c[1]"));
        paths.add(this.pathFactory.create("/a/c[1]/alpha"));
        paths.add(this.pathFactory.create("/a/c[1]/beta"));
        paths.add(this.pathFactory.create("/a/c[1]/mode:mixinTypes"));
        paths.add(this.pathFactory.create("/a/c[1]/mode:name"));
        paths.add(this.pathFactory.create("/a/c[1]/mode:primaryType"));
        paths.add(this.pathFactory.create("/a/c[2]"));
        paths.add(this.pathFactory.create("/a/c[2]/alpha"));
        paths.add(this.pathFactory.create("/a/c[2]/beta"));
        paths.add(this.pathFactory.create("/a/c[2]/mode:mixinTypes"));
        paths.add(this.pathFactory.create("/a/c[2]/mode:name"));
        paths.add(this.pathFactory.create("/a/c[2]/mode:primaryType"));
        ArrayList randomizedPaths = new ArrayList(paths);
        Collections.shuffle(randomizedPaths);
        Assert.assertThat(randomizedPaths, Is.is(IsNot.not(paths)));
        Collections.sort(randomizedPaths);
        Assert.assertThat(randomizedPaths, Is.is(paths));
    }

    @Test
    public void shouldGetNormalizedPathOfSelfShouldBeSame() {
        Assert.assertThat((Object)this.pathFactory.create(".").getNormalizedPath(), Is.is(this.pathFactory.create(".")));
        Assert.assertThat((Object)this.pathFactory.create("./").getNormalizedPath(), Is.is(this.pathFactory.create(".")));
        Assert.assertThat((Object)this.pathFactory.create("./././").getNormalizedPath(), Is.is(this.pathFactory.create(".")));
    }

    @Test
    public void shouldGetNormalizedPathWithParentReferences() {
        Assert.assertThat((Object)this.pathFactory.create("..").getNormalizedPath(), Is.is(this.pathFactory.create("..")));
        Assert.assertThat((Object)this.pathFactory.create("../").getNormalizedPath(), Is.is(this.pathFactory.create("../")));
        Assert.assertThat((Object)this.pathFactory.create("../../../../../..").getNormalizedPath(), Is.is(this.pathFactory.create("../../../../../..")));
    }

    @Test
    public void shouldGetRelativePathUsingSelf() {
        this.path = this.pathFactory.create("/a/b/c/d/e/f");
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create(".")), Is.is(IsSame.sameInstance(this.path)));
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("././.")), Is.is(IsSame.sameInstance(this.path)));
    }

    @Test
    public void shouldResolveRelativePathToParent() {
        this.path = this.pathFactory.create("/a/b/c/d/e/f");
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("..")), Is.is(this.path.getParent()));
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("..")), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b", "c", "d", "e"));
    }

    @Test
    public void shouldResolveRelativePaths() {
        this.path = this.pathFactory.create("/a/b/c/d/e/f");
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("../../../../../..")), Is.is(IsSame.sameInstance(ROOT)));
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("../..")), Is.is(this.path.getParent().getParent()));
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("../..")), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b", "c", "d"));
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("../x/../y/../z/..")), Is.is(this.path.getParent()));
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("../x/../y/../z/..")), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b", "c", "d", "e"));
        Assert.assertThat((Object)this.path.resolve(this.pathFactory.create("../x")), IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b", "c", "d", "e", "x"));
    }

    public void shouldResolveNonAbsolutePaths() {
        this.path = this.pathFactory.create("a/b/c");
        Assert.assertThat((Object)this.path, IsPathContaining.hasSegments((PathFactory)this.pathFactory, "a", "b", "c"));
    }

    @Test
    public void shouldConvertPathToString() {
        Jsr283Encoder encoder = new Jsr283Encoder();
        TextEncoder delimEncoder = new TextEncoder(){

            public String encode(String text) {
                if ("/".equals(text)) {
                    return "\\/";
                }
                if (":".equals(text)) {
                    return "\\:";
                }
                if ("{".equals(text)) {
                    return "\\{";
                }
                if ("}".equals(text)) {
                    return "\\}";
                }
                return text;
            }
        };
        Path path = this.pathFactory.create("a/b/c");
        Assert.assertThat((Object)path.getString(this.namespaceRegistry), Is.is("a/b/c"));
        Assert.assertThat((Object)path.getString(this.namespaceRegistry, (TextEncoder)encoder), Is.is("a/b/c"));
        Assert.assertThat((Object)path.getString(this.namespaceRegistry, (TextEncoder)encoder, delimEncoder), Is.is("a\\/b\\/c"));
        path = this.pathFactory.create("/a/b/c");
        Assert.assertThat((Object)path.getString(this.namespaceRegistry), Is.is("/a/b/c"));
        Assert.assertThat((Object)path.getString(this.namespaceRegistry, (TextEncoder)encoder), Is.is("/a/b/c"));
        Assert.assertThat((Object)path.getString(this.namespaceRegistry, (TextEncoder)encoder, delimEncoder), Is.is("\\/a\\/b\\/c"));
        path = this.pathFactory.create("/mode:a/b/c");
        Assert.assertThat((Object)path.getString((TextEncoder)encoder), Is.is("/{" + encoder.encode("http://www.modeshape.org/1.0") + "}a/{}b/{}c"));
        Assert.assertThat((Object)path.getString(null, (TextEncoder)encoder, delimEncoder), Is.is("\\/\\{" + encoder.encode("http://www.modeshape.org/1.0") + "\\}a\\/\\{\\}b\\/\\{\\}c"));
        Assert.assertThat((Object)path.getString(this.namespaceRegistry), Is.is("/mode:a/b/c"));
        Assert.assertThat((Object)path.getString(this.namespaceRegistry, (TextEncoder)encoder), Is.is("/mode:a/b/c"));
        Assert.assertThat((Object)path.getString(this.namespaceRegistry, (TextEncoder)encoder, delimEncoder), Is.is("\\/mode\\:a\\/b\\/c"));
    }
}

