/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.ArrayList;
import java.util.Iterator;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.graph.property.InvalidPathException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.basic.AbstractPathTest;
import org.modeshape.graph.property.basic.BasicName;
import org.modeshape.graph.property.basic.BasicPath;
import org.modeshape.graph.property.basic.BasicPathSegment;
import org.modeshape.graph.property.basic.RootPath;

public class RootPathTest
extends AbstractPathTest {
    protected Path root;

    @Override
    @Before
    public void beforeEach() {
        super.beforeEach();
        this.path = RootPath.INSTANCE;
        this.root = this.path;
    }

    @Test
    public void shouldReturnRootForLowestCommonAncestorWithAnyNodePath() {
        Path other = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)other.isRoot()).thenReturn((Object)true);
        Assert.assertThat((Object)this.root.getCommonAncestor(other).isRoot(), Is.is(true));
        Mockito.when((Object)other.isRoot()).thenReturn((Object)false);
        Assert.assertThat((Object)this.root.getCommonAncestor(other).isRoot(), Is.is(true));
    }

    @Test
    public void shouldConsiderRootToBeAncestorOfEveryNodeExceptRoot() {
        Path other = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)other.size()).thenReturn((Object)1);
        Assert.assertThat((Object)this.root.isAncestorOf(other), Is.is(true));
        Assert.assertThat((Object)this.root.isAncestorOf(this.root), Is.is(false));
    }

    @Test
    public void shouldNotConsiderRootNodeToBeDecendantOfAnyNode() {
        Path other = (Path)Mockito.mock(Path.class);
        Assert.assertThat((Object)this.root.isDecendantOf(other), Is.is(false));
        Assert.assertThat((Object)this.root.isDecendantOf(this.root), Is.is(false));
    }

    @Test
    public void shouldConsiderTwoRootNodesToHaveSameAncestor() {
        Assert.assertThat((Object)this.root.hasSameAncestor(this.root), Is.is(true));
    }

    @Test
    public void shouldBeNormalized() {
        Assert.assertThat((Object)this.root.isNormalized(), Is.is(true));
    }

    @Test
    public void shouldReturnSelfForGetNormalized() {
        Assert.assertThat((Object)this.root.getNormalizedPath(), Is.is(IsSame.sameInstance(this.root)));
    }

    @Test
    public void shouldReturnSelfForGetCanonicalPath() {
        Assert.assertThat((Object)this.root.getCanonicalPath(), Is.is(IsSame.sameInstance(this.root)));
    }

    @Test
    public void shouldReturnSizeOfZero() {
        Assert.assertThat((Object)this.root.size(), Is.is(0));
    }

    @Override
    @Test(expected=IllegalStateException.class)
    public void shouldReturnImmutableSegmentsIterator() {
        this.root.iterator().remove();
    }

    @Test
    public void shouldReturnEmptyIteratorOverSegments() {
        Assert.assertThat((Object)this.root.iterator(), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.root.iterator().hasNext(), Is.is(false));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailToReturnSegmentAtIndexZero() {
        this.root.getSegment(0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldFailToReturnSegmentAtPositiveIndex() {
        this.root.getSegment(1);
    }

    @Test
    public void shouldReturnEmptySegmentsArray() {
        Assert.assertThat((Object)this.root.getSegmentsArray(), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.root.getSegmentsArray().length, Is.is(0));
    }

    @Test
    public void shouldReturnEmptySegmentsList() {
        Assert.assertThat((Object)this.root.getSegmentsList(), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.root.getSegmentsList().isEmpty(), Is.is(true));
    }

    @Test
    public void shouldAlwaysReturnPathWithSingleSlashForGetString() {
        NamespaceRegistry registry = (NamespaceRegistry)Mockito.mock(NamespaceRegistry.class);
        TextEncoder encoder = (TextEncoder)Mockito.mock(TextEncoder.class);
        Mockito.when((Object)encoder.encode("/")).thenReturn((Object)"/");
        Assert.assertThat((Object)this.root.getString(), Is.is("/"));
        Assert.assertThat((Object)this.root.getString(registry), Is.is("/"));
        Assert.assertThat((Object)this.root.getString(registry, encoder), Is.is("/"));
        Assert.assertThat((Object)this.root.getString(registry, encoder, encoder), Is.is("/"));
        Assert.assertThat((Object)this.root.getString(encoder), Is.is("/"));
    }

    @Test
    public void shouldAllowNullNamespaceRegistryWithNonNullTextEncodersSinceRegistryIsNotNeeded() {
        TextEncoder encoder = (TextEncoder)Mockito.mock(TextEncoder.class);
        Mockito.when((Object)encoder.encode("/")).thenReturn((Object)"/");
        Assert.assertThat((Object)this.root.getString((NamespaceRegistry)null, encoder, encoder), Is.is("/"));
    }

    @Test
    public void shouldAllowNullTextEncoder() {
        Assert.assertThat((Object)this.root.getString((TextEncoder)null), Is.is("/"));
    }

    @Test
    public void shouldNotAllowNullTextEncoderWithNonNullNamespaceRegistry() {
        NamespaceRegistry registry = (NamespaceRegistry)Mockito.mock(NamespaceRegistry.class);
        Assert.assertThat((Object)this.root.getString(registry, (TextEncoder)null), Is.is("/"));
    }

    @Test
    public void shouldNotAllowNullTextEncoderForDelimiterWithNonNullNamespaceRegistry() {
        NamespaceRegistry registry = (NamespaceRegistry)Mockito.mock(NamespaceRegistry.class);
        TextEncoder encoder = (TextEncoder)Mockito.mock(TextEncoder.class);
        Assert.assertThat((Object)this.root.getString(registry, encoder, (TextEncoder)null), Is.is("/"));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldNotAllowSubpathStartingAtOne() {
        this.root.subpath(1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldNotAllowSubpathStartingAtMoreThanOne() {
        this.root.subpath(2);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void shouldNotAllowSubpathEndingAtMoreThanZero() {
        this.root.subpath(0, 1);
    }

    @Test
    public void shouldReturnRelativePathConsistingOfSameNumberOfParentReferencesAsSizeOfSuppliedPath() {
        ArrayList<BasicPathSegment> segments = new ArrayList<BasicPathSegment>();
        segments.add(new BasicPathSegment((Name)new BasicName("http://example.com", "a")));
        BasicPath other = new BasicPath(segments, true);
        Assert.assertThat((Object)this.root.relativeTo((Path)other).toString(), Is.is(".."));
        segments.add(new BasicPathSegment((Name)new BasicName("http://example.com", "b")));
        other = new BasicPath(segments, true);
        Assert.assertThat((Object)this.root.relativeTo((Path)other).toString(), Is.is("../.."));
        String expected = "..";
        segments.clear();
        for (int i = 1; i != 100; ++i) {
            segments.add(new BasicPathSegment((Name)new BasicName("http://example.com", "b" + i)));
            other = new BasicPath(segments, true);
            Assert.assertThat((Object)this.root.relativeTo((Path)other).toString(), Is.is(expected));
            expected = expected + "/..";
        }
    }

    @Test
    public void shouldResolveAllRelativePathsToTheirAbsolutePath() {
        ArrayList<BasicPathSegment> segments = new ArrayList<BasicPathSegment>();
        segments.add(new BasicPathSegment((Name)new BasicName("http://example.com", "a")));
        Path other = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)other.isAbsolute()).thenReturn((Object)false);
        Mockito.when((Object)other.getSegmentsList()).thenReturn(segments);
        Mockito.when((Object)other.getNormalizedPath()).thenReturn((Object)other);
        Path resolved = this.root.resolve(other);
        Assert.assertThat((Object)resolved.getSegmentsList(), Is.is(segments));
        Assert.assertThat((Object)resolved.isAbsolute(), Is.is(true));
    }

    @Test(expected=InvalidPathException.class)
    public void shouldNotResolveRelativePathUsingAnAbsolutePath() {
        Path other = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)other.isAbsolute()).thenReturn((Object)true);
        this.root.resolve(other);
    }

    @Test
    public void shouldAlwaysConsiderRootAsLessThanAnyPathOtherThanRoot() {
        Path other = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)other.isRoot()).thenReturn((Object)false);
        Assert.assertThat((Object)this.root.compareTo((Object)other), Is.is(-1));
        Assert.assertThat((Object)this.root.equals(other), Is.is(false));
    }

    @Test
    public void shouldAlwaysConsiderRootAsEqualToAnyOtherRoot() {
        Path other = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)other.isRoot()).thenReturn((Object)true);
        Assert.assertThat((Object)this.root.compareTo((Object)other), Is.is(0));
        Assert.assertThat((Object)this.root.equals(other), Is.is(true));
        Assert.assertThat((Object)this.root.equals(this.root), Is.is(true));
    }

    @Test
    public void shouldReturnIteratorWithRootPathFromPathsFromRoot() {
        Iterator iter = this.root.pathsFromRoot();
        Assert.assertThat((Object)iter.hasNext(), Is.is(true));
        Assert.assertThat(iter.next(), Is.is(this.root));
        Assert.assertThat((Object)iter.hasNext(), Is.is(false));
    }
}

