/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.parse;

import java.util.List;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.text.TokenStream;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.query.model.And;
import org.modeshape.graph.query.model.Between;
import org.modeshape.graph.query.model.BindVariableName;
import org.modeshape.graph.query.model.ChildNode;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.DescendantNode;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.FullTextSearch;
import org.modeshape.graph.query.model.FullTextSearchScore;
import org.modeshape.graph.query.model.Join;
import org.modeshape.graph.query.model.Length;
import org.modeshape.graph.query.model.Limit;
import org.modeshape.graph.query.model.Literal;
import org.modeshape.graph.query.model.LowerCase;
import org.modeshape.graph.query.model.NamedSelector;
import org.modeshape.graph.query.model.NodeDepth;
import org.modeshape.graph.query.model.NodeLocalName;
import org.modeshape.graph.query.model.NodeName;
import org.modeshape.graph.query.model.NodePath;
import org.modeshape.graph.query.model.Not;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.Or;
import org.modeshape.graph.query.model.Order;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.PropertyExistence;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.ReferenceValue;
import org.modeshape.graph.query.model.SameNode;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.Source;
import org.modeshape.graph.query.model.StaticOperand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.model.UpperCase;
import org.modeshape.graph.query.parse.FullTextSearchParserTest;
import org.modeshape.graph.query.parse.SqlQueryParser;

public class SqlQueryParserTest {
    private TypeSystem typeSystem;
    private SqlQueryParser parser;

    @Before
    public void beforeEach() {
        this.typeSystem = new ExecutionContext().getValueFactories().getTypeSystem();
        this.parser = new SqlQueryParser();
    }

    @Test
    public void shouldParseNominalQueries() {
        this.parse("SELECT * FROM tableA");
        this.parse("SELECT column1 FROM tableA");
        this.parse("SELECT tableA.column1 FROM tableA");
        this.parse("SELECT tableA.column1, tableB.column2 FROM tableA JOIN tableB ON tableA.id = tableB.id");
        this.parse("SELECT tableA.column1, tableB.column2 FROM tableA INNER JOIN tableB ON tableA.id = tableB.id");
        this.parse("SELECT tableA.column1, tableB.column2 FROM tableA OUTER JOIN tableB ON tableA.id = tableB.id");
        this.parse("SELECT tableA.column1, tableB.column2 FROM tableA LEFT OUTER JOIN tableB ON tableA.id = tableB.id");
        this.parse("SELECT tableA.column1, tableB.column2 FROM tableA RIGHT OUTER JOIN tableB ON tableA.id = tableB.id");
    }

    @Test
    public void shouldParseQueriesWithNonSqlColumnNames() {
        this.parse("SELECT * FROM [dna:tableA]");
        this.parse("SELECT [jcr:column1] FROM [dna:tableA]");
        this.parse("SELECT 'jcr:column1' FROM 'dna:tableA'");
        this.parse("SELECT \"jcr:column1\" FROM \"dna:tableA\"");
    }

    @Test
    public void shouldParseQueriesSelectingFromAllTables() {
        this.parse("SELECT * FROM __AllTables__");
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseQueriesWithNoFromClause() {
        this.parse("SELECT 'jcr:column1'");
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseQueriesWithIncompleteFromClause() {
        this.parse("SELECT 'jcr:column1' FROM  ");
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseQueriesWithUnmatchedSingleQuoteCharacters() {
        this.parse("SELECT 'jcr:column1' FROM \"dna:tableA'");
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseQueriesWithUnmatchedDoubleQuoteCharacters() {
        this.parse("SELECT \"jcr:column1' FROM \"dna:tableA\"");
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseQueriesWithUnmatchedBracketQuoteCharacters() {
        this.parse("SELECT [jcr:column1' FROM [dna:tableA]");
    }

    @Test
    public void shouldParseQueriesWithSelectStar() {
        this.parse("SELECT * FROM tableA");
        this.parse("SELECT tableA.* FROM tableA");
        this.parse("SELECT tableA.column1, tableB.* FROM tableA JOIN tableB ON tableA.id = tableB.id");
        this.parse("SELECT tableA.*, tableB.column2 FROM tableA JOIN tableB ON tableA.id = tableB.id");
        this.parse("SELECT tableA.*, tableB.* FROM tableA JOIN tableB ON tableA.id = tableB.id");
    }

    @Test
    public void shouldParseQueriesWithAllKindsOfJoins() {
        this.parse("SELECT tableA.column1, tableB.column2 FROM tableA JOIN tableB ON tableA.id = tableB.id");
        this.parse("SELECT tableA.column1, tableB.column2 FROM tableA INNER JOIN tableB ON tableA.id = tableB.id");
        this.parse("SELECT tableA.column1, tableB.column2 FROM tableA OUTER JOIN tableB ON tableA.id = tableB.id");
        this.parse("SELECT tableA.column1, tableB.column2 FROM tableA LEFT OUTER JOIN tableB ON tableA.id = tableB.id");
        this.parse("SELECT tableA.column1, tableB.column2 FROM tableA RIGHT OUTER JOIN tableB ON tableA.id = tableB.id");
        this.parse("SELECT tableA.column1, tableB.column2 FROM tableA FULL OUTER JOIN tableB ON tableA.id = tableB.id");
        this.parse("SELECT tableA.column1, tableB.column2 FROM tableA CROSS JOIN tableB ON tableA.id = tableB.id");
    }

    @Test
    public void shouldParseQueriesWithMultipleJoins() {
        this.parse("SELECT * FROM tableA JOIN tableB ON tableA.id = tableB.id");
        this.parse("SELECT * FROM tableA JOIN tableB ON tableA.id = tableB.id JOIN tableC ON tableA.id2 = tableC.id2");
    }

    @Test
    public void shouldParseQueriesWithEquiJoinCriteria() {
        this.parse("SELECT tableA.column1, tableB.column2 FROM tableA JOIN tableB ON tableA.id = tableB.id");
        this.parse("SELECT * FROM tableA JOIN tableB ON tableA.id = tableB.id JOIN tableC ON tableA.id2 = tableC.id2");
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseEquiJoinCriteriaMissingPropertyName() {
        this.parse("SELECT tableA.column1, tableB.column2 FROM tableA JOIN tableB ON tableA = tableB.id");
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseEquiJoinCriteriaMissingTableName() {
        this.parse("SELECT tableA.column1, tableB.column2 FROM tableA JOIN tableB ON column1 = tableB.id");
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseEquiJoinCriteriaMissingEquals() {
        this.parse("SELECT tableA.column1, tableB.column2 FROM tableA JOIN tableB ON column1 tableB.id");
    }

    @Test
    public void shouldParseQueriesOnMultpleLines() {
        this.parse("SELECT * \nFROM tableA");
        this.parse("SELECT \ncolumn1 \nFROM tableA");
        this.parse("SELECT \ntableA.column1 \nFROM\n tableA");
        this.parse("SELECT tableA.\ncolumn1, \ntableB.column2 \nFROM tableA JOIN \ntableB ON tableA.id \n= tableB.\nid");
    }

    @Test
    public void shouldParseQueriesThatUseDifferentCaseForKeywords() {
        this.parse("select * from tableA");
        this.parse("SeLeCt * from tableA");
        this.parse("select column1 from tableA");
        this.parse("select tableA.column1 from tableA");
        this.parse("select tableA.column1, tableB.column2 from tableA join tableB on tableA.id = tableB.id");
    }

    @Test
    public void shouldParseUnionQueries() {
        this.parse("SELECT * FROM tableA UNION SELECT * FROM tableB");
        this.parse("SELECT * FROM tableA UNION ALL SELECT * FROM tableB");
        this.parse("SELECT * FROM tableA UNION SELECT * FROM tableB UNION SELECT * FROM tableC");
        this.parse("SELECT * FROM tableA UNION ALL SELECT * FROM tableB UNION SELECT * FROM tableC");
    }

    @Test
    public void shouldParseIntersectQueries() {
        this.parse("SELECT * FROM tableA INTERSECT SELECT * FROM tableB");
        this.parse("SELECT * FROM tableA INTERSECT ALL SELECT * FROM tableB");
        this.parse("SELECT * FROM tableA INTERSECT SELECT * FROM tableB INTERSECT SELECT * FROM tableC");
        this.parse("SELECT * FROM tableA INTERSECT ALL SELECT * FROM tableB INTERSECT ALL SELECT * FROM tableC");
    }

    @Test
    public void shouldParseExceptQueries() {
        this.parse("SELECT * FROM tableA EXCEPT SELECT * FROM tableB");
        this.parse("SELECT * FROM tableA EXCEPT ALL SELECT * FROM tableB");
        this.parse("SELECT * FROM tableA EXCEPT SELECT * FROM tableB EXCEPT SELECT * FROM tableC");
        this.parse("SELECT * FROM tableA EXCEPT ALL SELECT * FROM tableB EXCEPT ALL SELECT * FROM tableC");
    }

    @Test
    public void shouldParseConstraintFromStringWithValidExpressions() {
        this.assertParseConstraint("ISSAMENODE('/a/b')");
        this.assertParseConstraint("ISSAMENODE('/a/b') AND NOT(ISCHILDNODE('/parent'))");
        this.assertParseConstraint("ISSAMENODE('/a/b') AND (NOT(ISCHILDNODE('/parent')))");
        this.assertParseConstraint("ISSAMENODE('/a/b') AND (NOT(tableA.id < 1234)))");
    }

    protected void assertParseConstraint(String expression) {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        this.parser.parseConstraint(this.tokens(expression), this.typeSystem, (Source)selector);
    }

    @Test
    public void shouldParseConstraintFromStringWithValidBetweenExpressionUsing() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        Constraint constraint = this.parser.parseConstraint(this.tokens("tableA.id BETWEEN 'lower' AND 'upper'"), this.typeSystem, (Source)selector);
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(Between.class)));
        Between between = (Between)constraint;
        Assert.assertThat((Object)between.isLowerBoundIncluded(), Is.is(true));
        Assert.assertThat((Object)between.isUpperBoundIncluded(), Is.is(true));
        Assert.assertThat((Object)between.operand(), Is.is(IsInstanceOf.instanceOf(PropertyValue.class)));
        PropertyValue operand = (PropertyValue)between.operand();
        Assert.assertThat((Object)operand.selectorName(), Is.is(selector.name()));
        Assert.assertThat((Object)operand.propertyName(), Is.is("id"));
        Assert.assertThat((Object)between.lowerBound(), Is.is(IsInstanceOf.instanceOf(Literal.class)));
        Assert.assertThat((Object)between.lowerBound(), Is.is(IsInstanceOf.instanceOf(Literal.class)));
        Assert.assertThat((Object)((Literal)between.lowerBound()), Is.is(this.literal("lower")));
        Assert.assertThat((Object)((Literal)between.upperBound()), Is.is(this.literal("upper")));
    }

    @Test
    public void shouldParseConstraintFromStringWithValidBetweenExpressionUsingExclusiveAndExclusive() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        Constraint constraint = this.parser.parseConstraint(this.tokens("tableA.id BETWEEN 'lower' EXCLUSIVE AND 'upper' EXCLUSIVE"), this.typeSystem, (Source)selector);
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(Between.class)));
        Between between = (Between)constraint;
        Assert.assertThat((Object)between.isLowerBoundIncluded(), Is.is(false));
        Assert.assertThat((Object)between.isUpperBoundIncluded(), Is.is(false));
        Assert.assertThat((Object)between.operand(), Is.is(IsInstanceOf.instanceOf(PropertyValue.class)));
        PropertyValue operand = (PropertyValue)between.operand();
        Assert.assertThat((Object)operand.selectorName(), Is.is(selector.name()));
        Assert.assertThat((Object)operand.propertyName(), Is.is("id"));
        Assert.assertThat((Object)between.lowerBound(), Is.is(IsInstanceOf.instanceOf(Literal.class)));
        Assert.assertThat((Object)between.lowerBound(), Is.is(IsInstanceOf.instanceOf(Literal.class)));
        Assert.assertThat((Object)((Literal)between.lowerBound()), Is.is(this.literal("lower")));
        Assert.assertThat((Object)((Literal)between.upperBound()), Is.is(this.literal("upper")));
    }

    @Test
    public void shouldParseConstraintFromStringWithValidBetweenExpressionUsingInclusiveAndExclusive() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        Constraint constraint = this.parser.parseConstraint(this.tokens("tableA.id BETWEEN 'lower' AND 'upper' EXCLUSIVE"), this.typeSystem, (Source)selector);
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(Between.class)));
        Between between = (Between)constraint;
        Assert.assertThat((Object)between.isLowerBoundIncluded(), Is.is(true));
        Assert.assertThat((Object)between.isUpperBoundIncluded(), Is.is(false));
        Assert.assertThat((Object)between.operand(), Is.is(IsInstanceOf.instanceOf(PropertyValue.class)));
        PropertyValue operand = (PropertyValue)between.operand();
        Assert.assertThat((Object)operand.selectorName(), Is.is(selector.name()));
        Assert.assertThat((Object)operand.propertyName(), Is.is("id"));
        Assert.assertThat((Object)between.lowerBound(), Is.is(IsInstanceOf.instanceOf(Literal.class)));
        Assert.assertThat((Object)between.lowerBound(), Is.is(IsInstanceOf.instanceOf(Literal.class)));
        Assert.assertThat((Object)((Literal)between.lowerBound()), Is.is(this.literal("lower")));
        Assert.assertThat((Object)((Literal)between.upperBound()), Is.is(this.literal("upper")));
    }

    @Test
    public void shouldParseConstraintFromStringWithValidBetweenExpressionUsingExclusiveAndInclusive() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        Constraint constraint = this.parser.parseConstraint(this.tokens("tableA.id BETWEEN 'lower' EXCLUSIVE AND 'upper'"), this.typeSystem, (Source)selector);
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(Between.class)));
        Between between = (Between)constraint;
        Assert.assertThat((Object)between.isLowerBoundIncluded(), Is.is(false));
        Assert.assertThat((Object)between.isUpperBoundIncluded(), Is.is(true));
        Assert.assertThat((Object)between.operand(), Is.is(IsInstanceOf.instanceOf(PropertyValue.class)));
        PropertyValue operand = (PropertyValue)between.operand();
        Assert.assertThat((Object)operand.selectorName(), Is.is(selector.name()));
        Assert.assertThat((Object)operand.propertyName(), Is.is("id"));
        Assert.assertThat((Object)between.lowerBound(), Is.is(IsInstanceOf.instanceOf(Literal.class)));
        Assert.assertThat((Object)between.lowerBound(), Is.is(IsInstanceOf.instanceOf(Literal.class)));
        Assert.assertThat((Object)((Literal)between.lowerBound()), Is.is(this.literal("lower")));
        Assert.assertThat((Object)((Literal)between.upperBound()), Is.is(this.literal("upper")));
    }

    @Test
    public void shouldParseConstraintFromStringWithValidNotBetweenExpression() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        Constraint constraint = this.parser.parseConstraint(this.tokens("tableA.id NOT BETWEEN 'lower' AND 'upper'"), this.typeSystem, (Source)selector);
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(Not.class)));
        constraint = ((Not)constraint).constraint();
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(Between.class)));
        Between between = (Between)constraint;
        Assert.assertThat((Object)between.isLowerBoundIncluded(), Is.is(true));
        Assert.assertThat((Object)between.isUpperBoundIncluded(), Is.is(true));
        Assert.assertThat((Object)between.operand(), Is.is(IsInstanceOf.instanceOf(PropertyValue.class)));
        PropertyValue operand = (PropertyValue)between.operand();
        Assert.assertThat((Object)operand.selectorName(), Is.is(selector.name()));
        Assert.assertThat((Object)operand.propertyName(), Is.is("id"));
        Assert.assertThat((Object)between.lowerBound(), Is.is(IsInstanceOf.instanceOf(Literal.class)));
        Assert.assertThat((Object)between.lowerBound(), Is.is(IsInstanceOf.instanceOf(Literal.class)));
        Assert.assertThat((Object)((Literal)between.lowerBound()), Is.is(this.literal("lower")));
        Assert.assertThat((Object)((Literal)between.upperBound()), Is.is(this.literal("upper")));
    }

    @Test
    public void shouldParseConstraintFromStringWithOuterParentheses() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        Constraint constraint = this.parser.parseConstraint(this.tokens("( ISSAMENODE('/a/b') )"), this.typeSystem, (Source)selector);
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(SameNode.class)));
        SameNode same = (SameNode)constraint;
        Assert.assertThat((Object)same.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)same.path(), Is.is("/a/b"));
    }

    @Test
    public void shouldParseConstraintFromStringWithMultipleOuterParentheses() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        Constraint constraint = this.parser.parseConstraint(this.tokens("((( ISSAMENODE('/a/b') )))"), this.typeSystem, (Source)selector);
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(SameNode.class)));
        SameNode same = (SameNode)constraint;
        Assert.assertThat((Object)same.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)same.path(), Is.is("/a/b"));
    }

    @Test
    public void shouldParseConstraintFromStringWithParenthesesAndConjunctionAndDisjunctions() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        Constraint constraint = this.parser.parseConstraint(this.tokens("ISSAMENODE('/a/b') OR (ISSAMENODE('/c/d') AND ISSAMENODE('/e/f'))"), this.typeSystem, (Source)selector);
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(Or.class)));
        Or or = (Or)constraint;
        Assert.assertThat((Object)or.left(), Is.is(IsInstanceOf.instanceOf(SameNode.class)));
        SameNode first = (SameNode)or.left();
        Assert.assertThat((Object)first.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)first.path(), Is.is("/a/b"));
        Assert.assertThat((Object)or.right(), Is.is(IsInstanceOf.instanceOf(And.class)));
        And and = (And)or.right();
        Assert.assertThat((Object)and.left(), Is.is(IsInstanceOf.instanceOf(SameNode.class)));
        SameNode second = (SameNode)and.left();
        Assert.assertThat((Object)second.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)second.path(), Is.is("/c/d"));
        Assert.assertThat((Object)and.right(), Is.is(IsInstanceOf.instanceOf(SameNode.class)));
        SameNode third = (SameNode)and.right();
        Assert.assertThat((Object)third.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)third.path(), Is.is("/e/f"));
    }

    @Test
    public void shouldParseConstraintFromStringWithAndExpressionWithNoParentheses() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        Constraint constraint = this.parser.parseConstraint(this.tokens("ISSAMENODE('/a/b/c') AND CONTAINS(p1,term1)"), this.typeSystem, (Source)selector);
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(And.class)));
        And and = (And)constraint;
        Assert.assertThat((Object)and.left(), Is.is(IsInstanceOf.instanceOf(SameNode.class)));
        SameNode same = (SameNode)and.left();
        Assert.assertThat((Object)same.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)same.path(), Is.is("/a/b/c"));
        Assert.assertThat((Object)and.right(), Is.is(IsInstanceOf.instanceOf(FullTextSearch.class)));
        FullTextSearch search = (FullTextSearch)and.right();
        Assert.assertThat((Object)search.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)search.propertyName(), Is.is("p1"));
        Assert.assertThat((Object)search.fullTextSearchExpression(), Is.is("term1"));
    }

    @Test
    public void shouldParseConstraintFromStringWithMultipleAndExpressions() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        Constraint constraint = this.parser.parseConstraint(this.tokens("ISSAMENODE('/a/b/c') AND CONTAINS(p1,term1) AND CONTAINS(p2,term2)"), this.typeSystem, (Source)selector);
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(And.class)));
        And and = (And)constraint;
        Assert.assertThat((Object)and.left(), Is.is(IsInstanceOf.instanceOf(SameNode.class)));
        SameNode same = (SameNode)and.left();
        Assert.assertThat((Object)same.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)same.path(), Is.is("/a/b/c"));
        Assert.assertThat((Object)and.right(), Is.is(IsInstanceOf.instanceOf(And.class)));
        And secondAnd = (And)and.right();
        Assert.assertThat((Object)secondAnd.left(), Is.is(IsInstanceOf.instanceOf(FullTextSearch.class)));
        FullTextSearch search1 = (FullTextSearch)secondAnd.left();
        Assert.assertThat((Object)search1.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)search1.propertyName(), Is.is("p1"));
        Assert.assertThat((Object)search1.fullTextSearchExpression(), Is.is("term1"));
        Assert.assertThat((Object)secondAnd.right(), Is.is(IsInstanceOf.instanceOf(FullTextSearch.class)));
        FullTextSearch search2 = (FullTextSearch)secondAnd.right();
        Assert.assertThat((Object)search2.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)search2.propertyName(), Is.is("p2"));
        Assert.assertThat((Object)search2.fullTextSearchExpression(), Is.is("term2"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithAndExpressionWithNoSecondConstraint() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        this.parser.parseConstraint(this.tokens("ISSAMENODE('/a/b/c') AND WHAT THE HECK IS THIS"), this.typeSystem, (Source)selector);
    }

    @Test
    public void shouldParseConstraintFromStringWithOrExpressionWithNoParentheses() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        Constraint constraint = this.parser.parseConstraint(this.tokens("ISSAMENODE('/a/b/c') OR CONTAINS(p1,term1)"), this.typeSystem, (Source)selector);
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(Or.class)));
        Or or = (Or)constraint;
        Assert.assertThat((Object)or.left(), Is.is(IsInstanceOf.instanceOf(SameNode.class)));
        SameNode same = (SameNode)or.left();
        Assert.assertThat((Object)same.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)same.path(), Is.is("/a/b/c"));
        Assert.assertThat((Object)or.right(), Is.is(IsInstanceOf.instanceOf(FullTextSearch.class)));
        FullTextSearch search = (FullTextSearch)or.right();
        Assert.assertThat((Object)search.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)search.propertyName(), Is.is("p1"));
        Assert.assertThat((Object)search.fullTextSearchExpression(), Is.is("term1"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithOrExpressionWithNoSecondConstraint() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        this.parser.parseConstraint(this.tokens("ISSAMENODE('/a/b/c') OR WHAT THE HECK IS THIS"), this.typeSystem, (Source)selector);
    }

    @Test
    public void shouldParseConstraintFromStringWithNotSameNodeExpression() {
        Constraint constraint = this.parser.parseConstraint(this.tokens("NOT(ISSAMENODE(tableA,'/a/b/c'))"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(Not.class)));
        Not not = (Not)constraint;
        Assert.assertThat((Object)not.constraint(), Is.is(IsInstanceOf.instanceOf(SameNode.class)));
        SameNode same = (SameNode)not.constraint();
        Assert.assertThat((Object)same.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)same.path(), Is.is("/a/b/c"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithNotConstraintWithOutOpeningParenthesis() {
        this.parser.parseConstraint(this.tokens("NOT CONTAINS(propertyA 'term1 term2 -term3')"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithNotConstraintWithOutClosingParenthesis() {
        this.parser.parseConstraint(this.tokens("NOT( CONTAINS(propertyA 'term1 term2 -term3') BLAH"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test
    public void shouldParseConstraintFromStringWithIsContainsExpressionWithPropertyAndNoSelectorNameOnlyIfThereIsOneSelectorSource() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        Constraint constraint = this.parser.parseConstraint(this.tokens("CONTAINS(propertyA,'term1 term2 -term3')"), this.typeSystem, (Source)selector);
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(FullTextSearch.class)));
        FullTextSearch search = (FullTextSearch)constraint;
        Assert.assertThat((Object)search.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)search.propertyName(), Is.is("propertyA"));
        Assert.assertThat((Object)search.fullTextSearchExpression(), Is.is("term1 term2 -term3"));
    }

    @Test
    public void shouldParseConstraintFromStringWithIsContainsExpressionWithSelectorNameAndProperty() {
        Constraint constraint = this.parser.parseConstraint(this.tokens("CONTAINS(tableA.propertyA,'term1 term2 -term3')"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(FullTextSearch.class)));
        FullTextSearch search = (FullTextSearch)constraint;
        Assert.assertThat((Object)search.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)search.propertyName(), Is.is("propertyA"));
        Assert.assertThat((Object)search.fullTextSearchExpression(), Is.is("term1 term2 -term3"));
    }

    @Test
    public void shouldParseConstraintFromStringWithIsContainsExpressionWithSelectorNameAndAnyProperty() {
        Constraint constraint = this.parser.parseConstraint(this.tokens("CONTAINS(tableA.*,'term1 term2 -term3')"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(FullTextSearch.class)));
        FullTextSearch search = (FullTextSearch)constraint;
        Assert.assertThat((Object)search.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)search.propertyName(), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)search.fullTextSearchExpression(), Is.is("term1 term2 -term3"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithContainsExpressionWithNoCommaAfterSelectorName() {
        this.parser.parseConstraint(this.tokens("CONTAINS(propertyA 'term1 term2 -term3')"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithContainsExpressionWithNoClosingParenthesis() {
        this.parser.parseConstraint(this.tokens("CONTAINS(propertyA,'term1 term2 -term3' OTHER"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithContainsExpressionWithNoOpeningParenthesis() {
        this.parser.parseConstraint(this.tokens("CONTAINS propertyA,'term1 term2 -term3')"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithContainsExpressionWithNoSelectorNameIfSourceIsNotSelector() {
        this.parser.parseConstraint(this.tokens("CONTAINS(propertyA,'term1 term2 -term3')"), this.typeSystem, (Source)Mockito.mock(Join.class));
    }

    @Test
    public void shouldParseConstraintFromStringWithIsSameNodeExpressionWithPathOnlyIfThereIsOneSelectorSource() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        Constraint constraint = this.parser.parseConstraint(this.tokens("ISSAMENODE('/a/b/c')"), this.typeSystem, (Source)selector);
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(SameNode.class)));
        SameNode same = (SameNode)constraint;
        Assert.assertThat((Object)same.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)same.path(), Is.is("/a/b/c"));
    }

    @Test
    public void shouldParseConstraintFromStringWithIsSameNodeExpressionWithSelectorNameAndPath() {
        Constraint constraint = this.parser.parseConstraint(this.tokens("ISSAMENODE(tableA,'/a/b/c')"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(SameNode.class)));
        SameNode same = (SameNode)constraint;
        Assert.assertThat((Object)same.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)same.path(), Is.is("/a/b/c"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithIsSameNodeExpressionWithNoCommaAfterSelectorName() {
        this.parser.parseConstraint(this.tokens("ISSAMENODE(tableA '/a/b/c')"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithIsSameNodeExpressionWithNoClosingParenthesis() {
        this.parser.parseConstraint(this.tokens("ISSAMENODE(tableA,'/a/b/c' AND"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithIsSameNodeExpressionWithNoOpeningParenthesis() {
        this.parser.parseConstraint(this.tokens("ISSAMENODE tableA,'/a/b/c')"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithIsSameNodeExpressionWithNoSelectorNameIfSourceIsNotSelector() {
        this.parser.parseConstraint(this.tokens("ISSAMENODE('/a/b/c')"), this.typeSystem, (Source)Mockito.mock(Join.class));
    }

    @Test
    public void shouldParseConstraintFromStringWithIsChildNodeExpressionWithPathOnlyIfThereIsOneSelectorSource() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        Constraint constraint = this.parser.parseConstraint(this.tokens("ISCHILDNODE('/a/b/c')"), this.typeSystem, (Source)selector);
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(ChildNode.class)));
        ChildNode child = (ChildNode)constraint;
        Assert.assertThat((Object)child.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)child.parentPath(), Is.is("/a/b/c"));
    }

    @Test
    public void shouldParseConstraintFromStringWithIsChildNodeExpressionWithSelectorNameAndPath() {
        Constraint constraint = this.parser.parseConstraint(this.tokens("ISCHILDNODE(tableA,'/a/b/c')"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(ChildNode.class)));
        ChildNode child = (ChildNode)constraint;
        Assert.assertThat((Object)child.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)child.parentPath(), Is.is("/a/b/c"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithIsChildNodeExpressionWithNoCommaAfterSelectorName() {
        this.parser.parseConstraint(this.tokens("ISCHILDNODE(tableA '/a/b/c')"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithIsChildNodeExpressionWithNoClosingParenthesis() {
        this.parser.parseConstraint(this.tokens("ISCHILDNODE(tableA,'/a/b/c' AND"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithIsChildNodeExpressionWithNoOpeningParenthesis() {
        this.parser.parseConstraint(this.tokens("ISCHILDNODE tableA,'/a/b/c')"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithIsChildNodeExpressionWithNoSelectorNameIfSourceIsNotSelector() {
        this.parser.parseConstraint(this.tokens("ISCHILDNODE('/a/b/c')"), this.typeSystem, (Source)Mockito.mock(Join.class));
    }

    @Test
    public void shouldParseConstraintFromStringWithIsDescendantNodeExpressionWithPathOnlyIfThereIsOneSelectorSource() {
        NamedSelector selector = new NamedSelector(this.selectorName("tableA"));
        Constraint constraint = this.parser.parseConstraint(this.tokens("ISDESCENDANTNODE('/a/b/c')"), this.typeSystem, (Source)selector);
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(DescendantNode.class)));
        DescendantNode descendant = (DescendantNode)constraint;
        Assert.assertThat((Object)descendant.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)descendant.ancestorPath(), Is.is("/a/b/c"));
    }

    @Test
    public void shouldParseConstraintFromStringWithIsDescendantNodeExpressionWithSelectorNameAndPath() {
        Constraint constraint = this.parser.parseConstraint(this.tokens("ISDESCENDANTNODE(tableA,'/a/b/c')"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(DescendantNode.class)));
        DescendantNode descendant = (DescendantNode)constraint;
        Assert.assertThat((Object)descendant.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)descendant.ancestorPath(), Is.is("/a/b/c"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithIsDescendantNodeExpressionWithNoCommaAfterSelectorName() {
        this.parser.parseConstraint(this.tokens("ISDESCENDANTNODE(tableA '/a/b/c')"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithIsDescendantNodeExpressionWithNoClosingParenthesis() {
        this.parser.parseConstraint(this.tokens("ISDESCENDANTNODE(tableA,'/a/b/c' AND"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithIsDescendantNodeExpressionWithNoOpeningParenthesis() {
        this.parser.parseConstraint(this.tokens("ISDESCENDANTNODE tableA,'/a/b/c')"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseConstraintFromStringWithIsDescendantNodeExpressionWithNoSelectorNameIfSourceIsNotSelector() {
        this.parser.parseConstraint(this.tokens("ISDESCENDANTNODE('/a/b/c')"), this.typeSystem, (Source)Mockito.mock(Join.class));
    }

    @Test
    public void shouldParseInClauseFromStringWithSingleValidLiteral() {
        List result = this.parser.parseInClause(this.tokens("IN ('value1')"), this.typeSystem);
        Assert.assertThat((Object)result.size(), Is.is(1));
        Assert.assertThat(result.get(0), Is.is(this.literal("value1")));
    }

    @Test
    public void shouldParseInClauseFromStringWithTwoValidLiteral() {
        List result = this.parser.parseInClause(this.tokens("IN ('value1','value2')"), this.typeSystem);
        Assert.assertThat((Object)result.size(), Is.is(2));
        Assert.assertThat(result.get(0), Is.is(this.literal("value1")));
        Assert.assertThat(result.get(1), Is.is(this.literal("value2")));
    }

    @Test
    public void shouldParseInClauseFromStringWithThreeValidLiteral() {
        List result = this.parser.parseInClause(this.tokens("IN ('value1','value2','value3')"), this.typeSystem);
        Assert.assertThat((Object)result.size(), Is.is(3));
        Assert.assertThat(result.get(0), Is.is(this.literal("value1")));
        Assert.assertThat(result.get(1), Is.is(this.literal("value2")));
        Assert.assertThat(result.get(2), Is.is(this.literal("value3")));
    }

    @Test
    public void shouldParseInClauseFromStringWithSingleValidLiteralCast() {
        List result = this.parser.parseInClause(this.tokens("IN (CAST('value1' AS STRING))"), this.typeSystem);
        Assert.assertThat((Object)result.size(), Is.is(1));
        Assert.assertThat(result.iterator().next(), Is.is(this.literal("value1")));
        result = this.parser.parseInClause(this.tokens("IN (CAST('3' AS LONG))"), this.typeSystem);
        Assert.assertThat((Object)result.size(), Is.is(1));
        Assert.assertThat(result.iterator().next(), Is.is(this.literal(new Long(3L))));
    }

    @Test
    public void shouldParseInClauseFromStringWithMultipleValidLiteralCasts() {
        List result = this.parser.parseInClause(this.tokens("IN (CAST('value1' AS STRING),CAST('3' AS LONG),'4')"), this.typeSystem);
        Assert.assertThat((Object)result.size(), Is.is(3));
        Assert.assertThat(result.get(0), Is.is(this.literal("value1")));
        Assert.assertThat(result.get(1), Is.is(this.literal(new Long(3L))));
        Assert.assertThat(result.get(2), Is.is(this.literal("4")));
    }

    protected Literal literal(Object literalValue) {
        return new Literal(literalValue);
    }

    @Test
    public void shouldParseFullTextSearchExpressionFromStringWithValidExpression() {
        Position pos = new Position(500, 100, 13);
        FullTextSearch.Term result = this.parser.parseFullTextSearchExpression("term1 term2 OR -term3 OR -term4 OR term5", pos);
        Assert.assertThat((Object)result, Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)result, Is.is(IsInstanceOf.instanceOf(FullTextSearch.Disjunction.class)));
        FullTextSearch.Disjunction disjunction = (FullTextSearch.Disjunction)result;
        Assert.assertThat((Object)disjunction.getTerms().size(), Is.is(4));
        FullTextSearch.Conjunction conjunction1 = (FullTextSearch.Conjunction)disjunction.getTerms().get(0);
        FullTextSearch.Term term3 = (FullTextSearch.Term)disjunction.getTerms().get(1);
        FullTextSearch.Term term4 = (FullTextSearch.Term)disjunction.getTerms().get(2);
        FullTextSearch.Term term5 = (FullTextSearch.Term)disjunction.getTerms().get(3);
        FullTextSearchParserTest.assertHasSimpleTerms((FullTextSearch.CompoundTerm)conjunction1, "term1", "term2");
        FullTextSearchParserTest.assertSimpleTerm(term3, "term3", true, false);
        FullTextSearchParserTest.assertSimpleTerm(term4, "term4", true, false);
        FullTextSearchParserTest.assertSimpleTerm(term5, "term5", false, false);
    }

    @Test
    public void shouldConvertPositionWhenUnableToParseFullTextSearchExpression() {
        try {
            this.parser.parseFullTextSearchExpression("", new Position(500, 100, 13));
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (ParsingException e) {
            Assert.assertThat((Object)e.getPosition().getLine(), Is.is(100));
            Assert.assertThat((Object)e.getPosition().getColumn(), Is.is(13));
            Assert.assertThat((Object)e.getPosition().getIndexInContent(), Is.is(500));
        }
    }

    @Test
    public void shouldParseComparisonOperator() {
        for (Operator operator : Operator.values()) {
            Assert.assertThat((Object)this.parser.parseComparisonOperator(this.tokens(operator.symbol())), Is.is(operator));
        }
        for (Operator operator : Operator.values()) {
            Assert.assertThat((Object)this.parser.parseComparisonOperator(this.tokens(operator.symbol().toUpperCase())), Is.is(operator));
        }
        for (Operator operator : Operator.values()) {
            Assert.assertThat((Object)this.parser.parseComparisonOperator(this.tokens(operator.symbol().toLowerCase())), Is.is(operator));
        }
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseComparisonOperatorIfOperatorIsUnknown() {
        this.parser.parseComparisonOperator(this.tokens("FOO"));
    }

    @Test
    public void shouldParserOrderByWithOneOrdering() {
        List orderBy = this.parser.parseOrderBy(this.tokens("ORDER BY NAME(tableA) ASC"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)orderBy.size(), Is.is(1));
        Ordering first = (Ordering)orderBy.get(0);
        Assert.assertThat((Object)first.operand(), Is.is(IsInstanceOf.instanceOf(NodeName.class)));
        Assert.assertThat((Object)first.order(), Is.is(Order.ASCENDING));
    }

    @Test
    public void shouldParserOrderByWithTwoOrderings() {
        List orderBy = this.parser.parseOrderBy(this.tokens("ORDER BY NAME(tableA) ASC, SCORE(tableB) DESC"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)orderBy.size(), Is.is(2));
        Ordering first = (Ordering)orderBy.get(0);
        Assert.assertThat((Object)first.operand(), Is.is(IsInstanceOf.instanceOf(NodeName.class)));
        Assert.assertThat((Object)first.order(), Is.is(Order.ASCENDING));
        Ordering second = (Ordering)orderBy.get(1);
        Assert.assertThat((Object)second.operand(), Is.is(IsInstanceOf.instanceOf(FullTextSearchScore.class)));
        Assert.assertThat((Object)second.order(), Is.is(Order.DESCENDING));
    }

    @Test
    public void shouldParserOrderByWithMultipleOrderings() {
        List orderBy = this.parser.parseOrderBy(this.tokens("ORDER BY NAME(tableA) ASC, SCORE(tableB) DESC, LENGTH(tableC.id) ASC"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)orderBy.size(), Is.is(3));
        Ordering first = (Ordering)orderBy.get(0);
        Assert.assertThat((Object)first.operand(), Is.is(IsInstanceOf.instanceOf(NodeName.class)));
        Assert.assertThat((Object)first.order(), Is.is(Order.ASCENDING));
        Ordering second = (Ordering)orderBy.get(1);
        Assert.assertThat((Object)second.operand(), Is.is(IsInstanceOf.instanceOf(FullTextSearchScore.class)));
        Assert.assertThat((Object)second.order(), Is.is(Order.DESCENDING));
        Ordering third = (Ordering)orderBy.get(2);
        Assert.assertThat((Object)third.operand(), Is.is(IsInstanceOf.instanceOf(Length.class)));
        Assert.assertThat((Object)third.order(), Is.is(Order.ASCENDING));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseOrderByIfCommaNotFollowedByAnotherOrdering() {
        this.parser.parseOrderBy(this.tokens("ORDER BY NAME(tableA) ASC, NOT A VALID ORDERING"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test
    public void shouldReturnNullFromParseOrderByWithoutOrderByKeywords() {
        Assert.assertThat((Object)this.parser.parseOrderBy(this.tokens("NOT ORDER BY"), this.typeSystem, (Source)Mockito.mock(Source.class)), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldParseOrderingFromDynamicOperandFollowedByAscendingKeyword() {
        Ordering ordering = this.parser.parseOrdering(this.tokens("NAME(tableA) ASC"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)ordering.operand(), Is.is(IsInstanceOf.instanceOf(NodeName.class)));
        Assert.assertThat((Object)ordering.order(), Is.is(Order.ASCENDING));
    }

    @Test
    public void shouldParseOrderingFromDynamicOperandFollowedByDecendingKeyword() {
        Ordering ordering = this.parser.parseOrdering(this.tokens("NAME(tableA) DESC"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)ordering.operand(), Is.is(IsInstanceOf.instanceOf(NodeName.class)));
        Assert.assertThat((Object)ordering.order(), Is.is(Order.DESCENDING));
    }

    @Test
    public void shouldParseOrderingFromDynamicOperandAndDefaultToAscendingWhenNotFollowedByAscendingOrDescendingKeyword() {
        Ordering ordering = this.parser.parseOrdering(this.tokens("NAME(tableA) OTHER"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)ordering.operand(), Is.is(IsInstanceOf.instanceOf(NodeName.class)));
        Assert.assertThat((Object)ordering.order(), Is.is(Order.ASCENDING));
    }

    @Test
    public void shouldParsePropertyExistanceFromPropertyNameWithSelectorNameAndPropertyNameFollowedByIsNotNull() {
        Constraint constraint = this.parser.parsePropertyExistance(this.tokens("tableA.property1 IS NOT NULL"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(PropertyExistence.class)));
        PropertyExistence p = (PropertyExistence)constraint;
        Assert.assertThat((Object)p.propertyName(), Is.is("property1"));
        Assert.assertThat((Object)p.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test
    public void shouldParsePropertyExistanceFromPropertyNameWithPropertyNameAndNoSelectorNameFollowedByIsNotNull() {
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        Constraint constraint = this.parser.parsePropertyExistance(this.tokens("property1 IS NOT NULL"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(PropertyExistence.class)));
        PropertyExistence p = (PropertyExistence)constraint;
        Assert.assertThat((Object)p.propertyName(), Is.is("property1"));
        Assert.assertThat((Object)p.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParsePropertyExistanceFromPropertyNameWithNoSelectorNameIfSourceIsNotSelector() {
        this.parser.parsePropertyExistance(this.tokens("property1 IS NOT NULL"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test
    public void shouldParseNotPropertyExistanceFromPropertyNameWithSelectorNameAndPropertyNameFollowedByIsNull() {
        Constraint constraint = this.parser.parsePropertyExistance(this.tokens("tableA.property1 IS NULL"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)constraint, Is.is(IsInstanceOf.instanceOf(Not.class)));
        Not not = (Not)constraint;
        Assert.assertThat((Object)not.constraint(), Is.is(IsInstanceOf.instanceOf(PropertyExistence.class)));
        PropertyExistence p = (PropertyExistence)not.constraint();
        Assert.assertThat((Object)p.propertyName(), Is.is("property1"));
        Assert.assertThat((Object)p.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test
    public void shouldReturnNullFromParsePropertyExistanceIfExpressionDoesNotMatchPattern() {
        Source s = (Source)Mockito.mock(Source.class);
        Assert.assertThat((Object)this.parser.parsePropertyExistance(this.tokens("tableA WILL NOT"), this.typeSystem, s), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.parser.parsePropertyExistance(this.tokens("tableA.property1 NOT NULL"), this.typeSystem, s), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.parser.parsePropertyExistance(this.tokens("tableA.property1 IS NOT SOMETHING"), this.typeSystem, s), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldParseStaticOperandFromStringWithBindVariable() {
        StaticOperand operand = this.parser.parseStaticOperand(this.tokens("$VAR"), this.typeSystem);
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(BindVariableName.class)));
        BindVariableName var = (BindVariableName)operand;
        Assert.assertThat((Object)var.variableName(), Is.is("VAR"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseStaticOperandFromStringWithBindVariableWithNoVariableName() {
        this.parser.parseStaticOperand(this.tokens("$"), this.typeSystem);
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseStaticOperandFromStringWithBindVariableWithCharactersThatAreNotFromNCName() {
        this.parser.parseStaticOperand(this.tokens("$#2VAR"), this.typeSystem);
    }

    @Test
    public void shouldParseStaticOperandFromStringWithLiteralValue() {
        StaticOperand operand = this.parser.parseStaticOperand(this.tokens("CAST(123 AS DOUBLE)"), this.typeSystem);
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(Literal.class)));
        Literal literal = (Literal)operand;
        Assert.assertThat((Object)((Double)literal.value()), Is.is(this.typeSystem.getDoubleFactory().create("123")));
    }

    @Test
    public void shouldParseLiteralFromStringWithCastBooleanLiteralToString() {
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(true AS STRING)"), this.typeSystem).value()), Is.is(Boolean.TRUE.toString()));
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(false AS STRING)"), this.typeSystem).value()), Is.is(Boolean.FALSE.toString()));
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(TRUE AS STRING)"), this.typeSystem).value()), Is.is(Boolean.TRUE.toString()));
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(FALSE AS STRING)"), this.typeSystem).value()), Is.is(Boolean.FALSE.toString()));
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST('true' AS stRinG)"), this.typeSystem).value()), Is.is(Boolean.TRUE.toString()));
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(\"false\" AS string)"), this.typeSystem).value()), Is.is(Boolean.FALSE.toString()));
    }

    @Test
    public void shouldParseLiteralFromStringWithCastBooleanLiteralToBinary() {
        Binary binaryTrue = (Binary)this.typeSystem.getTypeFactory(PropertyType.BINARY.getName()).create((Object)true);
        Binary binaryFalse = (Binary)this.typeSystem.getTypeFactory(PropertyType.BINARY.getName()).create((Object)false);
        Assert.assertThat((Object)((Binary)this.parser.parseLiteral(this.tokens("CAST(true AS BINARY)"), this.typeSystem).value()), Is.is(binaryTrue));
        Assert.assertThat((Object)((Binary)this.parser.parseLiteral(this.tokens("CAST(false AS BINARY)"), this.typeSystem).value()), Is.is(binaryFalse));
        Assert.assertThat((Object)((Binary)this.parser.parseLiteral(this.tokens("CAST(TRUE AS BINARY)"), this.typeSystem).value()), Is.is(binaryTrue));
        Assert.assertThat((Object)((Binary)this.parser.parseLiteral(this.tokens("CAST(FALSE AS BINARY)"), this.typeSystem).value()), Is.is(binaryFalse));
        Assert.assertThat((Object)((Binary)this.parser.parseLiteral(this.tokens("CAST('true' AS biNarY)"), this.typeSystem).value()), Is.is(binaryTrue));
        Assert.assertThat((Object)((Binary)this.parser.parseLiteral(this.tokens("CAST(\"false\" AS binary)"), this.typeSystem).value()), Is.is(binaryFalse));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseLiteralFromStringWithCastBooleanLiteralToLong() {
        this.parser.parseLiteral(this.tokens("CAST(true AS LONG)"), this.typeSystem);
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseLiteralFromStringWithCastBooleanLiteralToDouble() {
        this.parser.parseLiteral(this.tokens("CAST(true AS DOUBLE)"), this.typeSystem);
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseLiteralFromStringWithCastBooleanLiteralToDate() {
        this.parser.parseLiteral(this.tokens("CAST(true AS DATE)"), this.typeSystem);
    }

    @Test
    public void shouldParseLiteralFromStringWithCastLongLiteralToString() {
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(123 AS STRING)"), this.typeSystem).value()), Is.is("123"));
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(+123 AS STRING)"), this.typeSystem).value()), Is.is("123"));
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(-123 AS STRING)"), this.typeSystem).value()), Is.is("-123"));
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(0 AS STRING)"), this.typeSystem).value()), Is.is("0"));
    }

    @Test
    public void shouldParseLiteralFromStringWithCastLongLiteralToLong() {
        Assert.assertThat((Object)((Long)this.parser.parseLiteral(this.tokens("CAST(123 AS LONG)"), this.typeSystem).value()), Is.is(123L));
        Assert.assertThat((Object)((Long)this.parser.parseLiteral(this.tokens("CAST(+123 AS LONG)"), this.typeSystem).value()), Is.is(123L));
        Assert.assertThat((Object)((Long)this.parser.parseLiteral(this.tokens("CAST(-123 AS LONG)"), this.typeSystem).value()), Is.is(-123L));
        Assert.assertThat((Object)((Long)this.parser.parseLiteral(this.tokens("CAST(0 AS LONG)"), this.typeSystem).value()), Is.is(0L));
    }

    @Test
    public void shouldParseLiteralFromStringWithCastDoubleLiteralToString() {
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(1.23 AS STRING)"), this.typeSystem).value()), Is.is("1.23"));
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(+1.23 AS STRING)"), this.typeSystem).value()), Is.is("1.23"));
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(-1.23 AS STRING)"), this.typeSystem).value()), Is.is("-1.23"));
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(1.23e10 AS STRING)"), this.typeSystem).value()), Is.is("1.23E10"));
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(1.23e+10 AS STRING)"), this.typeSystem).value()), Is.is("1.23E10"));
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(1.23e-10 AS STRING)"), this.typeSystem).value()), Is.is("1.23E-10"));
    }

    @Test
    public void shouldParseLiteralFromStringWithCastDateLiteralToString() {
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(2009-03-22T03:22:45.345Z AS STRING)"), this.typeSystem).value()), Is.is("2009-03-22T03:22:45.345Z"));
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(2009-03-22T03:22:45.345UTC AS STRING)"), this.typeSystem).value()), Is.is("2009-03-22T03:22:45.345Z"));
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(2009-03-22T03:22:45.3-01:00 AS STRING)"), this.typeSystem).value()), Is.is("2009-03-22T04:22:45.300Z"));
        Assert.assertThat((Object)((String)this.parser.parseLiteral(this.tokens("CAST(2009-03-22T03:22:45.345+01:00 AS STRING)"), this.typeSystem).value()), Is.is("2009-03-22T02:22:45.345Z"));
    }

    @Test
    public void shouldParseLiteralFromStringWithCastStringLiteralToName() {
        Assert.assertThat((Object)((Name)this.parser.parseLiteral(this.tokens("CAST([mode:name] AS NAME)"), this.typeSystem).value()), Is.is(this.name("mode:name")));
        Assert.assertThat((Object)((Name)this.parser.parseLiteral(this.tokens("CAST('mode:name' AS NAME)"), this.typeSystem).value()), Is.is(this.name("mode:name")));
        Assert.assertThat((Object)((Name)this.parser.parseLiteral(this.tokens("CAST(\"mode:name\" AS NAME)"), this.typeSystem).value()), Is.is(this.name("mode:name")));
    }

    @Test
    public void shouldParseLiteralFromStringWithCastStringLiteralToPath() {
        Assert.assertThat((Object)((Path)this.parser.parseLiteral(this.tokens("CAST([/mode:name/a/b] AS PATH)"), this.typeSystem).value()), Is.is(this.path("/mode:name/a/b")));
    }

    @Test
    public void shouldParseLiteralFromStringWithUncastLiteralValueAndRepresentValueAsStringRepresentation() {
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("true"), this.typeSystem).value(), Is.is(Boolean.TRUE.toString()));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("false"), this.typeSystem).value(), Is.is(Boolean.FALSE.toString()));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("TRUE"), this.typeSystem).value(), Is.is(Boolean.TRUE.toString()));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("FALSE"), this.typeSystem).value(), Is.is(Boolean.FALSE.toString()));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("123"), this.typeSystem).value(), Is.is("123"));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("+123"), this.typeSystem).value(), Is.is("123"));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("-123"), this.typeSystem).value(), Is.is("-123"));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("1.23"), this.typeSystem).value(), Is.is("1.23"));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("+1.23"), this.typeSystem).value(), Is.is("1.23"));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("-1.23"), this.typeSystem).value(), Is.is("-1.23"));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("1.23e10"), this.typeSystem).value(), Is.is("1.23E10"));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("1.23e+10"), this.typeSystem).value(), Is.is("1.23E10"));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("1.23e-10"), this.typeSystem).value(), Is.is("1.23E-10"));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("0"), this.typeSystem).value(), Is.is("0"));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("2009-03-22T03:22:45.345Z"), this.typeSystem).value(), Is.is("2009-03-22T03:22:45.345Z"));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("2009-03-22T03:22:45.345UTC"), this.typeSystem).value(), Is.is("2009-03-22T03:22:45.345Z"));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("2009-03-22T03:22:45.3-01:00"), this.typeSystem).value(), Is.is("2009-03-22T04:22:45.300Z"));
        Assert.assertThat((Object)this.parser.parseLiteral(this.tokens("2009-03-22T03:22:45.345+01:00"), this.typeSystem).value(), Is.is("2009-03-22T02:22:45.345Z"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseLiteralFromStringWithCastAndNoEndingParenthesis() {
        this.parser.parseLiteral(this.tokens("CAST(123 AS STRING OTHER"), this.typeSystem);
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseLiteralFromStringWithCastAndNoOpeningParenthesis() {
        this.parser.parseLiteral(this.tokens("CAST 123 AS STRING) OTHER"), this.typeSystem);
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseLiteralFromStringWithCastAndInvalidType() {
        this.parser.parseLiteral(this.tokens("CAST(123 AS FOOD) OTHER"), this.typeSystem);
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseLiteralFromStringWithCastAndNoAsKeyword() {
        this.parser.parseLiteral(this.tokens("CAST(123 STRING) OTHER"), this.typeSystem);
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseLiteralFromStringWithCastAndNoLiteralValueBeforeAs() {
        this.parser.parseLiteral(this.tokens("CAST(AS STRING) OTHER"), this.typeSystem);
    }

    @Test
    public void shouldParseLiteralValueFromStringWithPositiveAndNegativeIntegerValues() {
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("123"), this.typeSystem), Is.is("123"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("-123"), this.typeSystem), Is.is("-123"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("- 123"), this.typeSystem), Is.is("-123"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("+123"), this.typeSystem), Is.is("123"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("+ 123"), this.typeSystem), Is.is("123"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("0"), this.typeSystem), Is.is("0"));
    }

    @Test
    public void shouldParseLiteralValueFromStringWithPositiveAndNegativeDecimalValues() {
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("1.23"), this.typeSystem), Is.is("1.23"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("-1.23"), this.typeSystem), Is.is("-1.23"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("+0.123"), this.typeSystem), Is.is("0.123"));
    }

    @Test
    public void shouldParseLiteralValueFromStringWithPositiveAndNegativeDecimalValuesInScientificNotation() {
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("1.23"), this.typeSystem), Is.is("1.23"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("1.23e10"), this.typeSystem), Is.is("1.23E10"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("- 1.23e10"), this.typeSystem), Is.is("-1.23E10"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("- 1.23e-10"), this.typeSystem), Is.is("-1.23E-10"));
    }

    @Test
    public void shouldParseLiteralValueFromStringWithBooleanValues() {
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("true"), this.typeSystem), Is.is(Boolean.TRUE.toString()));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("false"), this.typeSystem), Is.is(Boolean.FALSE.toString()));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("TRUE"), this.typeSystem), Is.is(Boolean.TRUE.toString()));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("FALSE"), this.typeSystem), Is.is(Boolean.FALSE.toString()));
    }

    @Test
    public void shouldParseLiteralValueFromStringWithDateValues() {
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("2009-03-22T03:22:45.345Z"), this.typeSystem), Is.is("2009-03-22T03:22:45.345Z"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("2009-03-22T03:22:45.345UTC"), this.typeSystem), Is.is("2009-03-22T03:22:45.345Z"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("2009-03-22T03:22:45.3-01:00"), this.typeSystem), Is.is("2009-03-22T04:22:45.300Z"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("2009-03-22T03:22:45.345+01:00"), this.typeSystem), Is.is("2009-03-22T02:22:45.345Z"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("-2009-03-22T03:22:45.345Z"), this.typeSystem), Is.is("-2009-03-22T03:22:45.345Z"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("-2009-03-22T03:22:45.345UTC"), this.typeSystem), Is.is("-2009-03-22T03:22:45.345Z"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("-2009-03-22T03:22:45.3-01:00"), this.typeSystem), Is.is("-2009-03-22T04:22:45.300Z"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("-2009-03-22T03:22:45.345+01:00"), this.typeSystem), Is.is("-2009-03-22T02:22:45.345Z"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("+2009-03-22T03:22:45.345Z"), this.typeSystem), Is.is("2009-03-22T03:22:45.345Z"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("+2009-03-22T03:22:45.345UTC"), this.typeSystem), Is.is("2009-03-22T03:22:45.345Z"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("+2009-03-22T03:22:45.3-01:00"), this.typeSystem), Is.is("2009-03-22T04:22:45.300Z"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("+2009-03-22T03:22:45.345+01:00"), this.typeSystem), Is.is("2009-03-22T02:22:45.345Z"));
    }

    @Test
    public void shouldParseLiteralValueFromQuotedStringWithPositiveAndNegativeIntegerValues() {
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'123'"), this.typeSystem), Is.is("123"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'-123'"), this.typeSystem), Is.is("-123"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'- 123'"), this.typeSystem), Is.is("- 123"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'+123'"), this.typeSystem), Is.is("+123"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'+ 123'"), this.typeSystem), Is.is("+ 123"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'0'"), this.typeSystem), Is.is("0"));
    }

    @Test
    public void shouldParseLiteralValueFromQuotedStringWithPositiveAndNegativeDecimalValues() {
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'1.23'"), this.typeSystem), Is.is("1.23"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'-1.23'"), this.typeSystem), Is.is("-1.23"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'+0.123'"), this.typeSystem), Is.is("+0.123"));
    }

    @Test
    public void shouldParseLiteralValueFromQuotedStringWithPositiveAndNegativeDecimalValuesInScientificNotation() {
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'1.23'"), this.typeSystem), Is.is("1.23"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'1.23e10'"), this.typeSystem), Is.is("1.23e10"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'- 1.23e10'"), this.typeSystem), Is.is("- 1.23e10"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'- 1.23e-10'"), this.typeSystem), Is.is("- 1.23e-10"));
    }

    @Test
    public void shouldParseLiteralValueFromQuotedStringWithBooleanValues() {
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'true'"), this.typeSystem), Is.is("true"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'false'"), this.typeSystem), Is.is("false"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'TRUE'"), this.typeSystem), Is.is("TRUE"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'FALSE'"), this.typeSystem), Is.is("FALSE"));
    }

    @Test
    public void shouldParseLiteralValueFromQuotedStringWithDateValues() {
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'2009-03-22T03:22:45.345Z'"), this.typeSystem), Is.is("2009-03-22T03:22:45.345Z"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'2009-03-22T03:22:45.345UTC'"), this.typeSystem), Is.is("2009-03-22T03:22:45.345UTC"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'2009-03-22T03:22:45.3-01:00'"), this.typeSystem), Is.is("2009-03-22T03:22:45.3-01:00"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'2009-03-22T03:22:45.345+01:00'"), this.typeSystem), Is.is("2009-03-22T03:22:45.345+01:00"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'-2009-03-22T03:22:45.345Z'"), this.typeSystem), Is.is("-2009-03-22T03:22:45.345Z"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'-2009-03-22T03:22:45.345UTC'"), this.typeSystem), Is.is("-2009-03-22T03:22:45.345UTC"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'-2009-03-22T03:22:45.3-01:00'"), this.typeSystem), Is.is("-2009-03-22T03:22:45.3-01:00"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'-2009-03-22T03:22:45.345+01:00'"), this.typeSystem), Is.is("-2009-03-22T03:22:45.345+01:00"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'+2009-03-22T03:22:45.345Z'"), this.typeSystem), Is.is("+2009-03-22T03:22:45.345Z"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'+2009-03-22T03:22:45.345UTC'"), this.typeSystem), Is.is("+2009-03-22T03:22:45.345UTC"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'+2009-03-22T03:22:45.3-01:00'"), this.typeSystem), Is.is("+2009-03-22T03:22:45.3-01:00"));
        Assert.assertThat((Object)this.parser.parseLiteralValue(this.tokens("'+2009-03-22T03:22:45.345+01:00'"), this.typeSystem), Is.is("+2009-03-22T03:22:45.345+01:00"));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingLengthOfPropertyValue() {
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("LENGTH(tableA.property)"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(Length.class)));
        Length length = (Length)operand;
        Assert.assertThat((Object)length.propertyValue().propertyName(), Is.is("property"));
        Assert.assertThat((Object)length.propertyValue().selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)length.selectorName(), Is.is(this.selectorName("tableA")));
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        operand = this.parser.parseDynamicOperand(this.tokens("LENGTH(property)"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(Length.class)));
        length = (Length)operand;
        Assert.assertThat((Object)length.propertyValue().propertyName(), Is.is("property"));
        Assert.assertThat((Object)length.propertyValue().selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)length.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingLengthWithoutClosingParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("LENGTH(tableA.property other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingLengthWithoutOpeningParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("LENGTH tableA.property other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingLowerOfAnotherDynamicOperand() {
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("LOWER(tableA.property)"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(LowerCase.class)));
        LowerCase lower = (LowerCase)operand;
        Assert.assertThat((Object)lower.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)lower.operand(), Is.is(IsInstanceOf.instanceOf(PropertyValue.class)));
        PropertyValue value = (PropertyValue)lower.operand();
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        operand = this.parser.parseDynamicOperand(this.tokens("LOWER(property)"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(LowerCase.class)));
        lower = (LowerCase)operand;
        Assert.assertThat((Object)lower.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)lower.operand(), Is.is(IsInstanceOf.instanceOf(PropertyValue.class)));
        value = (PropertyValue)lower.operand();
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingLowerOfUpperCaseOfAnotherOperand() {
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("LOWER(UPPER(tableA.property))"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(LowerCase.class)));
        LowerCase lower = (LowerCase)operand;
        Assert.assertThat((Object)lower.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)lower.operand(), Is.is(IsInstanceOf.instanceOf(UpperCase.class)));
        UpperCase upper = (UpperCase)lower.operand();
        Assert.assertThat((Object)upper.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)upper.operand(), Is.is(IsInstanceOf.instanceOf(PropertyValue.class)));
        PropertyValue value = (PropertyValue)upper.operand();
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingLowerWithoutClosingParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("LOWER(tableA.property other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingLowerWithoutOpeningParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("LOWER tableA.property other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingUpperOfAnotherDynamicOperand() {
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("UPPER(tableA.property)"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(UpperCase.class)));
        UpperCase upper = (UpperCase)operand;
        Assert.assertThat((Object)upper.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)upper.operand(), Is.is(IsInstanceOf.instanceOf(PropertyValue.class)));
        PropertyValue value = (PropertyValue)upper.operand();
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        operand = this.parser.parseDynamicOperand(this.tokens("UPPER(property)"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(UpperCase.class)));
        upper = (UpperCase)operand;
        Assert.assertThat((Object)upper.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)upper.operand(), Is.is(IsInstanceOf.instanceOf(PropertyValue.class)));
        value = (PropertyValue)upper.operand();
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingUpperOfLowerCaseOfAnotherOperand() {
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("UPPER(LOWER(tableA.property))"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(UpperCase.class)));
        UpperCase upper = (UpperCase)operand;
        Assert.assertThat((Object)upper.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)upper.operand(), Is.is(IsInstanceOf.instanceOf(LowerCase.class)));
        LowerCase lower = (LowerCase)upper.operand();
        Assert.assertThat((Object)lower.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)lower.operand(), Is.is(IsInstanceOf.instanceOf(PropertyValue.class)));
        PropertyValue value = (PropertyValue)lower.operand();
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingUpperWithoutClosingParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("UPPER(tableA.property other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingUpperWithoutOpeningParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("Upper tableA.property other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingDepthOfSelector() {
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("DEPTH(tableA)"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(NodeDepth.class)));
        NodeDepth depth = (NodeDepth)operand;
        Assert.assertThat((Object)depth.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingDepthWithNoSelectorOnlyIfThereIsOneSelectorAsSource() {
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("DEPTH()"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(NodeDepth.class)));
        NodeDepth depth = (NodeDepth)operand;
        Assert.assertThat((Object)depth.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingDepthWithNoSelectorIfTheSourceIsNotASelector() {
        this.parser.parseDynamicOperand(this.tokens("DEPTH()"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingDepthWithSelectorNameAndProperty() {
        this.parser.parseDynamicOperand(this.tokens("DEPTH(tableA.property) other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingDepthWithoutClosingParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("DEPTH(tableA other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingDepthWithoutOpeningParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("Depth  tableA other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingPathOfSelector() {
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("PATH(tableA)"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(NodePath.class)));
        NodePath path = (NodePath)operand;
        Assert.assertThat((Object)path.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingPathWithNoSelectorOnlyIfThereIsOneSelectorAsSource() {
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("PATH()"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(NodePath.class)));
        NodePath path = (NodePath)operand;
        Assert.assertThat((Object)path.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingPathWithNoSelectorIfTheSourceIsNotASelector() {
        this.parser.parseDynamicOperand(this.tokens("PATH()"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingPathWithSelectorNameAndProperty() {
        this.parser.parseDynamicOperand(this.tokens("PATH(tableA.property) other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingPathWithoutClosingParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("PATH(tableA other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingPathWithoutOpeningParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("Path  tableA other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingNameOfSelector() {
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("NAME(tableA)"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(NodeName.class)));
        NodeName name = (NodeName)operand;
        Assert.assertThat((Object)name.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingNameWithNoSelectorOnlyIfThereIsOneSelectorAsSource() {
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("NAME()"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(NodeName.class)));
        NodeName name = (NodeName)operand;
        Assert.assertThat((Object)name.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingNameWithNoSelectorIfTheSourceIsNotASelector() {
        this.parser.parseDynamicOperand(this.tokens("NAME()"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingNameWithSelectorNameAndProperty() {
        this.parser.parseDynamicOperand(this.tokens("NAME(tableA.property) other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingNameWithoutClosingParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("NAME(tableA other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingNameWithoutOpeningParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("Name  tableA other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingLocalNameOfSelector() {
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("LOCALNAME(tableA)"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(NodeLocalName.class)));
        NodeLocalName name = (NodeLocalName)operand;
        Assert.assertThat((Object)name.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingLocalNameWithNoSelectorOnlyIfThereIsOneSelectorAsSource() {
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("LOCALNAME()"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(NodeLocalName.class)));
        NodeLocalName name = (NodeLocalName)operand;
        Assert.assertThat((Object)name.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingLocalNameWithNoSelectorIfTheSourceIsNotASelector() {
        this.parser.parseDynamicOperand(this.tokens("LOCALNAME()"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingLocalNameWithSelectorNameAndProperty() {
        this.parser.parseDynamicOperand(this.tokens("LOCALNAME(tableA.property) other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingLocalNameWithoutClosingParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("LOCALNAME(tableA other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingLocalNameWithoutOpeningParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("LocalName  tableA other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingFullTextSearchScoreOfSelector() {
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("SCORE(tableA)"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(FullTextSearchScore.class)));
        FullTextSearchScore score = (FullTextSearchScore)operand;
        Assert.assertThat((Object)score.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingFullTextSearchScoreWithNoSelectorOnlyIfThereIsOneSelectorAsSource() {
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("SCORE()"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(FullTextSearchScore.class)));
        FullTextSearchScore score = (FullTextSearchScore)operand;
        Assert.assertThat((Object)score.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingFullTextSearchScoreWithNoSelectorIfTheSourceIsNotASelector() {
        this.parser.parseDynamicOperand(this.tokens("SCORE()"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingFullTextSearchScoreWithWithSelectorNameAndProperty() {
        this.parser.parseDynamicOperand(this.tokens("SCORE(tableA.property) other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingFullTextSearchScoreWithoutClosingParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("SCORE(tableA other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingFullTextSearchScoreWithoutOpeningParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("Score  tableA other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test
    public void shouldParseDynamicOperandFromStringWithUnquotedSelectorNameAndUnquotedPropertyName() {
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("tableA.property"), this.typeSystem, (Source)Mockito.mock(Join.class));
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(PropertyValue.class)));
        PropertyValue value = (PropertyValue)operand;
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test
    public void shouldParseDynamicOperandFromStringWithQuotedSelectorNameAndUnquotedPropertyName() {
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("[mode:tableA].property"), this.typeSystem, (Source)Mockito.mock(Join.class));
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(PropertyValue.class)));
        PropertyValue value = (PropertyValue)operand;
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("mode:tableA")));
    }

    @Test
    public void shouldParseDynamicOperandFromStringWithQuotedSelectorNameAndQuotedPropertyName() {
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("[mode:tableA].[mode:property]"), this.typeSystem, (Source)Mockito.mock(Join.class));
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(PropertyValue.class)));
        PropertyValue value = (PropertyValue)operand;
        Assert.assertThat((Object)value.propertyName(), Is.is("mode:property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("mode:tableA")));
    }

    @Test
    public void shouldParseDynamicOperandFromStringWithOnlyPropertyNameIfSourceIsSelector() {
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("property"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(PropertyValue.class)));
        PropertyValue value = (PropertyValue)operand;
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToDynamicOperandValueFromStringWithOnlyPropertyNameIfSourceIsNotSelector() {
        this.parser.parsePropertyValue(this.tokens("property"), this.typeSystem, (Source)Mockito.mock(Join.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringWithOnlySelectorNameAndPeriod() {
        this.parser.parsePropertyValue(this.tokens("tableA. "), this.typeSystem, (Source)Mockito.mock(Join.class));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingReferenceValueOfSelector() {
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("REFERENCE(tableA)"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(ReferenceValue.class)));
        ReferenceValue value = (ReferenceValue)operand;
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)value.propertyName(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingReferenceValueWithNoSelectorOnlyIfThereIsOneSelectorAsSource() {
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("REFERENCE()"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(ReferenceValue.class)));
        ReferenceValue value = (ReferenceValue)operand;
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)value.propertyName(), Is.is(IsNull.nullValue()));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingReferenceValueWithWithOnlyPropertyNameIfThereIsOneSelectorAsSource() {
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("REFERENCE(property) other"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(ReferenceValue.class)));
        ReferenceValue value = (ReferenceValue)operand;
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingReferenceValueWithWithSelectorNameAndPropertyNameIfThereIsOneSelectorAsSource() {
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("REFERENCE(tableA.property) other"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(ReferenceValue.class)));
        ReferenceValue value = (ReferenceValue)operand;
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingReferenceValueWithWithOnlySelectorNameMatchingThatOfOneSelectorAsSource() {
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("REFERENCE(tableA) other"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(ReferenceValue.class)));
        ReferenceValue value = (ReferenceValue)operand;
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)value.propertyName(), Is.is(IsNull.nullValue()));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingReferenceValueWithNoSelectorIfTheSourceIsNotASelector() {
        this.parser.parseDynamicOperand(this.tokens("REFERENCE()"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test
    public void shouldParseDynamicOperandFromStringContainingReferenceValueWithWithSelectorNameAndProperty() {
        DynamicOperand operand = this.parser.parseDynamicOperand(this.tokens("REFERENCE(tableA.property) other"), this.typeSystem, (Source)Mockito.mock(Source.class));
        Assert.assertThat((Object)operand, Is.is(IsInstanceOf.instanceOf(ReferenceValue.class)));
        ReferenceValue value = (ReferenceValue)operand;
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingReferenceValueWithoutClosingParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("REFERENCE(tableA other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingReferenceValueWithoutSelectorOrPropertyIfTheSourceIsNotASelector() {
        this.parser.parseDynamicOperand(this.tokens("REFERENCE() other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseDynamicOperandFromStringContainingReferenceValueWithoutOpeningParenthesis() {
        this.parser.parseDynamicOperand(this.tokens("Reference  tableA other"), this.typeSystem, (Source)Mockito.mock(Source.class));
    }

    @Test
    public void shouldParsePropertyValueFromStringWithUnquotedSelectorNameAndUnquotedPropertyName() {
        PropertyValue value = this.parser.parsePropertyValue(this.tokens("tableA.property"), this.typeSystem, (Source)Mockito.mock(Join.class));
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test
    public void shouldParsePropertyValueFromStringWithQuotedSelectorNameAndUnquotedPropertyName() {
        PropertyValue value = this.parser.parsePropertyValue(this.tokens("[mode:tableA].property"), this.typeSystem, (Source)Mockito.mock(Join.class));
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("mode:tableA")));
    }

    @Test
    public void shouldParsePropertyValueFromStringWithQuotedSelectorNameAndQuotedPropertyName() {
        PropertyValue value = this.parser.parsePropertyValue(this.tokens("[mode:tableA].[mode:property]"), this.typeSystem, (Source)Mockito.mock(Join.class));
        Assert.assertThat((Object)value.propertyName(), Is.is("mode:property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("mode:tableA")));
    }

    @Test
    public void shouldParsePropertyValueFromStringWithOnlyPropertyNameIfSourceIsSelector() {
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        PropertyValue value = this.parser.parsePropertyValue(this.tokens("property"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParsePropertyValueFromStringWithOnlyPropertyNameIfSourceIsNotSelector() {
        this.parser.parsePropertyValue(this.tokens("property"), this.typeSystem, (Source)Mockito.mock(Join.class));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParsePropertyValueFromStringWithOnlySelectorNameAndPeriod() {
        this.parser.parsePropertyValue(this.tokens("tableA. "), this.typeSystem, (Source)Mockito.mock(Join.class));
    }

    @Test
    public void shouldParseReferenceValueFromStringWithUnquotedSelectorNameAndUnquotedPropertyName() {
        ReferenceValue value = this.parser.parseReferenceValue(this.tokens("tableA.property"), this.typeSystem, (Source)Mockito.mock(Join.class));
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        value = this.parser.parseReferenceValue(this.tokens("tableA.property"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test
    public void shouldParseReferenceValueFromStringWithQuotedSelectorNameAndUnquotedPropertyName() {
        ReferenceValue value = this.parser.parseReferenceValue(this.tokens("[mode:tableA].property"), this.typeSystem, (Source)Mockito.mock(Join.class));
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("mode:tableA")));
        NamedSelector source = new NamedSelector(this.selectorName("mode:tableA"));
        value = this.parser.parseReferenceValue(this.tokens("[mode:tableA].property"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("mode:tableA")));
    }

    @Test
    public void shouldParseReferenceValueFromStringWithQuotedSelectorNameAndQuotedPropertyName() {
        ReferenceValue value = this.parser.parseReferenceValue(this.tokens("[mode:tableA].[mode:property]"), this.typeSystem, (Source)Mockito.mock(Join.class));
        Assert.assertThat((Object)value.propertyName(), Is.is("mode:property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("mode:tableA")));
        NamedSelector source = new NamedSelector(this.selectorName("mode:tableA"));
        value = this.parser.parseReferenceValue(this.tokens("[mode:tableA].[mode:property]"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)value.propertyName(), Is.is("mode:property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("mode:tableA")));
    }

    @Test
    public void shouldParseReferenceValueFromStringWithOnlyPropertyNameIfSourceIsSelector() {
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        ReferenceValue value = this.parser.parseReferenceValue(this.tokens("property)"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)value.propertyName(), Is.is("property"));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test
    public void shouldParseReferenceValueFromStringWithMatchingSelectorNameIfSourceIsSelector() {
        NamedSelector source = new NamedSelector(this.selectorName("tableA"));
        ReferenceValue value = this.parser.parseReferenceValue(this.tokens("tableA)"), this.typeSystem, (Source)source);
        Assert.assertThat((Object)value.propertyName(), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test
    public void shouldParseReferenceValueFromStringWithOnlySelectorNameIfSourceIsNotSelector() {
        Source source = (Source)Mockito.mock(Join.class);
        ReferenceValue value = this.parser.parseReferenceValue(this.tokens("tableA)"), this.typeSystem, source);
        Assert.assertThat((Object)value.propertyName(), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)value.selectorName(), Is.is(this.selectorName("tableA")));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseReferenceValueFromStringWithOnlySelectorNameAndPeriod() {
        this.parser.parseReferenceValue(this.tokens("tableA. "), this.typeSystem, (Source)Mockito.mock(Join.class));
    }

    @Test
    public void shouldParseLimitFromFormWithJustOneNumber() {
        Limit limit = this.parser.parseLimit(this.tokens("LIMIT 10"));
        Assert.assertThat((Object)limit.rowLimit(), Is.is(10));
        Assert.assertThat((Object)limit.offset(), Is.is(0));
        limit = this.parser.parseLimit(this.tokens("LIMIT 10 NONOFFSET"));
        Assert.assertThat((Object)limit.rowLimit(), Is.is(10));
        Assert.assertThat((Object)limit.offset(), Is.is(0));
    }

    @Test
    public void shouldParseLimitFromFormWithRowLimitAndOffset() {
        Limit limit = this.parser.parseLimit(this.tokens("LIMIT 10 OFFSET 30"));
        Assert.assertThat((Object)limit.rowLimit(), Is.is(10));
        Assert.assertThat((Object)limit.offset(), Is.is(30));
        limit = this.parser.parseLimit(this.tokens("LIMIT 10 OFFSET 30 OTHER"));
        Assert.assertThat((Object)limit.rowLimit(), Is.is(10));
        Assert.assertThat((Object)limit.offset(), Is.is(30));
    }

    @Test
    public void shouldParseLimitFromFormWithTwoCommaSeparatedNumbers() {
        Limit limit = this.parser.parseLimit(this.tokens("LIMIT 10,30"));
        Assert.assertThat((Object)limit.rowLimit(), Is.is(20));
        Assert.assertThat((Object)limit.offset(), Is.is(10));
    }

    @Test
    public void shouldReturnNullFromParseLimitWithNoLimitKeyword() {
        Assert.assertThat((Object)this.parser.parseLimit(this.tokens("OTHER")), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.parser.parseLimit(this.tokens("  ")), Is.is(IsNull.nullValue()));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseLimitIfRowLimitNumberTokenIsNotAnInteger() {
        this.parser.parseLimit(this.tokens("LIMIT 10a OFFSET 30"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseLimitIfOffsetNumberTokenIsNotAnInteger() {
        this.parser.parseLimit(this.tokens("LIMIT 10 OFFSET 30a"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseLimitIfStartingRowNumberTokenIsNotAnInteger() {
        this.parser.parseLimit(this.tokens("LIMIT 10a,20"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseLimitIfEndingRowNumberTokenIsNotAnInteger() {
        this.parser.parseLimit(this.tokens("LIMIT 10,20a"));
    }

    @Test
    public void shouldParseNamedSelectorFromUnquotedNameWithNoAlias() {
        NamedSelector selector = this.parser.parseNamedSelector(this.tokens("name"), this.typeSystem);
        Assert.assertThat((Object)selector.name(), Is.is(this.selectorName("name")));
        Assert.assertThat((Object)selector.alias(), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)selector.aliasOrName(), Is.is(this.selectorName("name")));
    }

    @Test
    public void shouldParseNamedSelectorFromUnquotedNameWithUnquotedAlias() {
        NamedSelector selector = this.parser.parseNamedSelector(this.tokens("name AS alias"), this.typeSystem);
        Assert.assertThat((Object)selector.name(), Is.is(this.selectorName("name")));
        Assert.assertThat((Object)selector.alias(), Is.is(this.selectorName("alias")));
        Assert.assertThat((Object)selector.aliasOrName(), Is.is(this.selectorName("alias")));
    }

    @Test
    public void shouldParseNamedSelectorFromQuotedNameWithUnquotedAlias() {
        NamedSelector selector = this.parser.parseNamedSelector(this.tokens("'name' AS alias"), this.typeSystem);
        Assert.assertThat((Object)selector.name(), Is.is(this.selectorName("name")));
        Assert.assertThat((Object)selector.alias(), Is.is(this.selectorName("alias")));
        Assert.assertThat((Object)selector.aliasOrName(), Is.is(this.selectorName("alias")));
    }

    @Test
    public void shouldParseNamedSelectorFromQuotedNameWithQuotedAlias() {
        NamedSelector selector = this.parser.parseNamedSelector(this.tokens("'name' AS [alias]"), this.typeSystem);
        Assert.assertThat((Object)selector.name(), Is.is(this.selectorName("name")));
        Assert.assertThat((Object)selector.alias(), Is.is(this.selectorName("alias")));
        Assert.assertThat((Object)selector.aliasOrName(), Is.is(this.selectorName("alias")));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailInParseNamedSelectorIfNoMoreTokens() {
        this.parser.parseNamedSelector(this.tokens("  "), this.typeSystem);
    }

    @Test
    public void shouldParseSelectorNameFromUnquotedString() {
        Assert.assertThat((Object)this.parser.parseSelectorName(this.tokens("name"), this.typeSystem), Is.is(this.selectorName("name")));
    }

    @Test
    public void shouldParseSelectorNameFromQuotedString() {
        Assert.assertThat((Object)this.parser.parseSelectorName(this.tokens("'name'"), this.typeSystem), Is.is(this.selectorName("name")));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailInParseSelectorNameIfNoMoreTokens() {
        this.parser.parseSelectorName(this.tokens("  "), this.typeSystem);
    }

    @Test
    public void shouldParseNameFromSingleQuotedString() {
        Assert.assertThat((Object)this.parser.parseName(this.tokens("'jcr:name'"), this.typeSystem), Is.is("jcr:name"));
    }

    @Test
    public void shouldParseNameFromDoubleQuotedString() {
        Assert.assertThat((Object)this.parser.parseName(this.tokens("\"jcr:name\""), this.typeSystem), Is.is("jcr:name"));
    }

    @Test
    public void shouldParseNameFromBracketedString() {
        Assert.assertThat((Object)this.parser.parseName(this.tokens("[jcr:name]"), this.typeSystem), Is.is("jcr:name"));
    }

    @Test
    public void shouldParseNameFromUnquotedStringWithoutPrefix() {
        Assert.assertThat((Object)this.parser.parseName(this.tokens("name"), this.typeSystem), Is.is("name"));
    }

    @Test
    public void shouldParseNameFromSingleQuotedStringWithoutPrefix() {
        Assert.assertThat((Object)this.parser.parseName(this.tokens("'name'"), this.typeSystem), Is.is("name"));
    }

    @Test
    public void shouldParseNameFromDoubleQuotedStringWithoutPrefix() {
        Assert.assertThat((Object)this.parser.parseName(this.tokens("\"name\""), this.typeSystem), Is.is("name"));
    }

    @Test
    public void shouldParseNameFromBracketedStringWithoutPrefix() {
        Assert.assertThat((Object)this.parser.parseName(this.tokens("[name]"), this.typeSystem), Is.is("name"));
    }

    @Test
    public void shouldParseNameFromBracketedAndQuotedStringWithoutPrefix() {
        Assert.assertThat((Object)this.parser.parseName(this.tokens("['name']"), this.typeSystem), Is.is("name"));
        Assert.assertThat((Object)this.parser.parseName(this.tokens("[\"name\"]"), this.typeSystem), Is.is("name"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailToParseNameIfNoMoreTokens() {
        this.parser.parseName(this.tokens("  "), this.typeSystem);
    }

    @Test
    public void shouldParsePathFromUnquotedStringConsistingOfSql92Identifiers() {
        String identifier = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
        Assert.assertThat((Object)this.parser.parsePath(this.tokens(identifier), this.typeSystem), Is.is(identifier));
    }

    @Test
    public void shouldParsePathFromSingleQuotedString() {
        Assert.assertThat((Object)this.parser.parsePath(this.tokens("'/a/b/c/mode:something/d'"), this.typeSystem), Is.is("/a/b/c/mode:something/d"));
    }

    @Test
    public void shouldParsePathFromDoubleQuotedString() {
        Assert.assertThat((Object)this.parser.parsePath(this.tokens("\"/a/b/c/mode:something/d\""), this.typeSystem), Is.is("/a/b/c/mode:something/d"));
    }

    @Test(expected=ParsingException.class)
    public void shouldFailInParsePathIfNoMoreTokens() {
        this.parser.parsePath(this.tokens("  "), this.typeSystem);
    }

    @Test
    public void shouldRemoveBracketsAndQuotes() {
        Assert.assertThat((Object)this.parser.removeBracketsAndQuotes("string"), Is.is("string"));
        Assert.assertThat((Object)this.parser.removeBracketsAndQuotes("[string]"), Is.is("string"));
        Assert.assertThat((Object)this.parser.removeBracketsAndQuotes("'string'"), Is.is("string"));
        Assert.assertThat((Object)this.parser.removeBracketsAndQuotes("\"string\""), Is.is("string"));
        Assert.assertThat((Object)this.parser.removeBracketsAndQuotes("word one and two"), Is.is("word one and two"));
        Assert.assertThat((Object)this.parser.removeBracketsAndQuotes("[word one and two]"), Is.is("word one and two"));
        Assert.assertThat((Object)this.parser.removeBracketsAndQuotes("'word one and two'"), Is.is("word one and two"));
        Assert.assertThat((Object)this.parser.removeBracketsAndQuotes("\"word one and two\""), Is.is("word one and two"));
    }

    protected void parse(String query) {
        this.parser.parseQuery(query, this.typeSystem);
    }

    protected SelectorName selectorName(String name) {
        return new SelectorName(name);
    }

    protected Name name(String name) {
        return (Name)this.typeSystem.getTypeFactory(PropertyType.NAME.getName()).create(name);
    }

    protected Path path(String path) {
        return (Path)this.typeSystem.getTypeFactory(PropertyType.PATH.getName()).create(path);
    }

    protected DateTime date(String dateTime) {
        return (DateTime)this.typeSystem.getDateTimeFactory().create(dateTime);
    }

    protected TokenStream tokens(String content) {
        return new TokenStream(content, (TokenStream.Tokenizer)new SqlQueryParser.SqlTokenizer(false), false).start();
    }
}

