/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.parse;

import java.util.LinkedList;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.text.TokenStream;
import org.modeshape.graph.query.parse.SqlQueryParser;

public class SqlTokenizerTest {
    private SqlQueryParser.SqlTokenizer tokenizer;
    private TokenStream.Tokens tokenFactory;
    private LinkedList<int[]> tokenValues;

    @Before
    public void beforeEach() {
        this.tokenizer = new SqlQueryParser.SqlTokenizer(true);
        final LinkedList tokenValues = new LinkedList();
        this.tokenFactory = new TokenStream.Tokens(){

            public void addToken(Position position, int index) {
                int[] token = new int[]{index, index + 1, 0};
                tokenValues.add(token);
            }

            public void addToken(Position position, int startIndex, int endIndex) {
                int[] token = new int[]{startIndex, endIndex, 0};
                tokenValues.add(token);
            }

            public void addToken(Position position, int startIndex, int endIndex, int type) {
                int[] token = new int[]{startIndex, endIndex, type};
                tokenValues.add(token);
            }
        };
        this.tokenValues = tokenValues;
    }

    protected void tokenize(String input) {
        this.tokenizer.tokenize((TokenStream.CharacterStream)new TokenStream.CharacterArrayStream(input.toCharArray()), this.tokenFactory);
    }

    protected void assertNextTokenIs(int startIndex, int endIndex, int type) {
        int[] token = this.tokenValues.removeFirst();
        Assert.assertThat((Object)token[0], Is.is(startIndex));
        Assert.assertThat((Object)token[1], Is.is(endIndex));
        Assert.assertThat((Object)token[2], Is.is(type));
    }

    protected void assertNoMoreTokens() {
        Assert.assertThat((Object)this.tokenValues.isEmpty(), Is.is(true));
    }

    @Test
    public void shouldCreateNoTokensForEmptyContent() {
        this.tokenize("");
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldCreateNoTokensForContentWithOnlyWhitespace() {
        this.tokenize("  \t   \n   \r\n  \r  ");
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldCreateTokenForEachSymbolCharacter() {
        String content = "(){}*,:+%?$]!<>|=:";
        int numSymbols = content.length();
        this.tokenize(content);
        for (int i = 0; i != numSymbols; ++i) {
            this.assertNextTokenIs(i, i + 1, 2);
        }
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldNotConsiderDoubleSlashAsComment() {
        String content = "++//this\n";
        this.tokenize(content);
        this.assertNextTokenIs(0, 1, 2);
        this.assertNextTokenIs(1, 2, 2);
        this.assertNextTokenIs(2, 3, 2);
        this.assertNextTokenIs(3, 4, 2);
        this.assertNextTokenIs(4, content.length() - 1, 1);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldCreateTokenForEndOfLineCommentUsingDoubleDash() {
        String content = "++--this is a comment\n";
        this.tokenize(content);
        this.assertNextTokenIs(0, 1, 2);
        this.assertNextTokenIs(1, 2, 2);
        this.assertNextTokenIs(2, content.length() - 1, 6);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldCreateTokenForMultiLineComment() {
        String content = "==/*this is a comment*/-";
        this.tokenize(content);
        this.assertNextTokenIs(0, 1, 2);
        this.assertNextTokenIs(1, 2, 2);
        this.assertNextTokenIs(2, content.length() - 1, 6);
        this.assertNextTokenIs(content.length() - 1, content.length(), 2);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldCreateTokenForMultiLineCommentAtEndOfContent() {
        String content = "==/*this is a comment*/";
        this.tokenize(content);
        this.assertNextTokenIs(0, 1, 2);
        this.assertNextTokenIs(1, 2, 2);
        this.assertNextTokenIs(2, content.length(), 6);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldCreateTokenForMultiLineCommentWithoutTerminatingCharacters() {
        String content = "==/*this is a comment";
        this.tokenize(content);
        this.assertNextTokenIs(0, 1, 2);
        this.assertNextTokenIs(1, 2, 2);
        this.assertNextTokenIs(2, content.length(), 6);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldCreateTokenForMultiLineCommentWithoutAllTerminatingCharacters() {
        String content = "==/*this is a comment*";
        this.tokenize(content);
        this.assertNextTokenIs(0, 1, 2);
        this.assertNextTokenIs(1, 2, 2);
        this.assertNextTokenIs(2, content.length(), 6);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldCreateTokenForSingleQuotedString() {
        String content = "=='this is a single-quoted \n string'-";
        Assert.assertThat((Object)Character.valueOf(content.charAt(2)), Is.is(Character.valueOf('\'')));
        Assert.assertThat((Object)Character.valueOf(content.charAt(35)), Is.is(Character.valueOf('\'')));
        this.tokenize(content);
        this.assertNextTokenIs(0, 1, 2);
        this.assertNextTokenIs(1, 2, 2);
        this.assertNextTokenIs(2, 36, 4);
        this.assertNextTokenIs(36, 37, 2);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldCreateTokenForSingleQuotedStringWithEscapedSingleQuoteCharacters() {
        String content = "=='this \"is\" a \\'single-quoted\\' \n string'-";
        Assert.assertThat((Object)Character.valueOf(content.charAt(2)), Is.is(Character.valueOf('\'')));
        Assert.assertThat((Object)Character.valueOf(content.charAt(41)), Is.is(Character.valueOf('\'')));
        this.tokenize(content);
        this.assertNextTokenIs(0, 1, 2);
        this.assertNextTokenIs(1, 2, 2);
        this.assertNextTokenIs(2, 42, 4);
        this.assertNextTokenIs(42, 43, 2);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldCreateTokenForSingleQuotedStringAtEndOfContent() {
        String content = "=='this is a single-quoted \n string'";
        Assert.assertThat((Object)Character.valueOf(content.charAt(2)), Is.is(Character.valueOf('\'')));
        Assert.assertThat((Object)Character.valueOf(content.charAt(35)), Is.is(Character.valueOf('\'')));
        this.tokenize(content);
        this.assertNextTokenIs(0, 1, 2);
        this.assertNextTokenIs(1, 2, 2);
        this.assertNextTokenIs(2, 36, 4);
        this.assertNoMoreTokens();
    }

    @Test(expected=ParsingException.class)
    public void shouldCreateTokenForSingleQuotedStringWithoutClosingQuote() {
        String content = "=='this is a single-quoted \n string";
        this.tokenize(content);
    }

    @Test
    public void shouldCreateTokenForDoubleQuotedString() {
        String content = "==\"this is a double-quoted \n string\"-";
        Assert.assertThat((Object)Character.valueOf(content.charAt(2)), Is.is(Character.valueOf('\"')));
        Assert.assertThat((Object)Character.valueOf(content.charAt(35)), Is.is(Character.valueOf('\"')));
        this.tokenize(content);
        this.assertNextTokenIs(0, 1, 2);
        this.assertNextTokenIs(1, 2, 2);
        this.assertNextTokenIs(2, 36, 4);
        this.assertNextTokenIs(36, 37, 2);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldCreateTokenForDoubleQuotedStringWithEscapedDoubleQuoteCharacters() {
        String content = "==\"this 'is' a \\\"double-quoted\\\" \n string\"-";
        Assert.assertThat((Object)Character.valueOf(content.charAt(2)), Is.is(Character.valueOf('\"')));
        Assert.assertThat((Object)Character.valueOf(content.charAt(41)), Is.is(Character.valueOf('\"')));
        this.tokenize(content);
        this.assertNextTokenIs(0, 1, 2);
        this.assertNextTokenIs(1, 2, 2);
        this.assertNextTokenIs(2, 42, 4);
        this.assertNextTokenIs(42, 43, 2);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldCreateTokenForDoubleQuotedStringAtEndOfContent() {
        String content = "==\"this is a double-quoted \n string\"";
        Assert.assertThat((Object)Character.valueOf(content.charAt(2)), Is.is(Character.valueOf('\"')));
        Assert.assertThat((Object)Character.valueOf(content.charAt(35)), Is.is(Character.valueOf('\"')));
        this.tokenize(content);
        this.assertNextTokenIs(0, 1, 2);
        this.assertNextTokenIs(1, 2, 2);
        this.assertNextTokenIs(2, 36, 4);
        this.assertNoMoreTokens();
    }

    @Test(expected=ParsingException.class)
    public void shouldCreateTokenForDoubleQuotedStringWithoutClosingQuote() {
        String content = "==\"this is a double-quoted \n string";
        this.tokenize(content);
    }

    @Test
    public void shouldCreateTokensForWordsWithAlphabeticCharacters() {
        String content = "This is a series of words.";
        this.tokenize(content);
        this.assertNextTokenIs(0, 4, 1);
        this.assertNextTokenIs(5, 7, 1);
        this.assertNextTokenIs(8, 9, 1);
        this.assertNextTokenIs(10, 16, 1);
        this.assertNextTokenIs(17, 19, 1);
        this.assertNextTokenIs(20, 25, 1);
        this.assertNextTokenIs(25, 26, 2);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldCreateTokensForWordsWithNumericCharacters() {
        String content = "1234 4 5353.324";
        this.tokenize(content);
        this.assertNextTokenIs(0, 4, 1);
        this.assertNextTokenIs(5, 6, 1);
        this.assertNextTokenIs(7, 11, 1);
        this.assertNextTokenIs(11, 12, 2);
        this.assertNextTokenIs(12, 15, 1);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldCreateTokensForWordsWithAlphaNumericCharacters() {
        String content = "123a 5353.324e100";
        this.tokenize(content);
        this.assertNextTokenIs(0, 4, 1);
        this.assertNextTokenIs(5, 9, 1);
        this.assertNextTokenIs(9, 10, 2);
        this.assertNextTokenIs(10, 17, 1);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldParseAlphaNumericAndUnderscoreCharactersAsOneWordToken() {
        String content = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";
        this.tokenize(content);
        this.assertNextTokenIs(0, 63, 1);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldParseUnquotedNameWithPrefixAsSeparateTokens() {
        String content = "dna:name";
        this.tokenize(content);
        this.assertNextTokenIs(0, 3, 1);
        this.assertNextTokenIs(3, 4, 2);
        this.assertNextTokenIs(4, 8, 1);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldParseQuotedNameWithPrefixAsOneToken() {
        String content = "'dna:name'";
        this.tokenize(content);
        this.assertNextTokenIs(0, 10, 4);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldParseUnquotedPathAsSeparateTokens() {
        String content = "/a/b/c/dna:name[1]/e/f";
        this.tokenize(content);
        this.assertNextTokenIs(0, 1, 2);
        this.assertNextTokenIs(1, 2, 1);
        this.assertNextTokenIs(2, 3, 2);
        this.assertNextTokenIs(3, 4, 1);
        this.assertNextTokenIs(4, 5, 2);
        this.assertNextTokenIs(5, 6, 1);
        this.assertNextTokenIs(6, 7, 2);
        this.assertNextTokenIs(7, 10, 1);
        this.assertNextTokenIs(10, 11, 2);
        this.assertNextTokenIs(11, 15, 1);
        this.assertNextTokenIs(15, 18, 4);
        this.assertNextTokenIs(18, 19, 2);
        this.assertNextTokenIs(19, 20, 1);
        this.assertNextTokenIs(20, 21, 2);
        this.assertNextTokenIs(21, 22, 1);
        this.assertNoMoreTokens();
    }

    @Test
    public void shouldParseQuotedPathAsOneToken() {
        String content = "'/a/b/c/dna:name[1]/e/f'";
        this.tokenize(content);
        this.assertNextTokenIs(0, 24, 4);
        this.assertNoMoreTokens();
    }
}

