/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.plan;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.query.QueryBuilder;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.plan.CanonicalPlanner;
import org.modeshape.graph.query.plan.PlanHints;
import org.modeshape.graph.query.plan.PlanNode;
import org.modeshape.graph.query.validate.ImmutableSchemata;
import org.modeshape.graph.query.validate.Schemata;

public class CanonicalPlannerTest {
    private CanonicalPlanner planner;
    private TypeSystem typeSystem;
    private QueryBuilder builder;
    private PlanHints hints;
    private QueryCommand query;
    private PlanNode plan;
    private Problems problems;
    private Schemata schemata;
    private ImmutableSchemata.Builder schemataBuilder;
    private QueryContext queryContext;
    private boolean print;

    @Before
    public void beforeEach() {
        this.planner = new CanonicalPlanner();
        this.typeSystem = new ExecutionContext().getValueFactories().getTypeSystem();
        this.hints = new PlanHints();
        this.builder = new QueryBuilder(this.typeSystem);
        this.problems = new SimpleProblems();
        this.schemataBuilder = ImmutableSchemata.createBuilder((TypeSystem)this.typeSystem);
        this.print = false;
    }

    protected void print(PlanNode plan) {
        if (this.print) {
            System.out.println(plan);
        }
    }

    protected SelectorName selector(String name) {
        return new SelectorName(name);
    }

    protected Set<SelectorName> selectors(String ... names) {
        HashSet<SelectorName> selectors = new HashSet<SelectorName>();
        for (String name : names) {
            selectors.add(this.selector(name));
        }
        return selectors;
    }

    protected void assertProjectNode(PlanNode node, String ... columnNames) {
        Assert.assertThat((Object)node.getType(), Is.is(PlanNode.Type.PROJECT));
        if (columnNames.length != 0) {
            Assert.assertThat((Object)node.hasCollectionProperty(PlanNode.Property.PROJECT_COLUMNS), Is.is(true));
        }
        List columns = (List)node.getProperty(PlanNode.Property.PROJECT_COLUMNS, List.class);
        Assert.assertThat((Object)columns.size(), Is.is(columnNames.length));
        for (int i = 0; i != columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            Assert.assertThat((Object)column.columnName(), Is.is(columnNames[i]));
        }
    }

    protected void assertSourceNode(PlanNode node, String sourceName, String sourceAlias, String ... availableColumns) {
        Assert.assertThat((Object)node.getType(), Is.is(PlanNode.Type.SOURCE));
        Assert.assertThat((Object)node.getProperty(PlanNode.Property.SOURCE_NAME, SelectorName.class), Is.is(this.selector(sourceName)));
        if (sourceAlias != null) {
            Assert.assertThat((Object)node.getProperty(PlanNode.Property.SOURCE_ALIAS, SelectorName.class), Is.is(this.selector(sourceAlias)));
        } else {
            Assert.assertThat((Object)node.hasProperty(PlanNode.Property.SOURCE_ALIAS), Is.is(false));
        }
        Collection columns = (Collection)node.getProperty(PlanNode.Property.SOURCE_COLUMNS);
        Assert.assertThat((Object)columns.size(), Is.is(availableColumns.length));
        int i = 0;
        for (Schemata.Column column : columns) {
            String expectedName = availableColumns[i++];
            Assert.assertThat((Object)column.getName(), Is.is(expectedName));
        }
    }

    @Test
    public void shouldProducePlanForSelectStarFromTable() {
        this.schemata = this.schemataBuilder.addTable("__ALLNODES__", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.selectStar().fromAllNodes().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.isEmpty(), Is.is(true));
        this.assertProjectNode(this.plan, "column1", "column2", "column3");
        Assert.assertThat((Object)this.plan.getType(), Is.is(PlanNode.Type.PROJECT));
        Assert.assertThat((Object)this.plan.getChildCount(), Is.is(1));
        PlanNode source = this.plan.getFirstChild();
        this.assertSourceNode(source, "__ALLNODES__", null, "column1", "column2", "column3");
        Assert.assertThat((Object)source.getChildCount(), Is.is(0));
        this.print(this.plan);
    }

    @Test
    public void shouldProduceErrorWhenSelectingNonExistantTable() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.selectStar().fromAllNodes().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), Is.is(true));
    }

    @Test
    public void shouldProduceErrorWhenSelectingNonExistantColumnOnExistingTable() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.select(new String[]{"column1", "column4"}).from("someTable").query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), Is.is(true));
    }

    @Test
    public void shouldProducePlanWhenSelectingAllColumnsOnExistingTable() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.selectStar().from("someTable").query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        this.print(this.plan);
        Assert.assertThat((Object)this.problems.hasErrors(), Is.is(false));
        Assert.assertThat((Object)this.problems.isEmpty(), Is.is(true));
        this.assertProjectNode(this.plan, "column1", "column2", "column3");
        Assert.assertThat((Object)this.plan.getType(), Is.is(PlanNode.Type.PROJECT));
        Assert.assertThat((Object)this.plan.getChildCount(), Is.is(1));
        PlanNode source = this.plan.getFirstChild();
        this.assertSourceNode(source, "someTable", null, "column1", "column2", "column3");
        Assert.assertThat((Object)source.getChildCount(), Is.is(0));
    }

    @Test
    public void shouldProducePlanWhenSelectingColumnsFromTableWithoutAlias() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.select(new String[]{"column1", "column2"}).from("someTable").where().path("someTable").isEqualTo((Object)1L).end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), Is.is(false));
        Assert.assertThat((Object)this.plan.getType(), Is.is(PlanNode.Type.PROJECT));
        Assert.assertThat((Object)this.plan.getSelectors(), Is.is(this.selectors("someTable")));
    }

    @Test
    public void shouldProducePlanWhenSelectingColumnsFromTableWithAlias() {
        this.schemata = this.schemataBuilder.addTable("dna:someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.select(new String[]{"column1", "column2"}).from("dna:someTable AS t1").where().path("t1").isEqualTo((Object)1L).end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), Is.is(false));
        this.print(this.plan);
        Assert.assertThat((Object)this.plan.getType(), Is.is(PlanNode.Type.PROJECT));
        Assert.assertThat((Object)this.plan.getSelectors(), Is.is(this.selectors("t1")));
    }

    @Test
    public void shouldProducePlanWhenSelectingAllColumnsFromTableWithAlias() {
        this.schemata = this.schemataBuilder.addTable("dna:someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.selectStar().from("dna:someTable AS t1").where().path("t1").isEqualTo((Object)1L).end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), Is.is(false));
        this.print(this.plan);
        Assert.assertThat((Object)this.plan.getType(), Is.is(PlanNode.Type.PROJECT));
        Assert.assertThat((Object)this.plan.getSelectors(), Is.is(this.selectors("t1")));
    }

    @Test
    public void shouldProduceErrorWhenFullTextSearchingTableWithNoSearchableColumns() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.select(new String[]{"column1", "column2"}).from("someTable").query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), Is.is(false));
        this.query = this.builder.select(new String[]{"column1", "column2"}).from("someTable").where().search("someTable", "term1").end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), Is.is(true));
    }

    @Test
    public void shouldProducePlanWhenFullTextSearchingTableWithAtLeastOneSearchableColumn() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).makeSearchable("someTable", "column1").build();
        this.query = this.builder.select(new String[]{"column1", "column4"}).from("someTable").where().search("someTable", "term1").end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), Is.is(true));
    }

    @Test
    public void shouldProduceErrorWhenFullTextSearchingColumnThatIsNotSearchable() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.select(new String[]{"column1", "column2"}).from("someTable").query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), Is.is(false));
        this.query = this.builder.select(new String[]{"column1", "column2"}).from("someTable").where().search("someTable", "column2", "term1").end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), Is.is(true));
    }

    @Test
    public void shouldProducePlanWhenFullTextSearchingColumnThatIsSearchable() {
        this.schemata = this.schemataBuilder.addTable("someTable", new String[]{"column1", "column2", "column3"}).makeSearchable("someTable", "column1").build();
        this.query = this.builder.select(new String[]{"column1", "column4"}).from("someTable").where().search("someTable", "column1", "term1").end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), Is.is(true));
    }

    @Test
    public void shouldProducePlanWhenOrderByClauseIsUsed() {
        this.schemata = this.schemataBuilder.addTable("dna:someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.selectStar().from("dna:someTable AS t1").where().path("t1").isEqualTo((Object)1L).end().orderBy().ascending().propertyValue("t1", "column1").end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), Is.is(false));
        this.print(this.plan);
        Assert.assertThat((Object)this.plan.getType(), Is.is(PlanNode.Type.SORT));
        Assert.assertThat((Object)this.plan.getSelectors(), Is.is(this.selectors("t1")));
    }

    @Test
    public void shouldProducePlanWhenOrderByClauseWithScoreIsUsed() {
        this.schemata = this.schemataBuilder.addTable("dna:someTable", new String[]{"column1", "column2", "column3"}).build();
        this.query = this.builder.selectStar().from("dna:someTable AS t1").where().path("t1").isEqualTo((Object)1L).end().orderBy().ascending().fullTextSearchScore("t1").end().query();
        this.queryContext = new QueryContext(this.schemata, this.typeSystem, this.hints, this.problems);
        this.plan = this.planner.createPlan(this.queryContext, this.query);
        Assert.assertThat((Object)this.problems.hasErrors(), Is.is(false));
        this.print(this.plan);
        Assert.assertThat((Object)this.plan.getType(), Is.is(PlanNode.Type.SORT));
        Assert.assertThat((Object)this.plan.getSelectors(), Is.is(this.selectors("t1")));
    }
}

