/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.Order;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.process.DelegatingComponent;
import org.modeshape.graph.query.process.ProcessingComponent;
import org.modeshape.graph.query.validate.Schemata;

public class SortValuesComponent
extends DelegatingComponent {
    private final Comparator<Object[]> sortingComparator;

    public SortValuesComponent(ProcessingComponent delegate, List<Ordering> orderings, Map<SelectorName, SelectorName> sourceNamesByAlias) {
        super(delegate);
        this.sortingComparator = this.createSortComparator(delegate.getContext(), delegate.getColumns(), orderings, sourceNamesByAlias);
    }

    public Comparator<Object[]> getSortingComparator() {
        return this.sortingComparator;
    }

    @Override
    public List<Object[]> execute() {
        List<Object[]> tuples = this.delegate().execute();
        if (tuples.size() > 1 && this.sortingComparator != null) {
            Collections.sort(tuples, this.sortingComparator);
        }
        return tuples;
    }

    protected Comparator<Object[]> createSortComparator(QueryContext context, QueryResults.Columns columns, List<Ordering> orderings, Map<SelectorName, SelectorName> sourceNamesByAlias) {
        assert (context != null);
        assert (orderings != null);
        if (orderings.isEmpty()) {
            return null;
        }
        if (orderings.size() == 1) {
            return this.createSortComparator(context, columns, orderings.get(0), sourceNamesByAlias);
        }
        final ArrayList<Comparator<Object[]>> comparators = new ArrayList<Comparator<Object[]>>(orderings.size());
        for (Ordering ordering : orderings) {
            comparators.add(this.createSortComparator(context, columns, ordering, sourceNamesByAlias));
        }
        return new Comparator<Object[]>(){

            @Override
            public int compare(Object[] tuple1, Object[] tuple2) {
                for (Comparator comparator : comparators) {
                    int result = comparator.compare(tuple1, tuple2);
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
        };
    }

    protected Comparator<Object[]> createSortComparator(QueryContext context, QueryResults.Columns columns, Ordering ordering, final Map<SelectorName, SelectorName> sourceNamesByAlias) {
        assert (context != null);
        assert (ordering != null);
        final Schemata originalSchemata = context.getSchemata();
        Schemata schemataWithAliases = sourceNamesByAlias == null ? originalSchemata : new Schemata(){

            @Override
            public Schemata.Table getTable(SelectorName name) {
                Schemata.Table result = null;
                SelectorName unaliasedName = (SelectorName)sourceNamesByAlias.get(name);
                if (unaliasedName != null) {
                    result = originalSchemata.getTable(unaliasedName);
                }
                if (result == null) {
                    result = originalSchemata.getTable(name);
                }
                return result;
            }
        };
        final ProcessingComponent.DynamicOperation operation = this.createDynamicOperation(context.getTypeSystem(), schemataWithAliases, columns, ordering.operand());
        TypeSystem typeSystem = context.getTypeSystem();
        final TypeSystem.TypeFactory<?> typeFactory = typeSystem.getTypeFactory(operation.getExpectedType());
        assert (typeFactory != null);
        final Comparator<?> typeComparator = typeFactory.getComparator();
        assert (typeComparator != null);
        if (ordering.order() == Order.DESCENDING) {
            return new Comparator<Object[]>(){

                @Override
                public int compare(Object[] tuple1, Object[] tuple2) {
                    Object value1 = typeFactory.create(operation.evaluate(tuple1));
                    Object value2 = typeFactory.create(operation.evaluate(tuple2));
                    return 0 - typeComparator.compare(value1, value2);
                }
            };
        }
        return new Comparator<Object[]>(){

            @Override
            public int compare(Object[] tuple1, Object[] tuple2) {
                Object value1 = typeFactory.create(operation.evaluate(tuple1));
                Object value2 = typeFactory.create(operation.evaluate(tuple2));
                return typeComparator.compare(value1, value2);
            }
        };
    }
}

