/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import java.util.List;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.request.RequestType;
import org.modeshape.graph.request.SearchRequest;

public class FullTextSearchRequest
extends SearchRequest {
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final String workspaceName;
    private final int maxResults;
    private final int offset;

    public FullTextSearchRequest(String fullTextSearch, String workspace, int maxResults, int offset) {
        CheckArg.isNotEmpty(fullTextSearch, "fullTextSearch");
        CheckArg.isNotNull(workspace, "workspace");
        CheckArg.isPositive(maxResults, "maxResults");
        CheckArg.isNonNegative(offset, "offset");
        this.expression = fullTextSearch;
        this.workspaceName = workspace;
        this.maxResults = maxResults;
        this.offset = offset;
    }

    public String expression() {
        return this.expression;
    }

    public String workspace() {
        return this.workspaceName;
    }

    public int maxResults() {
        return this.maxResults;
    }

    public int offset() {
        return this.offset;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public QueryResults.Columns getResultColumns() {
        return super.columns();
    }

    public void setResults(QueryResults.Columns resultColumns, List<Object[]> tuples, QueryResults.Statistics statistics) {
        super.doSetResults(resultColumns, tuples, statistics);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            FullTextSearchRequest that = (FullTextSearchRequest)obj;
            if (!this.expression().equals(that.expression())) {
                return false;
            }
            if (!this.workspace().equals(that.workspace())) {
                return false;
            }
            if (this.offset() != that.offset()) {
                return false;
            }
            return this.maxResults() == that.maxResults();
        }
        return false;
    }

    public String toString() {
        return "search the \"" + this.workspaceName + "\" workspace with \"" + this.expression + "\"";
    }

    @Override
    public RequestType getType() {
        return RequestType.FULL_TEXT_SEARCH;
    }
}

