/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.BasicEmptyProperty;
import org.modeshape.graph.property.basic.BasicMultiValueProperty;
import org.modeshape.graph.property.basic.BasicSingleValueProperty;

@Immutable
public class BasicPropertyFactory
implements PropertyFactory {
    private final ValueFactories factories;

    public BasicPropertyFactory(ValueFactories valueFactories) {
        CheckArg.isNotNull(valueFactories, "value factories");
        this.factories = valueFactories;
    }

    @Override
    public Property create(Name name, Iterable<?> values) {
        return this.create(name, PropertyType.OBJECT, values);
    }

    @Override
    public Property create(Name name, Iterator<?> values) {
        return this.create(name, PropertyType.OBJECT, values);
    }

    @Override
    public Property create(Name name, Object ... values) {
        return this.create(name, PropertyType.OBJECT, values);
    }

    @Override
    public Property create(Name name, PropertyType desiredType, Object ... values) {
        CheckArg.isNotNull(name, "name");
        if (values == null || values.length == 0) {
            return new BasicEmptyProperty(name);
        }
        int len = values.length;
        if (desiredType == null) {
            desiredType = PropertyType.OBJECT;
        }
        ValueFactory<?> factory = this.factories.getValueFactory(desiredType);
        if (values.length == 1) {
            Object value = values[0];
            if (value instanceof Collection) {
                return this.create(name, desiredType, (Iterable)value);
            }
            if (value instanceof Iterator) {
                return this.create(name, desiredType, (Iterator)value);
            }
            if (value instanceof Object[]) {
                return this.create(name, desiredType, (Object[])value);
            }
            value = factory.create(value);
            return new BasicSingleValueProperty(name, value);
        }
        ArrayList<Object> valueList = new ArrayList<Object>(len);
        for (int i = 0; i != len; ++i) {
            Object value = factory.create(values[i]);
            valueList.add(value);
        }
        return new BasicMultiValueProperty(name, valueList);
    }

    @Override
    public Property create(Name name, PropertyType desiredType, Iterable<?> values) {
        CheckArg.isNotNull(name, "name");
        ArrayList<Object> valueList = null;
        if (values instanceof Collection) {
            Collection originalValues = (Collection)values;
            if (originalValues.isEmpty()) {
                return new BasicEmptyProperty(name);
            }
            valueList = new ArrayList(originalValues.size());
        } else {
            valueList = new ArrayList<Object>();
        }
        if (desiredType == null) {
            desiredType = PropertyType.OBJECT;
        }
        ValueFactory<?> factory = this.factories.getValueFactory(desiredType);
        for (Object value : values) {
            valueList.add(factory.create(value));
        }
        if (valueList.isEmpty()) {
            return new BasicEmptyProperty(name);
        }
        if (valueList.size() == 1) {
            return new BasicSingleValueProperty(name, valueList.get(0));
        }
        return new BasicMultiValueProperty(name, valueList);
    }

    @Override
    public Property create(Name name, PropertyType desiredType, Iterator<?> values) {
        CheckArg.isNotNull(name, "name");
        ArrayList<Object> valueList = new ArrayList<Object>();
        if (desiredType == null) {
            desiredType = PropertyType.OBJECT;
        }
        ValueFactory<?> factory = this.factories.getValueFactory(desiredType);
        while (values.hasNext()) {
            Object value = values.next();
            value = factory.create(value);
            valueList.add(value);
        }
        if (valueList.isEmpty()) {
            return new BasicEmptyProperty(name);
        }
        if (valueList.size() == 1) {
            return new BasicSingleValueProperty(name, valueList.get(0));
        }
        return new BasicMultiValueProperty(name, valueList);
    }
}

