/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.property;

import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.common.util.ObjectUtil;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.property.InvalidPathExpressionException;

@Immutable
public class PathExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SEQUENCE_PATTERN_STRING = "\\[(\\d+(?:,\\d+)*)\\]";
    private static final Pattern SEQUENCE_PATTERN = Pattern.compile("\\[(\\d+(?:,\\d+)*)\\]");
    private static final String UNUSABLE_PREDICATE_PATTERN_STRING = "\\[(?:(?:\\d+(?:,\\d+)*)|\\*)\\]|(?:\\[[^\\]\\+\\-\\*=\\!><'\"\\s]+\\])$|(\\[[^\\]]+\\])";
    private static final Pattern UNUSABLE_PREDICATE_PATTERN = Pattern.compile("\\[(?:(?:\\d+(?:,\\d+)*)|\\*)\\]|(?:\\[[^\\]\\+\\-\\*=\\!><'\"\\s]+\\])$|(\\[[^\\]]+\\])");
    private static final String NON_INDEX_PREDICATE_PATTERN_STRING = "\\[(?:(?:\\d+(?:,\\d+)*)|\\*)\\]|(\\[[^\\]]+\\])";
    private static final Pattern NON_INDEX_PREDICATE_PATTERN = Pattern.compile("\\[(?:(?:\\d+(?:,\\d+)*)|\\*)\\]|(\\[[^\\]]+\\])");
    private static final String REPOSITORY_AND_WORKSPACE_AND_PATH_PATTERN_STRING = "((([^:/]*):)?(([^:/]*):))?(.*)";
    private static final Pattern REPOSITORY_AND_WORKSPACE_AND_PATH_PATTERN = Pattern.compile("((([^:/]*):)?(([^:/]*):))?(.*)");
    private final String expression;
    private final Pattern repositoryPattern;
    private final Pattern workspacePattern;
    private final Pattern matchPattern;
    private final Pattern selectPattern;
    private static final String ANYTHING_PATTERN_STRING = "/*(?:[*.](?:\\[\\*?\\])?/*)*";
    private static final Pattern ANYTHING_PATTERN = Pattern.compile("/*(?:[*.](?:\\[\\*?\\])?/*)*");
    private static final PathExpression ALL_PATHS_EXPRESSION = PathExpression.compile("//");

    public static final PathExpression compile(String expression) throws InvalidPathExpressionException {
        return new PathExpression(expression);
    }

    public PathExpression(String expression) throws InvalidPathExpressionException {
        CheckArg.isNotNull((Object)expression, (String)"path expression");
        this.expression = expression.trim();
        if (this.expression.length() == 0) {
            throw new InvalidPathExpressionException(GraphI18n.pathExpressionMayNotBeBlank.text(new Object[0]));
        }
        RepositoryPath repoPath = PathExpression.parseRepositoryPath(this.expression);
        if (repoPath == null) {
            throw new InvalidPathExpressionException(GraphI18n.pathExpressionHasInvalidMatch.text(new Object[]{this.expression, this.expression}));
        }
        String repoPatternStr = repoPath.repositoryName != null ? repoPath.repositoryName : ".*";
        String workPatternStr = repoPath.workspaceName != null ? repoPath.workspaceName : ".*";
        String pathPatternStr = repoPath.path;
        this.repositoryPattern = Pattern.compile(repoPatternStr);
        this.workspacePattern = Pattern.compile(workPatternStr);
        String matchString = pathPatternStr;
        try {
            matchString = this.removeUnusedPredicates(matchString);
            matchString = this.replaceXPathPatterns(matchString);
            this.matchPattern = Pattern.compile(matchString, 2);
        }
        catch (PatternSyntaxException e) {
            String msg = GraphI18n.pathExpressionHasInvalidMatch.text(new Object[]{matchString, this.expression});
            throw new InvalidPathExpressionException(msg, e);
        }
        String selectString = pathPatternStr;
        try {
            selectString = this.removeAllPredicatesExceptIndexes(selectString);
            selectString = this.replaceXPathPatterns(selectString);
            selectString = "(" + selectString + ").*";
            this.selectPattern = Pattern.compile(selectString, 2);
        }
        catch (PatternSyntaxException e) {
            String msg = GraphI18n.pathExpressionHasInvalidSelect.text(new Object[]{selectString, this.expression});
            throw new InvalidPathExpressionException(msg, e);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    protected String removeUnusedPredicates(String expression) {
        assert (expression != null);
        java.util.regex.Matcher matcher = UNUSABLE_PREDICATE_PATTERN.matcher(expression);
        StringBuffer sb = new StringBuffer();
        if (matcher.find()) {
            do {
                String predicateStr = matcher.group(0);
                String unusablePredicateStr = matcher.group(1);
                if (unusablePredicateStr != null) {
                    predicateStr = "";
                }
                matcher.appendReplacement(sb, predicateStr);
            } while (matcher.find());
            matcher.appendTail(sb);
            expression = sb.toString();
        }
        return expression;
    }

    protected String removeAllPredicatesExceptIndexes(String expression) {
        assert (expression != null);
        java.util.regex.Matcher matcher = NON_INDEX_PREDICATE_PATTERN.matcher(expression);
        StringBuffer sb = new StringBuffer();
        if (matcher.find()) {
            do {
                String predicateStr = matcher.group(0);
                String unusablePredicateStr = matcher.group(1);
                if (unusablePredicateStr != null) {
                    predicateStr = "";
                }
                matcher.appendReplacement(sb, predicateStr);
            } while (matcher.find());
            matcher.appendTail(sb);
            expression = sb.toString();
        }
        return expression;
    }

    protected String replaceXPathPatterns(String expression) {
        assert (expression != null);
        expression = expression.replaceAll("[\\|]{2,}", "|");
        expression = expression.replaceAll("/(\\([^|]+)(\\|){2,}([^)]+\\))", "(/$1$2$3)?");
        expression = expression.replaceAll("/\\(\\|+([^)]+)\\)", "(?:/($1))?");
        expression = expression.replaceAll("/\\((([^|]+)(\\|[^|]+)*)\\|+\\)", "(?:/($1))?");
        expression = expression.replaceAll("\\[\\]", "(?:\\\\[\\\\d+\\\\])?");
        expression = expression.replaceAll("\\[[*]\\]", "(?:\\\\[\\\\d+\\\\])?");
        expression = expression.replaceAll("\\[0\\]", "(?:\\\\[0\\\\])?");
        expression = expression.replaceAll("\\[([1-9]\\d*)\\]", "\\\\[$1\\\\]");
        expression = expression.replaceAll("(?<!\\\\)\\[([^\\]]*)\\]$", "/$1");
        java.util.regex.Matcher matcher = SEQUENCE_PATTERN.matcher(expression);
        StringBuffer sb = new StringBuffer();
        boolean result = matcher.find();
        if (result) {
            do {
                String sequenceStr = matcher.group(1);
                boolean optional = false;
                if (sequenceStr.startsWith("0,")) {
                    sequenceStr = sequenceStr.replaceFirst("^0,", "");
                    optional = true;
                }
                if (sequenceStr.endsWith(",0")) {
                    sequenceStr = sequenceStr.replaceFirst(",0$", "");
                    optional = true;
                }
                if (sequenceStr.contains(",0,")) {
                    sequenceStr = sequenceStr.replaceAll(",0,", ",");
                    optional = true;
                }
                sequenceStr = sequenceStr.replaceAll(",", "|");
                String replacement = "\\\\[(?:" + sequenceStr + ")\\\\]";
                if (optional) {
                    replacement = "(?:" + replacement + ")?";
                }
                matcher.appendReplacement(sb, replacement);
            } while (result = matcher.find());
            matcher.appendTail(sb);
            expression = sb.toString();
        }
        expression = expression.replaceAll("[*]([^/(\\\\])", "[^/$1]*$1");
        expression = expression.replaceAll("(?<!\\[\\^/\\])[*]", "[^/]*");
        expression = expression.replaceAll("[/]{2,}$", "(?:/[^/]*)*");
        expression = expression.replaceAll("[/]{2,}", "(?:/[^/]*)*/");
        return expression;
    }

    public String getSelectExpression() {
        return this.expression;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PathExpression) {
            PathExpression that = (PathExpression)obj;
            return this.expression.equalsIgnoreCase(that.expression);
        }
        return false;
    }

    public String toString() {
        return this.expression;
    }

    public Matcher matcher(String absolutePath) {
        RepositoryPath repoPath = PathExpression.parseRepositoryPath(absolutePath);
        if (repoPath == null) {
            return new Matcher(null, absolutePath, null, null, null);
        }
        String repoName = repoPath.repositoryName != null ? repoPath.repositoryName : "";
        String workspaceName = repoPath.workspaceName != null ? repoPath.workspaceName : "";
        String path = repoPath.path;
        if (!this.repositoryPattern.matcher(repoName).matches() || !this.workspacePattern.matcher(workspaceName).matches()) {
            return new Matcher(null, path, null, null, null);
        }
        String originalAbsolutePath = path;
        java.util.regex.Matcher matcher = this.matchPattern.matcher(path = path.replaceAll("/+$", ""));
        if (!matcher.matches()) {
            return new Matcher(matcher, originalAbsolutePath, null, null, null);
        }
        java.util.regex.Matcher selectMatcher = this.selectPattern.matcher(path);
        if (!selectMatcher.matches()) {
            return new Matcher(matcher, null, null, null, null);
        }
        String selectedPath = selectMatcher.group(1);
        selectedPath = selectedPath.replaceAll("/@[^/\\[\\]]+$", "");
        return new Matcher(matcher, originalAbsolutePath, repoName, workspaceName, selectedPath);
    }

    public boolean matchesAnything() {
        return ANYTHING_PATTERN.matcher(this.expression).matches();
    }

    public static PathExpression all() {
        return ALL_PATHS_EXPRESSION;
    }

    public static RepositoryPath parseRepositoryPath(String path) {
        java.util.regex.Matcher pathMatcher = REPOSITORY_AND_WORKSPACE_AND_PATH_PATTERN.matcher(path);
        if (!pathMatcher.matches()) {
            return null;
        }
        String repoName = pathMatcher.group(3);
        String workspaceName = pathMatcher.group(5);
        String absolutePath = pathMatcher.group(6);
        if (repoName == null || repoName.length() == 0 || repoName.trim().length() == 0) {
            repoName = null;
        }
        if (workspaceName == null || workspaceName.length() == 0 || workspaceName.trim().length() == 0) {
            workspaceName = null;
        }
        return new RepositoryPath(repoName, workspaceName, absolutePath);
    }

    @Immutable
    public static class RepositoryPath {
        public final String repositoryName;
        public final String workspaceName;
        public final String path;

        public RepositoryPath(String repositoryName, String workspaceName, String path) {
            this.repositoryName = repositoryName;
            this.workspaceName = workspaceName;
            this.path = path;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof RepositoryPath) {
                RepositoryPath that = (RepositoryPath)obj;
                if (!ObjectUtil.isEqualWithNulls((Object)this.repositoryName, (Object)that.repositoryName)) {
                    return false;
                }
                if (!ObjectUtil.isEqualWithNulls((Object)this.workspaceName, (Object)that.workspaceName)) {
                    return false;
                }
                return this.path.equals(that.path);
            }
            return false;
        }

        public String toString() {
            return (this.repositoryName != null ? this.repositoryName : "") + ":" + (this.workspaceName != null ? this.workspaceName : "") + ":" + this.path;
        }

        public RepositoryPath withRepositoryName(String repositoryName) {
            return new RepositoryPath(repositoryName, this.workspaceName, this.path);
        }

        public RepositoryPath withWorkspaceName(String workspaceName) {
            return new RepositoryPath(this.repositoryName, workspaceName, this.path);
        }

        public RepositoryPath withPath(String path) {
            return new RepositoryPath(this.repositoryName, this.workspaceName, path);
        }
    }

    @Immutable
    public static class Matcher {
        private final String inputPath;
        private final String selectedRepository;
        private final String selectedWorkspace;
        private final String selectedPath;
        private final java.util.regex.Matcher inputMatcher;
        private final int hc;

        protected Matcher(java.util.regex.Matcher inputMatcher, String inputPath, String selectedRepository, String selectedWorkspace, String selectedPath) {
            this.inputMatcher = inputMatcher;
            this.inputPath = inputPath;
            this.selectedRepository = selectedRepository == null || selectedRepository.length() == 0 ? null : selectedRepository;
            this.selectedWorkspace = selectedWorkspace == null || selectedWorkspace.length() == 0 ? null : selectedWorkspace;
            this.selectedPath = selectedPath;
            this.hc = HashCode.compute((Object[])new Object[]{this.inputPath, this.selectedPath});
        }

        public boolean matches() {
            return this.inputMatcher != null && this.selectedPath != null;
        }

        public String getInputPath() {
            return this.inputPath;
        }

        public String getSelectedNodePath() {
            return this.selectedPath;
        }

        public String getSelectedRepositoryName() {
            return this.selectedRepository;
        }

        public String getSelectedWorkspaceName() {
            return this.selectedWorkspace;
        }

        public int groupCount() {
            if (this.inputMatcher == null) {
                return 0;
            }
            return this.inputMatcher.groupCount();
        }

        public String group(int groupNumber) {
            return this.inputMatcher.group(groupNumber);
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Matcher) {
                Matcher that = (Matcher)obj;
                if (!this.inputPath.equalsIgnoreCase(that.inputPath)) {
                    return false;
                }
                return this.selectedPath.equalsIgnoreCase(that.selectedPath);
            }
            return false;
        }

        public String toString() {
            return this.selectedPath;
        }
    }
}

