/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.request;

import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.Location;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.RequestType;

public final class VerifyWorkspaceRequest
extends Request {
    private static final long serialVersionUID = 1L;
    private final String workspaceName;
    private Location actualLocationOfRoot;
    private String actualWorkspaceName;

    public VerifyWorkspaceRequest(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public String workspaceName() {
        return this.workspaceName;
    }

    public String getActualWorkspaceName() {
        return this.actualWorkspaceName;
    }

    public void setActualWorkspaceName(String actualWorkspaceName) {
        this.checkNotFrozen();
        CheckArg.isNotNull((Object)actualWorkspaceName, (String)"actualWorkspaceName");
        this.actualWorkspaceName = actualWorkspaceName;
    }

    public Location getActualLocationOfRoot() {
        return this.actualLocationOfRoot;
    }

    public void setActualRootLocation(Location actualLocationOfRoot) {
        this.checkNotFrozen();
        this.actualLocationOfRoot = actualLocationOfRoot;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void cancel() {
        super.cancel();
        this.actualLocationOfRoot = null;
        this.actualWorkspaceName = null;
    }

    public int hashCode() {
        return this.workspaceName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            VerifyWorkspaceRequest that = (VerifyWorkspaceRequest)obj;
            return this.workspaceName.equals(that.workspaceName());
        }
        return false;
    }

    public String toString() {
        return "verify workspace \"" + this.workspaceName() + "\"";
    }

    @Override
    public RequestType getType() {
        return RequestType.VERIFY_WORKSPACE;
    }
}

