/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph;

import java.net.URL;
import java.util.List;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.connector.xmlfile.XmlFileRepositorySource;
import org.modeshape.graph.property.PathNotFoundException;

public class GraphMergerTest {
    private ExecutionContext context;
    private InMemoryRepositorySource graphSource;
    private XmlFileRepositorySource initialContentSource;
    private Graph graph;
    private Graph initialContent;
    private boolean print = false;

    @Before
    public void beforeEaach() {
        this.context = new ExecutionContext();
        this.graphSource = new InMemoryRepositorySource();
        this.graphSource.setName("Graph source");
        this.initialContentSource = new XmlFileRepositorySource();
        this.initialContentSource.setName("Initial content source");
        this.initialContentSource.setContentLocation(this.resourceUrl("aircraft.xml"));
        this.graph = Graph.create((RepositorySource)this.graphSource, (ExecutionContext)this.context);
        this.initialContent = Graph.create((RepositorySource)this.initialContentSource, (ExecutionContext)this.context);
    }

    @Test
    public void shouldHaveNonEmptyInitialContent() {
        this.assertNodeExists(this.initialContent, "Aircraft");
    }

    @Test
    public void shouldInitializeEmptySource() {
        this.assertNoChildren(this.graph, "/");
        this.graph.merge(this.initialContent);
        this.printSubgraph(this.graph, "/");
        this.assertNodeExists(this.initialContent, "Aircraft");
        this.assertNodeDoesNotExist(this.initialContent, "Aircraft[2]");
    }

    @Test
    public void shouldInitializeSourceWithOnlySomeNodes() {
        this.assertNoChildren(this.graph, "/");
        this.graph.create("/Aircraft").and();
        this.graph.merge(this.initialContent);
        this.printSubgraph(this.graph, "/");
        this.assertNodeExists(this.initialContent, "Aircraft");
        this.assertNodeDoesNotExist(this.initialContent, "Aircraft[2]");
    }

    protected void assertNoChildren(Graph graph, String path) {
        this.assertNodeExists(graph, path);
        List children = (List)graph.getChildren().of(path);
        Assert.assertThat((Object)children.isEmpty(), Is.is(true));
    }

    protected Node assertNodeExists(Graph graph, String path) {
        Node node = graph.getNodeAt(path);
        Assert.assertThat((Object)node, Is.is(IsNull.notNullValue()));
        return node;
    }

    protected void assertNodeDoesNotExist(Graph graph, String path) {
        try {
            graph.getNodeAt(path);
            Assert.fail((String)("Node does exist at \"" + path + "\""));
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    protected void printSubgraph(Graph graph, String path) {
        if (this.print) {
            Subgraph subgraph = (Subgraph)graph.getSubgraphOfDepth(Integer.MAX_VALUE).at(path);
            System.out.println(subgraph);
        }
    }

    protected String resourceUrl(String path) {
        URL url = this.getClass().getClassLoader().getResource(path);
        return url != null ? url.toExternalForm() : path;
    }
}

