/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.connector.base.MapNode;
import org.modeshape.graph.connector.base.MapWorkspace;
import org.modeshape.graph.connector.base.StandardMapWorkspace;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Property;

public class StandardMapWorkspaceTest {
    private ExecutionContext context;
    private Map<UUID, MapNode> store;
    private MapWorkspace<MapNode> workspace;
    private UUID rootUuid;

    @Before
    public void beforeEach() throws Exception {
        this.context = new ExecutionContext();
        this.store = new HashMap<UUID, MapNode>();
        this.rootUuid = UUID.randomUUID();
        this.workspace = new StandardMapWorkspace("workspace", this.store, new MapNode(this.rootUuid));
    }

    @Test
    public void shouldHaveName() {
        Assert.assertThat((Object)this.workspace.getName(), Is.is("workspace"));
    }

    @Test
    public void shouldHaveRootNode() {
        Assert.assertThat((Object)this.workspace.getRootNode(), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.workspace.getRootNode().getUuid(), Is.is(this.rootUuid));
    }

    @Test
    public void shouldPlaceRootNodeIntoStoreIfNoExistingNode() {
        Assert.assertThat((Object)this.store.get(this.rootUuid), Is.is(IsNull.notNullValue()));
        Assert.assertThat((Object)this.store.get(this.rootUuid).getUuid(), Is.is(this.rootUuid));
        Assert.assertThat((Object)this.store.get(this.rootUuid), Is.is(IsSame.sameInstance(this.workspace.getRootNode())));
    }

    @Test
    public void shouldNotReplaceRootNodeInStoreIfExistingNode() {
        MapNode root = new MapNode(this.rootUuid);
        this.store.clear();
        this.store.put(this.rootUuid, root);
        this.workspace = new StandardMapWorkspace("workspace", this.store, new MapNode(this.rootUuid));
        this.assertStored(root);
    }

    @Test
    public void shouldAddNodes() {
        this.assertStored(this.addNodes(10));
    }

    @Test
    public void shouldReplaceExistingNodes() {
        MapNode[] original = this.addNodes(10);
        this.assertStored(original);
        MapNode[] modified = this.addProperty(original, "foo", "value1");
        this.assertStored(modified);
    }

    @Test
    public void shouldRemoveNodes() {
        for (MapNode node : this.addNodes(10)) {
            Assert.assertThat((Object)this.workspace.removeNode(node.getUuid()), Is.is(IsSame.sameInstance(node)));
        }
        Assert.assertThat((Object)this.store.size(), Is.is(1));
        Assert.assertThat((Object)this.store.get(this.rootUuid), Is.is(IsSame.sameInstance(this.workspace.getRootNode())));
    }

    @Test
    public void shouldNotRemoveRootNode() {
        Assert.assertThat((Object)this.workspace.removeNode(this.rootUuid), Is.is(IsNull.nullValue()));
        Assert.assertThat((Object)this.store.containsKey(this.rootUuid), Is.is(true));
        Assert.assertThat((Object)this.workspace.getRootNode(), Is.is(IsSame.sameInstance(this.store.get(this.rootUuid))));
    }

    @Test
    public void shouldRemoveAllNodesExceptTheRootNode() {
        MapNode[] nodes = this.addProperty(this.addNodes(10), "foo", "value1");
        MapNode root = this.addProperty(this.workspace.getRootNode(), "bar", "value2");
        Assert.assertThat((Object)this.store.size(), Is.is(11));
        this.assertStored(root);
        this.assertStored(nodes);
        this.workspace.removeAll();
        Assert.assertThat((Object)this.store.size(), Is.is(1));
        Assert.assertThat((Object)this.workspace.getRootNode(), Is.is(IsSame.sameInstance(this.store.get(this.rootUuid))));
        Assert.assertThat((Object)this.workspace.getRootNode(), Is.is(IsNot.not(IsSame.sameInstance(root))));
        Assert.assertThat((Object)this.workspace.getRootNode().getChildren().isEmpty(), Is.is(true));
        Assert.assertThat((Object)this.workspace.getRootNode().getProperties().isEmpty(), Is.is(true));
    }

    protected MapNode[] addNodes(int number) {
        MapNode[] results = new MapNode[number];
        for (int i = 0; i != number; ++i) {
            results[i] = new MapNode(UUID.randomUUID());
            this.workspace.putNode(results[i]);
            Assert.assertThat((Object)this.store.get(results[i].getUuid()), Is.is(IsSame.sameInstance(results[i])));
        }
        return results;
    }

    protected void assertStored(MapNode ... nodes) {
        for (MapNode node : nodes) {
            Assert.assertThat((Object)this.store.get(node.getUuid()), Is.is(IsSame.sameInstance(node)));
            Assert.assertThat((Object)this.store.get(node.getUuid()), Is.is(IsSame.sameInstance(this.workspace.getNode(node.getUuid()))));
        }
    }

    protected MapNode addProperty(MapNode original, String name, Object ... values) {
        MapNode newNode = original.withProperty(this.property(name, values));
        Assert.assertThat((Object)this.workspace.putNode(newNode), Is.is(IsSame.sameInstance(original)));
        return newNode;
    }

    protected MapNode[] addProperty(MapNode[] nodes, String name, Object ... values) {
        MapNode[] results = new MapNode[nodes.length];
        int i = 0;
        for (MapNode original : nodes) {
            results[i++] = this.addProperty(original, name, values);
        }
        return results;
    }

    protected Property property(String name, Object ... values) {
        return this.context.getPropertyFactory().create(this.name(name), values);
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }
}

